# This file was automatically generated by bifcl from /pobj/zeek-8.0.1/zeek-8.0.1/src/cluster/cluster.bif (alternative mode).

export {


module Cluster;





## Publishes an event to a given topic.
##
## topic: a topic associated with the event message.
##
## args: Either the event arguments as already made by
##       :zeek:see:`Cluster::make_event` or the argument list to pass along
##       to it.
##
## Returns: T if the event was accepted for sending. Depending on
##          the selected cluster backend, an event may be dropped
##          when a Zeek cluster is overloadede. This can happen on
##          the sending or receiving node.
global Cluster::publish: function(va_args: any): bool ;


## Create a data structure that may be used to send a remote event via
## :zeek:see:`Broker::publish`.
##
## args: an event, followed by a list of argument values that may be used
##       to call it.
##
## Returns: A :zeek:type:`Cluster::Event` instance that can be published via
##          :zeek:see:`Cluster::publish`, :zeek:see:`Cluster::publish_rr`
##          or :zeek:see:`Cluster::publish_hrw`.
global Cluster::make_event: function(va_args: any): Cluster::Event ;


global Cluster::__subscribe: function(topic_prefix: string ): bool ;


global Cluster::__unsubscribe: function(topic_prefix: string ): bool ;


## Initialize the global cluster backend.
##
## Returns: true on success.
global Cluster::Backend::__init: function(nid: string ): bool ;




## Publishes an event to a node within a pool according to Round-Robin
## distribution strategy.
##
## pool: the pool of nodes that are eligible to receive the event.
##
## key: an arbitrary string to identify the purpose for which you're
##      distributing the event.  e.g. consider using namespacing of your
##      script like "Intel::cluster_rr_key".
##
## args: Either the event arguments as already made by
##       :zeek:see:`Cluster::make_event` or the argument list to pass along
##       to it.
##
## Returns: true if the message is sent.
global Cluster::publish_rr: function(va_args: any): bool ;



## Publishes an event to a node within a pool according to Rendezvous
## (Highest Random Weight) hashing strategy.
##
## pool: the pool of nodes that are eligible to receive the event.
##
## key: data used for input to the hashing function that will uniformly
##      distribute keys among available nodes.
##
## args: Either the event arguments as already made by
##       :zeek:see:`Broker::make_event` or the argument list to pass along
##       to it.
##
## Returns: true if the message is sent.
global Cluster::publish_hrw: function(va_args: any): bool ;


global Cluster::__listen_websocket: function(options: WebSocketServerOptions ): bool ;


module Cluster::Backend;


## Generated on cluster backend error.
##
## tag: A structured tag, not further specified.
##
## message: A free form message with more details about the error.
global error: event(tag: string , message: string );

} # end of export section
module GLOBAL;
