(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/cipher#cipher::t
    (make-struct-type
     'std/crypto#cipher::t
     '#f
     '2
     'cipher
     '()
     ':init!
     '(type ctx)))
  (define std/crypto/cipher#cipher?
    (make-struct-predicate std/crypto/cipher#cipher::t))
  (define std/crypto/cipher#make-cipher
    (lambda _$args1986_
      (apply make-struct-instance std/crypto/cipher#cipher::t _$args1986_)))
  (define std/crypto/cipher#cipher-type
    (make-struct-field-accessor std/crypto/cipher#cipher::t '0))
  (define std/crypto/cipher#cipher-ctx
    (make-struct-field-accessor std/crypto/cipher#cipher::t '1))
  (define std/crypto/cipher#cipher-type-set!
    (make-struct-field-mutator std/crypto/cipher#cipher::t '0))
  (define std/crypto/cipher#cipher-ctx-set!
    (make-struct-field-mutator std/crypto/cipher#cipher::t '1))
  (define std/crypto/cipher#cipher:::init!
    (lambda (_self1981_ _type1982_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _type1982_)
          '#!void
          (error '"Invalid cipher" _type1982_))
      (let ((_ctx1984_ (std/crypto/libcrypto#EVP_CIPHER_CTX_create)))
        (if _ctx1984_ '#!void (error '"Failed to allocate cipher context"))
        (if (let ((__tmp5776
                   (let () (declare (not safe)) (##vector-length _self1981_))))
              (declare (not safe))
              (##fx< '2 __tmp5776))
            (begin
              (let ()
                (declare (not safe))
                (##vector-set! _self1981_ '1 _type1982_))
              (let ()
                (declare (not safe))
                (##vector-set! _self1981_ '2 _ctx1984_)))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self1981_)))))
  (bind-method!
   std/crypto/cipher#cipher::t
   ':init!
   std/crypto/cipher#cipher:::init!
   '#f)
  (define std/crypto/cipher#cipher-name
    (lambda (_cipher1857_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher1857_)
          (std/crypto/libcrypto#EVP_CIPHER_name _cipher1857_)
          (std/crypto/libcrypto#EVP_CIPHER_name
           (##structure-ref
            _cipher1857_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-block-size
    (lambda (_cipher1855_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher1855_)
          (std/crypto/libcrypto#EVP_CIPHER_block_size _cipher1855_)
          (std/crypto/libcrypto#EVP_CIPHER_block_size
           (##structure-ref
            _cipher1855_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-key-length
    (lambda (_cipher1853_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher1853_)
          (std/crypto/libcrypto#EVP_CIPHER_key_length _cipher1853_)
          (std/crypto/libcrypto#EVP_CIPHER_key_length
           (##structure-ref
            _cipher1853_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-iv-length
    (lambda (_cipher1851_)
      (if (std/crypto/libcrypto#EVP_CIPHER? _cipher1851_)
          (std/crypto/libcrypto#EVP_CIPHER_iv_length _cipher1851_)
          (std/crypto/libcrypto#EVP_CIPHER_iv_length
           (##structure-ref
            _cipher1851_
            '1
            std/crypto/cipher#cipher::t
            '#f)))))
  (define std/crypto/cipher#cipher-copy
    (lambda (_cipher1841_)
      (let* ((_ctx1843_ (std/crypto/cipher#cipher-context _cipher1841_))
             (_copy1845_
              (let ((__obj5731 (make-object std/crypto/cipher#cipher::t '2)))
                (std/crypto/cipher#cipher:::init!
                 __obj5731
                 (##structure-ref
                  _cipher1841_
                  '1
                  std/crypto/cipher#cipher::t
                  '#f))
                __obj5731)))
        (let ((_res1848_
               (std/crypto/libcrypto#EVP_CIPHER_CTX_copy
                (##structure-ref _copy1845_ '2 std/crypto/cipher#cipher::t '#f)
                _ctx1843_)))
          (if (let () (declare (not safe)) (##fxzero? _res1848_))
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        _copy1845_)))
  (define std/crypto/cipher#cipher-context
    (lambda (_cipher1836_)
      (let ((_$e1838_
             (##structure-ref
              _cipher1836_
              '2
              std/crypto/cipher#cipher::t
              '#f)))
        (if _$e1838_
            _$e1838_
            (error '"Cipher has been finalized" _cipher1836_)))))
  (define std/crypto/cipher#cipher-check-key+iv-length
    (lambda (_cipher1832_ _key1833_ _iv1834_)
      (if (= (std/crypto/cipher#cipher-key-length
              (##structure-ref
               _cipher1832_
               '1
               std/crypto/cipher#cipher::t
               '#f))
             (u8vector-length _key1833_))
          '#!void
          (error '"Bad cipher key; key length mismatch"))
      (if (= (std/crypto/cipher#cipher-iv-length
              (##structure-ref
               _cipher1832_
               '1
               std/crypto/cipher#cipher::t
               '#f))
             (u8vector-length _iv1834_))
          '#!void
          (error '"Bad cipher iv; iv length mismatch"))))
  (define std/crypto/cipher#cipher-init!
    (lambda (_cipher1824_ _key1825_ _iv1826_ _EVP-init1827_)
      (std/crypto/cipher#cipher-check-key+iv-length
       _cipher1824_
       _key1825_
       _iv1826_)
      (let ((_res1829_
             (_EVP-init1827_
              (std/crypto/cipher#cipher-context _cipher1824_)
              (##structure-ref _cipher1824_ '1 std/crypto/cipher#cipher::t '#f)
              _key1825_
              _iv1826_)))
        (if (let () (declare (not safe)) (##fxzero? _res1829_))
            (apply std/crypto/etc#raise-libcrypto-error '())
            '#!void))))
  (define std/crypto/cipher#cipher-update!
    (lambda (_ctx1814_
             _out1815_
             _out-start1816_
             _in1817_
             _start1818_
             _end1819_
             _EVP-update1820_)
      (let ((_r1822_ (_EVP-update1820_
                      _ctx1814_
                      _out1815_
                      _out-start1816_
                      _in1817_
                      _start1818_
                      _end1819_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r1822_)))
            _r1822_
            (std/crypto/etc#raise-libcrypto-error _ctx1814_)))))
  (define std/crypto/cipher#cipher-final!
    (lambda (_ctx1807_ _out1808_ _out-start1809_ _EVP-final1810_)
      (let ((_r1812_ (_EVP-final1810_ _ctx1807_ _out1808_ _out-start1809_)))
        (if (not (let () (declare (not safe)) (##fxnegative? _r1812_)))
            _r1812_
            (std/crypto/etc#raise-libcrypto-error _ctx1807_)))))
  (define std/crypto/cipher#encrypt-init!
    (lambda (_cipher1803_ _key1804_ _iv1805_)
      (std/crypto/cipher#cipher-init!
       _cipher1803_
       _key1804_
       _iv1805_
       std/crypto/libcrypto#EVP_EncryptInit)))
  (define std/crypto/cipher#encrypt-update!
    (lambda (_cipher1796_
             _out1797_
             _out-start1798_
             _in1799_
             _start1800_
             _end1801_)
      (std/crypto/cipher#cipher-update!
       (std/crypto/cipher#cipher-context _cipher1796_)
       _out1797_
       _out-start1798_
       _in1799_
       _start1800_
       _end1801_
       std/crypto/libcrypto#EVP_EncryptUpdate)))
  (define std/crypto/cipher#encrypt-final!__%
    (lambda (_cipher1778_ _out1779_ _out-start1780_)
      (let ((_olen1782_
             (std/crypto/cipher#cipher-final!
              (std/crypto/cipher#cipher-context _cipher1778_)
              _out1779_
              _out-start1780_
              std/crypto/libcrypto#EVP_EncryptFinal)))
        (##structure-set! _cipher1778_ '#f '2 std/crypto/cipher#cipher::t '#f)
        _olen1782_)))
  (define std/crypto/cipher#encrypt-final!__0
    (lambda (_cipher1787_ _out1788_)
      (let ((_out-start1790_ '0))
        (std/crypto/cipher#encrypt-final!__%
         _cipher1787_
         _out1788_
         _out-start1790_))))
  (define std/crypto/cipher#encrypt-final!
    (lambda _g5778_
      (let ((_g5777_ (let () (declare (not safe)) (##length _g5778_))))
        (cond ((let () (declare (not safe)) (##fx= _g5777_ 2))
               (apply std/crypto/cipher#encrypt-final!__0 _g5778_))
              ((let () (declare (not safe)) (##fx= _g5777_ 3))
               (apply std/crypto/cipher#encrypt-final!__% _g5778_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#encrypt-final!
                _g5778_))))))
  (define std/crypto/cipher#decrypt-init!
    (lambda (_cipher1773_ _key1774_ _iv1775_)
      (std/crypto/cipher#cipher-init!
       _cipher1773_
       _key1774_
       _iv1775_
       std/crypto/libcrypto#EVP_DecryptInit)))
  (define std/crypto/cipher#decrypt-update!
    (lambda (_cipher1766_
             _out1767_
             _out-start1768_
             _in1769_
             _start1770_
             _end1771_)
      (std/crypto/cipher#cipher-update!
       (std/crypto/cipher#cipher-context _cipher1766_)
       _out1767_
       _out-start1768_
       _in1769_
       _start1770_
       _end1771_
       std/crypto/libcrypto#EVP_DecryptUpdate)))
  (define std/crypto/cipher#decrypt-final!__%
    (lambda (_cipher1748_ _out1749_ _out-start1750_)
      (let ((_olen1752_
             (std/crypto/cipher#cipher-final!
              (std/crypto/cipher#cipher-context _cipher1748_)
              _out1749_
              _out-start1750_
              std/crypto/libcrypto#EVP_DecryptFinal)))
        (##structure-set! _cipher1748_ '#f '2 std/crypto/cipher#cipher::t '#f)
        _olen1752_)))
  (define std/crypto/cipher#decrypt-final!__0
    (lambda (_cipher1757_ _out1758_)
      (let ((_out-start1760_ '0))
        (std/crypto/cipher#decrypt-final!__%
         _cipher1757_
         _out1758_
         _out-start1760_))))
  (define std/crypto/cipher#decrypt-final!
    (lambda _g5780_
      (let ((_g5779_ (let () (declare (not safe)) (##length _g5780_))))
        (cond ((let () (declare (not safe)) (##fx= _g5779_ 2))
               (apply std/crypto/cipher#decrypt-final!__0 _g5780_))
              ((let () (declare (not safe)) (##fx= _g5779_ 3))
               (apply std/crypto/cipher#decrypt-final!__% _g5780_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#decrypt-final!
                _g5780_))))))
  (define std/crypto/cipher#encrypt
    (lambda (_cipher1742_ _key1743_ _iv1744_ _in1745_)
      (if (string? _in1745_)
          (std/crypto/cipher#encrypt-u8vector__0
           _cipher1742_
           _key1743_
           _iv1744_
           (std/text/utf8#string->utf8__0 _in1745_))
          (if (u8vector? _in1745_)
              (std/crypto/cipher#encrypt-u8vector__0
               _cipher1742_
               _key1743_
               _iv1744_
               _in1745_)
              (if (input-port? _in1745_)
                  (std/crypto/cipher#encrypt-port
                   _cipher1742_
                   _key1743_
                   _iv1744_
                   _in1745_)
                  (error '"Bad input source" _in1745_))))))
  (define std/crypto/cipher#encrypt-u8vector__%
    (lambda (_cipher1688_ _key1689_ _iv1690_ _in1691_ _start1692_ _end1693_)
      (let* ((_len1695_
              (let () (declare (not safe)) (##fx- _end1693_ _start1692_)))
             (_buflen1698_
              (let ((__tmp5781
                     (let ((__tmp5782
                            (std/crypto/cipher#cipher-block-size
                             _cipher1688_)))
                       (declare (not safe))
                       (##fx* '2 __tmp5782))))
                (declare (not safe))
                (##fx+ _len1695_ __tmp5781)))
             (_buf1701_ (make-u8vector _buflen1698_)))
        (std/crypto/cipher#encrypt-init! _cipher1688_ _key1689_ _iv1690_)
        (let* ((_ulen1705_
                (std/crypto/cipher#encrypt-update!
                 _cipher1688_
                 _buf1701_
                 '0
                 _in1691_
                 _start1692_
                 _end1693_))
               (_flen1708_
                (std/crypto/cipher#encrypt-final!__%
                 _cipher1688_
                 _buf1701_
                 _ulen1705_))
               (_olen1711_
                (let () (declare (not safe)) (##fx+ _ulen1705_ _flen1708_))))
          (if (let () (declare (not safe)) (##fx< _olen1711_ _buflen1698_))
              (u8vector-shrink! _buf1701_ _olen1711_)
              '#!void)
          _buf1701_))))
  (define std/crypto/cipher#encrypt-u8vector__0
    (lambda (_cipher1718_ _key1719_ _iv1720_ _in1721_)
      (let* ((_start1723_ '0) (_end1725_ (u8vector-length _in1721_)))
        (std/crypto/cipher#encrypt-u8vector__%
         _cipher1718_
         _key1719_
         _iv1720_
         _in1721_
         _start1723_
         _end1725_))))
  (define std/crypto/cipher#encrypt-u8vector__1
    (lambda (_cipher1727_ _key1728_ _iv1729_ _in1730_ _start1731_)
      (let ((_end1733_ (u8vector-length _in1730_)))
        (std/crypto/cipher#encrypt-u8vector__%
         _cipher1727_
         _key1728_
         _iv1729_
         _in1730_
         _start1731_
         _end1733_))))
  (define std/crypto/cipher#encrypt-u8vector
    (lambda _g5784_
      (let ((_g5783_ (let () (declare (not safe)) (##length _g5784_))))
        (cond ((let () (declare (not safe)) (##fx= _g5783_ 4))
               (apply std/crypto/cipher#encrypt-u8vector__0 _g5784_))
              ((let () (declare (not safe)) (##fx= _g5783_ 5))
               (apply std/crypto/cipher#encrypt-u8vector__1 _g5784_))
              ((let () (declare (not safe)) (##fx= _g5783_ 6))
               (apply std/crypto/cipher#encrypt-u8vector__% _g5784_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#encrypt-u8vector
                _g5784_))))))
  (define std/crypto/cipher#encrypt-u8vector!
    (lambda (_cipher1672_
             _key1673_
             _iv1674_
             _bytes1675_
             _start1676_
             _end1677_
             _buf1678_)
      (std/crypto/cipher#encrypt-init! _cipher1672_ _key1673_ _iv1674_)
      (let* ((_ulen1680_
              (std/crypto/cipher#encrypt-update!
               _cipher1672_
               _buf1678_
               '0
               _bytes1675_
               _start1676_
               _end1677_))
             (_flen1682_
              (std/crypto/cipher#encrypt-final!__%
               _cipher1672_
               _buf1678_
               _ulen1680_))
             (_olen1684_
              (let () (declare (not safe)) (##fx+ _ulen1680_ _flen1682_))))
        _olen1684_)))
  (define std/crypto/cipher#encrypt-port
    (lambda (_cipher1636_ _key1637_ _iv1638_ _inp1639_)
      (let* ((_bufsz1641_ '1024)
             (_buf1644_
              (make-u8vector
               (let ((__tmp5785
                      (std/crypto/cipher#cipher-block-size _cipher1636_)))
                 (declare (not safe))
                 (##fx+ _bufsz1641_ __tmp5785))))
             (_outp1647_ (open-output-u8vector)))
        (letrec ((_grow-buffer-if-needed1651_
                  (lambda (_ilen1666_)
                    (let ((_max-olen1669_
                           (let ((__tmp5786
                                  (std/crypto/cipher#cipher-block-size
                                   _cipher1636_)))
                             (declare (not safe))
                             (##fx+ _ilen1666_ __tmp5786))))
                      (if (let ((__tmp5787 (u8vector-length _buf1644_)))
                            (declare (not safe))
                            (##fx> _max-olen1669_ __tmp5787))
                          (set! _buf1644_ (make-u8vector _max-olen1669_))
                          '#!void)))))
          (std/crypto/cipher#encrypt-init! _cipher1636_ _key1637_ _iv1638_)
          (std/crypto/etc#call-with-binary-input
           (lambda (_bytes1654_ _start1656_ _end1658_)
             (_grow-buffer-if-needed1651_ (- _end1658_ _start1656_))
             (let ((_olen1661_
                    (std/crypto/cipher#encrypt-update!
                     _cipher1636_
                     _buf1644_
                     '0
                     _bytes1654_
                     _start1656_
                     _end1658_)))
               (write-subu8vector _buf1644_ '0 _olen1661_ _outp1647_)))
           _inp1639_)
          (let ((_olen1664_
                 (std/crypto/cipher#encrypt-final!__0 _cipher1636_ _buf1644_)))
            (write-subu8vector _buf1644_ '0 _olen1664_ _outp1647_)
            (get-output-u8vector _outp1647_))))))
  (define std/crypto/cipher#decrypt
    (lambda (_cipher1631_ _key1632_ _iv1633_ _in1634_)
      (if (u8vector? _in1634_)
          (std/crypto/cipher#decrypt-u8vector__0
           _cipher1631_
           _key1632_
           _iv1633_
           _in1634_)
          (if (input-port? _in1634_)
              (std/crypto/cipher#decrypt-port
               _cipher1631_
               _key1632_
               _iv1633_
               _in1634_)
              (error '"Bad input source" _in1634_)))))
  (define std/crypto/cipher#decrypt-u8vector__%
    (lambda (_cipher1577_ _key1578_ _iv1579_ _in1580_ _start1581_ _end1582_)
      (let* ((_len1584_
              (let () (declare (not safe)) (##fx- _end1582_ _start1581_)))
             (_buflen1587_
              (let ((__tmp5788
                     (let ((__tmp5789
                            (std/crypto/cipher#cipher-block-size
                             _cipher1577_)))
                       (declare (not safe))
                       (##fx* '2 __tmp5789))))
                (declare (not safe))
                (##fx+ _len1584_ __tmp5788)))
             (_buf1590_ (make-u8vector _buflen1587_)))
        (std/crypto/cipher#decrypt-init! _cipher1577_ _key1578_ _iv1579_)
        (let* ((_ulen1594_
                (std/crypto/cipher#decrypt-update!
                 _cipher1577_
                 _buf1590_
                 '0
                 _in1580_
                 _start1581_
                 _end1582_))
               (_flen1597_
                (std/crypto/cipher#decrypt-final!__%
                 _cipher1577_
                 _buf1590_
                 _ulen1594_))
               (_olen1600_
                (let () (declare (not safe)) (##fx+ _ulen1594_ _flen1597_))))
          (if (let () (declare (not safe)) (##fx< _olen1600_ _buflen1587_))
              (u8vector-shrink! _buf1590_ _olen1600_)
              '#!void)
          _buf1590_))))
  (define std/crypto/cipher#decrypt-u8vector__0
    (lambda (_cipher1607_ _key1608_ _iv1609_ _in1610_)
      (let* ((_start1612_ '0) (_end1614_ (u8vector-length _in1610_)))
        (std/crypto/cipher#decrypt-u8vector__%
         _cipher1607_
         _key1608_
         _iv1609_
         _in1610_
         _start1612_
         _end1614_))))
  (define std/crypto/cipher#decrypt-u8vector__1
    (lambda (_cipher1616_ _key1617_ _iv1618_ _in1619_ _start1620_)
      (let ((_end1622_ (u8vector-length _in1619_)))
        (std/crypto/cipher#decrypt-u8vector__%
         _cipher1616_
         _key1617_
         _iv1618_
         _in1619_
         _start1620_
         _end1622_))))
  (define std/crypto/cipher#decrypt-u8vector
    (lambda _g5791_
      (let ((_g5790_ (let () (declare (not safe)) (##length _g5791_))))
        (cond ((let () (declare (not safe)) (##fx= _g5790_ 4))
               (apply std/crypto/cipher#decrypt-u8vector__0 _g5791_))
              ((let () (declare (not safe)) (##fx= _g5790_ 5))
               (apply std/crypto/cipher#decrypt-u8vector__1 _g5791_))
              ((let () (declare (not safe)) (##fx= _g5790_ 6))
               (apply std/crypto/cipher#decrypt-u8vector__% _g5791_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/cipher#decrypt-u8vector
                _g5791_))))))
  (define std/crypto/cipher#decrypt-u8vector!
    (lambda (_cipher1561_
             _key1562_
             _iv1563_
             _bytes1564_
             _start1565_
             _end1566_
             _buf1567_)
      (std/crypto/cipher#decrypt-init! _cipher1561_ _key1562_ _iv1563_)
      (let* ((_ulen1569_
              (std/crypto/cipher#decrypt-update!
               _cipher1561_
               _buf1567_
               '0
               _bytes1564_
               _start1565_
               _end1566_))
             (_flen1571_
              (std/crypto/cipher#decrypt-final!__%
               _cipher1561_
               _buf1567_
               _ulen1569_))
             (_olen1573_
              (let () (declare (not safe)) (##fx+ _ulen1569_ _flen1571_))))
        _olen1573_)))
  (define std/crypto/cipher#decrypt-port
    (lambda (_cipher1525_ _key1526_ _iv1527_ _inp1528_)
      (let* ((_bufsz1530_ '1024)
             (_buf1533_
              (make-u8vector
               (let ((__tmp5792
                      (std/crypto/cipher#cipher-block-size _cipher1525_)))
                 (declare (not safe))
                 (##fx+ _bufsz1530_ __tmp5792))))
             (_outp1536_ (open-output-u8vector)))
        (letrec ((_grow-buffer-if-needed1540_
                  (lambda (_ilen1555_)
                    (let ((_max-olen1558_
                           (let ((__tmp5793
                                  (std/crypto/cipher#cipher-block-size
                                   _cipher1525_)))
                             (declare (not safe))
                             (##fx+ _ilen1555_ __tmp5793))))
                      (if (let ((__tmp5794 (u8vector-length _buf1533_)))
                            (declare (not safe))
                            (##fx> _max-olen1558_ __tmp5794))
                          (set! _buf1533_ (make-u8vector _max-olen1558_))
                          '#!void)))))
          (std/crypto/cipher#decrypt-init! _cipher1525_ _key1526_ _iv1527_)
          (std/crypto/etc#call-with-binary-input
           (lambda (_bytes1543_ _start1545_ _end1547_)
             (_grow-buffer-if-needed1540_ (- _end1547_ _start1545_))
             (let ((_olen1550_
                    (std/crypto/cipher#decrypt-update!
                     _cipher1525_
                     _buf1533_
                     '0
                     _bytes1543_
                     _start1545_
                     _end1547_)))
               (write-subu8vector _buf1533_ '0 _olen1550_ _outp1536_)))
           _inp1528_)
          (let ((_olen1553_
                 (std/crypto/cipher#decrypt-final!__0 _cipher1525_ _buf1533_)))
            (write-subu8vector _buf1533_ '0 _olen1553_ _outp1536_)
            (get-output-u8vector _outp1536_))))))
  (define std/crypto/cipher#cipher::aes-128-ecb
    (std/crypto/libcrypto#EVP_aes_128_ecb))
  (define std/crypto/cipher#make-aes-128-ecb-cipher
    (lambda ()
      (let ((__obj5732 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5732
         std/crypto/cipher#cipher::aes-128-ecb)
        __obj5732)))
  (define std/crypto/cipher#aes-128-ecb-cipher?
    (lambda (_obj1522_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1522_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1522_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-cbc
    (std/crypto/libcrypto#EVP_aes_128_cbc))
  (define std/crypto/cipher#make-aes-128-cbc-cipher
    (lambda ()
      (let ((__obj5733 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5733
         std/crypto/cipher#cipher::aes-128-cbc)
        __obj5733)))
  (define std/crypto/cipher#aes-128-cbc-cipher?
    (lambda (_obj1519_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1519_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1519_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-cfb
    (std/crypto/libcrypto#EVP_aes_128_cfb))
  (define std/crypto/cipher#make-aes-128-cfb-cipher
    (lambda ()
      (let ((__obj5734 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5734
         std/crypto/cipher#cipher::aes-128-cfb)
        __obj5734)))
  (define std/crypto/cipher#aes-128-cfb-cipher?
    (lambda (_obj1516_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1516_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1516_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-ofb
    (std/crypto/libcrypto#EVP_aes_128_ofb))
  (define std/crypto/cipher#make-aes-128-ofb-cipher
    (lambda ()
      (let ((__obj5735 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5735
         std/crypto/cipher#cipher::aes-128-ofb)
        __obj5735)))
  (define std/crypto/cipher#aes-128-ofb-cipher?
    (lambda (_obj1513_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1513_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1513_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-ctr
    (std/crypto/libcrypto#EVP_aes_128_ctr))
  (define std/crypto/cipher#make-aes-128-ctr-cipher
    (lambda ()
      (let ((__obj5736 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5736
         std/crypto/cipher#cipher::aes-128-ctr)
        __obj5736)))
  (define std/crypto/cipher#aes-128-ctr-cipher?
    (lambda (_obj1510_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1510_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1510_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ctr))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-ccm
    (std/crypto/libcrypto#EVP_aes_128_ccm))
  (define std/crypto/cipher#make-aes-128-ccm-cipher
    (lambda ()
      (let ((__obj5737 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5737
         std/crypto/cipher#cipher::aes-128-ccm)
        __obj5737)))
  (define std/crypto/cipher#aes-128-ccm-cipher?
    (lambda (_obj1507_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1507_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1507_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-ccm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-gcm
    (std/crypto/libcrypto#EVP_aes_128_gcm))
  (define std/crypto/cipher#make-aes-128-gcm-cipher
    (lambda ()
      (let ((__obj5738 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5738
         std/crypto/cipher#cipher::aes-128-gcm)
        __obj5738)))
  (define std/crypto/cipher#aes-128-gcm-cipher?
    (lambda (_obj1504_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1504_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1504_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-gcm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-128-xts
    (std/crypto/libcrypto#EVP_aes_128_xts))
  (define std/crypto/cipher#make-aes-128-xts-cipher
    (lambda ()
      (let ((__obj5739 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5739
         std/crypto/cipher#cipher::aes-128-xts)
        __obj5739)))
  (define std/crypto/cipher#aes-128-xts-cipher?
    (lambda (_obj1500_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1500_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1500_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-128-xts))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ecb
    (std/crypto/libcrypto#EVP_aes_192_ecb))
  (define std/crypto/cipher#make-aes-192-ecb-cipher
    (lambda ()
      (let ((__obj5740 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5740
         std/crypto/cipher#cipher::aes-192-ecb)
        __obj5740)))
  (define std/crypto/cipher#aes-192-ecb-cipher?
    (lambda (_obj1497_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1497_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1497_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-cbc
    (std/crypto/libcrypto#EVP_aes_192_cbc))
  (define std/crypto/cipher#make-aes-192-cbc-cipher
    (lambda ()
      (let ((__obj5741 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5741
         std/crypto/cipher#cipher::aes-192-cbc)
        __obj5741)))
  (define std/crypto/cipher#aes-192-cbc-cipher?
    (lambda (_obj1494_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1494_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1494_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-cfb
    (std/crypto/libcrypto#EVP_aes_192_cfb))
  (define std/crypto/cipher#make-aes-192-cfb-cipher
    (lambda ()
      (let ((__obj5742 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5742
         std/crypto/cipher#cipher::aes-192-cfb)
        __obj5742)))
  (define std/crypto/cipher#aes-192-cfb-cipher?
    (lambda (_obj1491_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1491_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1491_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ofb
    (std/crypto/libcrypto#EVP_aes_192_ofb))
  (define std/crypto/cipher#make-aes-192-ofb-cipher
    (lambda ()
      (let ((__obj5743 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5743
         std/crypto/cipher#cipher::aes-192-ofb)
        __obj5743)))
  (define std/crypto/cipher#aes-192-ofb-cipher?
    (lambda (_obj1488_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1488_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1488_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ctr
    (std/crypto/libcrypto#EVP_aes_192_ctr))
  (define std/crypto/cipher#make-aes-192-ctr-cipher
    (lambda ()
      (let ((__obj5744 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5744
         std/crypto/cipher#cipher::aes-192-ctr)
        __obj5744)))
  (define std/crypto/cipher#aes-192-ctr-cipher?
    (lambda (_obj1485_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1485_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1485_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ctr))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-ccm
    (std/crypto/libcrypto#EVP_aes_192_ccm))
  (define std/crypto/cipher#make-aes-192-ccm-cipher
    (lambda ()
      (let ((__obj5745 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5745
         std/crypto/cipher#cipher::aes-192-ccm)
        __obj5745)))
  (define std/crypto/cipher#aes-192-ccm-cipher?
    (lambda (_obj1482_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1482_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1482_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-ccm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-192-gcm
    (std/crypto/libcrypto#EVP_aes_192_gcm))
  (define std/crypto/cipher#make-aes-192-gcm-cipher
    (lambda ()
      (let ((__obj5746 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5746
         std/crypto/cipher#cipher::aes-192-gcm)
        __obj5746)))
  (define std/crypto/cipher#aes-192-gcm-cipher?
    (lambda (_obj1478_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1478_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1478_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-192-gcm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ecb
    (std/crypto/libcrypto#EVP_aes_256_ecb))
  (define std/crypto/cipher#make-aes-256-ecb-cipher
    (lambda ()
      (let ((__obj5747 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5747
         std/crypto/cipher#cipher::aes-256-ecb)
        __obj5747)))
  (define std/crypto/cipher#aes-256-ecb-cipher?
    (lambda (_obj1475_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1475_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1475_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-cbc
    (std/crypto/libcrypto#EVP_aes_256_cbc))
  (define std/crypto/cipher#make-aes-256-cbc-cipher
    (lambda ()
      (let ((__obj5748 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5748
         std/crypto/cipher#cipher::aes-256-cbc)
        __obj5748)))
  (define std/crypto/cipher#aes-256-cbc-cipher?
    (lambda (_obj1472_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1472_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1472_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-cfb
    (std/crypto/libcrypto#EVP_aes_256_cfb))
  (define std/crypto/cipher#make-aes-256-cfb-cipher
    (lambda ()
      (let ((__obj5749 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5749
         std/crypto/cipher#cipher::aes-256-cfb)
        __obj5749)))
  (define std/crypto/cipher#aes-256-cfb-cipher?
    (lambda (_obj1469_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1469_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1469_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ofb
    (std/crypto/libcrypto#EVP_aes_256_ofb))
  (define std/crypto/cipher#make-aes-256-ofb-cipher
    (lambda ()
      (let ((__obj5750 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5750
         std/crypto/cipher#cipher::aes-256-ofb)
        __obj5750)))
  (define std/crypto/cipher#aes-256-ofb-cipher?
    (lambda (_obj1466_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1466_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1466_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ctr
    (std/crypto/libcrypto#EVP_aes_256_ctr))
  (define std/crypto/cipher#make-aes-256-ctr-cipher
    (lambda ()
      (let ((__obj5751 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5751
         std/crypto/cipher#cipher::aes-256-ctr)
        __obj5751)))
  (define std/crypto/cipher#aes-256-ctr-cipher?
    (lambda (_obj1463_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1463_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1463_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ctr))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-ccm
    (std/crypto/libcrypto#EVP_aes_256_ccm))
  (define std/crypto/cipher#make-aes-256-ccm-cipher
    (lambda ()
      (let ((__obj5752 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5752
         std/crypto/cipher#cipher::aes-256-ccm)
        __obj5752)))
  (define std/crypto/cipher#aes-256-ccm-cipher?
    (lambda (_obj1460_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1460_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1460_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-ccm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-gcm
    (std/crypto/libcrypto#EVP_aes_256_gcm))
  (define std/crypto/cipher#make-aes-256-gcm-cipher
    (lambda ()
      (let ((__obj5753 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5753
         std/crypto/cipher#cipher::aes-256-gcm)
        __obj5753)))
  (define std/crypto/cipher#aes-256-gcm-cipher?
    (lambda (_obj1457_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1457_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1457_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-gcm))
          '#f)))
  (define std/crypto/cipher#cipher::aes-256-xts
    (std/crypto/libcrypto#EVP_aes_256_xts))
  (define std/crypto/cipher#make-aes-256-xts-cipher
    (lambda ()
      (let ((__obj5754 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5754
         std/crypto/cipher#cipher::aes-256-xts)
        __obj5754)))
  (define std/crypto/cipher#aes-256-xts-cipher?
    (lambda (_obj1453_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1453_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1453_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::aes-256-xts))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-ecb
    (std/crypto/libcrypto#EVP_camellia_128_ecb))
  (define std/crypto/cipher#make-camellia-128-ecb-cipher
    (lambda ()
      (let ((__obj5755 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5755
         std/crypto/cipher#cipher::camellia-128-ecb)
        __obj5755)))
  (define std/crypto/cipher#camellia-128-ecb-cipher?
    (lambda (_obj1450_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1450_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1450_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-cbc
    (std/crypto/libcrypto#EVP_camellia_128_cbc))
  (define std/crypto/cipher#make-camellia-128-cbc-cipher
    (lambda ()
      (let ((__obj5756 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5756
         std/crypto/cipher#cipher::camellia-128-cbc)
        __obj5756)))
  (define std/crypto/cipher#camellia-128-cbc-cipher?
    (lambda (_obj1447_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1447_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1447_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-cfb
    (std/crypto/libcrypto#EVP_camellia_128_cfb))
  (define std/crypto/cipher#make-camellia-128-cfb-cipher
    (lambda ()
      (let ((__obj5757 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5757
         std/crypto/cipher#cipher::camellia-128-cfb)
        __obj5757)))
  (define std/crypto/cipher#camellia-128-cfb-cipher?
    (lambda (_obj1444_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1444_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1444_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-128-ofb
    (std/crypto/libcrypto#EVP_camellia_128_ofb))
  (define std/crypto/cipher#make-camellia-128-ofb-cipher
    (lambda ()
      (let ((__obj5758 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5758
         std/crypto/cipher#cipher::camellia-128-ofb)
        __obj5758)))
  (define std/crypto/cipher#camellia-128-ofb-cipher?
    (lambda (_obj1440_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1440_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1440_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-128-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-ecb
    (std/crypto/libcrypto#EVP_camellia_192_ecb))
  (define std/crypto/cipher#make-camellia-192-ecb-cipher
    (lambda ()
      (let ((__obj5759 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5759
         std/crypto/cipher#cipher::camellia-192-ecb)
        __obj5759)))
  (define std/crypto/cipher#camellia-192-ecb-cipher?
    (lambda (_obj1437_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1437_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1437_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-cbc
    (std/crypto/libcrypto#EVP_camellia_192_cbc))
  (define std/crypto/cipher#make-camellia-192-cbc-cipher
    (lambda ()
      (let ((__obj5760 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5760
         std/crypto/cipher#cipher::camellia-192-cbc)
        __obj5760)))
  (define std/crypto/cipher#camellia-192-cbc-cipher?
    (lambda (_obj1434_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1434_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1434_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-cfb
    (std/crypto/libcrypto#EVP_camellia_192_cfb))
  (define std/crypto/cipher#make-camellia-192-cfb-cipher
    (lambda ()
      (let ((__obj5761 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5761
         std/crypto/cipher#cipher::camellia-192-cfb)
        __obj5761)))
  (define std/crypto/cipher#camellia-192-cfb-cipher?
    (lambda (_obj1431_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1431_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1431_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-192-ofb
    (std/crypto/libcrypto#EVP_camellia_192_ofb))
  (define std/crypto/cipher#make-camellia-192-ofb-cipher
    (lambda ()
      (let ((__obj5762 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5762
         std/crypto/cipher#cipher::camellia-192-ofb)
        __obj5762)))
  (define std/crypto/cipher#camellia-192-ofb-cipher?
    (lambda (_obj1427_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1427_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1427_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-192-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-ecb
    (std/crypto/libcrypto#EVP_camellia_256_ecb))
  (define std/crypto/cipher#make-camellia-256-ecb-cipher
    (lambda ()
      (let ((__obj5763 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5763
         std/crypto/cipher#cipher::camellia-256-ecb)
        __obj5763)))
  (define std/crypto/cipher#camellia-256-ecb-cipher?
    (lambda (_obj1424_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1424_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1424_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-cbc
    (std/crypto/libcrypto#EVP_camellia_256_cbc))
  (define std/crypto/cipher#make-camellia-256-cbc-cipher
    (lambda ()
      (let ((__obj5764 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5764
         std/crypto/cipher#cipher::camellia-256-cbc)
        __obj5764)))
  (define std/crypto/cipher#camellia-256-cbc-cipher?
    (lambda (_obj1421_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1421_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1421_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-cfb
    (std/crypto/libcrypto#EVP_camellia_256_cfb))
  (define std/crypto/cipher#make-camellia-256-cfb-cipher
    (lambda ()
      (let ((__obj5765 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5765
         std/crypto/cipher#cipher::camellia-256-cfb)
        __obj5765)))
  (define std/crypto/cipher#camellia-256-cfb-cipher?
    (lambda (_obj1418_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1418_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1418_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::camellia-256-ofb
    (std/crypto/libcrypto#EVP_camellia_256_ofb))
  (define std/crypto/cipher#make-camellia-256-ofb-cipher
    (lambda ()
      (let ((__obj5766 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5766
         std/crypto/cipher#cipher::camellia-256-ofb)
        __obj5766)))
  (define std/crypto/cipher#camellia-256-ofb-cipher?
    (lambda (_obj1414_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1414_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1414_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::camellia-256-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-ecb
    (std/crypto/libcrypto#EVP_cast5_ecb))
  (define std/crypto/cipher#make-cast5-ecb-cipher
    (lambda ()
      (let ((__obj5767 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5767
         std/crypto/cipher#cipher::cast5-ecb)
        __obj5767)))
  (define std/crypto/cipher#cast5-ecb-cipher?
    (lambda (_obj1411_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1411_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1411_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-cbc
    (std/crypto/libcrypto#EVP_cast5_cbc))
  (define std/crypto/cipher#make-cast5-cbc-cipher
    (lambda ()
      (let ((__obj5768 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5768
         std/crypto/cipher#cipher::cast5-cbc)
        __obj5768)))
  (define std/crypto/cipher#cast5-cbc-cipher?
    (lambda (_obj1408_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1408_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1408_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-cfb
    (std/crypto/libcrypto#EVP_cast5_cfb))
  (define std/crypto/cipher#make-cast5-cfb-cipher
    (lambda ()
      (let ((__obj5769 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5769
         std/crypto/cipher#cipher::cast5-cfb)
        __obj5769)))
  (define std/crypto/cipher#cast5-cfb-cipher?
    (lambda (_obj1405_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1405_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1405_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::cast5-ofb
    (std/crypto/libcrypto#EVP_cast5_ofb))
  (define std/crypto/cipher#make-cast5-ofb-cipher
    (lambda ()
      (let ((__obj5770 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5770
         std/crypto/cipher#cipher::cast5-ofb)
        __obj5770)))
  (define std/crypto/cipher#cast5-ofb-cipher?
    (lambda (_obj1401_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1401_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1401_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::cast5-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::bf-ecb (std/crypto/libcrypto#EVP_bf_ecb))
  (define std/crypto/cipher#make-bf-ecb-cipher
    (lambda ()
      (let ((__obj5771 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5771
         std/crypto/cipher#cipher::bf-ecb)
        __obj5771)))
  (define std/crypto/cipher#bf-ecb-cipher?
    (lambda (_obj1398_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1398_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1398_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-ecb))
          '#f)))
  (define std/crypto/cipher#cipher::bf-cbc (std/crypto/libcrypto#EVP_bf_cbc))
  (define std/crypto/cipher#make-bf-cbc-cipher
    (lambda ()
      (let ((__obj5772 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5772
         std/crypto/cipher#cipher::bf-cbc)
        __obj5772)))
  (define std/crypto/cipher#bf-cbc-cipher?
    (lambda (_obj1395_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1395_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1395_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-cbc))
          '#f)))
  (define std/crypto/cipher#cipher::bf-cfb (std/crypto/libcrypto#EVP_bf_cfb))
  (define std/crypto/cipher#make-bf-cfb-cipher
    (lambda ()
      (let ((__obj5773 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5773
         std/crypto/cipher#cipher::bf-cfb)
        __obj5773)))
  (define std/crypto/cipher#bf-cfb-cipher?
    (lambda (_obj1392_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1392_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1392_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-cfb))
          '#f)))
  (define std/crypto/cipher#cipher::bf-ofb (std/crypto/libcrypto#EVP_bf_ofb))
  (define std/crypto/cipher#make-bf-ofb-cipher
    (lambda ()
      (let ((__obj5774 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5774
         std/crypto/cipher#cipher::bf-ofb)
        __obj5774)))
  (define std/crypto/cipher#bf-ofb-cipher?
    (lambda (_obj1388_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1388_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1388_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::bf-ofb))
          '#f)))
  (define std/crypto/cipher#cipher::rc4 (std/crypto/libcrypto#EVP_rc4))
  (define std/crypto/cipher#make-rc4-cipher
    (lambda ()
      (let ((__obj5775 (make-object std/crypto/cipher#cipher::t '2)))
        (std/crypto/cipher#cipher:::init!
         __obj5775
         std/crypto/cipher#cipher::rc4)
        __obj5775)))
  (define std/crypto/cipher#rc4-cipher?
    (lambda (_obj1384_)
      (if (let ()
            (declare (not safe))
            (##structure-instance-of? _obj1384_ 'std/crypto#cipher::t))
          (eq? (std/crypto/libcrypto#EVP_CIPHER_nid
                (##structure-ref _obj1384_ '1 std/crypto/cipher#cipher::t '#f))
               (std/crypto/libcrypto#EVP_CIPHER_nid
                std/crypto/cipher#cipher::rc4))
          '#f))))
