/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Draw/Shape/ShapePolygonPP/Tests/ShapePolygonPPTest02.js
// Timestamp   : 2011-02-28 10:37:40
// Description : Regular polygons, 3 up to 8 lines, defined by base line

include('scripts/Developer/TestingDashboard/TdbTest.js');

function ShapePolygonPPTest02() {
    TdbTest.call(this, 'scripts/Draw/Shape/ShapePolygonPP/Tests/ShapePolygonPPTest02.js');
}

ShapePolygonPPTest02.prototype = new TdbTest();

ShapePolygonPPTest02.prototype.test00 = function() {
    qDebug('running ShapePolygonPPTest02.test00()...');
    this.setUp();
    this.clickOnWidget('MainWindow::MainToolsPanel::ShapeToolsPanelButton');
    this.clickOnWidget('MainWindow::ShapeToolsPanel::ShapePolygonPPButton');
    this.setToolOption('ShapePolygonPP/Corners', '3');
    this.setToolOption('Shape/CreatePolyline', 'true');
    this.setToolOption('Shape/Fill', 'true');
    this.updateToolOptions();
    this.setZoom(10, new RVector(5, 5, 0) );
    var p = new RVector(9.9, -0.1);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(9.9, -0.1);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(10, new RVector(5, 5, 0) );
    var p = new RVector(30, -0.1);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(30, -0.1);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('ShapePolygonPP/Corners', '4');
    this.setToolOption('Shape/CreatePolyline', 'true');
    this.setToolOption('Shape/Fill', 'true');
    this.updateToolOptions();
    this.setZoom(10, new RVector(5, 5, 0) );
    var p = new RVector(9.9, -0.1);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(9.9, -0.1);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(10, new RVector(5, 5, 0) );
    var p = new RVector(29.9, -0.2);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(29.9, -0.2);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('ShapePolygonPP/Corners', '5');
    this.setToolOption('Shape/CreatePolyline', 'true');
    this.setToolOption('Shape/Fill', 'true');
    this.updateToolOptions();
    this.setZoom(10, new RVector(5, 5, 0) );
    var p = new RVector(10, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(10, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(10, new RVector(5, 5, 0) );
    var p = new RVector(29.8, 0.2);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(29.8, 0.2);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('ShapePolygonPP/Corners', '6');
    this.setToolOption('Shape/CreatePolyline', 'true');
    this.setToolOption('Shape/Fill', 'true');
    this.updateToolOptions();
    this.setZoom(8.333333333333334, new RVector(9.88, 8.1, 0) );
    var p = new RVector(9.92, -0.06);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(9.92, -0.06);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(8.333333333333334, new RVector(9.88, 8.1, 0) );
    var p = new RVector(29.96, -0.06);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(29.96, -0.06);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('ShapePolygonPP/Corners', '7');
    this.setToolOption('Shape/CreatePolyline', 'true');
    this.setToolOption('Shape/Fill', 'true');
    this.updateToolOptions();
    this.setZoom(6.9444444444444455, new RVector(14.344, 11.652, 0) );
    var p = new RVector(9.992, -0.132);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(9.992, -0.132);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(6.9444444444444455, new RVector(14.344, 11.652, 0) );
    var p = new RVector(29.864, -0.132);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(29.864, -0.132);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('ShapePolygonPP/Corners', '8');
    this.setToolOption('Shape/CreatePolyline', 'true');
    this.setToolOption('Shape/Fill', 'true');
    this.updateToolOptions();
    this.setZoom(5.787037037037038, new RVector(20.7088, 17.4408, 0) );
    var p = new RVector(9.8768, -0.1608);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(9.8768, -0.1608);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(5.787037037037038, new RVector(20.7088, 17.4408, 0) );
    var p = new RVector(29.4032, -0.3336);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    var p = new RVector(29.4032, -0.3336);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    var p = new RVector(44.6096, 1.3944);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.RightButton, 2, 0);
    var p = new RVector(44.6096, 1.3944);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.RightButton, 0, 0);
    this.verifyDrawing('ShapePolygonPPTest02_000.dxf');
    this.tearDown();
    qDebug('finished ShapePolygonPPTest02.test00()');
};

