// ****************************************************************************
//
//          Aevol - An in silico experimental evolution platform
//
// ****************************************************************************
//
// Copyright: See the AUTHORS file provided with the package or <www.aevol.fr>
// Web: http://www.aevol.fr/
// E-mail: See <http://www.aevol.fr/contact/>
// Original Authors : Guillaume Beslon, Carole Knibbe, David Parsons
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ****************************************************************************

#ifndef AEVOL_FASTA_WRITER_H_
#define AEVOL_FASTA_WRITER_H_

#include <filesystem>
#include <fstream>

#include "fasta.h"
#include "FastaModifiers.h"
#include "indiv_idxs_map.h"

namespace aevol {

class FastaWriter {
 public:
  FastaWriter()                              = delete;
  FastaWriter(const FastaWriter&)            = delete;
  FastaWriter(FastaWriter&&)                 = delete;
  FastaWriter& operator=(const FastaWriter&) = delete;
  FastaWriter& operator=(FastaWriter&&)      = delete;
  virtual ~FastaWriter()                     = default;

  FastaWriter(std::filesystem::path filename);

  template<class T>
  FastaWriter& operator<<(const T& v);

  bool fail() const { return out_.fail(); };
  explicit operator bool() const { return !fail(); };

  void write_individual(const std::string& seqid, const Individual& individual, const FastaModifiers& modifiers);
  void write_individual(const indivs_idxs_sorted_map_t::value_type& entry, bool clonal_population);

 protected:
  std::filesystem::path filename_;
  std::ofstream out_;
};

template<class T>
FastaWriter& FastaWriter::operator<<(const T& v) {
  out_ << v;
  return *this;
}

}  // namespace aevol

#endif  // AEVOL_FASTA_WRITER_H_
