from __future__ import absolute_import, division, print_function
from six.moves import range
from rstbx.diffraction import rotation_angles
from cctbx.crystal_orientation import crystal_orientation,basis_type
from libtbx.test_utils import approx_equal

test_results=[
((-4, -3, -5),(-2.1644080756068704, 0.82603163906757826)),
((-4, -3, -4),(-2.1563824130204701, 0.83451621989551883)),
((-4, -3, -3),(-2.1476369882498436, 0.84275362492632477)),
((-4, -3, -2),(-2.1381420481925733, 0.85073212909354023)),
((-4, -3, -1),(-2.1278664357865269, 0.85843936020563638)),
((-4, -3, 0),(-2.1167775302687417, 0.86586226386067811)),
((-4, -3, 1),(-2.1048411851088034, 0.87298706505447998)),
((-4, -3, 2),(-2.0920216634827948, 0.87979922593866833)),
((-4, -2, -8),(-2.3517102079316765, 0.63998771713383507)),
((-4, -2, -7),(-2.3478281931611629, 0.64721041614149566)),
((-4, -2, -6),(-2.3433224076234787, 0.65416216116158055)),
((-4, -2, -5),(-2.338163187294632, 0.66082958483881171)),
((-4, -2, -4),(-2.3323190243690588, 0.66719843977099291)),
((-4, -2, -3),(-2.3257564359156206, 0.67325353443169111)),
((-4, -2, -2),(-2.3184398205079146, 0.67897866221111858)),
((-4, -2, -1),(-2.3103313013994797, 0.68435652253111579)),
((-4, -2, 0),(-2.3013905545938611, 0.68936863278894389)),
((-4, -2, 1),(-2.2915746198968177, 0.69399522963913585)),
((-4, -2, 2),(-2.2808376927234328, 0.69821515782199495)),
((-4, -2, 3),(-2.2691308940541397, 0.70200574437742413)),
((-4, -2, 4),(-2.2564020154745883, 0.70534265562555354)),
((-4, -2, 5),(-2.2425952356738228, 0.70819973372741496)),
((-4, -1, -9),(-2.5308098266764345, 0.46028415341980455)),
((-4, -1, -8),(-2.5302848214986784, 0.46514725234493398)),
((-4, -1, -7),(-2.5292342273209871, 0.46966628410773587)),
((-4, -1, -6),(-2.5276312561197014, 0.47382369995636803)),
((-4, -1, -5),(-2.5254472282330442, 0.47760069073118888)),
((-4, -1, -4),(-2.5226514099331481, 0.48097707866688094)),
((-4, -1, -3),(-2.5192108323762348, 0.4839311961914976)),
((-4, -1, -2),(-2.5150900891927819, 0.4864397496659289)),
((-4, -1, -1),(-2.5102511094811852, 0.48847766560364997)),
((-4, -1, 0),(-2.5046529023623023, 0.49001791641395342)),
((-4, -1, 1),(-2.4982512685115954, 0.49103132209800959)),
((-4, -1, 2),(-2.4909984731750785, 0.49148632356375704)),
((-4, -1, 3),(-2.4828428740492936, 0.49134872227079812)),
((-4, -1, 4),(-2.4737284960041088, 0.49058137971448473)),
((-4, -1, 5),(-2.4635945428704575, 0.48914386873456728)),
((-4, -1, 6),(-2.4523748342967511, 0.48699206668781031)),
((-4, 0, -9),(-2.7075479183479456, 0.28262514671259681)),
((-4, 0, -8),(-2.7099907535850076, 0.28453239000476199)),
((-4, 0, -7),(-2.712011168841761, 0.28599904122031838)),
((-4, 0, -6),(-2.7135874843901879, 0.28700247991898331)),
((-4, 0, -5),(-2.7146964449166768, 0.28751844401101351)),
((-4, 0, -4),(-2.7153130789933311, 0.28752088332609876)),
((-4, 0, -3),(-2.7154105413808369, 0.28698179536956087)),
((-4, 0, -2),(-2.7149599354532072, 0.28587104047261436)),
((-4, 0, -1),(-2.7139301125074402, 0.28415613300355697)),
((-4, 0, 0),(-2.7122874440734508, 0.28180200464428157)),
((-4, 0, 1),(-2.7099955625391106, 0.2787707349185628)),
((-4, 0, 2),(-2.7070150644101365, 0.2750212431429222)),
((-4, 0, 3),(-2.7033031692799137, 0.2705089347019079)),
((-4, 0, 4),(-2.6988133260168774, 0.26518529295327825)),
((-4, 0, 5),(-2.6934947556889823, 0.25899740604605698)),
((-4, 0, 6),(-2.6872919182034409, 0.25188741535194725)),
((-4, 1, -8),(-2.8796653646852977, 0.10938810433468421)),
((-4, 1, -7),(-2.8844290526903671, 0.10802314514838145)),
((-4, 1, -6),(-2.8888544340477269, 0.10612014605319227)),
((-4, 1, -5),(-2.8929247721042515, 0.10365257781794722)),
((-4, 1, -4),(-2.8966221726532195, 0.10059211225346927)),
((-4, 1, -3),(-2.8999274875451237, 0.096908473277887167)),
((-4, 1, -2),(-2.90282020686249, 0.09256927138710698)),
((-4, 1, -1),(-2.9052783378602522, 0.087539819143462594)),
((-4, 1, 0),(-2.9072782685237462, 0.081782924869921295)),
((-4, 1, 1),(-2.9087946131676299, 0.075258661221423648)),
((-4, 1, 2),(-2.9098000369706947, 0.067924104676897204)),
((-4, 1, 3),(-2.9102650556866623, 0.059733041226309229)),
((-4, 1, 4),(-2.9101578059546229, 0.050635632579456205)),
((-4, 1, 5),(-2.909443780608759, 0.040578036048329796)),
((-4, 2, -3),(-3.0621609181560006, -0.075176923028023243)),
((-4, 2, -2),(-3.0675200578810209, -0.081831067832066243)),
((-4, 2, -1),(-3.0725497629968923, -0.089189117263163406)),
((-4, 2, 0),(-3.0772340546619521, -0.097283839954712306)),
((-3, -4, -9),(-1.9186807978345002, 1.0678756183194666)),
((-3, -4, -8),(-1.9095408418739945, 1.0821170500791975)),
((-3, -4, -7),(-1.8996857140430228, 1.0962061655013031)),
((-3, -4, -6),(-1.8890926257610019, 1.1101336310873262)),
((-3, -4, -5),(-1.8777383483996397, 1.1238896353781627)),
((-3, -4, -4),(-1.8655992637788497, 1.1374638864261277)),
((-3, -4, -3),(-1.8526514223811588, 1.1508456108700291)),
((-3, -4, -2),(-1.8388706097467478, 1.1640235547087561)),
((-3, -4, -1),(-1.8242324214645822, 1.1769859858454257)),
((-3, -4, 0),(-1.8087123471112596, 1.189720698444829)),
((-3, -4, 1),(-1.7922858634060383, 1.2022150191114247)),
((-3, -4, 2),(-1.7749285367455292, 1.214455814852786)),
((-3, -4, 3),(-1.7566161351529119, 1.2264295027444108)),
((-3, -4, 4),(-1.7373247495219588, 1.2381220611555419)),
((-3, -4, 5),(-1.717030923854153, 1.249519042332484)),
((-3, -4, 6),(-1.6957117939762307, 1.2606055860656162)),
((-3, -3, -12),(-2.1014485380247865, 0.87645308424953716)),
((-3, -3, -11),(-2.0957357801431784, 0.89042140922191038)),
((-3, -3, -10),(-2.089318695933847, 0.90427646297309716)),
((-3, -3, -9),(-2.0821669686519959, 0.91801060121359623)),
((-3, -3, -8),(-2.0742488395849121, 0.93161559528854909)),
((-3, -3, -7),(-2.0655310728826279, 0.94508260617016893)),
((-3, -3, -6),(-2.0559789247649376, 0.9584021579863129)),
((-3, -3, -5),(-2.045556118199046, 0.97156411117071717)),
((-3, -3, -4),(-2.0342248242844101, 0.98455763532001472)),
((-3, -3, -3),(-2.0219456517325916, 0.99737118183784879)),
((-3, -3, -2),(-2.0086776459885258, 1.0099924564358937)),
((-3, -3, -1),(-1.9943782997027253, 1.0224083915437105)),
((-3, -3, 0),(-1.979003576428247, 1.0346051186525971)),
((-3, -3, 1),(-1.962507949576102, 1.0465679405804109)),
((-3, -3, 2),(-1.9448444588120386, 1.0582813035928971)),
((-3, -3, 3),(-1.9259647862068898, 1.0697287692491899)),
((-3, -3, 4),(-1.9058193545508628, 1.0808929857519785)),
((-3, -3, 5),(-1.8843574502948603, 1.0917556584727153)),
((-3, -3, 6),(-1.8615273735714883, 1.1022975191852051)),
((-3, -3, 7),(-1.8372766176529489, 1.1124982933720182)),
((-3, -3, 8),(-1.8115520799964697, 1.1223366647620168)),
((-3, -3, 9),(-1.7843003066790657, 1.1317902360070144)),
((-3, -2, -13),(-2.2900278505333258, 0.68617749256662541)),
((-3, -2, -12),(-2.2875880980790106, 0.69829285391925877)),
((-3, -2, -11),(-2.2844906531541063, 0.71026682526633877)),
((-3, -2, -10),(-2.2807008820870909, 0.72209093411940517)),
((-3, -2, -9),(-2.2761817673439348, 0.73375597668886261)),
((-3, -2, -8),(-2.2708937381379699, 0.74525196591387977)),
((-3, -2, -7),(-2.2647944885152289, 0.75656807511358304)),
((-3, -2, -6),(-2.2578387821488413, 0.7676925768166255)),
((-3, -2, -5),(-2.2499782430721043, 0.77861277625440528)),
((-3, -2, -4),(-2.2411611315891755, 0.78931493891473092)),
((-3, -2, -3),(-2.2313321046291188, 0.79978421144347833)),
((-3, -2, -2),(-2.2204319598581872, 0.81000453504626735)),
((-3, -2, -1),(-2.2083973629420037, 0.81995855037294751)),
((-3, -2, 0),(-2.1951605574608921, 0.8296274926561944)),
((-3, -2, 1),(-2.1806490571347852, 0.83899107560948483)),
((-3, -2, 2),(-2.1647853202173759, 0.84802736225450637)),
((-3, -2, 3),(-2.1474864061802501, 0.85671262042368024)),
((-3, -2, 4),(-2.1286636151339779, 0.86502116014437558)),
((-3, -2, 5),(-2.1082221108293702, 0.87292514942377353)),
((-3, -2, 6),(-2.0860605285475167, 0.88039440407201508)),
((-3, -2, 7),(-2.0620705697121102, 0.88739614606635686)),
((-3, -2, 8),(-2.0361365856149476, 0.89389472348891319)),
((-3, -2, 9),(-2.008135153181632, 0.8998512831539176)),
((-3, -2, 10),(-1.9779346461214229, 0.90522338452333351)),
((-3, -2, 11),(-1.9453948049357528, 0.90996454017632245)),
((-3, -1, -14),(-2.4908850917087864, 0.47810695364223693)),
((-3, -1, -13),(-2.4926358998901077, 0.48715824176293415)),
((-3, -1, -12),(-2.4938666015936364, 0.49597167311988166)),
((-3, -1, -11),(-2.4945471313040022, 0.50453364205691342)),
((-3, -1, -10),(-2.4946449448748949, 0.5128293499299994)),
((-3, -1, -9),(-2.4941247840238758, 0.52084269550513662)),
((-3, -1, -8),(-2.492948412836181, 0.52855615217397856)),
((-3, -1, -7),(-2.4910743222639158, 0.53595063000129917)),
((-3, -1, -6),(-2.4884573979099538, 0.54300532023644543)),
((-3, -1, -5),(-2.4850485455454199, 0.54969751945004997)),
((-3, -1, -4),(-2.4807942677917314, 0.55600242987341009)),
((-3, -1, -3),(-2.4756361841590762, 0.56189293178957433)),
((-3, -1, -2),(-2.46951048511644, 0.56733932291033429)),
((-3, -1, -1),(-2.4623473090015806, 0.5723090185171017)),
((-3, -1, 0),(-2.4540700282669023, 0.57676620467101924)),
((-3, -1, 1),(-2.4445944286747676, 0.58067143490906037)),
((-3, -1, 2),(-2.4338277614360146, 0.58398115840023113)),
((-3, -1, 3),(-2.4216676437051952, 0.58664716435076802)),
((-3, -1, 4),(-2.4080007770002441, 0.58861592325487977)),
((-3, -1, 5),(-2.3927014455838824, 0.58982780001598689)),
((-3, -1, 6),(-2.3756297470418053, 0.59021610647888945)),
((-3, -1, 7),(-2.3566294943870654, 0.58970595074380672)),
((-3, -1, 8),(-2.3355257118081156, 0.58821282663979757)),
((-3, -1, 9),(-2.3121216228927586, 0.58564086721481734)),
((-3, -1, 10),(-2.2861949981468088, 0.58188065845470027)),
((-3, -1, 11),(-2.2574936838111155, 0.57680646963619076)),
((-3, -1, 12),(-2.2257300699530007, 0.57027269833079075)),
((-3, 0, -14),(-2.6946178997817647, 0.27409042376715442)),
((-3, 0, -13),(-2.7002814312865349, 0.27922063173268452)),
((-3, 0, -12),(-2.7055804876639731, 0.28396543283279291)),
((-3, 0, -11),(-2.7104939026322081, 0.28830240392495621)),
((-3, 0, -10),(-2.7149986754165156, 0.29220718470089274)),
((-3, 0, -9),(-2.7190697882855615, 0.29565328452088058)),
((-3, 0, -8),(-2.7226800004707767, 0.29861186426422409)),
((-3, 0, -7),(-2.7257996146682943, 0.30105148918718122)),
((-3, 0, -6),(-2.7283962115666003, 0.30293784798635459)),
((-3, 0, -5),(-2.7304343469077001, 0.30423343228563537)),
((-3, 0, -4),(-2.7318752044252759, 0.30489716954650892)),
((-3, 0, -3),(-2.7326761965451589, 0.30488400087792644)),
((-3, 0, -2),(-2.7327905028944786, 0.30414439330309334)),
((-3, 0, -1),(-2.7321665343305295, 0.30262377360739312)),
((-3, 0, 0),(-2.7307473072116188, 0.30026186778244973)),
((-3, 0, 1),(-2.7284697087762617, 0.29699192607649683)),
((-3, 0, 2),(-2.7252636294791652, 0.29273980845810754)),
((-3, 0, 3),(-2.7210509315406544, 0.28742289847705527)),
((-3, 0, 4),(-2.7157442142198303, 0.28094880446869103)),
((-3, 0, 5),(-2.7092453245888524, 0.27321379494723746)),
((-3, 0, 6),(-2.7014435466590054, 0.2641008986382013)),
((-3, 0, 7),(-2.6922133798079226, 0.25347757709856139)),
((-3, 0, 8),(-2.6814117869099356, 0.24119284655150369)),
((-3, 0, 9),(-2.6688747492937166, 0.2270736812777692)),
((-3, 0, 10),(-2.6544129032694777, 0.2109204672045038)),
((-3, 0, 11),(-2.6378059413036521, 0.19250118092482396)),
((-3, 0, 12),(-2.6187953233011818, 0.17154382943920357)),
((-3, 1, -13),(-2.8959492178816468, 0.079382252936560108)),
((-3, 1, -12),(-2.9047325778546265, 0.080283095570497093)),
((-3, 1, -11),(-2.9132746229649684, 0.080648634296221502)),
((-3, 1, -10),(-2.9215619008626383, 0.080448946442102126)),
((-3, 1, -9),(-2.9295798367305146, 0.079651756780256378)),
((-3, 1, -8),(-2.9373126348700018, 0.07822222455894795)),
((-3, 1, -7),(-2.9447431688812951, 0.076122706402541637)),
((-3, 1, -6),(-2.9518528587543407, 0.073312491763175197)),
((-3, 1, -5),(-2.9586215328659113, 0.069747507052956362)),
((-3, 1, -4),(-2.96502727248384, 0.06537998391962753)),
((-3, 1, -3),(-2.9710462358917846, 0.060158086326600413)),
((-3, 1, -2),(-2.9766524586413388, 0.054025490127486135)),
((-3, 1, -1),(-2.9818176256792897, 0.046920907643934848)),
((-3, 1, 0),(-2.9865108101420965, 0.038777548310174062)),
((-3, 1, 1),(-2.990698172398043, 0.029522504668110922)),
((-3, 1, 2),(-2.9943426113709446, 0.019076050791998238)),
((-3, 1, 3),(-2.9974033581898958, 0.0073508374699347455)),
((-3, 1, 4),(-2.9998354996303429, -0.0057490349911365375)),
((-3, 1, 5),(-3.0015894154387355, -0.020329089859899077)),
((-3, 1, 6),(-3.0026101091808122, -0.036505722117989456)),
((-3, 1, 7),(-3.002836406317571, -0.054407658055330113)),
((-3, 1, 8),(-3.0021999852119077, -0.074177672256026353)),
((-3, 1, 9),(-3.0006241958554454, -0.09597462052503887)),
((-3, 1, 10),(-2.9980226060242305, -0.11997586427498406)),
((-3, 1, 11),(-2.9942971934337583, -0.14638018508015721)),
((-3, 2, -12),(-3.07808083517271, -0.10157678587130563)),
((-3, 2, -11),(-3.088995129959494, -0.10416656658978136)),
((-3, 2, -10),(-3.0997387566944417, -0.10737234131068603)),
((-3, 2, -9),(-3.1103025410616842, -0.11122425520833933)),
((-3, 2, -8),(-3.1206766168492766, -0.11575437696165745)),
((-3, 2, -7),(-3.1308503808521446, -0.12099682538634071)),
((-3, 2, -6),(-3.1408124440644722, -0.12698790509229746)),
((-3, 2, -5),(3.1326347284295228, -0.13376625179038171)),
((-3, 2, -4),(3.123133646273303, -0.14137298791237843)),
((-3, 2, -3),(3.1138836996314532, -0.14985188924979251)),
((-3, 2, -2),(3.1048999990498225, -0.15924956336065643)),
((-3, 2, -1),(3.0961987578933035, -0.16961564053966618)),
((-3, 2, 0),(3.0877973752665762, -0.18100297819589323)),
((-3, 2, 1),(3.0797145277853075, -0.19346787953534081)),
((-3, 2, 2),(3.0719702716401334, -0.20707032750446822)),
((-3, 2, 3),(3.0645861567123447, -0.22187423501832021)),
((-3, 2, 4),(3.0575853548956911, -0.23794771257793224)),
((-3, 2, 5),(3.0509928052745892, -0.25536335448362563)),
((-3, 2, 6),(3.0448353794335929, -0.27419854498545915)),
((-3, 2, 7),(3.0391420709631691, -0.29453578589718205)),
((-3, 2, 8),(3.0339442142326489, -0.31646304746364151)),
((-3, 2, 9),(3.0292757387887681, -0.34007414465511288)),
((-3, 2, 10),(3.0251734673983983, -0.36546914162936717)),
((-3, 3, -9),(3.0266036406275112, -0.2714343471465524)),
((-3, 3, -8),(3.0150146400279647, -0.27770919088120244)),
((-3, 3, -7),(3.0035939871263553, -0.28465701480251288)),
((-3, 3, -6),(2.9923505381928734, -0.29230513049554352)),
((-3, 3, -5),(2.9812936847289455, -0.30068207717481887)),
((-3, 3, -4),(2.9704333750156682, -0.30981765584878845)),
((-3, 3, -3),(2.9597801364827814, -0.31974296179984474)),
((-3, 3, -2),(2.9493450989868197, -0.33049041490526571)),
((-3, 3, -1),(2.9391400191170254, -0.34209378727285161)),
((-3, 3, 0),(2.9291773056849482, -0.35458822761224001)),
((-3, 3, 1),(2.9194700465998551, -0.36801028171004563)),
((-3, 3, 2),(2.9100320373888535, -0.38239790832589482)),
((-3, 3, 3),(2.9008778116898419, -0.39779048977904935)),
((-3, 3, 4),(2.8920226741297621, -0.41422883645512371)),
((-3, 3, 5),(2.8834827361025943, -0.43175518443287592)),
((-3, 3, 6),(2.8752749550850796, -0.4504131854179832)),
((-3, 3, 7),(2.8674171782770053, -0.47024788818041519)),
((-2, -5, -8),(-1.605922572980891, 1.3789676344488606)),
((-2, -5, -7),(-1.59360645649702, 1.3963409915414469)),
((-2, -5, -6),(-1.5806129687441293, 1.4134950104401838)),
((-2, -5, -5),(-1.5669326690749705, 1.4304169158635192)),
((-2, -5, -4),(-1.5525568043973321, 1.4470936674417654)),
((-2, -5, -3),(-1.537477391548643, 1.4635119993729206)),
((-2, -5, -2),(-1.5216872997680631, 1.4796584629433895)),
((-2, -5, -1),(-1.5051803323581259, 1.4955194716213571)),
((-2, -5, 0),(-1.4879513065430903, 1.5110813483659975)),
((-2, -5, 1),(-1.4699961304568954, 1.5263303747329939)),
((-2, -5, 2),(-1.4513118761332438, 1.5412528412978961)),
((-2, -5, 3),(-1.4318968473268818, 1.5558350988652616)),
((-2, -5, 4),(-1.4117506409717981, 1.5700636098854062)),
((-2, -5, 5),(-1.3908742010811483, 1.5839249994632258)),
((-2, -4, -12),(-1.7778803590305985, 1.192944457020763)),
((-2, -4, -11),(-1.7679243070396791, 1.2125324265410495)),
((-2, -4, -10),(-1.7571887591131963, 1.232022644417655)),
((-2, -4, -9),(-1.7456519035003482, 1.251402880352716)),
((-2, -4, -8),(-1.7332920150014441, 1.2706601120462966)),
((-2, -4, -7),(-1.7200875822544963, 1.2897805298834644)),
((-2, -4, -6),(-1.7060174476443417, 1.3087495475655646)),
((-2, -4, -5),(-1.6910609597582038, 1.3275518192052365)),
((-2, -4, -4),(-1.6751981380505165, 1.3461712633473057)),
((-2, -4, -3),(-1.6584098490778507, 1.3645910942997934)),
((-2, -4, -2),(-1.6406779933237261, 1.3827938610602535)),
((-2, -4, -1),(-1.6219857012562289, 1.4007614940020583)),
((-2, -4, 0),(-1.6023175368547904, 1.4184753593439896)),
((-2, -4, 1),(-1.5816597064144342, 1.4359163212660293)),
((-2, -4, 2),(-1.5600002699976907, 1.4530648113576652)),
((-2, -4, 3),(-1.5373293524698313, 1.4699009048958904)),
((-2, -4, 4),(-1.513639350638706, 1.4864044032536328)),
((-2, -4, 5),(-1.4889251326449831, 1.5025549215415581)),
((-2, -4, 6),(-1.4631842254320027, 1.518331980393643)),
((-2, -4, 7),(-1.4364169858880103, 1.5337151006270768)),
((-2, -4, 8),(-1.4086267511177266, 1.5486838993472103)),
((-2, -4, 9),(-1.3798199632841384, 1.5632181859355041)),
((-2, -4, 10),(-1.3500062645811519, 1.5772980562591647)),
((-2, -3, -14),(-1.961145554426309, 0.99639350507505586)),
((-2, -3, -13),(-1.9537070073086735, 1.0165396744612776)),
((-2, -3, -12),(-1.9454072172832793, 1.0367058186598703)),
((-2, -3, -11),(-1.9362085625242742, 1.0568851263535748)),
((-2, -3, -10),(-1.9260719916887274, 1.0770697866469485)),
((-2, -3, -9),(-1.9149570894189225, 1.0972509266959534)),
((-2, -3, -8),(-1.9028221670393766, 1.1174185495764493)),
((-2, -3, -7),(-1.8896243821983425, 1.1375614733545736)),
((-2, -3, -6),(-1.8753198914131723, 1.1576672724768875)),
((-2, -3, -5),(-1.85986403961655, 1.1777222227547364)),
((-2, -3, -4),(-1.8432115908366409, 1.1977112513694244)),
((-2, -3, -3),(-1.8253170040445212, 1.2176178934651263)),
((-2, -3, -2),(-1.8061347579277713, 1.2374242570158311)),
((-2, -3, -1),(-1.7856197278574781, 1.2571109977406938)),
((-2, -3, 0),(-1.7637276175625991, 1.2766573058872754)),
((-2, -3, 1),(-1.7404154469666968, 1.2960409066917946)),
((-2, -3, 2),(-1.7156420962379133, 1.3152380762473281)),
((-2, -3, 3),(-1.6893689043229891, 1.3342236743531339)),
((-2, -3, 4),(-1.6615603180639444, 1.3529711956708281)),
((-2, -3, 5),(-1.6321845854374721, 1.3714528401693209)),
((-2, -3, 6),(-1.6012144835461797, 1.3896396033972531)),
((-2, -3, 7),(-1.5686280687979681, 1.4075013865821169)),
((-2, -3, 8),(-1.5344094333474456, 1.4250071259284192)),
((-2, -3, 9),(-1.4985494484996831, 1.4421249397894331)),
((-2, -3, 10),(-1.4610464725965029, 1.4588222916416103)),
((-2, -3, 11),(-1.4219069981649757, 1.4750661660277178)),
((-2, -3, 12),(-1.3811462110820822, 1.4908232538885866)),
((-2, -2, -16),(-2.1770875262902583, 0.75486276703925259)),
((-2, -2, -15),(-2.1742296001557411, 0.77325027933803869)),
((-2, -2, -14),(-2.1705677731918511, 0.7917022548841296)),
((-2, -2, -13),(-2.1660541532585751, 0.81021939775622709)),
((-2, -2, -12),(-2.1606372119800041, 0.82880191537715076)),
((-2, -2, -11),(-2.1542615359671982, 0.8474494562070447)),
((-2, -2, -10),(-2.1468675696166448, 0.86616104010636807)),
((-2, -2, -9),(-2.138391352275864, 0.88493498079940403)),
((-2, -2, -8),(-2.1287642536550782, 0.90376879987982861)),
((-2, -2, -7),(-2.1179127127242428, 0.92265913183010073)),
((-2, -2, -6),(-2.1057579870203611, 0.94160161958196176)),
((-2, -2, -5),(-2.0922159213561735, 0.96059080023166288)),
((-2, -2, -4),(-2.0771967474267092, 0.97961998064808498)),
((-2, -2, -3),(-2.0606049288098367, 0.99868110288150069)),
((-2, -2, -2),(-2.0423390693976238, 1.0177645995028808)),
((-2, -2, -1),(-2.0222919074039694, 1.036859239285431)),
((-2, -2, 0),(-2.0003504217625907, 1.0559519639869408)),
((-2, -2, 1),(-1.9763960828945939, 1.0750277174073446)),
((-2, -2, 2),(-1.9503052853376268, 1.0940692683799269)),
((-2, -2, 3),(-1.9219500053196745, 1.1130570299018316)),
((-2, -2, 4),(-1.8911987315924774, 1.1319688772061942)),
((-2, -2, 5),(-1.8579177220577598, 1.1507799682021429)),
((-2, -2, 6),(-1.8219726409969379, 1.1694625703248867)),
((-2, -2, 7),(-1.7832306308097254, 1.1879858983978555)),
((-2, -2, 8),(-1.7415628665020486, 1.2063159685480485)),
((-2, -2, 9),(-1.696847628860449, 1.2244154734552524)),
((-2, -2, 10),(-1.6489739112459292, 1.2422436841616578)),
((-2, -2, 11),(-1.5978455432345993, 1.2597563832170331)),
((-2, -2, 12),(-1.5433857703970069, 1.2769058329774596)),
((-2, -2, 13),(-1.4855421728835125, 1.2936407813075186)),
((-2, -2, 14),(-1.4242917375405248, 1.3099065046663554)),
((-2, -1, -16),(-2.4174256118115083, 0.51478521163695512)),
((-2, -1, -15),(-2.4196625400308394, 0.5288349499696221)),
((-2, -1, -14),(-2.4212613302745831, 0.54281705924534585)),
((-2, -1, -13),(-2.422176210022986, 0.55672709723075176)),
((-2, -1, -12),(-2.4223566761828486, 0.57055987098597605)),
((-2, -1, -11),(-2.4217469332903088, 0.58430935035621989)),
((-2, -1, -10),(-2.4202852520641684, 0.59796856888302408)),
((-2, -1, -9),(-2.4179032355630947, 0.61152951012423662)),
((-2, -1, -8),(-2.4145249779502005, 0.62498297698710459)),
((-2, -1, -7),(-2.4100660982033912, 0.63831844120808068)),
((-2, -1, -6),(-2.4044326279555897, 0.65152386953167341)),
((-2, -1, -5),(-2.397519728924125, 0.66458552241840907)),
((-2, -1, -4),(-2.3892102110048161, 0.67748772020697434)),
((-2, -1, -3),(-2.3793728169744091, 0.69021257051251117)),
((-2, -1, -2),(-2.367860233783269, 0.70273964918520349)),
((-2, -1, -1),(-2.3545067835735587, 0.71504562527676285)),
((-2, -1, 0),(-2.3391257398254477, 0.72710381802053026)),
((-2, -1, 1),(-2.3215062055198059, 0.73888367061836779)),
((-2, -1, 2),(-2.3014094811985863, 0.7503501213495517)),
((-2, -1, 3),(-2.2785648419042692, 0.76146284674722053)),
((-2, -1, 4),(-2.2526646342975765, 0.77217534369910701)),
((-2, -1, 5),(-2.2233586007108515, 0.78243380638430515)),
((-2, -1, 6),(-2.1902473386737102, 0.79217573853181422)),
((-2, -1, 7),(-2.1528748176230037, 0.80132821937550969)),
((-2, -1, 8),(-2.1107199068854703, 0.80980570939889818)),
((-2, -1, 9),(-2.0631869321105372, 0.81750723388422575)),
((-2, -1, 10),(-2.0095953871257994, 0.82431270907896581)),
((-2, -1, 11),(-1.9491691048075186, 0.83007806158789776)),
((-2, -1, 12),(-1.8810254543618012, 0.83462860847461118)),
((-2, -1, 13),(-1.8041654910699358, 0.83774986265941742)),
((-2, -1, 14),(-1.7174663988188439, 0.83917440902265061)),
((-2, -1, 15),(-1.6196778674424834, 0.83856256910615612)),
((-2, 0, -16),(-2.6742338248640292, 0.25810775861426655)),
((-2, 0, -15),(-2.6826716275504783, 0.26597666218712451)),
((-2, 0, -14),(-2.6907791179514136, 0.27348678800507398)),
((-2, 0, -13),(-2.698532603680051, 0.28061225252527133)),
((-2, 0, -12),(-2.7059056717757564, 0.28732422083312842)),
((-2, 0, -11),(-2.7128688351186465, 0.29359052184901241)),
((-2, 0, -10),(-2.7193891204144722, 0.29937519990097899)),
((-2, 0, -9),(-2.7254295860923095, 0.30463798996467495)),
((-2, 0, -8),(-2.730948755650382, 0.30933370081920192)),
((-2, 0, -7),(-2.7358999483782425, 0.313411486448609)),
((-2, 0, -6),(-2.7402304847100054, 0.3168139809453247)),
((-2, 0, -5),(-2.7438807373541989, 0.31947626554676273)),
((-2, 0, -4),(-2.7467829912841766, 0.32132462770393111)),
((-2, 0, -3),(-2.748860064926463, 0.3222750604552585)),
((-2, 0, -2),(-2.7500236304006966, 0.32223143473346444)),
((-2, 0, -1),(-2.7501721509129964, 0.32108325593240367)),
((-2, 0, 0),(-2.7491883261213261, 0.31870288669215702)),
((-2, 0, 1),(-2.7469358980764871, 0.31494207680927261)),
((-2, 0, 2),(-2.7432556159949573, 0.30962758293135806)),
((-2, 0, 3),(-2.7379600795264225, 0.30255557667492866)),
((-2, 0, 4),(-2.7308270644045414, 0.29348441638373723)),
((-2, 0, 5),(-2.721590760288104, 0.2821251727381171)),
((-2, 0, 6),(-2.70993008276373, 0.26812901474778272)),
((-2, 0, 7),(-2.6954527985805949, 0.25107011641362947)),
((-2, 0, 8),(-2.6776735154578657, 0.23042202159588754)),
((-2, 0, 9),(-2.6559824308243845, 0.20552419409084915)),
((-2, 0, 10),(-2.6295997090797387, 0.17553337147973194)),
((-2, 0, 11),(-2.5975066445829107, 0.13935049508565997)),
((-2, 0, 12),(-2.5583375697259516, 0.095506570698406804)),
((-2, 0, 13),(-2.510201522861248, 0.041975498267722205)),
((-2, 0, 14),(-2.450368873552089, -0.024152558944191663)),
((-2, 0, 15),(-2.374672514560543, -0.10729046496109691)),
((-2, 1, -16),(-2.9162341100377613, 0.016154217238288721)),
((-2, 1, -15),(-2.9297916190874878, 0.018200179642295464)),
((-2, 1, -14),(-2.9432619291746622, 0.01963693194788935)),
((-2, 1, -13),(-2.9566394893397008, 0.020423525906037802)),
((-2, 1, -12),(-2.969917963597128, 0.020515048732940841)),
((-2, 1, -11),(-2.9830901477844587, 0.019862187173828295)),
((-2, 1, -10),(-2.9961478753186297, 0.018410734449018508)),
((-2, 1, -9),(-3.0090819102230584, 0.016101031680140952)),
((-2, 1, -8),(-3.0218818254948414, 0.012867334033330943)),
((-2, 1, -7),(-3.0345358645247225, 0.008637090224791831)),
((-2, 1, -6),(-3.0470307828456087, 0.0033301221753511069)),
((-2, 1, -5),(-3.0593516669467413, -0.0031423105666652375)),
((-2, 1, -4),(-3.0714817262211529, -0.010878579534785101)),
((-2, 1, -3),(-3.0834020532749151, -0.019987910004500259)),
((-2, 1, -2),(-3.0950913467658867, -0.030591781781268802)),
((-2, 1, -1),(-3.1065255895857997, -0.042825536127287352)),
((-2, 1, 0),(-3.1176776734546721, -0.056840221161992686)),
((-2, 1, 1),(-3.1285169587244193, -0.07280471286596403)),
((-2, 1, 2),(-3.1390087551974237, -0.090908154003143435)),
((-2, 1, 3),(3.1340716013968124, -0.11136275867330883)),
((-2, 1, 4),(3.1243982577353626, -0.13440703548190311)),
((-2, 1, 5),(3.1152075746149586, -0.16030948689721536)),
((-2, 1, 6),(3.1065579794712335, -0.18937284533745402)),
((-2, 1, 7),(3.0985166026602404, -0.22193890648177397)),
((-2, 1, 8),(3.0911609300047442, -0.25839401515909799)),
((-2, 1, 9),(3.0845808838449518, -0.29917524606293044)),
((-2, 1, 10),(3.0788814812320062, -0.3447772967915817)),
((-2, 1, 11),(3.0741862836627254, -0.39576007028831728)),
((-2, 1, 12),(3.0706419542903856, -0.4527568648335677)),
((-2, 1, 13),(3.0684243994264535, -0.51648301489400805)),
((-2, 1, 14),(3.0677472336474154, -0.58774475330329912)),
((-2, 2, -15),(-3.1366085678242674, -0.19162477073908118)),
((-2, 2, -14),(3.1302576234549799, -0.19423785889316278)),
((-2, 2, -13),(3.1139514767008847, -0.19758349688951568)),
((-2, 2, -12),(3.0976612654560811, -0.20170245077352167)),
((-2, 2, -11),(3.081390530463938, -0.20663839908339063)),
((-2, 2, -10),(3.0651434371756374, -0.21243812506317017)),
((-2, 2, -9),(3.0489248304289327, -0.21915171719960067)),
((-2, 2, -8),(3.0327402936907757, -0.22683277694290863)),
((-2, 2, -7),(3.0165962130616295, -0.2355386319715603)),
((-2, 2, -6),(3.0004998462176959, -0.24533055273673721)),
((-2, 2, -5),(2.9844593964385671, -0.25627396925035778)),
((-2, 2, -4),(2.9684840918313489, -0.268438684134019)),
((-2, 2, -3),(2.9525842698178466, -0.28189907679579351)),
((-2, 2, -2),(2.9367714668992146, -0.29673429221627856)),
((-2, 2, -1),(2.9210585136536711, -0.3130284061732892)),
((-2, 2, 0),(2.9054596348591981, -0.33087055678648963)),
((-2, 2, 1),(2.8899905545681417, -0.35035502999580626)),
((-2, 2, 2),(2.8746686058990747, -0.37158128398828194)),
((-2, 2, 3),(2.8595128452607339, -0.3946538946645784)),
((-2, 2, 4),(2.844544170693216, -0.41968240102611987)),
((-2, 2, 5),(2.8297854440166588, -0.44678102594980629)),
((-2, 2, 6),(2.8152616165354836, -0.47606824434671668)),
((-2, 2, 7),(2.8009998581795017, -0.50766616740892268)),
((-2, 2, 8),(2.7870296902019871, -0.54169970888673391)),
((-2, 2, 9),(2.7733831219349367, -0.57829549760454257)),
((-2, 2, 10),(2.7600947926695962, -0.61758050039277579)),
((-2, 2, 11),(2.7472021205419792, -0.65968032216083872)),
((-2, 2, 12),(2.7347454614287283, -0.7047171560425074)),
((-2, 2, 13),(2.7227682823866663, -0.75280736767409706)),
((-2, 3, -12),(2.934579800719082, -0.37543972122466324)),
((-2, 3, -11),(2.9176709072172002, -0.38230464031066574)),
((-2, 3, -10),(2.900819183084721, -0.38995059390871123)),
((-2, 3, -9),(2.884031968930973, -0.39841079755044617)),
((-2, 3, -8),(2.8673173208094047, -0.4077198334169288)),
((-2, 3, -7),(2.8506840436372962, -0.41791363627351397)),
((-2, 3, -6),(2.8341417241691058, -0.42902946607314524)),
((-2, 3, -5),(2.8177007631177018, -0.44110586504466709)),
((-2, 3, -4),(2.8013724059742908, -0.45418259689638435)),
((-2, 3, -3),(2.7851687720375535, -0.46830056559253003)),
((-2, 3, -2),(2.7691028811275413, -0.48350171101177369)),
((-2, 3, -1),(2.7531886774329908, -0.49982887868497888)),
((-2, 3, 0),(2.7374410499246, -0.51732566074911046)),
((-2, 3, 1),(2.7218758487650967, -0.5360362052635973)),
((-2, 3, 2),(2.7065098971629573, -0.55600499113515434)),
((-2, 3, 3),(2.6913609981542232, -0.57727656611036549)),
((-2, 3, 4),(2.6764479358598083, -0.59989524564789465)),
((-2, 3, 5),(2.66179047085748, -0.62390477100097019)),
((-2, 3, 6),(2.6474093294319592, -0.64934792555362075)),
((-2, 3, 7),(2.63332618662553, -0.67626610938689347)),
((-2, 3, 8),(2.619563643207786, -0.70469887322757718)),
((-2, 3, 9),(2.6061451969174061, -0.7346834143685449)),
((-2, 3, 10),(2.5930952086010866, -0.76625403885438459)),
((-2, 3, 11),(2.5804388641843614, -0.79944159619371657)),
((-2, 4, -9),(2.7662716098051656, -0.53371259995208931)),
((-2, 4, -8),(2.7503408231106636, -0.54319868415434458)),
((-2, 4, -7),(2.7345469829879456, -0.55341227700219542)),
((-2, 4, -6),(2.7189000301774371, -0.56437503636985431)),
((-2, 4, -5),(2.7034104344765399, -0.57610884489830316)),
((-2, 4, -4),(2.6880891930469986, -0.58863573511774403)),
((-2, 4, -3),(2.6729478260435631, -0.60197780554814295)),
((-2, 4, -2),(2.65799836938108, -0.616157127472023)),
((-2, 4, -1),(2.6432533644859961, -0.63119564217486768)),
((-2, 4, 0),(2.6287258449151101, -0.64711504857301927)),
((-2, 4, 1),(2.6144293197693553, -0.66393668129806316)),
((-2, 4, 2),(2.6003777538837127, -0.68168137948152818)),
((-2, 4, 3),(2.586585544836034, -0.7003693466849038)),
((-2, 4, 4),(2.5730674968871381, -0.72002000264702659)),
((-2, 4, 5),(2.5598387920414969, -0.74065182777278038)),
((-2, 4, 6),(2.5469149585012882, -0.76228220156158588)),
((-2, 4, 7),(2.534311836875268, -0.78492723646783957)),
((-2, 4, 8),(2.5220455445964012, -0.80860160899362454)),
((-1, -5, -10),(-1.4223017712201291, 1.54833876937515)),
((-1, -5, -9),(-1.4093651956654165, 1.569640722143512)),
((-1, -5, -8),(-1.3957776443574506, 1.5906506421919817)),
((-1, -5, -7),(-1.3815370604073349, 1.6113511236532452)),
((-1, -5, -6),(-1.366642478766529, 1.6317247079678798)),
((-1, -5, -5),(-1.3510940893219072, 1.651753968371021)),
((-1, -5, -4),(-1.3348932933931397, 1.6714215963674204)),
((-1, -5, -3),(-1.3180427524922638, 1.6907104892260136)),
((-1, -5, -2),(-1.3005464282515264, 1.7096038374563505)),
((-1, -5, -1),(-1.2824096125016791, 1.7280852111813452)),
((-1, -5, 0),(-1.2636389465890874, 1.7461386442962714)),
((-1, -5, 1),(-1.2442424291554621, 1.7637487153048497)),
((-1, -5, 2),(-1.2242294117663888, 1.7809006237503524)),
((-1, -5, 3),(-1.2036105819609746, 1.797580261213187)),
((-1, -5, 4),(-1.1823979335001737, 1.8137742759251552)),
((-1, -5, 5),(-1.160604723810287, 1.8294701301526681)),
((-1, -5, 6),(-1.1382454188444615, 1.8446561496236042)),
((-1, -5, 7),(-1.1153356258118525, 1.8593215644114522)),
((-1, -5, 8),(-1.0918920144444579, 1.8734565408415178)),
((-1, -4, -13),(-1.5652384868565226, 1.3853684323814828)),
((-1, -4, -12),(-1.5528057823083659, 1.4108879319517065)),
((-1, -4, -11),(-1.5395349509118541, 1.4362694308357247)),
((-1, -4, -10),(-1.5254128120452619, 1.4614896350362352)),
((-1, -4, -9),(-1.5104275353063623, 1.4865241021494895)),
((-1, -4, -8),(-1.4945688399920847, 1.5113473335573213)),
((-1, -4, -7),(-1.4778281962724591, 1.5359328840963868)),
((-1, -4, -6),(-1.4601990248473624, 1.5602534890082638)),
((-1, -4, -5),(-1.4416768914617875, 1.5842812075314978)),
((-1, -4, -4),(-1.422259692300067, 1.6079875820228333)),
((-1, -4, -3),(-1.4019478260062708, 1.6313438110053389)),
((-1, -4, -2),(-1.3807443479118318, 1.6543209340550278)),
((-1, -4, -1),(-1.3586551020154396, 1.6768900259760504)),
((-1, -4, 0),(-1.3356888263740743, 1.6990223973001879)),
((-1, -4, 1),(-1.3118572278416465, 1.7206897978012687)),
((-1, -4, 2),(-1.2871750225402165, 1.7418646194602267)),
((-1, -4, 3),(-1.2616599390657925, 1.7625200951688091)),
((-1, -4, 4),(-1.2353326822048021, 1.7826304894323812)),
((-1, -4, 5),(-1.2082168558463671, 1.8021712774313761)),
((-1, -4, 6),(-1.1803388447880863, 1.8211193090267861)),
((-1, -4, 7),(-1.1517276562092003, 1.8394529546404133)),
((-1, -4, 8),(-1.1224147226792021, 1.8571522303918424)),
((-1, -4, 9),(-1.0924336696325214, 1.8741989004109447)),
((-1, -4, 10),(-1.0618200512220664, 1.8905765548431175)),
((-1, -4, 11),(-1.0306110593197699, 1.906270662696508)),
((-1, -4, 12),(-0.99884521112173363, 1.92126859931789)),
((-1, -3, -15),(-1.7414478646842444, 1.1795108147937547)),
((-1, -3, -14),(-1.7301641847753189, 1.2083231994237558)),
((-1, -3, -13),(-1.7178062822486646, 1.2372826085315882)),
((-1, -3, -12),(-1.7043362152291894, 1.2663708540301248)),
((-1, -3, -11),(-1.6897164292348839, 1.2955668435644194)),
((-1, -3, -10),(-1.673910173543756, 1.3248464474980153)),
((-1, -3, -9),(-1.6568819730212438, 1.3541823914443791)),
((-1, -3, -8),(-1.63859815510582, 1.3835441814134193)),
((-1, -3, -7),(-1.619027429593245, 1.412898068935192)),
((-1, -3, -6),(-1.5981415163620034, 1.4422070635366011)),
((-1, -3, -5),(-1.5759158132720821, 1.4714309996101935)),
((-1, -3, -4),(-1.5523300932165822, 1.5005266639610397)),
((-1, -3, -3),(-1.5273692158330308, 1.5294479890985819)),
((-1, -3, -2),(-1.5010238358674799, 1.5581463156309199)),
((-1, -3, -1),(-1.4732910868653331, 1.5865707249304133)),
((-1, -3, 0),(-1.444175216023087, 1.6146684406259559)),
((-1, -3, 1),(-1.4136881439921001, 1.6423852945410897)),
((-1, -3, 2),(-1.3818499225033798, 1.6696662495893566)),
((-1, -3, 3),(-1.3486890631762154, 1.6964559690511034)),
((-1, -3, 4),(-1.3142427130093381, 1.7226994188107594)),
((-1, -3, 5),(-1.2785566559461525, 1.7483424867609716)),
((-1, -3, 6),(-1.2416851255229715, 1.7733326018953544)),
((-1, -3, 7),(-1.2036904207489598, 1.7976193347903904)),
((-1, -3, 8),(-1.1646423256526997, 1.821154961330689)),
((-1, -3, 9),(-1.1246173418335996, 1.8438949726908513)),
((-1, -3, 10),(-1.0836977522385727, 1.8657985166935689)),
((-1, -3, 11),(-1.0419705425625261, 1.8868287585740249)),
((-1, -3, 12),(-0.99952621349354609, 1.9069531526813754)),
((-1, -3, 13),(-0.95645752194571765, 1.926143620478352)),
((-1, -3, 14),(-0.91285819207161267, 1.944376634081628)),
((-1, -2, -17),(-1.9783296348340551, 0.89136067959089771)),
((-1, -2, -16),(-1.9713187456923786, 0.92007792748068451)),
((-1, -2, -15),(-1.9631053084908032, 0.94927688748118721)),
((-1, -2, -14),(-1.953611748027819, 0.97897383651766712)),
((-1, -2, -13),(-1.942755293123795, 1.0091835131590017)),
((-1, -2, -12),(-1.9304479625214923, 1.0399186608816493)),
((-1, -2, -11),(-1.9165966601917725, 1.0711894957584118)),
((-1, -2, -10),(-1.9011034136526932, 1.1030030933213535)),
((-1, -2, -9),(-1.8838657949614435, 1.1353626913507802)),
((-1, -2, -8),(-1.8647775700542246, 1.1682669084219002)),
((-1, -2, -7),(-1.8437296274784165, 1.2017088824432269)),
((-1, -2, -6),(-1.8206112413791629, 1.2356753393693272)),
((-1, -2, -5),(-1.7953117246140589, 1.2701456099185175)),
((-1, -2, -4),(-1.7677225244445973, 1.30509062148945)),
((-1, -2, -3),(-1.7377398034198253, 1.3404719033410482)),
((-1, -2, -2),(-1.7052675296506781, 1.3762406549474673)),
((-1, -2, -1),(-1.6702210715807224, 1.4123369393172498)),
((-1, -2, 0),(-1.6325312510620209, 1.4486890735512201)),
((-1, -2, 1),(-1.5921487547591304, 1.4852132961191049)),
((-1, -2, 2),(-1.5490487394215193, 1.5218137920364458)),
((-1, -2, 3),(-1.5032353960825644, 1.5583831510442048)),
((-1, -2, 4),(-1.4547461699235573, 1.594803318153041)),
((-1, -2, 5),(-1.4036552779206741, 1.630947069598687)),
((-1, -2, 6),(-1.3500761392687148, 1.66668001100162)),
((-1, -2, 7),(-1.2941623476347339, 1.7018630509394921)),
((-1, -2, 8),(-1.2361068796471357, 1.7363552568519929)),
((-1, -2, 9),(-1.1761393533277689, 1.7700169573821132)),
((-1, -2, 10),(-1.1145213155561446, 1.8027129226258665)),
((-1, -2, 11),(-1.0515397298530962, 1.8343154371700559)),
((-1, -2, 12),(-0.9874990264815634, 1.8647070838383566)),
((-1, -2, 13),(-0.92271223430650895, 1.8937830790783536)),
((-1, -2, 14),(-0.85749181025866217, 1.9214530407628752)),
((-1, -2, 15),(-0.79214080090168648, 1.9476421198646601)),
((-1, -1, -17),(-2.2758321696961494, 0.57877354735385955)),
((-1, -1, -16),(-2.2759567222043038, 0.60184800051661669)),
((-1, -1, -15),(-2.2750498842731108, 0.6253842492290298)),
((-1, -1, -14),(-2.2730128056647501, 0.64942600074730372)),
((-1, -1, -13),(-2.2697334053690512, 0.67402122731672343)),
((-1, -1, -12),(-2.2650843646281285, 0.69922267525197246)),
((-1, -1, -11),(-2.258920789151007, 0.72508842484521852)),
((-1, -1, -10),(-2.2510774915149838, 0.75168249977020241)),
((-1, -1, -9),(-2.2413658431663008, 0.77907552042286599)),
((-1, -1, -8),(-2.2295701482473498, 0.80734538899634412)),
((-1, -1, -7),(-2.2154435022317776, 0.83657798392405613)),
((-1, -1, -6),(-2.1987031227029585, 0.86686782610010515)),
((-1, -1, -5),(-2.179025186417046, 0.89831865690676926)),
((-1, -1, -4),(-2.1560392895707712, 0.93104383579552175)),
((-1, -1, -3),(-2.1293227869938116, 0.96516641955541216)),
((-1, -1, -2),(-2.098395489347487, 1.0008187225688625)),
((-1, -1, -1),(-2.0627155435389866, 1.0381410736442436)),
((-1, -1, 0),(-2.0216778364458423, 1.0772793786701926)),
((-1, -1, 1),(-1.9746169898275954, 1.1183809728698957)),
((-1, -1, 2),(-1.9208179710306377, 1.1615881166443547)),
((-1, -1, 3),(-1.8595384611758194, 1.2070283905037682)),
((-1, -1, 4),(-1.7900481443860699, 1.2548012464320695)),
((-1, -1, 5),(-1.7116904161688737, 1.3049601890846023)),
((-1, -1, 6),(-1.6239705846419192, 1.357490647222372)),
((-1, -1, 7),(-1.5266699469518212, 1.4122847140776518)),
((-1, -1, 8),(-1.4199758065640098, 1.4691156414051583)),
((-1, -1, 9),(-1.3046038513558524, 1.5276170328468719)),
((-1, -1, 10),(-1.1818754693106903, 1.5872733837389601)),
((-1, -1, 11),(-1.0537074988571615, 1.6474287723598442)),
((-1, -1, 12),(-0.92248587136463078, 1.707317953338086)),
((-1, -1, 13),(-0.7908300738153109, 1.7661186535445859)),
((-1, -1, 14),(-0.66129881728667805, 1.8230171469618368)),
((-1, -1, 15),(-0.53611371336674796, 1.8772742586865989)),
((-1, -1, 16),(-0.41696946697714049, 1.9282785080028921)),
((-1, 0, -17),(-2.6304358112854382, 0.22130560946858746)),
((-1, 0, -16),(-2.6423432938486902, 0.23265031758922181)),
((-1, 0, -15),(-2.6540131022373181, 0.24371713142818605)),
((-1, 0, -14),(-2.6654234505928693, 0.25447979382001967)),
((-1, 0, -13),(-2.6765486973173926, 0.2649075036020595)),
((-1, 0, -12),(-2.6873585926840216, 0.2749640255020615)),
((-1, 0, -11),(-2.6978173384657014, 0.28460657759581076)),
((-1, 0, -10),(-2.7078824028601214, 0.29378442912342151)),
((-1, 0, -9),(-2.717503013440878, 0.30243711708889004)),
((-1, 0, -8),(-2.7266182215184771, 0.31049215526871465)),
((-1, 0, -7),(-2.7351543887372873, 0.31786205879094798)),
((-1, 0, -6),(-2.7430218839781464, 0.32444043303551845)),
((-1, 0, -5),(-2.7501106843817138, 0.33009676386822068)),
((-1, 0, -4),(-2.7562844298510929, 0.33466937501991262)),
((-1, 0, -3),(-2.7613722539703716, 0.33795575020569046)),
((-1, 0, -2),(-2.7651573503749076, 0.33969898679466226)),
((-1, 0, -1),(-2.7673606320414992, 0.3395684363742667)),
((-1, 0, 0),(-2.7676168142294859, 0.33713137480031641)),
((-1, 0, 1),(-2.7654384341381517, 0.33181040107455262)),
((-1, 0, 2),(-2.7601599633411076, 0.32281731532030339)),
((-1, 0, 3),(-2.7508476533478996, 0.30904658533195223)),
((-1, 0, 4),(-2.7361473359800779, 0.28889584211809982)),
((-1, 0, 5),(-2.7140126962581741, 0.25994635865816723)),
((-1, 0, 6),(-2.6811845599992714, 0.21835356097172631)),
((-1, 0, 7),(-2.6320955857387323, 0.15757415324245172)),
((-1, 0, 8),(-2.5562465452264274, 0.065351811919026337)),
((-1, 0, 9),(-2.4305358552392473, -0.084929070414013194)),
((-1, 0, 10),(-2.1867730156425362, -0.36965123645568493)),
((-1, 1, -17),(-2.966308687169966, -0.10175589616337215)),
((-1, 1, -16),(-2.9876665871363186, -0.10105219015998403)),
((-1, 1, -15),(-3.009352180062888, -0.10126790435278231)),
((-1, 1, -14),(-3.031394466493043, -0.10248474449754615)),
((-1, 1, -13),(-3.053824896513158, -0.10479465242523209)),
((-1, 1, -12),(-3.0766776386105983, -0.10830125644616737)),
((-1, 1, -11),(-3.0999898733476168, -0.11312154877399311)),
((-1, 1, -10),(-3.1238021117537138, -0.11938782362337449)),
((-1, 1, -9),(3.1350267702777934, -0.12724991219357915)),
((-1, 1, -8),(3.1100779422522935, -0.13687775175942726)),
((-1, 1, -7),(3.084484088732542, -0.148464324170725)),
((-1, 1, -6),(3.0581878066920658, -0.16222899200950641)),
((-1, 1, -5),(3.0311265571477013, -0.17842124503523407)),
((-1, 1, -4),(3.0032323568430379, -0.19732484009517107)),
((-1, 1, -3),(2.97443155996856, -0.21926226648760105)),
((-1, 1, -2),(2.9446447919629453, -0.24459938426561545)),
((-1, 1, -1),(2.9137871234386941, -0.27374994875575759)),
((-1, 1, 0),(2.8817686065353647, -0.30717952846265645)),
((-1, 1, 1),(2.8484953396280619, -0.34540801771726926)),
((-1, 1, 2),(2.8138712791749101, -0.38900950950781388)),
((-1, 1, 3),(2.7778010766828349, -0.43860770449406811)),
((-1, 1, 4),(2.7401942761660147, -0.4948642948507615)),
((-1, 1, 5),(2.7009712460433133, -0.55845695376649263)),
((-1, 1, 6),(2.6600712088327159, -0.63004290344649527)),
((-1, 1, 7),(2.6174626250012443, -0.7102039838762797)),
((-1, 1, 8),(2.5731559210395369, -0.79937047168651576)),
((-1, 1, 9),(2.5272180613075479, -0.89772462490302196)),
((-1, 1, 10),(2.4797877166559359, -1.0050919184593838)),
((-1, 1, 11),(2.4310888429764046, -1.1208379303870397)),
((-1, 1, 12),(2.3814395783315683, -1.2437991115474563)),
((-1, 1, 13),(2.3312529207266657, -1.3722803418750655)),
((-1, 1, 14),(2.2810261757709052, -1.5041441089625256)),
((-1, 1, 15),(2.2313179935286889, -1.636992359376646)),
((-1, 1, 16),(2.1827147274733227, -1.768409539861133)),
((-1, 2, -16),(3.0324230553743385, -0.35068439154093728)),
((-1, 2, -15),(3.0075710395910829, -0.35634235310704732)),
((-1, 2, -14),(2.982410695160147, -0.36305526979409047)),
((-1, 2, -13),(2.956932187865998, -0.3708894446586114)),
((-1, 2, -12),(2.9311265523231498, -0.37991587982892566)),
((-1, 2, -11),(2.9049859145824963, -0.39021043454637694)),
((-1, 2, -10),(2.8785037499703443, -0.40185393593821334)),
((-1, 2, -9),(2.8516751791934958, -0.41493222422146275)),
((-1, 2, -8),(2.8244973053108176, -0.42953610993753766)),
((-1, 2, -7),(2.7969695934306769, -0.44576121623478604)),
((-1, 2, -6),(2.7690942938596037, -0.46370767427136711)),
((-1, 2, -5),(2.7408769078098767, -0.48347963473292666)),
((-1, 2, -4),(2.712326692581537, -0.50518455362521808)),
((-1, 2, -3),(2.6834572002904347, -0.52893220648285177)),
((-1, 2, -2),(2.6542868406703355, -0.55483338274108074)),
((-1, 2, -1),(2.6248394542386664, -0.58299821232960936)),
((-1, 2, 0),(2.5951448772696071, -0.61353408092751627)),
((-1, 2, 1),(2.5652394747652281, -0.64654310036304341)),
((-1, 2, 2),(2.5351666123009151, -0.6821191180608035)),
((-1, 2, 3),(2.504977032757655, -0.72034427581795246)),
((-1, 2, 4),(2.4747291002223166, -0.76128516461954043)),
((-1, 2, 5),(2.4444888715583328, -0.8049886687601302)),
((-1, 2, 6),(2.4143299572092851, -0.85147764767718603)),
((-1, 2, 7),(2.3843331375224812, -0.90074666384022783)),
((-1, 2, 8),(2.3545857098630156, -0.95275802334622461)),
((-1, 2, 9),(2.3251805551959595, -1.0074384434945709)),
((-1, 2, 10),(2.2962149301972787, -1.0646766876316793)),
((-1, 2, 11),(2.2677890111377432, -1.1243225008186337)),
((-1, 2, 12),(2.240004236878002, -1.1861871315046892)),
((-1, 2, 13),(2.2129615178882207, -1.2500456307000245)),
((-1, 2, 14),(2.1867593936453451, -1.315640985237934)),
((-1, 2, 15),(2.1614922297165249, -1.3826899787342275)),
((-1, 3, -14),(2.8027663497305126, -0.54131648967659929)),
((-1, 3, -13),(2.7786074765857149, -0.55040404133028153)),
((-1, 3, -12),(2.7543626695574099, -0.56044580020656898)),
((-1, 3, -11),(2.7300418761532295, -0.5714801805471833)),
((-1, 3, -10),(2.7056567020969773, -0.58354638340928355)),
((-1, 3, -9),(2.6812205117755799, -0.59668419124187666)),
((-1, 3, -8),(2.6567485234241928, -0.61093372094463883)),
((-1, 3, -7),(2.6322578963014203, -0.62633513174952116)),
((-1, 3, -6),(2.6077678067733063, -0.64292828470931862)),
((-1, 3, -5),(2.5832995099284055, -0.66075235127443166)),
((-1, 3, -4),(2.5588763831116235, -0.67984536943266805)),
((-1, 3, -3),(2.5345239476195696, -0.70024374721558347)),
((-1, 3, -2),(2.5102698647753332, -0.72198171506716524)),
((-1, 3, -1),(2.4861439027263765, -0.74509073063897246)),
((-1, 3, 0),(2.4621778706146928, -0.76959884200953788)),
((-1, 3, 1),(2.4384055172770371, -0.79553001808346901)),
((-1, 3, 2),(2.4148623923602259, -0.82290345792834241)),
((-1, 3, 3),(2.3915856686856052, -0.85173289393374763)),
((-1, 3, 4),(2.3686139258549699, -0.88202590675928982)),
((-1, 3, 5),(2.3459868964278225, -0.91378327286781047)),
((-1, 3, 6),(2.3237451774662414, -0.9469983677705226)),
((-1, 3, 7),(2.301929911771126, -0.98165664967727906)),
((-1, 3, 8),(2.2805824446373935, -1.0177352487828404)),
((-1, 3, 9),(2.2597439633410077, -1.05520268669301)),
((-1, 3, 10),(2.2394551277399719, -1.0940187483277706)),
((-1, 3, 11),(2.2197557012319464, -1.1341345249479071)),
((-1, 3, 12),(2.2006841917870821, -1.1754926417733211)),
((-1, 3, 13),(2.1822775128130698, -1.2180276771669867)),
((-1, 3, 14),(2.1645706731901093, -1.2616667728616324)),
((-1, 4, -11),(2.6191615923930476, -0.69468181307242771)),
((-1, 4, -10),(2.5977227951049127, -0.70578541078379753)),
((-1, 4, -9),(2.5763940175764657, -0.71769468267067793)),
((-1, 4, -8),(2.5551906789328021, -0.73042864209372715)),
((-1, 4, -7),(2.5341291027202608, -0.74400574920869578)),
((-1, 4, -6),(2.5132264910392412, -0.75844374925605007)),
((-1, 4, -5),(2.4925008894384701, -0.77375950035944896)),
((-1, 4, -4),(2.4719711420959114, -0.78996879195283343)),
((-1, 4, -3),(2.4516568369563925, -0.80708615533399874)),
((-1, 4, -2),(2.4315782406700737, -0.82512466824437181)),
((-1, 4, -1),(2.4117562233770364, -0.84409575578985518)),
((-1, 4, 0),(2.3922121736087134, -0.86400899043353507)),
((-1, 4, 1),(2.3729679038212161, -0.88487189419171852)),
((-1, 4, 2),(2.3540455473325639, -0.9066897465325805)),
((-1, 4, 3),(2.3354674476972956, -0.92946540179198445)),
((-1, 4, 4),(2.3172560418084207, -0.95319912016302599)),
((-1, 4, 5),(2.2994337382580743, -0.97788841646432201)),
((-1, 4, 6),(2.2820227927039411, -1.0035279309278713)),
((-1, 4, 7),(2.265045182168004, -1.0301093261542034)),
((-1, 4, 8),(2.2485224803279658, -1.0576212141484611)),
((-1, 4, 9),(2.2324757359418164, -1.0860491169696749)),
((-1, 4, 10),(2.2169253565664655, -1.115375463997003)),
((-1, 4, 11),(2.2018909996891352, -1.1455796281491686)),
((-1, 5, -7),(2.4727046265106227, -0.82711441295408206)),
((-1, 5, -6),(2.4547517210730585, -0.83962092694638513)),
((-1, 5, -5),(2.4370313479601005, -0.85279514124207856)),
((-1, 5, -4),(2.4195568927974311, -0.86664477623877068)),
((-1, 5, -3),(2.4023419634279146, -0.88117677352898638)),
((-1, 5, -2),(2.3854003435152369, -0.89639721750686241)),
((-1, 5, -1),(2.3687459434104947, -0.91231125828609705)),
((-1, 5, 0),(2.3523927486698346, -0.92892303690742406)),
((-1, 5, 1),(2.3363547666773523, -0.94623561387551991)),
((-1, 5, 2),(2.3206459718891441, -0.9642509021116813)),
((-1, 5, 3),(2.3052802502696736, -0.98296960543692447)),
((-1, 5, 4),(2.2902713435385298, -1.002391163707689)),
((-1, 5, 5),(2.2756327938823473, -1.0225137057107787)),
((-1, 5, 6),(2.2613778898118571, -1.0433340108841187)),
((-1, 5, 7),(2.2475196138560105, -1.0648474808639055)),
((0, -5, -9),(-1.1691683245330327, 1.8004341975687961)),
((0, -5, -8),(-1.1549169614189114, 1.8235000712066969)),
((0, -5, -7),(-1.1401143773609781, 1.8460706669918843)),
((0, -5, -6),(-1.1247692066710087, 1.8681286040355805)),
((0, -5, -5),(-1.1088911056387225, 1.8896573981240894)),
((0, -5, -4),(-1.0924907308342064, 1.9106415494455224)),
((0, -5, -3),(-1.0755797076504292, 1.9310666207227569)),
((0, -5, -2),(-1.0581705893174036, 1.9509193048385947)),
((0, -5, -1),(-1.0402768067893853, 1.9701874812280027)),
((0, -5, 0),(-1.0219126100699536, 1.9888602605165069)),
((0, -5, 1),(-1.0030930016921511, 2.0069280170973482)),
((0, -5, 2),(-0.98383366320674392, 2.0243824095556406)),
((0, -5, 3),(-0.96415087564725099, 2.0412163890592843)),
((0, -5, 4),(-0.94406143503205986, 2.0574241960373221)),
((0, -5, 5),(-0.92358256402927252, 2.0730013456512193)),
((0, -5, 6),(-0.90273182094760152, 2.0879446027286477)),
((0, -5, 7),(-0.88152700722620081, 2.1022519469688556)),
((0, -5, 8),(-0.85998607457865794, 2.1159225293413471)),
((0, -4, -13),(-1.2821641053665989, 1.6468666295270351)),
((0, -4, -12),(-1.2674515804837547, 1.6774032903592317)),
((0, -4, -11),(-1.2519796826329199, 1.7075334731669776)),
((0, -4, -10),(-1.2357546712707259, 1.7372196564169433)),
((0, -4, -9),(-1.218784940089592, 1.7664245567195194)),
((0, -4, -8),(-1.2010810697503302, 1.7951114309070269)),
((0, -4, -7),(-1.1826558551441007, 1.8232443777687526)),
((0, -4, -6),(-1.1635243052618105, 1.8507886338218804)),
((0, -4, -5),(-1.1437036143275408, 1.8777108574623904)),
((0, -4, -4),(-1.1232131035191977, 1.9039793960045646)),
((0, -4, -3),(-1.1020741333301984, 1.9295645304811433)),
((0, -4, -2),(-1.0803099873907283, 1.9544386936259808)),
((0, -4, -1),(-1.0579457293325751, 1.9785766571742425)),
((0, -4, 0),(-1.0350080350129789, 2.001955685459532)),
((0, -4, 1),(-1.0115250030759964, 2.0245556532230475)),
((0, -4, 2),(-0.9875259473940089, 2.0463591265332264)),
((0, -4, 3),(-0.9630411753715854, 2.0673514067000434)),
((0, -4, 4),(-0.93810175639059645, 2.0875205380125434)),
((0, -4, 5),(-0.91273928481928956, 2.1068572809926458)),
((0, -4, 6),(-0.88698564199750229, 2.1253550536105155)),
((0, -4, 7),(-0.86087276145232616, 2.1430098435232261)),
((0, -4, 8),(-0.834432401307873, 2.159820094864624)),
((0, -4, 9),(-0.80769592744992735, 2.1757865734249724)),
((0, -4, 10),(-0.78069411051589699, 2.1909122142172603)),
((0, -4, 11),(-0.75345693922993007, 2.2052019554437265)),
((0, -4, 12),(-0.72601345201966361, 2.2186625627671388)),
((0, -3, -15),(-1.4081991224572259, 1.4692300256341491)),
((0, -3, -14),(-1.3916464243668003, 1.5084779065679847)),
((0, -3, -13),(-1.3739743404920211, 1.5476429827501872)),
((0, -3, -12),(-1.355179401621013, 1.5866566754092379)),
((0, -3, -11),(-1.335262853719243, 1.6254464001329243)),
((0, -3, -10),(-1.3142310795663896, 1.6639362288756268)),
((0, -3, -9),(-1.2920959606415969, 1.702047670517074)),
((0, -3, -8),(-1.2688751614402922, 1.739700556440664)),
((0, -3, -7),(-1.2445923192825323, 1.7768140115738287)),
((0, -3, -6),(-1.2192771246644476, 1.8133074858211444)),
((0, -3, -5),(-1.1929652803346111, 1.84910181630134)),
((0, -3, -4),(-1.1656983314659863, 1.8841202877118557)),
((0, -3, -3),(-1.1375233643480813, 1.9182896568334482)),
((0, -3, -2),(-1.1084925766445033, 1.9515411078535916)),
((0, -3, -1),(-1.0786627280649492, 1.9838111078535825)),
((0, -3, 0),(-1.0480944858574381, 2.0150421363039914)),
((0, -3, 1),(-1.0168516844053388, 2.045183268405605)),
((0, -3, 2),(-0.98500052203186761, 2.0741905991207039)),
((0, -3, 3),(-0.95260872058389845, 2.1020275022058454)),
((0, -3, 4),(-0.91974467432513707, 2.1286647259113534)),
((0, -3, 5),(-0.88647661409578993, 2.1540803337328498)),
((0, -3, 6),(-0.85287181071023621, 2.178259504266987)),
((0, -3, 7),(-0.81899583840063184, 2.2011942085529643)),
((0, -3, 8),(-0.78491191509001668, 2.2228827861383538)),
((0, -3, 9),(-0.75068033175099735, 2.2433294424984727)),
((0, -3, 10),(-0.71635797843274385, 2.2625436904880196)),
((0, -3, 11),(-0.68199797004142282, 2.2805397574230346)),
((0, -3, 12),(-0.64764937089684982, 2.2973359774407305)),
((0, -3, 13),(-0.6133570136456582, 2.3129541862408782)),
((0, -3, 14),(-0.57916140539409389, 2.3274191324385294)),
((0, -3, 15),(-0.54509871196423343, 2.3407579167842725)),
((0, -2, -17),(-1.6125342991198492, 1.1595432044852867)),
((0, -2, -16),(-1.5953620460271281, 1.2073962161665062)),
((0, -2, -15),(-1.5763864249853297, 1.2562622727205348)),
((0, -2, -14),(-1.5555395535523542, 1.3060941271975257)),
((0, -2, -13),(-1.5327601770307657, 1.3568246070055858)),
((0, -2, -12),(-1.5079962132395288, 1.4083646837207753)),
((0, -2, -11),(-1.4812075466576062, 1.4606019756145157)),
((0, -2, -10),(-1.4523689831489996, 1.5133998863259228)),
((0, -2, -9),(-1.4214732344968495, 1.5665975874150184)),
((0, -2, -8),(-1.3885337597280616, 1.6200110335162865)),
((0, -2, -7),(-1.353587253989504, 1.6734351510599219)),
((0, -2, -6),(-1.3166955533847777, 1.7266472632602547)),
((0, -2, -5),(-1.2779467238985753, 1.7794117090447927)),
((0, -2, -4),(-1.237455131022652, 1.8314854921793486)),
((0, -2, -3),(-1.1953603469274934, 1.8826246754875633)),
((0, -2, -2),(-1.1518248413017549, 1.9325911337871218)),
((0, -2, -1),(-1.1070305110746603, 1.9811592173099128)),
((0, -2, 0),(-1.0611742182229884, 2.0281218686695417)),
((0, -2, 1),(-1.0144626058542214, 2.073295784993439)),
((0, -2, 2),(-0.96710653390107826, 2.1165253155230253)),
((0, -2, 3),(-0.9193155053632065, 2.15768491697622)),
((0, -2, 4),(-0.87129243839349391, 2.1966801319502447)),
((0, -2, 5),(-0.82322908359075098, 2.2334471872921142)),
((0, -2, 6),(-0.77530230149797086, 2.2679514122454463)),
((0, -2, 7),(-0.72767131797804274, 2.3001847406953138)),
((0, -2, 8),(-0.68047598014044208, 2.3301625866843225)),
((0, -2, 9),(-0.63383595489979072, 2.3579203729680431)),
((0, -2, 10),(-0.58785075328130421, 2.3835099581013433)),
((0, -2, 11),(-0.54260042845898693, 2.4069961589422575)),
((0, -2, 12),(-0.49814678238088095, 2.428453512041906)),
((0, -2, 13),(-0.45453492030963472, 2.4479633663874254)),
((0, -2, 14),(-0.41179500925714668, 2.4656113559520558)),
((0, -2, 15),(-0.36994411983693759, 2.4814852656421977)),
((0, -2, 16),(-0.32898805709982404, 2.4956732788397491)),
((0, -1, -17),(-1.9414620662993445, 0.73682758794254977)),
((0, -1, -16),(-1.9276048463387523, 0.78421629089586042)),
((0, -1, -15),(-1.9108929341266159, 0.83443328491493918)),
((0, -1, -14),(-1.8909831872428327, 0.88779211384403711)),
((0, -1, -13),(-1.8674911486908969, 0.9446265952621572)),
((0, -1, -12),(-1.8399913150490406, 1.0052825878201876)),
((0, -1, -11),(-1.8080211008790705, 1.0701037191824743)),
((0, -1, -10),(-1.7710906349034654, 1.1394087877719323)),
((0, -1, -9),(-1.7287011471175371, 1.2134584358247937)),
((0, -1, -8),(-1.680375102078564, 1.2924092722179419)),
((0, -1, -7),(-1.6257009307343857, 1.3762555043795572)),
((0, -1, -6),(-1.5643934875504253, 1.4647619580316718)),
((0, -1, -5),(-1.4963674138620635, 1.5573983170389869)),
((0, -1, -4),(-1.4218141297263556, 1.6532914035145803)),
((0, -1, -3),(-1.3412654231808641, 1.7512171330563409)),
((0, -1, -2),(-1.2556211348079191, 1.8496514959646158)),
((0, -1, -1),(-1.1661204713174087, 1.9468867638027754)),
((0, -1, 0),(-1.0742494773473581, 2.0411971277939114)),
((0, -1, 1),(-0.98159825624657793, 2.1310170378685247)),
((0, -1, 2),(-0.88970057677141212, 2.2150882703281627)),
((0, -1, 3),(-0.79989446720171675, 2.2925435779491923)),
((0, -1, 4),(-0.71323205128060219, 2.3629186578244825)),
((0, -1, 5),(-0.63044729639749142, 2.4261065012175305)),
((0, -1, 6),(-0.55197256342683443, 2.482279293087859)),
((0, -1, 7),(-0.47798579057401525, 2.5318021372689246)),
((0, -1, 8),(-0.40846998101243476, 2.5751552027523599)),
((0, -1, 9),(-0.34327158781281653, 2.6128721658296201)),
((0, -1, 10),(-0.28215040019872067, 2.6454963185725142)),
((0, -1, 11),(-0.2248183255306041, 2.6735521329330547)),
((0, -1, 12),(-0.17096739972217218, 2.6975287651720636)),
((0, -1, 13),(-0.12028873576760708, 2.7178720082657746)),
((0, -1, 14),(-0.072484490998817208, 2.7349818015063141)),
((0, -1, 15),(-0.027274782537352816, 2.749213141017945)),
((0, -1, 16),(0.015598873801588819, 2.7608788933246076)),
((0, -1, 17),(0.056372409560768548, 2.7702535283459624)),
((0, 0, -17),(-2.5121299174267175, 0.11931118067908661)),
((0, 0, -16),(-2.5274385320248984, 0.13461979527726745)),
((0, 0, -15),(-2.5426900618813693, 0.14987132513373852)),
((0, 0, -14),(-2.5578886507428389, 0.16506991399520829)),
((0, 0, -13),(-2.5730383222090163, 0.18021958546138522)),
((0, 0, -12),(-2.5881429907956646, 0.19532425404803352)),
((0, 0, -11),(-2.6032064722842359, 0.21038773553660475)),
((0, 0, -10),(-2.6182324934400847, 0.22541375669245359)),
((0, 0, -9),(-2.6332247011746261, 0.24040596442699511)),
((0, 0, -8),(-2.6481866712166928, 0.25536793446906181)),
((0, 0, -7),(-2.6631219163563258, 0.2703031796086951)),
((0, 0, -6),(-2.6780338943149964, 0.28521515756736532)),
((0, 0, -5),(-2.6929260152949439, 0.30010727854731295)),
((0, 0, -4),(-2.7078016492541366, 0.31498291250650551)),
((0, 0, -3),(-2.722664132952878, 0.32984539620524705)),
((0, 0, -2),(-2.7375167768128401, 0.34469804006520893)),
((0, 0, -1),(-2.7523628716285096, 0.35954413488087872)),
((0, 0, 1),(0.38922978196128366, -2.7820485187089146)),
((0, 0, 2),(0.40407587677695328, -2.7968946135245845)),
((0, 0, 3),(0.41892852063691527, -2.8117472573845461)),
((0, 0, 4),(0.43379100433565676, -2.8266097410832876)),
((0, 0, 5),(0.44866663829484943, -2.8414853750424802)),
((0, 0, 6),(0.46355875927479706, -2.8563774960224277)),
((0, 0, 7),(0.4784707372334675, -2.8712894739810984)),
((0, 0, 8),(0.49340598237310046, -2.8862247191207313)),
((0, 0, 9),(0.50836795241516719, -2.901186689162798)),
((0, 0, 10),(0.52336016014970865, -2.9161788968973394)),
((0, 0, 11),(0.5383861813055576, -2.9312049180531883)),
((0, 0, 12),(0.55344966279412877, -2.9462683995417596)),
((0, 0, 13),(0.56855433138077704, -2.9613730681284078)),
((0, 0, 14),(0.58370400284695423, -2.9765227395945848)),
((0, 0, 15),(0.59890259170842386, -2.9917213284560549)),
((0, 0, 16),(0.61415412156489491, -3.0069728583125257)),
((0, 0, 17),(0.62946273616307569, -3.0222814729107066)),
((0, 1, -17),(-3.0852202440290246, -0.371339125243831)),
((0, 1, -16),(-3.1259937797882045, -0.38071376026518555)),
((0, 1, -15),(3.1143178710524406, -0.39237951257184811)),
((0, 1, -14),(3.0691081625909762, -0.40661085208347902)),
((0, 1, -13),(3.0213039178221863, -0.42372064532401849)),
((0, 1, -12),(2.9706252538676212, -0.4440638884177297)),
((0, 1, -11),(2.9167743280591893, -0.46804052065673846)),
((0, 1, -10),(2.8594422533910726, -0.49609633501727879)),
((0, 1, -9),(2.7983210657769768, -0.52872048776017333)),
((0, 1, -8),(2.7331226725773585, -0.56643745083743335)),
((0, 1, -7),(2.6636068630157781, -0.60979051632086878)),
((0, 1, -6),(2.5896200901629589, -0.65931336050193401)),
((0, 1, -5),(2.5111453571923019, -0.71548615237226287)),
((0, 1, -4),(2.428360602309191, -0.7786739957653106)),
((0, 1, -3),(2.3416981863880766, -0.84904907564060117)),
((0, 1, -2),(2.2518920768183812, -0.92650438326163043)),
((0, 1, -1),(2.1599943973432154, -1.0105756157212686)),
((0, 1, 0),(2.067343176242435, -1.100395525795882)),
((0, 1, 1),(1.9754721822723846, -1.1947058897870177)),
((0, 1, 2),(1.8859715187818742, -1.2919411576251774)),
((0, 1, 3),(1.8003272304089293, -1.3903755205334523)),
((0, 1, 4),(1.7197785238634378, -1.4883012500752129)),
((0, 1, 5),(1.6452252397277296, -1.5841943365508064)),
((0, 1, 6),(1.5771991660393681, -1.6768306955581214)),
((0, 1, 7),(1.5158917228554074, -1.7653371492102361)),
((0, 1, 8),(1.4612175515112293, -1.8491833813718512)),
((0, 1, 9),(1.412891506472256, -1.9281342177649994)),
((0, 1, 10),(1.3705020186863277, -2.002183865817861)),
((0, 1, 11),(1.3335715527107228, -2.0714889344073191)),
((0, 1, 12),(1.3016013385407526, -2.1363100657696057)),
((0, 1, 13),(1.2741015048988964, -2.1969660583276363)),
((0, 1, 14),(1.2506094663469607, -2.2538005397457561)),
((0, 1, 15),(1.2306997194631772, -2.3071593686748542)),
((0, 1, 16),(1.2139878072510408, -2.357376362693933)),
((0, 1, 17),(1.2001305872904486, -2.4047650656472435)),
((0, 2, -16),(2.8126045964899693, -0.64591937475004424)),
((0, 2, -15),(2.7716485337528556, -0.6601073879475956)),
((0, 2, -14),(2.7297976443326464, -0.67598129763773729)),
((0, 2, -13),(2.6870577332801586, -0.69362928720236794)),
((0, 2, -12),(2.6434458712089124, -0.71313914154788749)),
((0, 2, -11),(2.5989922251308064, -0.73459649464753585)),
((0, 2, -10),(2.5537419003084891, -0.75808269548844998)),
((0, 2, -9),(2.5077566986900024, -0.78367228062175032)),
((0, 2, -8),(2.461116673449351, -0.81143006690547059)),
((0, 2, -7),(2.4139213356117506, -0.84140791289447969)),
((0, 2, -6),(2.3662903520918221, -0.87364124134434706)),
((0, 2, -5),(2.3183635699990424, -0.90814546629767878)),
((0, 2, -4),(2.2703002151962992, -0.94491252163954853)),
((0, 2, -3),(2.2222771482265866, -0.98390773661357334)),
((0, 2, -2),(2.1744861196887149, -1.0250673380667683)),
((0, 2, -1),(2.1271300477355717, -1.0682968685963541)),
((0, 2, 0),(2.0804184353668047, -1.1134707849202516)),
((0, 2, 1),(2.0345621425151328, -1.1604334362798805)),
((0, 2, 2),(1.9897678122880385, -1.2090015198026716)),
((0, 2, 3),(1.9462323066623, -1.2589679781022298)),
((0, 2, 4),(1.9041375225671413, -1.3101071614104445)),
((0, 2, 5),(1.8636459296912178, -1.3621809445450006)),
((0, 2, 6),(1.8248971002050154, -1.4149453903295386)),
((0, 2, 7),(1.7880053996002891, -1.4681575025298712)),
((0, 2, 8),(1.7530588938617315, -1.5215816200735068)),
((0, 2, 9),(1.7201194190929436, -1.5749950661747749)),
((0, 2, 10),(1.6892236704407935, -1.6281927672638703)),
((0, 2, 11),(1.6603851069321869, -1.6809906779752777)),
((0, 2, 12),(1.6335964403502643, -1.7332279698690178)),
((0, 2, 13),(1.6088324765590276, -1.7847680465842073)),
((0, 2, 14),(1.5860531000374389, -1.8354985263922676)),
((0, 2, 15),(1.5652062286044637, -1.8853303808692585)),
((0, 2, 16),(1.5462306075626651, -1.934196437423287)),
((0, 2, 17),(1.5290583544699439, -1.9820494491045064)),
((0, 3, -15),(2.5964939416255599, -0.80083473680552086)),
((0, 3, -14),(2.5624312481956992, -0.81417352115126362)),
((0, 3, -13),(2.528235639944135, -0.82863846734891489)),
((0, 3, -12),(2.4939432826929435, -0.84425667614906252)),
((0, 3, -11),(2.4595946835483704, -0.86105289616675862)),
((0, 3, -10),(2.4252346751570495, -0.87904896310177361)),
((0, 3, -9),(2.3909123218387958, -0.89826321109132057)),
((0, 3, -8),(2.3566807384997763, -0.91870986745143934)),
((0, 3, -7),(2.3225968151891614, -0.94039844503682901)),
((0, 3, -6),(2.2887208428795569, -0.96333314932280611)),
((0, 3, -5),(2.2551160394940033, -0.98751231985694343)),
((0, 3, -4),(2.2218479792646564, -1.0129279276784398)),
((0, 3, -3),(2.1889839330058947, -1.0395651513839479)),
((0, 3, -2),(2.1565921315579257, -1.0674020544690894)),
((0, 3, -1),(2.1247409691844545, -1.0964093851841883)),
((0, 3, 0),(2.093498167732355, -1.1265505172858017)),
((0, 3, 1),(2.0629299255248439, -1.1577815457362106)),
((0, 3, 2),(2.0331000769452898, -1.1900515457362018)),
((0, 3, 3),(2.0040692892417118, -1.2233029967563451)),
((0, 3, 4),(1.975894322123807, -1.2574723658779374)),
((0, 3, 5),(1.948627373255182, -1.2924908372884534)),
((0, 3, 6),(1.9223155289253455, -1.3282851677686487)),
((0, 3, 7),(1.8970003343072608, -1.3647786420159644)),
((0, 3, 8),(1.8727174921495011, -1.4018920971491293)),
((0, 3, 9),(1.8494966929481962, -1.4395449830727194)),
((0, 3, 10),(1.8273615740234037, -1.4776564247141666)),
((0, 3, 11),(1.8063297998705503, -1.516146253456869)),
((0, 3, 12),(1.7864132519687801, -1.5549359781805552)),
((0, 3, 13),(1.7676183130977723, -1.5939496708396061)),
((0, 3, 14),(1.749946229222993, -1.6331147470218084)),
((0, 3, 15),(1.7333935311325674, -1.6723626279556443)),
((0, 4, -12),(2.4155792015701296, -0.9229300908226542)),
((0, 4, -11),(2.3881357143598629, -0.93639069814606657)),
((0, 4, -10),(2.3608985430738962, -0.95068043937253277)),
((0, 4, -9),(2.3338967261398658, -0.96580608016482095)),
((0, 4, -8),(2.3071602522819203, -0.98177255872516944)),
((0, 4, -7),(2.280719892137467, -0.99858281006656724)),
((0, 4, -6),(2.2546070115922907, -1.0162375999792777)),
((0, 4, -5),(2.2288533687705034, -1.0347353725971475)),
((0, 4, -4),(2.2034908971991967, -1.0540721155772499)),
((0, 4, -3),(2.1785514782182078, -1.0742412468897498)),
((0, 4, -2),(2.1540667061957843, -1.0952335270565667)),
((0, 4, -1),(2.130067650513797, -1.1170370003667458)),
((0, 4, 0),(2.1065846185768144, -1.1396369681302612)),
((0, 4, 1),(2.0836469242572182, -1.1630159964155509)),
((0, 4, 2),(2.0612826661990651, -1.1871539599638123)),
((0, 4, 3),(2.0395185202595947, -1.21202812310865)),
((0, 4, 4),(2.0183795500705957, -1.2376132575852286)),
((0, 4, 5),(1.9978890392622524, -1.2638817961274027)),
((0, 4, 6),(1.9780683483279828, -1.2908040197679129)),
((0, 4, 7),(1.9589367984456927, -1.3183482758210407)),
((0, 4, 8),(1.9405115838394631, -1.3464812226827663)),
((0, 4, 9),(1.9228077135002013, -1.3751680968702737)),
((0, 4, 10),(1.9058379823190674, -1.40437299717285)),
((0, 4, 11),(1.8896129709568732, -1.4340591804228155)),
((0, 4, 12),(1.8741410731060384, -1.4641893632305614)),
((0, 4, 13),(1.8594285482231945, -1.494726024062758)),
((0, 5, -8),(2.2816065790111355, -1.0256701242484463)),
((0, 5, -7),(2.2600656463635924, -1.0393407066209377)),
((0, 5, -6),(2.2388608326421919, -1.0536480508611454)),
((0, 5, -5),(2.2180100895605208, -1.0685913079385738)),
((0, 5, -4),(2.1975312185577334, -1.0841684575524713)),
((0, 5, -3),(2.1774417779425423, -1.1003762645305089)),
((0, 5, -2),(2.1577589903830492, -1.1172102440341527)),
((0, 5, -1),(2.138499651897642, -1.1346646364924449)),
((0, 5, 0),(2.1196800435198395, -1.1527323930732862)),
((0, 5, 1),(2.1013158468004081, -1.1714051723617906)),
((0, 5, 2),(2.0834220642723897, -1.1906733487511987)),
((0, 5, 3),(2.0660129459393639, -1.2105260328670362)),
((0, 5, 4),(2.0491019227555869, -1.2309511041442707)),
((0, 5, 5),(2.0327015479510706, -1.2519352554657039)),
((0, 5, 6),(2.0168234469187847, -1.2734640495542129)),
((0, 5, 7),(2.001478276228815, -1.2955219865979088)),
((0, 5, 8),(1.9866756921708819, -1.3180925823830962)),
((0, 5, 9),(1.9724243290567605, -1.3411584560209973)),
((1, -5, -7),(-0.89407303973378249, 2.0767451727258877)),
((1, -5, -6),(-0.88021476377793617, 2.0982586427056744)),
((1, -5, -5),(-0.86595985970744616, 2.1190789478790144)),
((1, -5, -4),(-0.85132131005126332, 2.1392014898821041)),
((1, -5, -3),(-0.83631240332011947, 2.1586230481528688)),
((1, -5, -2),(-0.82094668170064922, 2.1773417514781119)),
((1, -5, -1),(-0.80523788691244103, 2.1953570397142732)),
((1, -5, 0),(-0.78919990491995873, 2.2126696166823692)),
((1, -5, 1),(-0.77284671017929862, 2.2292813953036963)),
((1, -5, 2),(-0.75619231007455623, 2.2451954360829309)),
((1, -5, 3),(-0.73925069016187839, 2.260415880060807)),
((1, -5, 4),(-0.72203576079236209, 2.2749478773510226)),
((1, -5, 5),(-0.70456130562969288, 2.2887975123477147)),
((1, -5, 6),(-0.68684093251673461, 2.3019717266434081)),
((1, -5, 7),(-0.66888802707917072, 2.3144782406357112)),
((1, -4, -11),(-0.9397016539006583, 1.9960130254406245)),
((1, -4, -10),(-0.92466729702332773, 2.0262171895927903)),
((1, -4, -9),(-0.90911691764797675, 2.0555435366201182)),
((1, -4, -8),(-0.89307017326182725, 2.0839714394413322)),
((1, -4, -7),(-0.87654747142178913, 2.11148332743559)),
((1, -4, -6),(-0.85956986088585208, 2.1380647226619218)),
((1, -4, -5),(-0.84215891533171905, 2.1637042371254713)),
((1, -4, -4),(-0.82433661178137252, 2.1883935334267672)),
((1, -4, -3),(-0.80612520589249759, 2.2121272517978086)),
((1, -4, -2),(-0.78754710625722946, 2.2349029070572128)),
((1, -4, -1),(-0.76862474976857698, 2.2567207593980747)),
((1, -4, 0),(-0.74938047998107993, 2.2775836631562583)),
((1, -4, 1),(-0.72983643021275701, 2.2974968977999382)),
((1, -4, 2),(-0.71001441291971956, 2.3164679853454215)),
((1, -4, 3),(-0.68993581663340087, 2.3345064982557946)),
((1, -4, 4),(-0.66962151149388205, 2.35162386163696)),
((1, -4, 5),(-0.64909176415132319, 2.3678331532303445)),
((1, -4, 6),(-0.62836616255055211, 2.3831489043337433)),
((1, -4, 7),(-0.60746355086953252, 2.3975869043810976)),
((1, -4, 8),(-0.58640197465699107, 2.4111640114960662)),
((1, -4, 9),(-0.56519863601332765, 2.4238979709191155)),
((1, -4, 10),(-0.54386985848488067, 2.4358072428059958)),
((1, -4, 11),(-0.52243106119674565, 2.4469108405173654)),
((1, -3, -14),(-0.97702198039968391, 1.8799258807281607)),
((1, -3, -13),(-0.95931514077672331, 1.9235649764228067)),
((1, -3, -12),(-0.94090846180271104, 1.9661000118164722)),
((1, -3, -11),(-0.92183695235784668, 2.0074581286418862)),
((1, -3, -10),(-0.90213752584982132, 2.0475739052620225)),
((1, -3, -9),(-0.88184869024878554, 2.0863899668967831)),
((1, -3, -8),(-0.86101020895239966, 2.123857404806953)),
((1, -3, -7),(-0.83966274181866707, 2.1599360039125144)),
((1, -3, -6),(-0.8178474761235518, 2.1945942858192704)),
((1, -3, -5),(-0.79560575716197046, 2.2278093807219825)),
((1, -3, -4),(-0.77297872773482323, 2.2595667468305036)),
((1, -3, -3),(-0.75000698490418827, 2.2898597596560455)),
((1, -3, -2),(-0.72673026122956719, 2.318689195661451)),
((1, -3, -1),(-0.70318713631275598, 2.3460626355063243)),
((1, -3, 0),(-0.67941478297510038, 2.3719938115802552)),
((1, -3, 1),(-0.6554487508634167, 2.3965019229508209)),
((1, -3, 2),(-0.63132278881446013, 2.4196109385226281)),
((1, -3, 3),(-0.60706870597022367, 2.4413489063742095)),
((1, -3, 4),(-0.58271627047816998, 2.4617472841571253)),
((1, -3, 5),(-0.55829314366138749, 2.4808403023153613)),
((1, -3, 6),(-0.53382484681648712, 2.4986643688804748)),
((1, -3, 7),(-0.50933475728837307, 2.515257521840272)),
((1, -3, 8),(-0.48484413016560046, 2.5306589326451543)),
((1, -3, 9),(-0.46037214181421321, 2.5449084623479163)),
((1, -3, 10),(-0.43593595149281611, 2.5580462701805096)),
((1, -3, 11),(-0.41155077743656382, 2.5701124730426099)),
((1, -3, 12),(-0.38722998403238346, 2.5811468533832245)),
((1, -3, 13),(-0.36298517700407829, 2.5911886122595118)),
((1, -3, 14),(-0.33882630385928064, 2.6002761639131937)),
((1, -2, -15),(-0.98010042387326823, 1.7589026748555658)),
((1, -2, -14),(-0.95483325994444801, 1.8259516683518591)),
((1, -2, -13),(-0.92863113570157263, 1.8915470228897688)),
((1, -2, -12),(-0.90158841671179124, 1.9554055220851041)),
((1, -2, -11),(-0.87380364245204989, 2.0172701527711596)),
((1, -2, -10),(-0.84537772339251449, 2.076915965958114)),
((1, -2, -9),(-0.81641209839383366, 2.1341542100952222)),
((1, -2, -8),(-0.7870069437267776, 2.1888346302435684)),
((1, -2, -7),(-0.75725951606731212, 2.2408459897495652)),
((1, -2, -6),(-0.72726269638050811, 2.290115005912607)),
((1, -2, -5),(-0.69710378203146028, 2.3366039848296629)),
((1, -2, -4),(-0.66686355336747638, 2.3803074889702529)),
((1, -2, -3),(-0.6366156208321383, 2.4212483777718408)),
((1, -2, -2),(-0.60642604128887811, 2.4594735355289896)),
((1, -2, -1),(-0.57635317882456527, 2.49504955322675)),
((1, -2, 0),(-0.54644777632018637, 2.5280585726622768)),
((1, -2, 1),(-0.51675319935112696, 2.5585944412601838)),
((1, -2, 2),(-0.4873058129194579, 2.5867592708487126)),
((1, -2, 3),(-0.45813545329935856, 2.6126604471069412)),
((1, -2, 4),(-0.42926596100825631, 2.6364080999645751)),
((1, -2, 5),(-0.40071574577991653, 2.6581130188568665)),
((1, -2, 6),(-0.37249835973018969, 2.6778849793184261)),
((1, -2, 7),(-0.3446230601591162, 2.6958314373550074)),
((1, -2, 8),(-0.31709534827897584, 2.7120565436522557)),
((1, -2, 9),(-0.28991747439629739, 2.7266604293683305)),
((1, -2, 10),(-0.26308890361944892, 2.7397387176515799)),
((1, -2, 11),(-0.2366067390072969, 2.7513822190434163)),
((1, -2, 12),(-0.2104661012666435, 2.7616767737608674)),
((1, -2, 13),(-0.18466046572379519, 2.7707032089311818)),
((1, -2, 14),(-0.15918195842964611, 2.7785373837957028)),
((1, -2, 15),(-0.13402161399871051, 2.7852503004827458)),
((1, -2, 16),(-0.10916959821545456, 2.7909082620488559)),
((1, -1, -16),(-0.95887792611647071, 1.3731831137286603)),
((1, -1, -15),(-0.91027466006110458, 1.5046002942131473)),
((1, -1, -14),(-0.86056647781888818, 1.6374485446272675)),
((1, -1, -13),(-0.81033973286312777, 1.7693123117147276)),
((1, -1, -12),(-0.76015307525822517, 1.8977935420423371)),
((1, -1, -11),(-0.71050381061338863, 2.0207547232027534)),
((1, -1, -10),(-0.66180493693385722, 2.1365007351304093)),
((1, -1, -9),(-0.61437459228224556, 2.2438680286867712)),
((1, -1, -8),(-0.56843673255025617, 2.3422221819032774)),
((1, -1, -7),(-0.52413002858854896, 2.4313886697135136)),
((1, -1, -6),(-0.4815214447570772, 2.5115497501432982)),
((1, -1, -5),(-0.44062140754648005, 2.5831356998233006)),
((1, -1, -4),(-0.40139837742377854, 2.6467283587390318)),
((1, -1, -3),(-0.36379157690695846, 2.702984949095725)),
((1, -1, -2),(-0.32772137441488314, 2.7525831440819792)),
((1, -1, -1),(-0.29309731396173128, 2.7961846358725242)),
((1, -1, 0),(-0.25982404705442846, 2.8344131251271367)),
((1, -1, 1),(-0.22780553015109939, 2.8678427048340356)),
((1, -1, 2),(-0.19694786162684805, 2.8969932693241778)),
((1, -1, 3),(-0.16716109362123341, 2.9223303871021922)),
((1, -1, 4),(-0.13836029674675512, 2.9442678134946223)),
((1, -1, 5),(-0.11046609644209177, 2.9631714085545591)),
((1, -1, 6),(-0.083404846897727397, 2.9793636615802868)),
((1, -1, 7),(-0.057108564857251125, 2.993128329419068)),
((1, -1, 8),(-0.031514711337499599, 3.0047149018303658)),
((1, -1, 9),(-0.006565883311999793, 3.0143427413962143)),
((1, -1, 10),(0.01779054183607957, 3.0222048299664186)),
((1, -1, 11),(0.041602780242176667, 3.0284711048158002)),
((1, -1, 12),(0.06491501497919476, 3.0332913971436257)),
((1, -1, 13),(0.087767757076635144, 3.036798001164561)),
((1, -1, 14),(0.11019818709675025, 3.0391079090922473)),
((1, -1, 15),(0.13224047352690543, 3.0403247492370111)),
((1, -1, 16),(0.15392606645347479, 3.0405404634298092)),
((1, -1, 17),(0.17528396641982708, 3.0398367574264209)),
((1, 0, -10),(0.95481963794725688, 2.7719414171341081)),
((1, 0, -9),(0.71105679835054592, 3.05666358317578)),
((1, 0, -8),(0.58534610836336609, -3.0762408416707667)),
((1, 0, -7),(0.50949706785106086, -2.9840185003473416)),
((1, 0, -6),(0.46040809359052204, -2.9232390926180671)),
((1, 0, -5),(0.4275799573316193, -2.8816462949316262)),
((1, 0, -4),(0.40544531760971536, -2.8526968114716933)),
((1, 0, -3),(0.39074500024189346, -2.8325460682578409)),
((1, 0, -2),(0.3814326902486857, -2.8187753382694898)),
((1, 0, -1),(0.37615421945164157, -2.8097822525152405)),
((1, 0, 0),(0.37397583936030748, -2.8044612787894767)),
((1, 0, 1),(0.3742320215482941, -2.8020242172155267)),
((1, 0, 2),(0.3764353032148855, -2.8018936667951309)),
((1, 0, 3),(0.38022039961942189, -2.8036369033841027)),
((1, 0, 4),(0.38530822373870033, -2.8069232785698808)),
((1, 0, 5),(0.39148196920807926, -2.8114958897215727)),
((1, 0, 6),(0.39857076961164667, -2.8171522205542749)),
((1, 0, 7),(0.40643826485250595, -2.8237305947988451)),
((1, 0, 8),(0.41497443207131601, -2.8311004983210784)),
((1, 0, 9),(0.42408964014891531, -2.8391555365009031)),
((1, 0, 10),(0.43371025072967179, -2.8478082244663718)),
((1, 0, 11),(0.44377531512409168, -2.8569860759939827)),
((1, 0, 12),(0.45423406090577162, -2.8666286280877316)),
((1, 0, 13),(0.46504395627240053, -2.8766851499877339)),
((1, 0, 14),(0.47616920299692378, -2.8871128597697737)),
((1, 0, 15),(0.48757955135247516, -2.8978755221616073)),
((1, 0, 16),(0.49924935974110324, -2.9089423360005715)),
((1, 0, 17),(0.51115684230435487, -2.9202870441212059)),
((1, 1, -16),(2.7246231866126527, -1.2133141455869012)),
((1, 1, -15),(2.6054789402230454, -1.2643183949031944)),
((1, 1, -14),(2.4802938363031153, -1.3185755066279565)),
((1, 1, -13),(2.3507625797744822, -1.3754740000452073)),
((1, 1, -12),(2.2191067822251624, -1.4342747002517073)),
((1, 1, -11),(2.0878851547326316, -1.4941638812299491)),
((1, 1, -10),(1.9597171842791028, -1.5543192698508332)),
((1, 1, -9),(1.8369888022339407, -1.6139756207429214)),
((1, 1, -8),(1.7216168470257835, -1.6724770121846348)),
((1, 1, -7),(1.6149227066379719, -1.7293079395121413)),
((1, 1, -6),(1.5176220689478739, -1.7841020063674211)),
((1, 1, -5),(1.4299022374209196, -1.836632464505191)),
((1, 1, -4),(1.3515445092037235, -1.8867914071577239)),
((1, 1, -3),(1.2820541924139739, -1.9345642630860251)),
((1, 1, -2),(1.2207746825591554, -1.9800045369454387)),
((1, 1, -1),(1.166975663762198, -2.0232116807198977)),
((1, 1, 0),(1.1199148171439508, -2.0643132749196007)),
((1, 1, 1),(1.0788771100508068, -2.1034515799455495)),
((1, 1, 2),(1.0431971642423064, -2.1407739310209308)),
((1, 1, 3),(1.0122698665959817, -2.176426234034381)),
((1, 1, 4),(0.98555336401902194, -2.2105488177942716)),
((1, 1, 5),(0.96256746717274733, -2.243273996683024)),
((1, 1, 6),(0.94288953088683458, -2.2747248274896879)),
((1, 1, 7),(0.92614915135801568, -2.305014669665737)),
((1, 1, 8),(0.91202250534244345, -2.3342472645934493)),
((1, 1, 9),(0.90022681042349251, -2.3625171331669272)),
((1, 1, 10),(0.89051516207480941, -2.3899101538195908)),
((1, 1, 11),(0.88267186443878642, -2.4165042287445746)),
((1, 1, 12),(0.87650828896166466, -2.4423699783378208)),
((1, 1, 13),(0.87185924822074201, -2.4675714262730697)),
((1, 1, 14),(0.86857984792504295, -2.4921666528424895)),
((1, 1, 15),(0.86654276931668217, -2.5162084043607633)),
((1, 1, 16),(0.86563593138548922, -2.5397446530731767)),
((1, 1, 17),(0.86576048389364357, -2.5628191062359336)),
((1, 2, -15),(2.349451852688107, -1.1939505337251333)),
((1, 2, -14),(2.2841008433311312, -1.2201396128269182)),
((1, 2, -13),(2.2188804192832841, -1.2478095745114395)),
((1, 2, -12),(2.1540936271082298, -1.2768855697514365)),
((1, 2, -11),(2.0900529237366969, -1.3072772164197373)),
((1, 2, -10),(2.0270713380336485, -1.3388797309639269)),
((1, 2, -9),(1.9654533002620245, -1.3715756962076799)),
((1, 2, -8),(1.9054857739426576, -1.4052373967378002)),
((1, 2, -7),(1.8474303059550592, -1.439729602650301)),
((1, 2, -6),(1.7915165143210783, -1.4749126425881733)),
((1, 2, -5),(1.737937375669119, -1.5106455839911062)),
((1, 2, -4),(1.686846483666236, -1.5467893354367523)),
((1, 2, -3),(1.6383572575072287, -1.5832095025455886)),
((1, 2, -2),(1.5925439141682738, -1.6197788615533473)),
((1, 2, -1),(1.5494438988306627, -1.6563793574706882)),
((1, 2, 0),(1.5090614025277724, -1.6929035800385732)),
((1, 2, 1),(1.4713715820090709, -1.7292557142725435)),
((1, 2, 2),(1.4363251239391153, -1.7653519986423261)),
((1, 2, 3),(1.4038528501699679, -1.801120750248745)),
((1, 2, 4),(1.3738701291451958, -1.8365020321003434)),
((1, 2, 5),(1.3462809289757345, -1.8714470436712756)),
((1, 2, 6),(1.3209814122106305, -1.9059173142204662)),
((1, 2, 7),(1.2978630261113768, -1.9398837711465664)),
((1, 2, 8),(1.2768150835355687, -1.9733257451678932)),
((1, 2, 9),(1.2577268586283499, -2.0062299622390132)),
((1, 2, 10),(1.2404892399371001, -2.0385895602684396)),
((1, 2, 11),(1.2249959933980208, -2.0704031578313815)),
((1, 2, 12),(1.211144691068301, -2.101673992708144)),
((1, 2, 13),(1.1988373604659983, -2.1324091404307914)),
((1, 2, 14),(1.1879809055619741, -2.1626188170721261)),
((1, 2, 15),(1.1784873450989899, -2.1923157661086061)),
((1, 2, 16),(1.1702739078974147, -2.2215147261091088)),
((1, 2, 17),(1.1632630187557382, -2.2502319739988956)),
((1, 3, -14),(2.2287344615181803, -1.1972160195081651)),
((1, 3, -13),(2.1851351316440755, -1.2154490331114414)),
((1, 3, -12),(2.1420664400962472, -1.2346395009084177)),
((1, 3, -11),(2.0996221110272675, -1.2547638950157685)),
((1, 3, -10),(2.0578949013512204, -1.2757941368962245)),
((1, 3, -9),(2.0169753117561937, -1.297697680898942)),
((1, 3, -8),(1.9769503279370937, -1.3204376922591041)),
((1, 3, -7),(1.9379022328408335, -1.3439733187994027)),
((1, 3, -6),(1.8999075280668218, -1.3682600516944388)),
((1, 3, -5),(1.8630359976436406, -1.3932501668288215)),
((1, 3, -4),(1.8273499405804552, -1.418893234779034)),
((1, 3, -3),(1.7929035904135779, -1.4451366845386899)),
((1, 3, -2),(1.7597427310864133, -1.4719264040004365)),
((1, 3, -1),(1.7279045095976933, -1.4992073590487036)),
((1, 3, 0),(1.6974174375667062, -1.5269242129638374)),
((1, 3, 1),(1.6683015667244603, -1.55502192865938)),
((1, 3, 2),(1.6405688177223134, -1.5834463379588732)),
((1, 3, 3),(1.6142234377567626, -1.6121446644912112)),
((1, 3, 4),(1.5892625603732111, -1.6410659896287536)),
((1, 3, 5),(1.565676840317711, -1.6701616539795996)),
((1, 3, 6),(1.5434511372277899, -1.699385590053192)),
((1, 3, 7),(1.5225652239965484, -1.7286945846546011)),
((1, 3, 8),(1.5029944984839734, -1.7580484721763741)),
((1, 3, 9),(1.4847106805685495, -1.7874102621454142)),
((1, 3, 10),(1.4676824800460371, -1.8167462060917778)),
((1, 3, 11),(1.4518762243549095, -1.8460258100253739)),
((1, 3, 12),(1.4372564383606037, -1.8752217995596685)),
((1, 3, 13),(1.4237863713411285, -1.9043100450582051)),
((1, 3, 14),(1.4114284688144743, -1.9332694541660373)),
((1, 3, 15),(1.4001447889055489, -1.9620818387960384)),
((1, 4, -12),(2.1427474424680595, -1.2203240542719034)),
((1, 4, -11),(2.1109815942700232, -1.2353219908932851)),
((1, 4, -10),(2.079772602367727, -1.2510160987466759)),
((1, 4, -9),(2.0491589839572719, -1.2673937531788486)),
((1, 4, -8),(2.0191779309105913, -1.2844404231979507)),
((1, 4, -7),(1.9898649973805929, -1.3021396989493801)),
((1, 4, -6),(1.9612538088017069, -1.320473344563007)),
((1, 4, -5),(1.9333757977434263, -1.3394213761584173)),
((1, 4, -4),(1.906259971384991, -1.3589621641574121)),
((1, 4, -3),(1.8799327145240008, -1.3790725584209842)),
((1, 4, -2),(1.8544176310495768, -1.3997280341295666)),
((1, 4, -1),(1.8297354257481466, -1.4209028557885244)),
((1, 4, 0),(1.8059038272157191, -1.4425702562896054)),
((1, 4, 1),(1.7829375515743535, -1.4647026276137429)),
((1, 4, 2),(1.7608483056779614, -1.4872717195347653)),
((1, 4, 3),(1.7396448275835226, -1.5102488425844542)),
((1, 4, 4),(1.7193329612897263, -1.53360507156696)),
((1, 4, 5),(1.6999157621280057, -1.5573114460582953)),
((1, 4, 6),(1.6813936287424309, -1.5813391645815296)),
((1, 4, 7),(1.663764457317334, -1.6056597694934063)),
((1, 4, 8),(1.6470238135977084, -1.630245320032472)),
((1, 4, 9),(1.6311651182834308, -1.6550685514403038)),
((1, 4, 10),(1.6161798415445314, -1.6801030185535581)),
((1, 4, 11),(1.602057702677939, -1.7053232227540684)),
((1, 4, 12),(1.5887868712814273, -1.7307047216380866)),
((1, 4, 13),(1.5763541667332706, -1.7562242212083103)),
((1, 5, -8),(2.0497006391453354, -1.2681361127482753)),
((1, 5, -7),(2.0262570277779406, -1.2822710891783409)),
((1, 5, -6),(2.0033472347453318, -1.2969365039661889)),
((1, 5, -5),(1.9809879297795063, -1.3121225234371252)),
((1, 5, -4),(1.9591947200896194, -1.3278183776646379)),
((1, 5, -3),(1.9379820716288185, -1.3440123923766063)),
((1, 5, -2),(1.9173632418234046, -1.3606920298394409)),
((1, 5, -1),(1.897350224434331, -1.3778439382849437)),
((1, 5, 0),(1.8779537070007057, -1.3954540092935219)),
((1, 5, 1),(1.8591830410881141, -1.4135074424084479)),
((1, 5, 2),(1.8410462253382669, -1.4319888161334426)),
((1, 5, 3),(1.8235499010975293, -1.4508821643637797)),
((1, 5, 4),(1.8066993601966537, -1.470171057222373)),
((1, 5, 5),(1.7904985642678861, -1.4898386852187724)),
((1, 5, 6),(1.7749501748232641, -1.5098679456219133)),
((1, 5, 7),(1.7600555931824582, -1.5302415299365482)),
((1, 5, 8),(1.7458150092323426, -1.5509420113978114)),
((1, 5, 9),(1.7322274579243766, -1.5719519314462813)),
((1, 5, 10),(1.719290882369664, -1.5932538842146433)),
((2, -4, -8),(-0.61954710899339216, 2.3329910445961688)),
((2, -4, -7),(-0.60728081671452516, 2.3566654171219534)),
((2, -4, -6),(-0.59467769508850477, 2.3793104520282076)),
((2, -4, -5),(-0.58175386154829634, 2.4009408258170128)),
((2, -4, -4),(-0.56852515670265502, 2.4215726509427666)),
((2, -4, -3),(-0.55500710875375914, 2.4412233069048894)),
((2, -4, -2),(-0.54121489970608039, 2.4599112741082649)),
((2, -4, -1),(-0.52716333382043812, 2.4776559722917302)),
((2, -4, 0),(-0.51286680867468315, 2.4944776050167738)),
((2, -4, 1),(-0.49833928910379732, 2.5103970114149257)),
((2, -4, 2),(-0.48359428420871325, 2.5254355261177701)),
((2, -4, 3),(-0.46864482754623005, 2.5396148480416505)),
((2, -4, 4),(-0.45350346054279467, 2.5529569184720491)),
((2, -4, 5),(-0.43818221911325317, 2.5654838086914902)),
((2, -4, 6),(-0.42269262341235625, 2.5772176172199388)),
((2, -4, 7),(-0.40704567060184782, 2.5881803765875979)),
((2, -4, 8),(-0.3912518304791297, 2.5983939694354485)),
((2, -4, 9),(-0.37532104378462744, 2.6078800536377038)),
((2, -3, -11),(-0.56115378940543204, 2.3421510573960767)),
((2, -3, -10),(-0.54849744498870678, 2.3753386147354085)),
((2, -3, -9),(-0.53544745667238725, 2.4069092392212483)),
((2, -3, -8),(-0.52202901038200744, 2.4368937803622162)),
((2, -3, -7),(-0.50826646696426347, 2.4653265442028998)),
((2, -3, -6),(-0.49418332415783389, 2.4922447280361726)),
((2, -3, -5),(-0.47980218273231312, 2.5176878825888229)),
((2, -3, -4),(-0.46514471772998506, 2.5416974079418986)),
((2, -3, -3),(-0.45023165543556992, 2.564316087479428)),
((2, -3, -2),(-0.4350827564268358, 2.585587662454639)),
((2, -3, -1),(-0.41971680482469637, 2.6055564483261962)),
((2, -3, 0),(-0.40415160366519337, 2.6242669928406825)),
((2, -3, 1),(-0.38840397615680261, 2.6417637749048142)),
((2, -3, 2),(-0.37248977246225196, 2.6580909425780197)),
((2, -3, 3),(-0.35642388155223975, 2.6732920879972633)),
((2, -3, 4),(-0.34022024761550229, 2.6874100566934089)),
((2, -3, 5),(-0.3238918904720916, 2.7004867885451262)),
((2, -3, 6),(-0.30745092942068752, 2.7125631875166478)),
((2, -3, 7),(-0.29090860995249707, 2.7236790173162793)),
((2, -3, 8),(-0.27427533278038851, 2.7338728201728646)),
((2, -3, 9),(-0.25756068465882037, 2.7431818560393468)),
((2, -3, 10),(-0.24077347050507247, 2.7516420596810822)),
((2, -3, 11),(-0.22392174637259285, 2.7592880132791273)),
((2, -3, 12),(-0.20701285287071128, 2.7661529323651299)),
((2, -2, -13),(-0.41882437120312666, 2.3887852859156964)),
((2, -2, -12),(-0.40684719216106496, 2.4368754975472857)),
((2, -2, -11),(-0.39439053304781396, 2.4819123314289544)),
((2, -2, -10),(-0.381497860920197, 2.5240121531970177)),
((2, -2, -9),(-0.3682095316548567, 2.5632971559852504)),
((2, -2, -8),(-0.35456296338780607, 2.5998929447030594)),
((2, -2, -7),(-0.34059279541029142, 2.6339264861808704)),
((2, -2, -6),(-0.32633103705430982, 2.6655244092430763)),
((2, -2, -5),(-0.31180720957313457, 2.6948116276399872)),
((2, -2, -4),(-0.29704848289657715, 2.7219102525636734)),
((2, -2, -3),(-0.28207980832905938, 2.7469387589252148)),
((2, -2, -2),(-0.26692404769071842, 2.7700113696015114)),
((2, -2, -1),(-0.2516020990216517, 2.7912376235939869)),
((2, -2, 0),(-0.23613301873059528, 2.8107220968033038)),
((2, -2, 1),(-0.22053413993612225, 2.8285642474165043)),
((2, -2, 2),(-0.20482118669057842, 2.8448583613735146)),
((2, -2, 3),(-0.18900838377194662, 2.8596935767939997)),
((2, -2, 4),(-0.17310856175844452, 2.8731539694557742)),
((2, -2, 5),(-0.15713325715122611, 2.8853186843394356)),
((2, -2, 6),(-0.14109280737209723, 2.8962621008530562)),
((2, -2, 7),(-0.12499644052816389, 2.9060540216182331)),
((2, -2, 8),(-0.1088523598990175, 2.9147598766468845)),
((2, -2, 9),(-0.092667823160860557, 2.9224409363901924)),
((2, -2, 10),(-0.076449216414155668, 2.9291545285266229)),
((2, -2, 11),(-0.060202123125855073, 2.9349542545064025)),
((2, -2, 12),(-0.043931388133712175, 2.9398902028162714)),
((2, -2, 13),(-0.02764117688890844, 2.9440091567002775)),
((2, -2, 14),(-0.011335030134813325, 2.9473547946966305)),
((2, -2, 15),(0.0049840857655256057, 2.9499678828507121)),
((2, -1, -14),(-0.073845419942377755, 2.553847900286494)),
((2, -1, -13),(-0.073168254163339941, 2.6251096386957853)),
((2, -1, -12),(-0.070950699299407741, 2.6888357887562258)),
((2, -1, -11),(-0.067406369927067902, 2.7458325833014761)),
((2, -1, -10),(-0.062711172357787184, 2.7968153567982115)),
((2, -1, -9),(-0.057011769744841491, 2.8424174075268627)),
((2, -1, -8),(-0.050431723585048945, 2.8831986384306951)),
((2, -1, -7),(-0.04307605092955262, 2.9196537471080193)),
((2, -1, -6),(-0.035034674118559789, 2.9522198082523392)),
((2, -1, -5),(-0.02638507897483465, 2.9812831666925779)),
((2, -1, -4),(-0.017194395854430757, 3.00718561810789)),
((2, -1, -3),(-0.0075210521929808261, 3.0302298949164843)),
((2, -1, -2),(0.0025838983923695065, 3.0506844995866498)),
((2, -1, -1),(0.01307569486537382, 3.0687879407238294)),
((2, -1, 0),(0.023914980135121326, 3.0847524324278006)),
((2, -1, 1),(0.035067064003993439, 3.098767117462506)),
((2, -1, 2),(0.04650130682390665, 3.1110008718085242)),
((2, -1, 3),(0.058190600314878133, 3.1216047435852929)),
((2, -1, 4),(0.070110927368640219, 3.1307140740550081)),
((2, -1, 5),(0.082240986643051933, 3.1384503430231279)),
((2, -1, 6),(0.094561870744184331, -3.1382625314144423)),
((2, -1, 7),(0.10705678906507073, -3.1329555633650013)),
((2, -1, 8),(0.11971082809495169, -3.1287253195564624)),
((2, -1, 9),(0.13251074336673507, -3.1254916219096525)),
((2, -1, 10),(0.14544477827116342, -3.1231819191407748)),
((2, -1, 11),(0.15850250580533459, -3.1217304664159649)),
((2, -1, 12),(0.1716746899926653, -3.1210776048568523)),
((2, -1, 13),(0.18495316425009234, -3.1211691276837557)),
((2, -1, 14),(0.19833072441513086, -3.1219557216419038)),
((2, -1, 15),(0.21180103450230528, -3.1233924739474976)),
((2, -1, 16),(0.22535854355203175, -3.1254384363515046)),
((2, 0, -15),(0.76692013902925027, 3.0343021886286965)),
((2, 0, -14),(0.69122378003770413, 3.1174400946456018)),
((2, 0, -13),(0.63139113072854547, -3.099617155322071)),
((2, 0, -12),(0.58325508386384151, -3.0460860828913865)),
((2, 0, -11),(0.54408600900688264, -3.0022421585041332)),
((2, 0, -10),(0.51199294451005473, -2.9660592821100611)),
((2, 0, -9),(0.48561022276540866, -2.9360684594989439)),
((2, 0, -8),(0.4639191381319277, -2.9111706319939059)),
((2, 0, -7),(0.44613985500919839, -2.8905225371761638)),
((2, 0, -6),(0.43166257082606302, -2.8734636388420105)),
((2, 0, -5),(0.42000189330168941, -2.8594674808516762)),
((2, 0, -4),(0.4107655891852518, -2.848108237206056)),
((2, 0, -3),(0.40363257406337077, -2.8390370769148645)),
((2, 0, -2),(0.39833703759483602, -2.8319650706584354)),
((2, 0, -1),(0.39465675551330615, -2.8266505767805206)),
((2, 0, 0),(0.39240432746846693, -2.822889766897636)),
((2, 0, 1),(0.39142050267679701, -2.8205093976573896)),
((2, 0, 2),(0.39156902318909637, -2.8193612188563288)),
((2, 0, 3),(0.39273258866333016, -2.8193175931345347)),
((2, 0, 4),(0.39480966230561654, -2.8202680258858623)),
((2, 0, 5),(0.39771191623559415, -2.8221163880430304)),
((2, 0, 6),(0.40136216887978765, -2.8247786726444684)),
((2, 0, 7),(0.4056927052115506, -2.8281811671411843)),
((2, 0, 8),(0.41064389793941108, -2.8322589527705913)),
((2, 0, 9),(0.41616306749748377, -2.8369546636251184)),
((2, 0, 10),(0.422203533175321, -2.8422174536888143)),
((2, 0, 11),(0.42872381847114654, -2.8480021317407807)),
((2, 0, 12),(0.4356869818140367, -2.854268432756665)),
((2, 0, 13),(0.44306004990974235, -2.8609804010645221)),
((2, 0, 14),(0.45081353563837984, -2.8681058655847194)),
((2, 0, 15),(0.45892102603931506, -2.8756159914026687)),
((2, 0, 16),(0.46735882872576412, -2.8834848949755267)),
((2, 1, -15),(1.5219147861473099, -2.3030300844836371)),
((2, 1, -14),(1.4241262547709492, -2.3024182445671428)),
((2, 1, -13),(1.3374271625198573, -2.3038427909303758)),
((2, 1, -12),(1.2605671992279919, -2.306964045115182)),
((2, 1, -11),(1.1924235487822747, -2.3115145920018954)),
((2, 1, -10),(1.1319972664639939, -2.3172799445108274)),
((2, 1, -9),(1.0784057214792562, -2.3240854197055674)),
((2, 1, -8),(1.0308727467043228, -2.3317869441908949)),
((2, 1, -7),(0.9887178359667893, -2.3402644342142835)),
((2, 1, -6),(0.95134531491608321, -2.3494169150579789)),
((2, 1, -5),(0.91823405287894178, -2.3591588472054883)),
((2, 1, -4),(0.88892801929221665, -2.3694173098906863)),
((2, 1, -3),(0.86302781168552412, -2.3801298068425725)),
((2, 1, -2),(0.84018317239120677, -2.3912425322402413)),
((2, 1, -1),(0.82008644806998743, -2.4027089829714252)),
((2, 1, 0),(0.80246691376434565, -2.4144888355692631)),
((2, 1, 1),(0.78708587001623442, -2.4265470283130304)),
((2, 1, 2),(0.77373241980652407, -2.43885300440459)),
((2, 1, 3),(0.76221983661538395, -2.4513800830772823)),
((2, 1, 4),(0.75238244258497722, -2.4641049333828189)),
((2, 1, 5),(0.7440729246656681, -2.4770071311713844)),
((2, 1, 6),(0.73716002563420346, -2.4900687840581197)),
((2, 1, 7),(0.7315265553864021, -2.5032742123817124)),
((2, 1, 8),(0.72706767563959285, -2.5166096766026889)),
((2, 1, 9),(0.72368941802669839, -2.5300631434655565)),
((2, 1, 10),(0.72130740152562467, -2.543624084706769)),
((2, 1, 11),(0.71984572029948457, -2.5572833032335733)),
((2, 1, 12),(0.71923597740694467, -2.5710327826038171)),
((2, 1, 13),(0.71941644356680723, -2.5848655563590417)),
((2, 1, 14),(0.72033132331520999, -2.5987755943444473)),
((2, 1, 15),(0.72193011355895387, -2.6127577036201712)),
((2, 1, 16),(0.72416704177828517, -2.6268074419528382)),
((2, 2, -14),(1.7173009160492683, -1.8316861489234377)),
((2, 2, -13),(1.6560504807062806, -1.8479518722822745)),
((2, 2, -12),(1.5982068831927863, -1.8646868206123335)),
((2, 2, -11),(1.5437471103551941, -1.88183627037276)),
((2, 2, -10),(1.4926187423438639, -1.8993489694281354)),
((2, 2, -9),(1.4447450247293441, -1.9171771801345407)),
((2, 2, -8),(1.4000297870877445, -1.9352766850417449)),
((2, 2, -7),(1.3583620227800679, -1.9536067551919378)),
((2, 2, -6),(1.3196200125928552, -1.9721300832649065)),
((2, 2, -5),(1.2836749315320335, -1.9908126853876502)),
((2, 2, -4),(1.2503939219973159, -2.0096237763835991)),
((2, 2, -3),(1.2196426482701186, -2.0285356236879615)),
((2, 2, -2),(1.1912873682521665, -2.0475233852098662)),
((2, 2, -1),(1.1651965706951994, -2.0665649361824485)),
((2, 2, 0),(1.1412422318272026, -2.0856406896028523)),
((2, 2, 1),(1.119300746185824, -2.1047334143043623)),
((2, 2, 2),(1.0992535841921696, -2.1238280540869123)),
((2, 2, 3),(1.0809877247799564, -2.1429115507082925)),
((2, 2, 4),(1.0643959061630839, -2.1619726729417081)),
((2, 2, 5),(1.0493767322336196, -2.1810018533581301)),
((2, 2, 6),(1.0358346665694322, -2.1999910340078315)),
((2, 2, 7),(1.0236799408655504, -2.2189335217596926)),
((2, 2, 8),(1.0128283999347152, -2.2378238537099646)),
((2, 2, 9),(1.0032013013139292, -2.2566576727903893)),
((2, 2, 10),(0.99472508397314841, -2.2754316134834252)),
((2, 2, 11),(0.98733111762259518, -2.2941431973827484)),
((2, 2, 12),(0.98095544160978909, -2.3127907382126422)),
((2, 2, 13),(0.97553850033121803, -2.331373255833566)),
((2, 2, 14),(0.9710248803979421, -2.3498903987056639)),
((2, 2, 15),(0.96736305343405193, -2.3683423742517546)),
((2, 2, 16),(0.96450512729953497, -2.3867298865505404)),
((2, 3, -12),(1.7604464425077111, -1.6507693997012065)),
((2, 3, -11),(1.7196856554248177, -1.6665264875620756)),
((2, 3, -10),(1.6805461809932902, -1.6827703619481831)),
((2, 3, -9),(1.64304320509011, -1.69946771380036)),
((2, 3, -8),(1.6071832202423475, -1.716585527661374)),
((2, 3, -7),(1.5729645847918252, -1.7340912670076762)),
((2, 3, -6),(1.5403781700436137, -1.75195305019254)),
((2, 3, -5),(1.509408068152321, -1.7701398134204724)),
((2, 3, -4),(1.4800323355258489, -1.788621457918965)),
((2, 3, -3),(1.4522237492668042, -1.8073689792366594)),
((2, 3, -2),(1.42595055735188, -1.826354577342465)),
((2, 3, -1),(1.4011772066230965, -1.8455517468979985)),
((2, 3, 0),(1.3778650360271942, -1.8649353477025177)),
((2, 3, 1),(1.3559729257323152, -1.8844816558490995)),
((2, 3, 2),(1.3354578956620218, -1.9041683965739622)),
((2, 3, 3),(1.3162756495452721, -1.9239747601246668)),
((2, 3, 4),(1.2983810627531525, -1.9438814022203688)),
((2, 3, 5),(1.2817286139732431, -1.963870430835057)),
((2, 3, 6),(1.266272762176621, -1.9839253811129056)),
((2, 3, 7),(1.2519682713914508, -2.0040311802352195)),
((2, 3, 8),(1.2387704865504168, -2.0241741040133441)),
((2, 3, 9),(1.2266355641708708, -2.04434172689384)),
((2, 3, 10),(1.2155206619010659, -2.0645228669428448)),
((2, 3, 11),(1.2053840910655191, -2.0847075272362185)),
((2, 3, 12),(1.1961854363065139, -2.104886834929923)),
((2, 3, 13),(1.1878856462811196, -2.1250529791285158)),
((2, 3, 14),(1.1804470991634843, -2.1451991485147373)),
((2, 4, -10),(1.7915863890086414, -1.5642945973306286)),
((2, 4, -9),(1.7617726903056548, -1.5783744676542892)),
((2, 4, -8),(1.7329659024720667, -1.5929087542425828)),
((2, 4, -7),(1.7051756677017831, -1.6078775529627165)),
((2, 4, -6),(1.6784084281577905, -1.6232606731961503)),
((2, 4, -5),(1.6526675209448101, -1.6390377320482352)),
((2, 4, -4),(1.6279533029510871, -1.6551882503361606)),
((2, 4, -3),(1.6042633011199618, -1.6716917486939027)),
((2, 4, -2),(1.5815923835921026, -1.6885278422321282)),
((2, 4, -1),(1.5599329471753591, -1.705676332323764)),
((2, 4, 0),(1.5392751167350027, -1.7231172942458037)),
((2, 4, 1),(1.5196069523335645, -1.7408311595877348)),
((2, 4, 2),(1.500914660266067, -1.7587987925295396)),
((2, 4, 3),(1.4831828045119426, -1.7770015592899999)),
((2, 4, 4),(1.4663945155392768, -1.7954213902424876)),
((2, 4, 5),(1.4505316938315893, -1.8140408343845569)),
((2, 4, 6),(1.4355752059454514, -1.8328431060242285)),
((2, 4, 7),(1.421505071335297, -1.851812123706329)),
((2, 4, 8),(1.4083006385883492, -1.8709325415434965)),
((2, 4, 9),(1.3959407500894452, -1.8901897732370774)),
((2, 4, 10),(1.3844038944765971, -1.9095700091721381)),
((2, 4, 11),(1.373668346550114, -1.9290602270487438)),
((2, 4, 12),(1.3637122945591946, -1.9486481965690303)),
((2, 5, -5),(1.750718452508645, -1.5576676541265673)),
((2, 5, -4),(1.7298420126179952, -1.571529043704387)),
((2, 5, -3),(1.7096958062629115, -1.5857575547245317)),
((2, 5, -2),(1.6902807774565496, -1.6003398122918973)),
((2, 5, -1),(1.671596523132898, -1.6152622788567994)),
((2, 5, 0),(1.6536413470467028, -1.6305113052237958)),
((2, 5, 1),(1.6364123212316675, -1.646073181968436)),
((2, 5, 2),(1.6199053538217301, -1.6619341906464038)),
((2, 5, 3),(1.6041152620411503, -1.6780806542168727)),
((2, 5, 4),(1.589035849192461, -1.694498986148028)),
((2, 5, 5),(1.5746599845148228, -1.7111757377262742)),
((2, 5, 6),(1.5609796848456641, -1.7280976431496093)),
((2, 5, 7),(1.5479861970927733, -1.7452516620483465)),
((2, 5, 8),(1.5356700806089021, -1.7626250191409327)),
((3, -3, -7),(-0.2741754753127878, 2.671344765409378)),
((3, -3, -6),(-0.26631769850471354, 2.6911794681718102)),
((3, -3, -5),(-0.2581099174871988, 2.7098374691569171)),
((3, -3, -4),(-0.24956997946003118, 2.7273638171346697)),
((3, -3, -3),(-0.24071484189995113, 2.7438021638107437)),
((3, -3, -2),(-0.23156061620093968, 2.7591947452638985)),
((3, -3, -1),(-0.22212260698993833, 2.7735823718797477)),
((3, -3, 0),(-0.21241534790484487, 2.7870044259775533)),
((3, -3, 1),(-0.20245263447276779, 2.7994988663169416)),
((3, -3, 2),(-0.19224755460297335, 2.8111022386845277)),
((3, -3, 3),(-0.18181251710701202, 2.8218496917899483)),
((3, -3, 4),(-0.17115927857412513, 2.8317749977410047)),
((3, -3, 5),(-0.16029896886084771, 2.8409105764149745)),
((3, -3, 6),(-0.14924211539692001, 2.8492875230942496)),
((3, -3, 7),(-0.137998666463438, 2.8569356387872804)),
((3, -3, 8),(-0.12657801356182855, 2.863883462708591)),
((3, -3, 9),(-0.11498901296228205, 2.870158306443241)),
((3, -2, -10),(-0.11641918619139514, 2.7761235119604262)),
((3, -2, -9),(-0.11231691480102528, 2.8015185089346804)),
((3, -2, -8),(-0.1076484393571444, 2.8251296061261519)),
((3, -2, -7),(-0.10245058262662413, 2.8470568676926113)),
((3, -2, -6),(-0.096757274156200168, 2.867394108604334)),
((3, -2, -5),(-0.090599848315203999, 2.8862292991061675)),
((3, -2, -4),(-0.084007298694101992, 2.9036449410118612)),
((3, -2, -3),(-0.07700649687744851, 2.9197184185714731)),
((3, -2, -2),(-0.069622381949659862, 2.9345223260853248)),
((3, -2, -1),(-0.061878125804485914, 2.9481247740544525)),
((3, -2, 0),(-0.05379527832321726, 2.9605896753939001)),
((3, -2, 1),(-0.045393895696489987, 2.9719770130501271)),
((3, -2, 2),(-0.036692654539970893, 2.9823430902291368)),
((3, -2, 3),(-0.027708953958340284, 2.9917407643400007)),
((3, -2, 4),(-0.018459007316490302, 3.0002196656774149)),
((3, -2, 5),(-0.0089579251602703927, 3.0078264017994116)),
((3, -2, 6),(0.00078020952532086452, 3.0146047484974958)),
((3, -2, 7),(0.01074227273764859, 3.0205958282034526)),
((3, -2, 8),(0.020916036740516567, 3.0258382766281358)),
((3, -2, 9),(0.031290112528109024, 3.0303683983814538)),
((3, -2, 10),(0.041853896895351524, 3.0342203122791074)),
((3, -2, 11),(0.05259752363029941, 3.037426087000012)),
((3, -2, 12),(0.063511818417083157, 3.0400158677184876)),
((3, -1, -11),(0.14729546015603492, 2.995212468509636)),
((3, -1, -10),(0.14357004756556263, 3.0216167893148094)),
((3, -1, -9),(0.14096845773434796, 3.0456180330647542)),
((3, -1, -8),(0.13939266837788566, 3.067414981333767)),
((3, -1, -7),(0.13875624727222233, 3.087184995534463)),
((3, -1, -6),(0.1389825444089812, 3.1050869314718037)),
((3, -1, -5),(0.14000323815105772, 3.1212635637298942)),
((3, -1, -4),(0.14175715395945049, 3.1358436185986567)),
((3, -1, -3),(0.14418929539989767, -3.1342418161198586)),
((3, -1, -2),(0.14725004221884844, -3.1225166027977949)),
((3, -1, -1),(0.15089448119175036, -3.1120701489216822)),
((3, -1, 0),(0.15508184344769674, -3.1028151052796193)),
((3, -1, 1),(0.15977502791050344, -3.0946717459458584)),
((3, -1, 2),(0.16494019494845452, -3.0875671634623072)),
((3, -1, 3),(0.17054641769800868, -3.0814345672631926)),
((3, -1, 4),(0.17656538110595318, -3.0762126696701655)),
((3, -1, 5),(0.18297112072388205, -3.071845146536837)),
((3, -1, 6),(0.18973979483545253, -3.068280161826618)),
((3, -1, 7),(0.19684948470849836, -3.0654699471872515)),
((3, -1, 8),(0.20428001871979151, -3.0633704290308454)),
((3, -1, 9),(0.21201281685927884, -3.0619408968095367)),
((3, -1, 10),(0.22003075272715505, -3.061143707147691)),
((3, -1, 11),(0.22831803062482503, -3.0609440192935717)),
((3, -1, 12),(0.23686007573516663, -3.0613095580192962)),
((3, -1, 13),(0.24564343570814631, -3.0622104006532331)),
((3, 0, -12),(0.52279733028861153, -2.9700488241505898)),
((3, 0, -11),(0.50378671228614103, -2.9490914726649691)),
((3, 0, -10),(0.48717975032031569, -2.9306721863852894)),
((3, 0, -9),(0.47271790429607663, -2.9145189723120239)),
((3, 0, -8),(0.4601808666798578, -2.9003998070382897)),
((3, 0, -7),(0.44937927378187081, -2.888115076491232)),
((3, 0, -6),(0.44014910693078774, -2.8774917549515919)),
((3, 0, -5),(0.43234732900094108, -2.8683788586425556)),
((3, 0, -4),(0.42584843936996292, -2.8606438491211024)),
((3, 0, -3),(0.42054172204913881, -2.8541697551127378)),
((3, 0, -2),(0.41632902411062811, -2.8488528451316859)),
((3, 0, -1),(0.41312294481353168, -2.8446007275132965)),
((3, 0, 0),(0.41084534637817421, -2.8413307858073433)),
((3, 0, 1),(0.40942611925926353, -2.8389688799824002)),
((3, 0, 2),(0.40880215069531456, -2.8374482602866999)),
((3, 0, 3),(0.4089164570446342, -2.836708652711867)),
((3, 0, 4),(0.40971744916451736, -2.8366954840432843)),
((3, 0, 5),(0.41115830668209302, -2.8373592213041579)),
((3, 0, 6),(0.41319644202319294, -2.8386548056034386)),
((3, 0, 7),(0.41579303892149883, -2.840541164402612)),
((3, 0, 8),(0.41891265311901671, -2.8429807893255692)),
((3, 0, 9),(0.42252286530423161, -2.8459393690689128)),
((3, 0, 10),(0.42659397817327777, -2.8493854688889004)),
((3, 0, 11),(0.43109875095758526, -2.8532902496648371)),
((3, 0, 12),(0.43601216592582015, -2.8576272207570002)),
((3, 0, 13),(0.44131122230325831, -2.8623720218571087)),
((3, 0, 14),(0.44697475380802854, -2.8675022298226387)),
((3, 1, -12),(0.91586258363679263, -2.5713199552590025)),
((3, 1, -11),(0.88409896977867775, -2.5647861839536024)),
((3, 1, -10),(0.85539765544298452, -2.5597119951350931)),
((3, 1, -9),(0.82947103069703465, -2.5559517863749757)),
((3, 1, -8),(0.80606694178167759, -2.5533798269499957)),
((3, 1, -7),(0.78496315920272786, -2.5518867028459864)),
((3, 1, -6),(0.76596290654798782, -2.5513765471109036)),
((3, 1, -5),(0.74889120800591102, -2.5517648535738062)),
((3, 1, -4),(0.73359187658954905, -2.5529767303349136)),
((3, 1, -3),(0.71992500988459818, -2.5549454892390253)),
((3, 1, -2),(0.70776489215377847, -2.5576114951895619)),
((3, 1, -1),(0.69699822491502572, -2.5609212186807326)),
((3, 1, 0),(0.68752262532289088, -2.5648264489187738)),
((3, 1, 1),(0.67924534458821284, -2.5692836350726918)),
((3, 1, 2),(0.67208216847335345, -2.5742533306794591)),
((3, 1, 3),(0.66595646943071718, -2.5796997218002189)),
((3, 1, 4),(0.66079838579806205, -2.585590223716383)),
((3, 1, 5),(0.65654410804437335, -2.5918951341397434)),
((3, 1, 6),(0.65313525567983921, -2.5985873333533478)),
((3, 1, 7),(0.65051833132587744, -2.6056420235884943)),
((3, 1, 8),(0.64864424075361238, -2.6130365014158148)),
((3, 1, 9),(0.64746786956591751, -2.6207499580846565)),
((3, 1, 10),(0.64694770871489848, -2.6287633036597939)),
((3, 1, 11),(0.64704552228579104, -2.6370590115328798)),
((3, 1, 12),(0.64772605199615707, -2.6456209804699116)),
((3, 1, 13),(0.64895675369968531, -2.654434411826859)),
((3, 1, 14),(0.65070756188100687, -2.6634856999475565)),
((3, 2, -11),(1.1961978486540406, -2.2316281134134708)),
((3, 2, -10),(1.1636580074683704, -2.2363692690664596)),
((3, 2, -9),(1.1334575004081613, -2.2417413704358755)),
((3, 2, -8),(1.1054560679748455, -2.2476979301008799)),
((3, 2, -7),(1.0795220838776829, -2.2541965075234365)),
((3, 2, -6),(1.0555321250422767, -2.2611982495177783)),
((3, 2, -5),(1.0333705427604229, -2.2686675041660198)),
((3, 2, -4),(1.0129290384558152, -2.2765714934454175)),
((3, 2, -3),(0.99410624740954312, -2.2848800331661132)),
((3, 2, -2),(0.97680733337241732, -2.2935652913352871)),
((3, 2, -1),(0.96094359645500826, -2.3026015779803082)),
((3, 2, 0),(0.94643209612890089, -2.3119651609335987)),
((3, 2, 1),(0.93319529064778928, -2.3216341032168457)),
((3, 2, 2),(0.92116069373160625, -2.3315881185435257)),
((3, 2, 3),(0.91026054896067465, -2.341808442146315)),
((3, 2, 4),(0.90043152200061793, -2.3522777146750622)),
((3, 2, 5),(0.89161441051768886, -2.3629798773353881)),
((3, 2, 6),(0.88375387144095185, -2.3739000767731677)),
((3, 2, 7),(0.87679816507456454, -2.3850245784762101)),
((3, 2, 8),(0.87069891545182321, -2.3963406876759135)),
((3, 2, 9),(0.86541088624585827, -2.4078366769009305)),
((3, 2, 10),(0.86089177150270246, -2.4195017194703881)),
((3, 2, 11),(0.85710200043568696, -2.4313258283234545)),
((3, 2, 12),(0.85400455551078269, -2.4432997996705343)),
((3, 2, 13),(0.85156480305646742, -2.4554151610231676)),
((3, 3, -9),(1.3572923469107276, -2.0098024175827787)),
((3, 3, -8),(1.3300405735933236, -2.0192559888277763)),
((3, 3, -7),(1.3043160359368444, -2.0290943602177749)),
((3, 3, -6),(1.2800652800183048, -2.039295134404588)),
((3, 3, -5),(1.2572352032949328, -2.0498369951170781)),
((3, 3, -4),(1.2357732990389303, -2.0606996678378149)),
((3, 3, -3),(1.2156278673829035, -2.0718638843406034)),
((3, 3, -2),(1.1967481947777547, -2.083311349996896)),
((3, 3, -1),(1.1790847040136911, -2.0950247130093822)),
((3, 3, 0),(1.1625890771615464, -2.106987534937196)),
((3, 3, 1),(1.1472143538870681, -2.1191842620460828)),
((3, 3, 2),(1.1329150076012675, -2.1316001971538996)),
((3, 3, 3),(1.1196470018572016, -2.1442214717519446)),
((3, 3, 4),(1.1073678293053832, -2.1570350182697786)),
((3, 3, 5),(1.0960365353907473, -2.1700285424190762)),
((3, 3, 6),(1.0856137288248557, -2.1831904956034802)),
((3, 3, 7),(1.0760615807071654, -2.1965100474196242)),
((3, 3, 8),(1.0673438140048812, -2.2099770583012441)),
((3, 3, 9),(1.0594256849377974, -2.2235820523761971)),
((3, 3, 10),(1.0522739576559463, -2.2373161906166961)),
((3, 3, 11),(1.0458568734466149, -2.2511712443678831)),
((3, 3, 12),(1.0401441155650066, -2.2651395693402563)),
((3, 4, -6),(1.4458808596135624, -1.8809870675241769)),
((3, 4, -5),(1.4245617297356401, -1.8920736112573091)),
((3, 4, -4),(1.4042679040678343, -1.9034705924342512)),
((3, 4, -3),(1.3849765184368814, -1.9151631508453824)),
((3, 4, -2),(1.3666641168442639, -1.9271368387370071)),
((3, 4, -1),(1.3493067901837548, -1.9393776344783686)),
((3, 4, 0),(1.3328803064785337, -1.9518719551449641)),
((3, 4, 1),(1.3173602321252111, -1.9646066677443677)),
((3, 4, 2),(1.3027220438430454, -1.977569098881037)),
((3, 4, 3),(1.2889412312086344, -1.9907470427197642)),
((3, 4, 4),(1.2759933898109437, -2.0041287671636656)),
((3, 4, 5),(1.2638543051901536, -2.0177030182116305)),
((3, 4, 6),(1.2525000278287912, -2.0314590225024669)),
((3, 4, 7),(1.2419069395467706, -2.0453864880884902)),
((3, 4, 8),(1.2320518117157988, -2.0594756035105957)),
((3, 4, 9),(1.2229118557552929, -2.0737170352703265)),
((4, -2, 0),(0.06435859892784096, 3.0443088136350811)),
((4, -2, 1),(0.069042890592901043, 3.0524035363266298)),
((4, -2, 2),(0.074072595708772337, 3.0597615857577272)),
((4, -2, 3),(0.079431735433792561, 3.0664157305617699)),
((4, -1, -5),(0.23214887298103432, -3.1010146175414635)),
((4, -1, -4),(0.23143484763517025, -3.090957021010337)),
((4, -1, -3),(0.23132759790313087, -3.081859612363484)),
((4, -1, -2),(0.23179261661909864, -3.0736685489128961)),
((4, -1, -1),(0.2327980404221634, -3.0663339923683695)),
((4, -1, 0),(0.2343143850660469, -3.059809728719872)),
((4, -1, 1),(0.23631431572954079, -3.0540528344463307)),
((4, -1, 2),(0.23877244672730308, -3.0490233822026864)),
((4, -1, 3),(0.24166516604466937, -3.044684180311906)),
((4, -1, 4),(0.24497048093657392, -3.0410005413363241)),
((4, -1, 5),(0.24866788148554173, -3.037940075771846)),
((4, -1, 6),(0.25273821954206654, -3.0354725075366011)),
((4, -1, 7),(0.25716360089942614, -3.0335695084414116)),
((4, -1, 8),(0.26192728890449551, -3.0322045492551091)),
((4, 0, -6),(0.45430073538635213, -2.8897052382378461)),
((4, 0, -5),(0.44809789790081089, -2.8825952475437364)),
((4, 0, -4),(0.44277932757291577, -2.8764073606365148)),
((4, 0, -3),(0.43828948430987963, -2.8710837188878853)),
((4, 0, -2),(0.4345775891796565, -2.8665714104468711)),
((4, 0, -1),(0.43159709105068261, -2.8628219186712305)),
((4, 0, 0),(0.42930520951634238, -2.8597906489455118)),
((4, 0, 1),(0.42766254108235296, -2.8574365205862362)),
((4, 0, 2),(0.42663271813658615, -2.8557216131171788)),
((4, 0, 3),(0.42618211220895647, -2.8546108582202323)),
((4, 0, 4),(0.42627957459646199, -2.8540717702636944)),
((4, 0, 5),(0.42689620867311634, -2.8540742095787799)),
((4, 0, 6),(0.42800516919960535, -2.8545901736708101)),
((4, 0, 7),(0.42958148474803215, -2.855593612369475)),
((4, 0, 8),(0.4316019000047856, -2.8570602635850313)),
((4, 0, 9),(0.4340447352418475, -2.8589675068771965)),
((4, 1, -6),(0.68921781929304227, -2.6546005869019829)),
((4, 1, -5),(0.6779981107193358, -2.6524487848552258)),
((4, 1, -4),(0.66786415758568451, -2.6510112738753087)),
((4, 1, -3),(0.65874977954049951, -2.6502439313189949)),
((4, 1, -2),(0.65059418041471451, -2.6501063300260363)),
((4, 1, -1),(0.64334138507819771, -2.6505613314917835)),
((4, 1, 0),(0.63693975122749091, -2.65157473717584)),
((4, 1, 1),(0.63134154410860788, -2.6531149879861431)),
((4, 1, 2),(0.62650256439701135, -2.6551529039238644)),
((4, 1, 3),(0.62238182121355845, -2.6576614573982957)),
((4, 1, 4),(0.61894124365664538, -2.6606155749229123)),
((4, 1, 5),(0.61614542535674921, -2.6639919628586042)),
((4, 1, 6),(0.61396139747009182, -2.6677689536334253)),
((4, 1, 7),(0.6123584262688061, -2.6719263694820574)),
((4, 1, 8),(0.61130783209111506, -2.6764454012448593)),
((4, 1, 9),(0.61078282691335861, -2.6813085001699886)),
((4, 2, -5),(0.89899741791597043, -2.4333929198623783)),
((4, 2, -4),(0.88519063811520515, -2.4362499979642398)),
((4, 2, -3),(0.87246175953565352, -2.4395869092123692)),
((4, 2, -2),(0.86075496086636039, -2.4433774957677983)),
((4, 2, -1),(0.85001803369297546, -2.4475974239506573)),
((4, 2, 0),(0.84020209899593201, -2.4522240208008492)),
((4, 2, 1),(0.83126135219031361, -2.4572361310586777)),
((4, 2, 2),(0.82315283308187859, -2.4626139913786744)),
((4, 2, 3),(0.81583621767417269, -2.4683391191581023)),
((4, 2, 4),(0.80927362922073443, -2.4743942138188002)),
((4, 2, 5),(0.80342946629516132, -2.4807630687509814)),
((4, 2, 6),(0.79827024596631457, -2.4874304924282127)),
((4, 2, 7),(0.79376446042863036, -2.4943822374482973)),
((4, 2, 8),(0.78988244565811649, -2.5016049364559581)),
((4, 3, -2),(1.0495709901069983, -2.2617934276511251)),
((4, 3, -1),(1.0367514684809902, -2.2686055885353134)),
((4, 3, 0),(1.0248151233210518, -2.275730389729115)),
((4, 3, 1),(1.0137262178032664, -2.283153293384157)),
((4, 3, 2),(1.0034506053972199, -2.290860524496253)),
((4, 3, 3),(0.99395566533994972, -2.2988390286634686)),
((4, 3, 4),(0.98521024056932294, -2.3070764336942742)),
((4, 3, 5),(0.97718457798292291, -2.3155610145222152)),
]

def test_ewald_sphere_model():
  # direct space orientation matrix
  orientation = (24.67303504408280, -8.27539755075503, 12.97853642392082,
        -13.21765114237159, -0.18925842832666, 35.37258184706041,
         39.24485466996793, 107.21509370974169, 20.28943160079353)
  limiting_resolution = 6.429576016992
  wavelength = 0.979454000
  axial_direction = (0,1,0)

  # rotation_angles object must be instantiated with reciprocal-space orientation matrix
  CO = crystal_orientation(orientation,basis_type.direct)
  MM = CO.unit_cell().max_miller_indices(limiting_resolution)
  RA = rotation_angles(limiting_resolution,CO.reciprocal_matrix(),wavelength,axial_direction)

  maxh = MM[0];
  maxk = MM[1];
  maxl = MM[2];

  ptr=0
  for h in range(-maxh, maxh+1):
    for k in range(-maxk, maxk+1):
      for l in range(-maxl, maxl+1):
        if RA((h,k,l)):
          assert test_results[ptr][0]==(h,k,l)
          assert approx_equal(
            test_results[ptr][1],RA.get_intersection_angles(),eps = 1.E-10, multiplier=1.e-10)
          ptr+=1
          #print "(%s,%s),"%(str((h,k,l)),RA.get_intersection_angles())
  assert(ptr == len(test_results))

if __name__=="__main__":

  test_ewald_sphere_model()
  print("OK")
