// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/products/v1beta/products_common.proto

package productspb

import (
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The subscription period of the product.
type SubscriptionPeriod int32

const (
	// Indicates that the subscription period is unspecified.
	SubscriptionPeriod_SUBSCRIPTION_PERIOD_UNSPECIFIED SubscriptionPeriod = 0
	// Indicates that the subscription period is month.
	SubscriptionPeriod_MONTH SubscriptionPeriod = 1
	// Indicates that the subscription period is year.
	SubscriptionPeriod_YEAR SubscriptionPeriod = 2
)

// Enum value maps for SubscriptionPeriod.
var (
	SubscriptionPeriod_name = map[int32]string{
		0: "SUBSCRIPTION_PERIOD_UNSPECIFIED",
		1: "MONTH",
		2: "YEAR",
	}
	SubscriptionPeriod_value = map[string]int32{
		"SUBSCRIPTION_PERIOD_UNSPECIFIED": 0,
		"MONTH":                           1,
		"YEAR":                            2,
	}
)

func (x SubscriptionPeriod) Enum() *SubscriptionPeriod {
	p := new(SubscriptionPeriod)
	*p = x
	return p
}

func (x SubscriptionPeriod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionPeriod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_enumTypes[0].Descriptor()
}

func (SubscriptionPeriod) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_products_v1beta_products_common_proto_enumTypes[0]
}

func (x SubscriptionPeriod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionPeriod.Descriptor instead.
func (SubscriptionPeriod) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{0}
}

// How the issue affects the serving of the product.
type ProductStatus_ItemLevelIssue_Severity int32

const (
	// Not specified.
	ProductStatus_ItemLevelIssue_SEVERITY_UNSPECIFIED ProductStatus_ItemLevelIssue_Severity = 0
	// This issue represents a warning and does not have a direct affect
	// on the product.
	ProductStatus_ItemLevelIssue_NOT_IMPACTED ProductStatus_ItemLevelIssue_Severity = 1
	// The product is demoted and most likely have limited performance
	// in search results
	ProductStatus_ItemLevelIssue_DEMOTED ProductStatus_ItemLevelIssue_Severity = 2
	// Issue disapproves the product.
	ProductStatus_ItemLevelIssue_DISAPPROVED ProductStatus_ItemLevelIssue_Severity = 3
)

// Enum value maps for ProductStatus_ItemLevelIssue_Severity.
var (
	ProductStatus_ItemLevelIssue_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "NOT_IMPACTED",
		2: "DEMOTED",
		3: "DISAPPROVED",
	}
	ProductStatus_ItemLevelIssue_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"NOT_IMPACTED":         1,
		"DEMOTED":              2,
		"DISAPPROVED":          3,
	}
)

func (x ProductStatus_ItemLevelIssue_Severity) Enum() *ProductStatus_ItemLevelIssue_Severity {
	p := new(ProductStatus_ItemLevelIssue_Severity)
	*p = x
	return p
}

func (x ProductStatus_ItemLevelIssue_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductStatus_ItemLevelIssue_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_enumTypes[1].Descriptor()
}

func (ProductStatus_ItemLevelIssue_Severity) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_products_v1beta_products_common_proto_enumTypes[1]
}

func (x ProductStatus_ItemLevelIssue_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductStatus_ItemLevelIssue_Severity.Descriptor instead.
func (ProductStatus_ItemLevelIssue_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{18, 1, 0}
}

// Attributes.
type Attributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set this value to false when the item does not have unique product
	// identifiers appropriate to its category, such as GTIN, MPN, and brand.
	// Defaults to true, if not provided.
	IdentifierExists *bool `protobuf:"varint,4,opt,name=identifier_exists,json=identifierExists,proto3,oneof" json:"identifier_exists,omitempty"`
	// Whether the item is a merchant-defined bundle. A bundle is a custom
	// grouping of different products sold by a merchant for a single price.
	IsBundle *bool `protobuf:"varint,5,opt,name=is_bundle,json=isBundle,proto3,oneof" json:"is_bundle,omitempty"`
	// Title of the item.
	Title *string `protobuf:"bytes,6,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Description of the item.
	Description *string `protobuf:"bytes,7,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// URL directly linking to your item's page on your online store.
	Link *string `protobuf:"bytes,8,opt,name=link,proto3,oneof" json:"link,omitempty"`
	// URL for the mobile-optimized version of your item's landing page.
	MobileLink *string `protobuf:"bytes,9,opt,name=mobile_link,json=mobileLink,proto3,oneof" json:"mobile_link,omitempty"`
	// URL for the canonical version of your item's landing page.
	CanonicalLink *string `protobuf:"bytes,10,opt,name=canonical_link,json=canonicalLink,proto3,oneof" json:"canonical_link,omitempty"`
	// URL of an image of the item.
	ImageLink *string `protobuf:"bytes,11,opt,name=image_link,json=imageLink,proto3,oneof" json:"image_link,omitempty"`
	// Additional URLs of images of the item.
	AdditionalImageLinks []string `protobuf:"bytes,12,rep,name=additional_image_links,json=additionalImageLinks,proto3" json:"additional_image_links,omitempty"`
	// Date on which the item should expire, as specified upon insertion, in
	// [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
	// expiration date is exposed in `productstatuses` as
	// [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
	// and might be earlier if `expirationDate` is too far in the future.
	ExpirationDate *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=expiration_date,json=expirationDate,proto3" json:"expiration_date,omitempty"`
	// The date time when an offer becomes visible in search results across
	// Google’s YouTube surfaces, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format. See [Disclosure date](
	// https://support.google.com/merchants/answer/13034208) for more information.
	DisclosureDate *timestamppb.Timestamp `protobuf:"bytes,79,opt,name=disclosure_date,json=disclosureDate,proto3" json:"disclosure_date,omitempty"`
	// Set to true if the item is targeted towards adults.
	Adult *bool `protobuf:"varint,17,opt,name=adult,proto3,oneof" json:"adult,omitempty"`
	// Target [age group](https://support.google.com/merchants/answer/6324463) of
	// the item.
	AgeGroup *string `protobuf:"bytes,18,opt,name=age_group,json=ageGroup,proto3,oneof" json:"age_group,omitempty"`
	// Availability status of the item.
	Availability *string `protobuf:"bytes,19,opt,name=availability,proto3,oneof" json:"availability,omitempty"`
	// The day a pre-ordered product becomes available for delivery, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	AvailabilityDate *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=availability_date,json=availabilityDate,proto3" json:"availability_date,omitempty"`
	// Brand of the item.
	Brand *string `protobuf:"bytes,21,opt,name=brand,proto3,oneof" json:"brand,omitempty"`
	// Color of the item.
	Color *string `protobuf:"bytes,22,opt,name=color,proto3,oneof" json:"color,omitempty"`
	// Condition or state of the item.
	Condition *string `protobuf:"bytes,23,opt,name=condition,proto3,oneof" json:"condition,omitempty"`
	// Target gender of the item.
	Gender *string `protobuf:"bytes,24,opt,name=gender,proto3,oneof" json:"gender,omitempty"`
	// Google's category of the item (see [Google product
	// taxonomy](https://support.google.com/merchants/answer/1705911)). When
	// querying products, this field will contain the user provided value. There
	// is currently no way to get back the auto assigned google product
	// categories through the API.
	GoogleProductCategory *string `protobuf:"bytes,25,opt,name=google_product_category,json=googleProductCategory,proto3,oneof" json:"google_product_category,omitempty"`
	// Global Trade Item Number
	// ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
	// item.
	Gtin *string `protobuf:"bytes,26,opt,name=gtin,proto3,oneof" json:"gtin,omitempty"`
	// Shared identifier for all variants of the same product.
	ItemGroupId *string `protobuf:"bytes,27,opt,name=item_group_id,json=itemGroupId,proto3,oneof" json:"item_group_id,omitempty"`
	// The material of which the item is made.
	Material *string `protobuf:"bytes,28,opt,name=material,proto3,oneof" json:"material,omitempty"`
	// Manufacturer Part Number
	// ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
	// item.
	Mpn *string `protobuf:"bytes,29,opt,name=mpn,proto3,oneof" json:"mpn,omitempty"`
	// The item's pattern (for example, polka dots).
	Pattern *string `protobuf:"bytes,30,opt,name=pattern,proto3,oneof" json:"pattern,omitempty"`
	// Price of the item.
	Price *typepb.Price `protobuf:"bytes,31,opt,name=price,proto3" json:"price,omitempty"`
	// Number and amount of installments to pay for an item.
	Installment *Installment `protobuf:"bytes,32,opt,name=installment,proto3" json:"installment,omitempty"`
	// Number of periods (months or years) and amount of payment per period
	// for an item with an associated subscription contract.
	SubscriptionCost *SubscriptionCost `protobuf:"bytes,33,opt,name=subscription_cost,json=subscriptionCost,proto3" json:"subscription_cost,omitempty"`
	// Loyalty points that users receive after purchasing the item. Japan only.
	LoyaltyPoints *LoyaltyPoints `protobuf:"bytes,34,opt,name=loyalty_points,json=loyaltyPoints,proto3" json:"loyalty_points,omitempty"`
	// A list of loyalty program information that is used to surface loyalty
	// benefits (for example, better pricing, points, etc) to the user of this
	// item.
	LoyaltyPrograms []*LoyaltyProgram `protobuf:"bytes,136,rep,name=loyalty_programs,json=loyaltyPrograms,proto3" json:"loyalty_programs,omitempty"`
	// Categories of the item (formatted as in [product data
	// specification](https://support.google.com/merchants/answer/188494#product_type)).
	ProductTypes []string `protobuf:"bytes,35,rep,name=product_types,json=productTypes,proto3" json:"product_types,omitempty"`
	// Advertised sale price of the item.
	SalePrice *typepb.Price `protobuf:"bytes,36,opt,name=sale_price,json=salePrice,proto3" json:"sale_price,omitempty"`
	// Date range during which the item is on sale (see [product data
	// specification](https://support.google.com/merchants/answer/188494#sale_price_effective_date)).
	SalePriceEffectiveDate *interval.Interval `protobuf:"bytes,37,opt,name=sale_price_effective_date,json=salePriceEffectiveDate,proto3" json:"sale_price_effective_date,omitempty"`
	// The quantity of the product that is available for selling on Google.
	// Supported only for online products.
	SellOnGoogleQuantity *int64 `protobuf:"varint,38,opt,name=sell_on_google_quantity,json=sellOnGoogleQuantity,proto3,oneof" json:"sell_on_google_quantity,omitempty"`
	// The height of the product in the units provided. The value must be
	// between
	// 0 (exclusive) and 3000 (inclusive).
	ProductHeight *ProductDimension `protobuf:"bytes,119,opt,name=product_height,json=productHeight,proto3" json:"product_height,omitempty"`
	// The length of the product in the units provided. The value must be
	// between 0 (exclusive) and 3000 (inclusive).
	ProductLength *ProductDimension `protobuf:"bytes,120,opt,name=product_length,json=productLength,proto3" json:"product_length,omitempty"`
	// The width of the product in the units provided. The value must be between
	// 0 (exclusive) and 3000 (inclusive).
	ProductWidth *ProductDimension `protobuf:"bytes,121,opt,name=product_width,json=productWidth,proto3" json:"product_width,omitempty"`
	// The weight of the product in the units provided. The value must be
	// between 0 (exclusive) and 2000 (inclusive).
	ProductWeight *ProductWeight `protobuf:"bytes,122,opt,name=product_weight,json=productWeight,proto3" json:"product_weight,omitempty"`
	// Shipping rules.
	Shipping []*Shipping `protobuf:"bytes,39,rep,name=shipping,proto3" json:"shipping,omitempty"`
	// Conditions to be met for a product to have free shipping.
	FreeShippingThreshold []*FreeShippingThreshold `protobuf:"bytes,135,rep,name=free_shipping_threshold,json=freeShippingThreshold,proto3" json:"free_shipping_threshold,omitempty"`
	// Weight of the item for shipping.
	ShippingWeight *ShippingWeight `protobuf:"bytes,40,opt,name=shipping_weight,json=shippingWeight,proto3" json:"shipping_weight,omitempty"`
	// Length of the item for shipping.
	ShippingLength *ShippingDimension `protobuf:"bytes,41,opt,name=shipping_length,json=shippingLength,proto3" json:"shipping_length,omitempty"`
	// Width of the item for shipping.
	ShippingWidth *ShippingDimension `protobuf:"bytes,42,opt,name=shipping_width,json=shippingWidth,proto3" json:"shipping_width,omitempty"`
	// Height of the item for shipping.
	ShippingHeight *ShippingDimension `protobuf:"bytes,43,opt,name=shipping_height,json=shippingHeight,proto3" json:"shipping_height,omitempty"`
	// Maximal product handling time (in business days).
	MaxHandlingTime *int64 `protobuf:"varint,44,opt,name=max_handling_time,json=maxHandlingTime,proto3,oneof" json:"max_handling_time,omitempty"`
	// Minimal product handling time (in business days).
	MinHandlingTime *int64 `protobuf:"varint,45,opt,name=min_handling_time,json=minHandlingTime,proto3,oneof" json:"min_handling_time,omitempty"`
	// The shipping label of the product, used to group product in account-level
	// shipping rules.
	ShippingLabel *string `protobuf:"bytes,46,opt,name=shipping_label,json=shippingLabel,proto3,oneof" json:"shipping_label,omitempty"`
	// The transit time label of the product, used to group product in
	// account-level transit time tables.
	TransitTimeLabel *string `protobuf:"bytes,47,opt,name=transit_time_label,json=transitTimeLabel,proto3,oneof" json:"transit_time_label,omitempty"`
	// Size of the item. Only one value is allowed. For variants with different
	// sizes, insert a separate product for each size with the same
	// `itemGroupId` value (see
	// [https://support.google.com/merchants/answer/6324492](size definition)).
	Size *string `protobuf:"bytes,48,opt,name=size,proto3,oneof" json:"size,omitempty"`
	// System in which the size is specified. Recommended for apparel items.
	SizeSystem *string `protobuf:"bytes,49,opt,name=size_system,json=sizeSystem,proto3,oneof" json:"size_system,omitempty"`
	// The cut of the item. It can be used to represent combined size types for
	// apparel items. Maximum two of size types can be provided (see
	// [https://support.google.com/merchants/answer/6324497](size type)).
	SizeTypes []string `protobuf:"bytes,50,rep,name=size_types,json=sizeTypes,proto3" json:"size_types,omitempty"`
	// Tax information.
	Taxes []*Tax `protobuf:"bytes,51,rep,name=taxes,proto3" json:"taxes,omitempty"`
	// The tax category of the product, used to configure detailed tax nexus
	// in account-level tax settings.
	TaxCategory *string `protobuf:"bytes,52,opt,name=tax_category,json=taxCategory,proto3,oneof" json:"tax_category,omitempty"`
	// The energy efficiency class as defined in EU directive 2010/30/EU.
	EnergyEfficiencyClass *string `protobuf:"bytes,53,opt,name=energy_efficiency_class,json=energyEfficiencyClass,proto3,oneof" json:"energy_efficiency_class,omitempty"`
	// The energy efficiency class as defined in EU directive 2010/30/EU.
	MinEnergyEfficiencyClass *string `protobuf:"bytes,54,opt,name=min_energy_efficiency_class,json=minEnergyEfficiencyClass,proto3,oneof" json:"min_energy_efficiency_class,omitempty"`
	// The energy efficiency class as defined in EU directive 2010/30/EU.
	MaxEnergyEfficiencyClass *string `protobuf:"bytes,55,opt,name=max_energy_efficiency_class,json=maxEnergyEfficiencyClass,proto3,oneof" json:"max_energy_efficiency_class,omitempty"`
	// The measure and dimension of an item.
	UnitPricingMeasure *UnitPricingMeasure `protobuf:"bytes,56,opt,name=unit_pricing_measure,json=unitPricingMeasure,proto3" json:"unit_pricing_measure,omitempty"`
	// The preference of the denominator of the unit price.
	UnitPricingBaseMeasure *UnitPricingBaseMeasure `protobuf:"bytes,57,opt,name=unit_pricing_base_measure,json=unitPricingBaseMeasure,proto3" json:"unit_pricing_base_measure,omitempty"`
	// The number of identical products in a merchant-defined multipack.
	Multipack *int64 `protobuf:"varint,58,opt,name=multipack,proto3,oneof" json:"multipack,omitempty"`
	// Used to group items in an arbitrary way. Only for CPA%, discouraged
	// otherwise.
	AdsGrouping *string `protobuf:"bytes,59,opt,name=ads_grouping,json=adsGrouping,proto3,oneof" json:"ads_grouping,omitempty"`
	// Similar to ads_grouping, but only works on CPC.
	AdsLabels []string `protobuf:"bytes,60,rep,name=ads_labels,json=adsLabels,proto3" json:"ads_labels,omitempty"`
	// Allows advertisers to override the item URL when the product is shown
	// within the context of Product ads.
	AdsRedirect *string `protobuf:"bytes,61,opt,name=ads_redirect,json=adsRedirect,proto3,oneof" json:"ads_redirect,omitempty"`
	// Cost of goods sold. Used for gross profit reporting.
	CostOfGoodsSold *typepb.Price `protobuf:"bytes,62,opt,name=cost_of_goods_sold,json=costOfGoodsSold,proto3" json:"cost_of_goods_sold,omitempty"`
	// Technical specification or additional product details.
	ProductDetails []*ProductDetail `protobuf:"bytes,63,rep,name=product_details,json=productDetails,proto3" json:"product_details,omitempty"`
	// Bullet points describing the most relevant highlights of a product.
	ProductHighlights []string `protobuf:"bytes,64,rep,name=product_highlights,json=productHighlights,proto3" json:"product_highlights,omitempty"`
	// An identifier for an item for dynamic remarketing campaigns.
	DisplayAdsId *string `protobuf:"bytes,65,opt,name=display_ads_id,json=displayAdsId,proto3,oneof" json:"display_ads_id,omitempty"`
	// Advertiser-specified recommendations.
	DisplayAdsSimilarIds []string `protobuf:"bytes,66,rep,name=display_ads_similar_ids,json=displayAdsSimilarIds,proto3" json:"display_ads_similar_ids,omitempty"`
	// Title of an item for dynamic remarketing campaigns.
	DisplayAdsTitle *string `protobuf:"bytes,67,opt,name=display_ads_title,json=displayAdsTitle,proto3,oneof" json:"display_ads_title,omitempty"`
	// URL directly to your item's landing page for dynamic remarketing
	// campaigns.
	DisplayAdsLink *string `protobuf:"bytes,68,opt,name=display_ads_link,json=displayAdsLink,proto3,oneof" json:"display_ads_link,omitempty"`
	// Offer margin for dynamic remarketing campaigns.
	DisplayAdsValue *float64 `protobuf:"fixed64,69,opt,name=display_ads_value,json=displayAdsValue,proto3,oneof" json:"display_ads_value,omitempty"`
	// The unique ID of a promotion.
	PromotionIds []string `protobuf:"bytes,70,rep,name=promotion_ids,json=promotionIds,proto3" json:"promotion_ids,omitempty"`
	// The pick up option for the item.
	PickupMethod *string `protobuf:"bytes,80,opt,name=pickup_method,json=pickupMethod,proto3,oneof" json:"pickup_method,omitempty"`
	// Item store pickup timeline.
	PickupSla *string `protobuf:"bytes,81,opt,name=pickup_sla,json=pickupSla,proto3,oneof" json:"pickup_sla,omitempty"`
	// Link template for merchant hosted local storefront.
	LinkTemplate *string `protobuf:"bytes,82,opt,name=link_template,json=linkTemplate,proto3,oneof" json:"link_template,omitempty"`
	// Link template for merchant hosted local storefront optimized for mobile
	// devices.
	MobileLinkTemplate *string `protobuf:"bytes,83,opt,name=mobile_link_template,json=mobileLinkTemplate,proto3,oneof" json:"mobile_link_template,omitempty"`
	// Custom label 0 for custom grouping of items in a Shopping campaign.
	CustomLabel_0 *string `protobuf:"bytes,71,opt,name=custom_label_0,json=customLabel0,proto3,oneof" json:"custom_label_0,omitempty"`
	// Custom label 1 for custom grouping of items in a Shopping campaign.
	CustomLabel_1 *string `protobuf:"bytes,72,opt,name=custom_label_1,json=customLabel1,proto3,oneof" json:"custom_label_1,omitempty"`
	// Custom label 2 for custom grouping of items in a Shopping campaign.
	CustomLabel_2 *string `protobuf:"bytes,73,opt,name=custom_label_2,json=customLabel2,proto3,oneof" json:"custom_label_2,omitempty"`
	// Custom label 3 for custom grouping of items in a Shopping campaign.
	CustomLabel_3 *string `protobuf:"bytes,74,opt,name=custom_label_3,json=customLabel3,proto3,oneof" json:"custom_label_3,omitempty"`
	// Custom label 4 for custom grouping of items in a Shopping campaign.
	CustomLabel_4 *string `protobuf:"bytes,75,opt,name=custom_label_4,json=customLabel4,proto3,oneof" json:"custom_label_4,omitempty"`
	// The list of destinations to include for this target (corresponds to
	// checked check boxes in Merchant Center). Default destinations are always
	// included unless provided in `excludedDestinations`.
	IncludedDestinations []string `protobuf:"bytes,76,rep,name=included_destinations,json=includedDestinations,proto3" json:"included_destinations,omitempty"`
	// The list of destinations to exclude for this target (corresponds to
	// unchecked check boxes in Merchant Center).
	ExcludedDestinations []string `protobuf:"bytes,77,rep,name=excluded_destinations,json=excludedDestinations,proto3" json:"excluded_destinations,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) to exclude the offer from
	// Shopping Ads destination.
	// Countries from this list are removed from countries configured
	// in data source settings.
	ShoppingAdsExcludedCountries []string `protobuf:"bytes,78,rep,name=shopping_ads_excluded_countries,json=shoppingAdsExcludedCountries,proto3" json:"shopping_ads_excluded_countries,omitempty"`
	// Required for multi-seller accounts. Use this attribute if you're a
	// marketplace uploading products for various sellers to your multi-seller
	// account.
	ExternalSellerId *string `protobuf:"bytes,1,opt,name=external_seller_id,json=externalSellerId,proto3,oneof" json:"external_seller_id,omitempty"`
	// Publication of this item will be temporarily
	// [paused](https://support.google.com/merchants/answer/11909930).
	Pause *string `protobuf:"bytes,13,opt,name=pause,proto3,oneof" json:"pause,omitempty"`
	// Additional URLs of lifestyle images of the item, used to explicitly
	// identify images that showcase your item in a real-world context. See the
	// [Help Center article](https://support.google.com/merchants/answer/9103186)
	// for more information.
	LifestyleImageLinks []string `protobuf:"bytes,14,rep,name=lifestyle_image_links,json=lifestyleImageLinks,proto3" json:"lifestyle_image_links,omitempty"`
	// Extra fields to export to the Cloud Retail program.
	CloudExportAdditionalProperties []*CloudExportAdditionalProperties `protobuf:"bytes,84,rep,name=cloud_export_additional_properties,json=cloudExportAdditionalProperties,proto3" json:"cloud_export_additional_properties,omitempty"`
	// URL of the 3D image of the item. See the
	// [Help Center article](https://support.google.com/merchants/answer/13674896)
	// for more information.
	VirtualModelLink *string `protobuf:"bytes,130,opt,name=virtual_model_link,json=virtualModelLink,proto3,oneof" json:"virtual_model_link,omitempty"`
	// Product Certifications, for example for energy efficiency labeling of
	// products recorded in the [EU EPREL](https://eprel.ec.europa.eu/screen/home)
	// database. See the [Help
	// Center](https://support.google.com/merchants/answer/13528839)
	// article for more information.
	Certifications []*Certification `protobuf:"bytes,123,rep,name=certifications,proto3" json:"certifications,omitempty"`
	// Structured title, for algorithmically (AI)-generated titles.
	StructuredTitle *ProductStructuredTitle `protobuf:"bytes,132,opt,name=structured_title,json=structuredTitle,proto3,oneof" json:"structured_title,omitempty"`
	// Structured description, for algorithmically (AI)-generated descriptions.
	StructuredDescription *ProductStructuredDescription `protobuf:"bytes,133,opt,name=structured_description,json=structuredDescription,proto3,oneof" json:"structured_description,omitempty"`
	// A safeguard in the "Automated Discounts"
	// (https://support.google.com/merchants/answer/10295759) and
	// "Dynamic Promotions"
	// (https://support.google.com/merchants/answer/13949249) projects,
	// ensuring that discounts on merchants' offers do not fall below this value,
	// thereby preserving the offer's value and profitability.
	AutoPricingMinPrice *typepb.Price `protobuf:"bytes,124,opt,name=auto_pricing_min_price,json=autoPricingMinPrice,proto3" json:"auto_pricing_min_price,omitempty"`
}

func (x *Attributes) Reset() {
	*x = Attributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attributes) ProtoMessage() {}

func (x *Attributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attributes.ProtoReflect.Descriptor instead.
func (*Attributes) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{0}
}

func (x *Attributes) GetIdentifierExists() bool {
	if x != nil && x.IdentifierExists != nil {
		return *x.IdentifierExists
	}
	return false
}

func (x *Attributes) GetIsBundle() bool {
	if x != nil && x.IsBundle != nil {
		return *x.IsBundle
	}
	return false
}

func (x *Attributes) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *Attributes) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Attributes) GetLink() string {
	if x != nil && x.Link != nil {
		return *x.Link
	}
	return ""
}

func (x *Attributes) GetMobileLink() string {
	if x != nil && x.MobileLink != nil {
		return *x.MobileLink
	}
	return ""
}

func (x *Attributes) GetCanonicalLink() string {
	if x != nil && x.CanonicalLink != nil {
		return *x.CanonicalLink
	}
	return ""
}

func (x *Attributes) GetImageLink() string {
	if x != nil && x.ImageLink != nil {
		return *x.ImageLink
	}
	return ""
}

func (x *Attributes) GetAdditionalImageLinks() []string {
	if x != nil {
		return x.AdditionalImageLinks
	}
	return nil
}

func (x *Attributes) GetExpirationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationDate
	}
	return nil
}

func (x *Attributes) GetDisclosureDate() *timestamppb.Timestamp {
	if x != nil {
		return x.DisclosureDate
	}
	return nil
}

func (x *Attributes) GetAdult() bool {
	if x != nil && x.Adult != nil {
		return *x.Adult
	}
	return false
}

func (x *Attributes) GetAgeGroup() string {
	if x != nil && x.AgeGroup != nil {
		return *x.AgeGroup
	}
	return ""
}

func (x *Attributes) GetAvailability() string {
	if x != nil && x.Availability != nil {
		return *x.Availability
	}
	return ""
}

func (x *Attributes) GetAvailabilityDate() *timestamppb.Timestamp {
	if x != nil {
		return x.AvailabilityDate
	}
	return nil
}

func (x *Attributes) GetBrand() string {
	if x != nil && x.Brand != nil {
		return *x.Brand
	}
	return ""
}

func (x *Attributes) GetColor() string {
	if x != nil && x.Color != nil {
		return *x.Color
	}
	return ""
}

func (x *Attributes) GetCondition() string {
	if x != nil && x.Condition != nil {
		return *x.Condition
	}
	return ""
}

func (x *Attributes) GetGender() string {
	if x != nil && x.Gender != nil {
		return *x.Gender
	}
	return ""
}

func (x *Attributes) GetGoogleProductCategory() string {
	if x != nil && x.GoogleProductCategory != nil {
		return *x.GoogleProductCategory
	}
	return ""
}

func (x *Attributes) GetGtin() string {
	if x != nil && x.Gtin != nil {
		return *x.Gtin
	}
	return ""
}

func (x *Attributes) GetItemGroupId() string {
	if x != nil && x.ItemGroupId != nil {
		return *x.ItemGroupId
	}
	return ""
}

func (x *Attributes) GetMaterial() string {
	if x != nil && x.Material != nil {
		return *x.Material
	}
	return ""
}

func (x *Attributes) GetMpn() string {
	if x != nil && x.Mpn != nil {
		return *x.Mpn
	}
	return ""
}

func (x *Attributes) GetPattern() string {
	if x != nil && x.Pattern != nil {
		return *x.Pattern
	}
	return ""
}

func (x *Attributes) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *Attributes) GetInstallment() *Installment {
	if x != nil {
		return x.Installment
	}
	return nil
}

func (x *Attributes) GetSubscriptionCost() *SubscriptionCost {
	if x != nil {
		return x.SubscriptionCost
	}
	return nil
}

func (x *Attributes) GetLoyaltyPoints() *LoyaltyPoints {
	if x != nil {
		return x.LoyaltyPoints
	}
	return nil
}

func (x *Attributes) GetLoyaltyPrograms() []*LoyaltyProgram {
	if x != nil {
		return x.LoyaltyPrograms
	}
	return nil
}

func (x *Attributes) GetProductTypes() []string {
	if x != nil {
		return x.ProductTypes
	}
	return nil
}

func (x *Attributes) GetSalePrice() *typepb.Price {
	if x != nil {
		return x.SalePrice
	}
	return nil
}

func (x *Attributes) GetSalePriceEffectiveDate() *interval.Interval {
	if x != nil {
		return x.SalePriceEffectiveDate
	}
	return nil
}

func (x *Attributes) GetSellOnGoogleQuantity() int64 {
	if x != nil && x.SellOnGoogleQuantity != nil {
		return *x.SellOnGoogleQuantity
	}
	return 0
}

func (x *Attributes) GetProductHeight() *ProductDimension {
	if x != nil {
		return x.ProductHeight
	}
	return nil
}

func (x *Attributes) GetProductLength() *ProductDimension {
	if x != nil {
		return x.ProductLength
	}
	return nil
}

func (x *Attributes) GetProductWidth() *ProductDimension {
	if x != nil {
		return x.ProductWidth
	}
	return nil
}

func (x *Attributes) GetProductWeight() *ProductWeight {
	if x != nil {
		return x.ProductWeight
	}
	return nil
}

func (x *Attributes) GetShipping() []*Shipping {
	if x != nil {
		return x.Shipping
	}
	return nil
}

func (x *Attributes) GetFreeShippingThreshold() []*FreeShippingThreshold {
	if x != nil {
		return x.FreeShippingThreshold
	}
	return nil
}

func (x *Attributes) GetShippingWeight() *ShippingWeight {
	if x != nil {
		return x.ShippingWeight
	}
	return nil
}

func (x *Attributes) GetShippingLength() *ShippingDimension {
	if x != nil {
		return x.ShippingLength
	}
	return nil
}

func (x *Attributes) GetShippingWidth() *ShippingDimension {
	if x != nil {
		return x.ShippingWidth
	}
	return nil
}

func (x *Attributes) GetShippingHeight() *ShippingDimension {
	if x != nil {
		return x.ShippingHeight
	}
	return nil
}

func (x *Attributes) GetMaxHandlingTime() int64 {
	if x != nil && x.MaxHandlingTime != nil {
		return *x.MaxHandlingTime
	}
	return 0
}

func (x *Attributes) GetMinHandlingTime() int64 {
	if x != nil && x.MinHandlingTime != nil {
		return *x.MinHandlingTime
	}
	return 0
}

func (x *Attributes) GetShippingLabel() string {
	if x != nil && x.ShippingLabel != nil {
		return *x.ShippingLabel
	}
	return ""
}

func (x *Attributes) GetTransitTimeLabel() string {
	if x != nil && x.TransitTimeLabel != nil {
		return *x.TransitTimeLabel
	}
	return ""
}

func (x *Attributes) GetSize() string {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return ""
}

func (x *Attributes) GetSizeSystem() string {
	if x != nil && x.SizeSystem != nil {
		return *x.SizeSystem
	}
	return ""
}

func (x *Attributes) GetSizeTypes() []string {
	if x != nil {
		return x.SizeTypes
	}
	return nil
}

func (x *Attributes) GetTaxes() []*Tax {
	if x != nil {
		return x.Taxes
	}
	return nil
}

func (x *Attributes) GetTaxCategory() string {
	if x != nil && x.TaxCategory != nil {
		return *x.TaxCategory
	}
	return ""
}

func (x *Attributes) GetEnergyEfficiencyClass() string {
	if x != nil && x.EnergyEfficiencyClass != nil {
		return *x.EnergyEfficiencyClass
	}
	return ""
}

func (x *Attributes) GetMinEnergyEfficiencyClass() string {
	if x != nil && x.MinEnergyEfficiencyClass != nil {
		return *x.MinEnergyEfficiencyClass
	}
	return ""
}

func (x *Attributes) GetMaxEnergyEfficiencyClass() string {
	if x != nil && x.MaxEnergyEfficiencyClass != nil {
		return *x.MaxEnergyEfficiencyClass
	}
	return ""
}

func (x *Attributes) GetUnitPricingMeasure() *UnitPricingMeasure {
	if x != nil {
		return x.UnitPricingMeasure
	}
	return nil
}

func (x *Attributes) GetUnitPricingBaseMeasure() *UnitPricingBaseMeasure {
	if x != nil {
		return x.UnitPricingBaseMeasure
	}
	return nil
}

func (x *Attributes) GetMultipack() int64 {
	if x != nil && x.Multipack != nil {
		return *x.Multipack
	}
	return 0
}

func (x *Attributes) GetAdsGrouping() string {
	if x != nil && x.AdsGrouping != nil {
		return *x.AdsGrouping
	}
	return ""
}

func (x *Attributes) GetAdsLabels() []string {
	if x != nil {
		return x.AdsLabels
	}
	return nil
}

func (x *Attributes) GetAdsRedirect() string {
	if x != nil && x.AdsRedirect != nil {
		return *x.AdsRedirect
	}
	return ""
}

func (x *Attributes) GetCostOfGoodsSold() *typepb.Price {
	if x != nil {
		return x.CostOfGoodsSold
	}
	return nil
}

func (x *Attributes) GetProductDetails() []*ProductDetail {
	if x != nil {
		return x.ProductDetails
	}
	return nil
}

func (x *Attributes) GetProductHighlights() []string {
	if x != nil {
		return x.ProductHighlights
	}
	return nil
}

func (x *Attributes) GetDisplayAdsId() string {
	if x != nil && x.DisplayAdsId != nil {
		return *x.DisplayAdsId
	}
	return ""
}

func (x *Attributes) GetDisplayAdsSimilarIds() []string {
	if x != nil {
		return x.DisplayAdsSimilarIds
	}
	return nil
}

func (x *Attributes) GetDisplayAdsTitle() string {
	if x != nil && x.DisplayAdsTitle != nil {
		return *x.DisplayAdsTitle
	}
	return ""
}

func (x *Attributes) GetDisplayAdsLink() string {
	if x != nil && x.DisplayAdsLink != nil {
		return *x.DisplayAdsLink
	}
	return ""
}

func (x *Attributes) GetDisplayAdsValue() float64 {
	if x != nil && x.DisplayAdsValue != nil {
		return *x.DisplayAdsValue
	}
	return 0
}

func (x *Attributes) GetPromotionIds() []string {
	if x != nil {
		return x.PromotionIds
	}
	return nil
}

func (x *Attributes) GetPickupMethod() string {
	if x != nil && x.PickupMethod != nil {
		return *x.PickupMethod
	}
	return ""
}

func (x *Attributes) GetPickupSla() string {
	if x != nil && x.PickupSla != nil {
		return *x.PickupSla
	}
	return ""
}

func (x *Attributes) GetLinkTemplate() string {
	if x != nil && x.LinkTemplate != nil {
		return *x.LinkTemplate
	}
	return ""
}

func (x *Attributes) GetMobileLinkTemplate() string {
	if x != nil && x.MobileLinkTemplate != nil {
		return *x.MobileLinkTemplate
	}
	return ""
}

func (x *Attributes) GetCustomLabel_0() string {
	if x != nil && x.CustomLabel_0 != nil {
		return *x.CustomLabel_0
	}
	return ""
}

func (x *Attributes) GetCustomLabel_1() string {
	if x != nil && x.CustomLabel_1 != nil {
		return *x.CustomLabel_1
	}
	return ""
}

func (x *Attributes) GetCustomLabel_2() string {
	if x != nil && x.CustomLabel_2 != nil {
		return *x.CustomLabel_2
	}
	return ""
}

func (x *Attributes) GetCustomLabel_3() string {
	if x != nil && x.CustomLabel_3 != nil {
		return *x.CustomLabel_3
	}
	return ""
}

func (x *Attributes) GetCustomLabel_4() string {
	if x != nil && x.CustomLabel_4 != nil {
		return *x.CustomLabel_4
	}
	return ""
}

func (x *Attributes) GetIncludedDestinations() []string {
	if x != nil {
		return x.IncludedDestinations
	}
	return nil
}

func (x *Attributes) GetExcludedDestinations() []string {
	if x != nil {
		return x.ExcludedDestinations
	}
	return nil
}

func (x *Attributes) GetShoppingAdsExcludedCountries() []string {
	if x != nil {
		return x.ShoppingAdsExcludedCountries
	}
	return nil
}

func (x *Attributes) GetExternalSellerId() string {
	if x != nil && x.ExternalSellerId != nil {
		return *x.ExternalSellerId
	}
	return ""
}

func (x *Attributes) GetPause() string {
	if x != nil && x.Pause != nil {
		return *x.Pause
	}
	return ""
}

func (x *Attributes) GetLifestyleImageLinks() []string {
	if x != nil {
		return x.LifestyleImageLinks
	}
	return nil
}

func (x *Attributes) GetCloudExportAdditionalProperties() []*CloudExportAdditionalProperties {
	if x != nil {
		return x.CloudExportAdditionalProperties
	}
	return nil
}

func (x *Attributes) GetVirtualModelLink() string {
	if x != nil && x.VirtualModelLink != nil {
		return *x.VirtualModelLink
	}
	return ""
}

func (x *Attributes) GetCertifications() []*Certification {
	if x != nil {
		return x.Certifications
	}
	return nil
}

func (x *Attributes) GetStructuredTitle() *ProductStructuredTitle {
	if x != nil {
		return x.StructuredTitle
	}
	return nil
}

func (x *Attributes) GetStructuredDescription() *ProductStructuredDescription {
	if x != nil {
		return x.StructuredDescription
	}
	return nil
}

func (x *Attributes) GetAutoPricingMinPrice() *typepb.Price {
	if x != nil {
		return x.AutoPricingMinPrice
	}
	return nil
}

// The Tax of the product.
type Tax struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentage of tax rate that applies to the item price.
	Rate float64 `protobuf:"fixed64,1,opt,name=rate,proto3" json:"rate,omitempty"`
	// The country within which the item is taxed, specified as a [CLDR
	// territory
	// code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml).
	Country string `protobuf:"bytes,2,opt,name=country,proto3" json:"country,omitempty"`
	// The geographic region to which the tax rate applies.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Set to true if tax is charged on shipping.
	TaxShip bool `protobuf:"varint,4,opt,name=tax_ship,json=taxShip,proto3" json:"tax_ship,omitempty"`
	// The numeric ID of a location that the tax rate applies to as defined in
	// the [AdWords
	// API](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
	LocationId int64 `protobuf:"varint,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// The postal code range that the tax rate applies to, represented by
	// a ZIP code, a ZIP code prefix using * wildcard, a range between two ZIP
	// codes or two ZIP code prefixes of equal length.
	// Examples: 94114, 94*, 94002-95460, 94*-95*.
	PostalCode string `protobuf:"bytes,6,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
}

func (x *Tax) Reset() {
	*x = Tax{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Tax) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tax) ProtoMessage() {}

func (x *Tax) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tax.ProtoReflect.Descriptor instead.
func (*Tax) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{1}
}

func (x *Tax) GetRate() float64 {
	if x != nil {
		return x.Rate
	}
	return 0
}

func (x *Tax) GetCountry() string {
	if x != nil {
		return x.Country
	}
	return ""
}

func (x *Tax) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *Tax) GetTaxShip() bool {
	if x != nil {
		return x.TaxShip
	}
	return false
}

func (x *Tax) GetLocationId() int64 {
	if x != nil {
		return x.LocationId
	}
	return 0
}

func (x *Tax) GetPostalCode() string {
	if x != nil {
		return x.PostalCode
	}
	return ""
}

// The ShippingWeight of the product.
type ShippingWeight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The weight of the product used to calculate the shipping cost of the
	// item.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// The unit of value.
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ShippingWeight) Reset() {
	*x = ShippingWeight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShippingWeight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShippingWeight) ProtoMessage() {}

func (x *ShippingWeight) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShippingWeight.ProtoReflect.Descriptor instead.
func (*ShippingWeight) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{2}
}

func (x *ShippingWeight) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *ShippingWeight) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The ShippingDimension of the product.
type ShippingDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension of the product used to calculate the shipping cost of the
	// item.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// The unit of value.
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ShippingDimension) Reset() {
	*x = ShippingDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShippingDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShippingDimension) ProtoMessage() {}

func (x *ShippingDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShippingDimension.ProtoReflect.Descriptor instead.
func (*ShippingDimension) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{3}
}

func (x *ShippingDimension) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *ShippingDimension) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The UnitPricingBaseMeasure of the product.
type UnitPricingBaseMeasure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The denominator of the unit price.
	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	// The unit of the denominator.
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *UnitPricingBaseMeasure) Reset() {
	*x = UnitPricingBaseMeasure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnitPricingBaseMeasure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnitPricingBaseMeasure) ProtoMessage() {}

func (x *UnitPricingBaseMeasure) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnitPricingBaseMeasure.ProtoReflect.Descriptor instead.
func (*UnitPricingBaseMeasure) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{4}
}

func (x *UnitPricingBaseMeasure) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *UnitPricingBaseMeasure) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The UnitPricingMeasure of the product.
type UnitPricingMeasure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The measure of an item.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// The unit of the measure.
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *UnitPricingMeasure) Reset() {
	*x = UnitPricingMeasure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnitPricingMeasure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnitPricingMeasure) ProtoMessage() {}

func (x *UnitPricingMeasure) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnitPricingMeasure.ProtoReflect.Descriptor instead.
func (*UnitPricingMeasure) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{5}
}

func (x *UnitPricingMeasure) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *UnitPricingMeasure) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The SubscriptionCost of the product.
type SubscriptionCost struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of subscription period.
	// Supported values are:
	//   - "`month`"
	//   - "`year`"
	Period SubscriptionPeriod `protobuf:"varint,1,opt,name=period,proto3,enum=google.shopping.merchant.products.v1beta.SubscriptionPeriod" json:"period,omitempty"`
	// The number of subscription periods the buyer has to pay.
	PeriodLength int64 `protobuf:"varint,2,opt,name=period_length,json=periodLength,proto3" json:"period_length,omitempty"`
	// The amount the buyer has to pay per subscription period.
	Amount *typepb.Price `protobuf:"bytes,3,opt,name=amount,proto3" json:"amount,omitempty"`
}

func (x *SubscriptionCost) Reset() {
	*x = SubscriptionCost{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriptionCost) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionCost) ProtoMessage() {}

func (x *SubscriptionCost) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionCost.ProtoReflect.Descriptor instead.
func (*SubscriptionCost) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{6}
}

func (x *SubscriptionCost) GetPeriod() SubscriptionPeriod {
	if x != nil {
		return x.Period
	}
	return SubscriptionPeriod_SUBSCRIPTION_PERIOD_UNSPECIFIED
}

func (x *SubscriptionCost) GetPeriodLength() int64 {
	if x != nil {
		return x.PeriodLength
	}
	return 0
}

func (x *SubscriptionCost) GetAmount() *typepb.Price {
	if x != nil {
		return x.Amount
	}
	return nil
}

// A message that represents installment.
type Installment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of installments the buyer has to pay.
	Months int64 `protobuf:"varint,1,opt,name=months,proto3" json:"months,omitempty"`
	// The amount the buyer has to pay per month.
	Amount *typepb.Price `protobuf:"bytes,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// The up-front down payment amount the buyer has to pay.
	Downpayment *typepb.Price `protobuf:"bytes,3,opt,name=downpayment,proto3,oneof" json:"downpayment,omitempty"`
	// Type of installment payments.
	// Supported values are:
	//   - "`finance`"
	//   - "`lease`"
	CreditType *string `protobuf:"bytes,4,opt,name=credit_type,json=creditType,proto3,oneof" json:"credit_type,omitempty"`
}

func (x *Installment) Reset() {
	*x = Installment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Installment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Installment) ProtoMessage() {}

func (x *Installment) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Installment.ProtoReflect.Descriptor instead.
func (*Installment) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{7}
}

func (x *Installment) GetMonths() int64 {
	if x != nil {
		return x.Months
	}
	return 0
}

func (x *Installment) GetAmount() *typepb.Price {
	if x != nil {
		return x.Amount
	}
	return nil
}

func (x *Installment) GetDownpayment() *typepb.Price {
	if x != nil {
		return x.Downpayment
	}
	return nil
}

func (x *Installment) GetCreditType() string {
	if x != nil && x.CreditType != nil {
		return *x.CreditType
	}
	return ""
}

// A message that represents loyalty points.
type LoyaltyPoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of loyalty points program. It is recommended to limit the name to
	// 12 full-width characters or 24 Roman characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The retailer's loyalty points in absolute value.
	PointsValue int64 `protobuf:"varint,2,opt,name=points_value,json=pointsValue,proto3" json:"points_value,omitempty"`
	// The ratio of a point when converted to currency. Google assumes currency
	// based on Merchant Center settings. If ratio is left out, it defaults to
	// 1.0.
	Ratio float64 `protobuf:"fixed64,3,opt,name=ratio,proto3" json:"ratio,omitempty"`
}

func (x *LoyaltyPoints) Reset() {
	*x = LoyaltyPoints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoyaltyPoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoyaltyPoints) ProtoMessage() {}

func (x *LoyaltyPoints) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoyaltyPoints.ProtoReflect.Descriptor instead.
func (*LoyaltyPoints) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{8}
}

func (x *LoyaltyPoints) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoyaltyPoints) GetPointsValue() int64 {
	if x != nil {
		return x.PointsValue
	}
	return 0
}

func (x *LoyaltyPoints) GetRatio() float64 {
	if x != nil {
		return x.Ratio
	}
	return 0
}

// A message that represents loyalty program.
type LoyaltyProgram struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The label of the loyalty program. This is an internal label that uniquely
	// identifies the relationship between a merchant entity and a loyalty
	// program entity. The label must be provided so that the system can associate
	// the assets below (for example, price and points) with a merchant. The
	// corresponding program must be linked to the merchant account.
	ProgramLabel *string `protobuf:"bytes,1,opt,name=program_label,json=programLabel,proto3,oneof" json:"program_label,omitempty"`
	// The label of the tier within the loyalty program.
	// Must match one of the labels within the program.
	TierLabel *string `protobuf:"bytes,2,opt,name=tier_label,json=tierLabel,proto3,oneof" json:"tier_label,omitempty"`
	// The price for members of the given tier, that is, the instant discount
	// price. Must be smaller or equal to the regular price.
	Price *typepb.Price `protobuf:"bytes,3,opt,name=price,proto3,oneof" json:"price,omitempty"`
	// The cashback that can be used for future purchases.
	CashbackForFutureUse *typepb.Price `protobuf:"bytes,4,opt,name=cashback_for_future_use,json=cashbackForFutureUse,proto3,oneof" json:"cashback_for_future_use,omitempty"`
	// The amount of loyalty points earned on a purchase.
	LoyaltyPoints *int64 `protobuf:"varint,5,opt,name=loyalty_points,json=loyaltyPoints,proto3,oneof" json:"loyalty_points,omitempty"`
}

func (x *LoyaltyProgram) Reset() {
	*x = LoyaltyProgram{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoyaltyProgram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoyaltyProgram) ProtoMessage() {}

func (x *LoyaltyProgram) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoyaltyProgram.ProtoReflect.Descriptor instead.
func (*LoyaltyProgram) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{9}
}

func (x *LoyaltyProgram) GetProgramLabel() string {
	if x != nil && x.ProgramLabel != nil {
		return *x.ProgramLabel
	}
	return ""
}

func (x *LoyaltyProgram) GetTierLabel() string {
	if x != nil && x.TierLabel != nil {
		return *x.TierLabel
	}
	return ""
}

func (x *LoyaltyProgram) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *LoyaltyProgram) GetCashbackForFutureUse() *typepb.Price {
	if x != nil {
		return x.CashbackForFutureUse
	}
	return nil
}

func (x *LoyaltyProgram) GetLoyaltyPoints() int64 {
	if x != nil && x.LoyaltyPoints != nil {
		return *x.LoyaltyPoints
	}
	return 0
}

// The Shipping of the product.
type Shipping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fixed shipping price, represented as a number.
	Price *typepb.Price `protobuf:"bytes,1,opt,name=price,proto3" json:"price,omitempty"`
	// The [CLDR territory
	// code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// of the country to which an item will ship.
	Country string `protobuf:"bytes,2,opt,name=country,proto3" json:"country,omitempty"`
	// The geographic region to which a shipping rate applies.
	// See [region](https://support.google.com/merchants/answer/6324484) for more
	// information.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// A free-form description of the service class or delivery speed.
	Service string `protobuf:"bytes,4,opt,name=service,proto3" json:"service,omitempty"`
	// The numeric ID of a location that the shipping rate applies to as
	// defined in the [AdWords
	// API](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
	LocationId int64 `protobuf:"varint,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// The location where the shipping is applicable, represented by a
	// location group name.
	LocationGroupName string `protobuf:"bytes,6,opt,name=location_group_name,json=locationGroupName,proto3" json:"location_group_name,omitempty"`
	// The postal code range that the shipping rate applies to, represented by
	// a postal code, a postal code prefix followed by a * wildcard, a range
	// between two postal codes or two postal code prefixes of equal length.
	PostalCode string `protobuf:"bytes,7,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Minimum handling time (inclusive) between when the order is received and
	// shipped in business days. 0 means that the order is shipped on the same
	// day as it is received if it happens before the cut-off time.
	// [minHandlingTime][google.shopping.content.bundles.Products.Shipping.min_handling_time]
	// can only be present together with
	// [maxHandlingTime][google.shopping.content.bundles.Products.Shipping.max_handling_time];
	// but it is not required if
	// [maxHandlingTime][google.shopping.content.bundles.Products.Shipping.max_handling_time]
	// is present.
	MinHandlingTime *int64 `protobuf:"varint,8,opt,name=min_handling_time,json=minHandlingTime,proto3,oneof" json:"min_handling_time,omitempty"`
	// Maximum handling time (inclusive) between when the order is received and
	// shipped in business days. 0 means that the order is shipped on the same
	// day as it is received if it happens before the cut-off time. Both
	// [maxHandlingTime][google.shopping.content.bundles.Products.Shipping.max_handling_time]
	// and
	// [maxTransitTime][google.shopping.content.bundles.Products.Shipping.max_transit_time]
	// are required if providing shipping speeds.
	// [minHandlingTime][google.shopping.content.bundles.Products.Shipping.min_handling_time]
	// is optional if
	// [maxHandlingTime][google.shopping.content.bundles.Products.Shipping.max_handling_time]
	// is present.
	MaxHandlingTime *int64 `protobuf:"varint,9,opt,name=max_handling_time,json=maxHandlingTime,proto3,oneof" json:"max_handling_time,omitempty"`
	// Minimum transit time (inclusive) between when the order has shipped and
	// when it is delivered in business days. 0 means that the order is
	// delivered on the same day as it ships.
	// [minTransitTime][google.shopping.content.bundles.Products.Shipping.min_transit_time]
	// can only be present together with
	// [maxTransitTime][google.shopping.content.bundles.Products.Shipping.max_transit_time];
	// but it is not required if
	// [maxTransitTime][google.shopping.content.bundles.Products.Shipping.max_transit_time]
	// is present.
	MinTransitTime *int64 `protobuf:"varint,10,opt,name=min_transit_time,json=minTransitTime,proto3,oneof" json:"min_transit_time,omitempty"`
	// Maximum transit time (inclusive) between when the order has shipped and
	// when it is delivered in business days. 0 means that the order is
	// delivered on the same day as it ships. Both
	// [maxHandlingTime][google.shopping.content.bundles.Products.Shipping.max_handling_time]
	// and
	// [maxTransitTime][google.shopping.content.bundles.Products.Shipping.max_transit_time]
	// are required if providing shipping speeds.
	// [minTransitTime][google.shopping.content.bundles.Products.Shipping.min_transit_time]
	// is optional if
	// [maxTransitTime][google.shopping.content.bundles.Products.Shipping.max_transit_time]
	// is present.
	MaxTransitTime *int64 `protobuf:"varint,11,opt,name=max_transit_time,json=maxTransitTime,proto3,oneof" json:"max_transit_time,omitempty"`
}

func (x *Shipping) Reset() {
	*x = Shipping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shipping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shipping) ProtoMessage() {}

func (x *Shipping) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shipping.ProtoReflect.Descriptor instead.
func (*Shipping) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{10}
}

func (x *Shipping) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *Shipping) GetCountry() string {
	if x != nil {
		return x.Country
	}
	return ""
}

func (x *Shipping) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *Shipping) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *Shipping) GetLocationId() int64 {
	if x != nil {
		return x.LocationId
	}
	return 0
}

func (x *Shipping) GetLocationGroupName() string {
	if x != nil {
		return x.LocationGroupName
	}
	return ""
}

func (x *Shipping) GetPostalCode() string {
	if x != nil {
		return x.PostalCode
	}
	return ""
}

func (x *Shipping) GetMinHandlingTime() int64 {
	if x != nil && x.MinHandlingTime != nil {
		return *x.MinHandlingTime
	}
	return 0
}

func (x *Shipping) GetMaxHandlingTime() int64 {
	if x != nil && x.MaxHandlingTime != nil {
		return *x.MaxHandlingTime
	}
	return 0
}

func (x *Shipping) GetMinTransitTime() int64 {
	if x != nil && x.MinTransitTime != nil {
		return *x.MinTransitTime
	}
	return 0
}

func (x *Shipping) GetMaxTransitTime() int64 {
	if x != nil && x.MaxTransitTime != nil {
		return *x.MaxTransitTime
	}
	return 0
}

// Conditions to be met for a product to have free shipping.
type FreeShippingThreshold struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [CLDR territory
	// code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
	// of the country to which an item will ship.
	Country *string `protobuf:"bytes,1,opt,name=country,proto3,oneof" json:"country,omitempty"`
	// The minimum product price for the shipping cost to become free. Represented
	// as a number.
	PriceThreshold *typepb.Price `protobuf:"bytes,2,opt,name=price_threshold,json=priceThreshold,proto3,oneof" json:"price_threshold,omitempty"`
}

func (x *FreeShippingThreshold) Reset() {
	*x = FreeShippingThreshold{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FreeShippingThreshold) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FreeShippingThreshold) ProtoMessage() {}

func (x *FreeShippingThreshold) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FreeShippingThreshold.ProtoReflect.Descriptor instead.
func (*FreeShippingThreshold) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{11}
}

func (x *FreeShippingThreshold) GetCountry() string {
	if x != nil && x.Country != nil {
		return *x.Country
	}
	return ""
}

func (x *FreeShippingThreshold) GetPriceThreshold() *typepb.Price {
	if x != nil {
		return x.PriceThreshold
	}
	return nil
}

// The product details.
type ProductDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The section header used to group a set of product details.
	SectionName string `protobuf:"bytes,1,opt,name=section_name,json=sectionName,proto3" json:"section_name,omitempty"`
	// The name of the product detail.
	AttributeName string `protobuf:"bytes,2,opt,name=attribute_name,json=attributeName,proto3" json:"attribute_name,omitempty"`
	// The value of the product detail.
	AttributeValue string `protobuf:"bytes,3,opt,name=attribute_value,json=attributeValue,proto3" json:"attribute_value,omitempty"`
}

func (x *ProductDetail) Reset() {
	*x = ProductDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductDetail) ProtoMessage() {}

func (x *ProductDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductDetail.ProtoReflect.Descriptor instead.
func (*ProductDetail) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{12}
}

func (x *ProductDetail) GetSectionName() string {
	if x != nil {
		return x.SectionName
	}
	return ""
}

func (x *ProductDetail) GetAttributeName() string {
	if x != nil {
		return x.AttributeName
	}
	return ""
}

func (x *ProductDetail) GetAttributeValue() string {
	if x != nil {
		return x.AttributeValue
	}
	return ""
}

// Product
// [certification](https://support.google.com/merchants/answer/13528839),
// initially introduced for EU energy efficiency labeling compliance using the
// EU EPREL database.
type Certification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certification authority, for example "European_Commission".
	// Maximum length is 2000 characters.
	CertificationAuthority *string `protobuf:"bytes,1,opt,name=certification_authority,json=certificationAuthority,proto3,oneof" json:"certification_authority,omitempty"`
	// The name of the certification, for example "EPREL".
	// Maximum length is 2000 characters.
	CertificationName *string `protobuf:"bytes,2,opt,name=certification_name,json=certificationName,proto3,oneof" json:"certification_name,omitempty"`
	// The certification code.
	// Maximum length is 2000 characters.
	CertificationCode *string `protobuf:"bytes,3,opt,name=certification_code,json=certificationCode,proto3,oneof" json:"certification_code,omitempty"`
	// The certification value (also known as class, level or grade), for example
	// "A+", "C", "gold".
	// Maximum length is 2000 characters.
	CertificationValue *string `protobuf:"bytes,4,opt,name=certification_value,json=certificationValue,proto3,oneof" json:"certification_value,omitempty"`
}

func (x *Certification) Reset() {
	*x = Certification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certification) ProtoMessage() {}

func (x *Certification) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certification.ProtoReflect.Descriptor instead.
func (*Certification) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{13}
}

func (x *Certification) GetCertificationAuthority() string {
	if x != nil && x.CertificationAuthority != nil {
		return *x.CertificationAuthority
	}
	return ""
}

func (x *Certification) GetCertificationName() string {
	if x != nil && x.CertificationName != nil {
		return *x.CertificationName
	}
	return ""
}

func (x *Certification) GetCertificationCode() string {
	if x != nil && x.CertificationCode != nil {
		return *x.CertificationCode
	}
	return ""
}

func (x *Certification) GetCertificationValue() string {
	if x != nil && x.CertificationValue != nil {
		return *x.CertificationValue
	}
	return ""
}

// Structured title, for algorithmically (AI)-generated titles.
type ProductStructuredTitle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digital source type, for example "trained_algorithmic_media".
	// Following [IPTC](https://cv.iptc.org/newscodes/digitalsourcetype).
	// Maximum length is 40 characters.
	DigitalSourceType *string `protobuf:"bytes,1,opt,name=digital_source_type,json=digitalSourceType,proto3,oneof" json:"digital_source_type,omitempty"`
	// The title text
	// Maximum length is 150 characters
	Content *string `protobuf:"bytes,2,opt,name=content,proto3,oneof" json:"content,omitempty"`
}

func (x *ProductStructuredTitle) Reset() {
	*x = ProductStructuredTitle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductStructuredTitle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductStructuredTitle) ProtoMessage() {}

func (x *ProductStructuredTitle) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductStructuredTitle.ProtoReflect.Descriptor instead.
func (*ProductStructuredTitle) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{14}
}

func (x *ProductStructuredTitle) GetDigitalSourceType() string {
	if x != nil && x.DigitalSourceType != nil {
		return *x.DigitalSourceType
	}
	return ""
}

func (x *ProductStructuredTitle) GetContent() string {
	if x != nil && x.Content != nil {
		return *x.Content
	}
	return ""
}

// Structured description, for algorithmically (AI)-generated descriptions.
type ProductStructuredDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The digital source type, for example "trained_algorithmic_media".
	// Following [IPTC](https://cv.iptc.org/newscodes/digitalsourcetype).
	// Maximum length is 40 characters.
	DigitalSourceType *string `protobuf:"bytes,1,opt,name=digital_source_type,json=digitalSourceType,proto3,oneof" json:"digital_source_type,omitempty"`
	// The description text
	// Maximum length is 5000 characters
	Content *string `protobuf:"bytes,2,opt,name=content,proto3,oneof" json:"content,omitempty"`
}

func (x *ProductStructuredDescription) Reset() {
	*x = ProductStructuredDescription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductStructuredDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductStructuredDescription) ProtoMessage() {}

func (x *ProductStructuredDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductStructuredDescription.ProtoReflect.Descriptor instead.
func (*ProductStructuredDescription) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{15}
}

func (x *ProductStructuredDescription) GetDigitalSourceType() string {
	if x != nil && x.DigitalSourceType != nil {
		return *x.DigitalSourceType
	}
	return ""
}

func (x *ProductStructuredDescription) GetContent() string {
	if x != nil && x.Content != nil {
		return *x.Content
	}
	return ""
}

// The dimension of the product.
type ProductDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dimension value represented as a number. The value can have a
	// maximum precision of four decimal places.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. The dimension units.
	// Acceptable values are:
	//   - "`in`"
	//   - "`cm`"
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ProductDimension) Reset() {
	*x = ProductDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductDimension) ProtoMessage() {}

func (x *ProductDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductDimension.ProtoReflect.Descriptor instead.
func (*ProductDimension) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{16}
}

func (x *ProductDimension) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *ProductDimension) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The weight of the product.
type ProductWeight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The weight represented as a number. The weight can have a maximum
	// precision of four decimal places.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. The weight unit.
	// Acceptable values are:
	//   - "`g`"
	//   - "`kg`"
	//   - "`oz`"
	//   - "`lb`"
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *ProductWeight) Reset() {
	*x = ProductWeight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductWeight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductWeight) ProtoMessage() {}

func (x *ProductWeight) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductWeight.ProtoReflect.Descriptor instead.
func (*ProductWeight) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{17}
}

func (x *ProductWeight) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *ProductWeight) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The status of a product, data validation issues, that is, information about
// a product computed asynchronously.
type ProductStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intended destinations for the product.
	DestinationStatuses []*ProductStatus_DestinationStatus `protobuf:"bytes,3,rep,name=destination_statuses,json=destinationStatuses,proto3" json:"destination_statuses,omitempty"`
	// A list of all issues associated with the product.
	ItemLevelIssues []*ProductStatus_ItemLevelIssue `protobuf:"bytes,4,rep,name=item_level_issues,json=itemLevelIssues,proto3" json:"item_level_issues,omitempty"`
	// Date on which the item has been created, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	CreationDate *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Date on which the item has been last updated, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	LastUpdateDate *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_update_date,json=lastUpdateDate,proto3" json:"last_update_date,omitempty"`
	// Date on which the item expires, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	GoogleExpirationDate *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=google_expiration_date,json=googleExpirationDate,proto3" json:"google_expiration_date,omitempty"`
}

func (x *ProductStatus) Reset() {
	*x = ProductStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductStatus) ProtoMessage() {}

func (x *ProductStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductStatus.ProtoReflect.Descriptor instead.
func (*ProductStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{18}
}

func (x *ProductStatus) GetDestinationStatuses() []*ProductStatus_DestinationStatus {
	if x != nil {
		return x.DestinationStatuses
	}
	return nil
}

func (x *ProductStatus) GetItemLevelIssues() []*ProductStatus_ItemLevelIssue {
	if x != nil {
		return x.ItemLevelIssues
	}
	return nil
}

func (x *ProductStatus) GetCreationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationDate
	}
	return nil
}

func (x *ProductStatus) GetLastUpdateDate() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateDate
	}
	return nil
}

func (x *ProductStatus) GetGoogleExpirationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.GoogleExpirationDate
	}
	return nil
}

// Product property for the Cloud Retail API.
// For example, properties for a TV product could be "Screen-Resolution" or
// "Screen-Size".
type CloudExportAdditionalProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the given property. For example,
	// "Screen-Resolution" for a TV product. Maximum string size is 256
	// characters.
	PropertyName *string `protobuf:"bytes,1,opt,name=property_name,json=propertyName,proto3,oneof" json:"property_name,omitempty"`
	// Text value of the given property. For example,
	// "8K(UHD)" could be a text value for a TV product. Maximum
	// repeatedness of this value is 400. Values are stored in an arbitrary but
	// consistent order. Maximum string size is 256 characters.
	TextValue []string `protobuf:"bytes,2,rep,name=text_value,json=textValue,proto3" json:"text_value,omitempty"`
	// Boolean value of the given property. For example for a TV product,
	// "True" or "False" if the screen is UHD.
	BoolValue *bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof" json:"bool_value,omitempty"`
	// Integer values of the given property. For example, 1080 for a TV
	// product's Screen Resolution. Maximum repeatedness of this value
	// is 400. Values are stored in an arbitrary but consistent order.
	IntValue []int64 `protobuf:"varint,4,rep,packed,name=int_value,json=intValue,proto3" json:"int_value,omitempty"`
	// Float values of the given property. For example for a TV product
	// 1.2345. Maximum repeatedness of this value is 400. Values
	// are stored in an arbitrary but consistent order.
	FloatValue []float32 `protobuf:"fixed32,5,rep,packed,name=float_value,json=floatValue,proto3" json:"float_value,omitempty"`
	// Minimum float value of the given property. For example for a TV
	// product 1.00.
	MinValue *float32 `protobuf:"fixed32,6,opt,name=min_value,json=minValue,proto3,oneof" json:"min_value,omitempty"`
	// Maximum float value of the given property. For example for a TV
	// product 100.00.
	MaxValue *float32 `protobuf:"fixed32,7,opt,name=max_value,json=maxValue,proto3,oneof" json:"max_value,omitempty"`
	// Unit of the given property. For example, "Pixels" for a TV product. Maximum
	// string size is 256B.
	UnitCode *string `protobuf:"bytes,8,opt,name=unit_code,json=unitCode,proto3,oneof" json:"unit_code,omitempty"`
}

func (x *CloudExportAdditionalProperties) Reset() {
	*x = CloudExportAdditionalProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudExportAdditionalProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudExportAdditionalProperties) ProtoMessage() {}

func (x *CloudExportAdditionalProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudExportAdditionalProperties.ProtoReflect.Descriptor instead.
func (*CloudExportAdditionalProperties) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{19}
}

func (x *CloudExportAdditionalProperties) GetPropertyName() string {
	if x != nil && x.PropertyName != nil {
		return *x.PropertyName
	}
	return ""
}

func (x *CloudExportAdditionalProperties) GetTextValue() []string {
	if x != nil {
		return x.TextValue
	}
	return nil
}

func (x *CloudExportAdditionalProperties) GetBoolValue() bool {
	if x != nil && x.BoolValue != nil {
		return *x.BoolValue
	}
	return false
}

func (x *CloudExportAdditionalProperties) GetIntValue() []int64 {
	if x != nil {
		return x.IntValue
	}
	return nil
}

func (x *CloudExportAdditionalProperties) GetFloatValue() []float32 {
	if x != nil {
		return x.FloatValue
	}
	return nil
}

func (x *CloudExportAdditionalProperties) GetMinValue() float32 {
	if x != nil && x.MinValue != nil {
		return *x.MinValue
	}
	return 0
}

func (x *CloudExportAdditionalProperties) GetMaxValue() float32 {
	if x != nil && x.MaxValue != nil {
		return *x.MaxValue
	}
	return 0
}

func (x *CloudExportAdditionalProperties) GetUnitCode() string {
	if x != nil && x.UnitCode != nil {
		return *x.UnitCode
	}
	return ""
}

// The destination status of the product status.
type ProductStatus_DestinationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the reporting context.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,1,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where the offer is approved.
	ApprovedCountries []string `protobuf:"bytes,2,rep,name=approved_countries,json=approvedCountries,proto3" json:"approved_countries,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where the offer is pending
	// approval.
	PendingCountries []string `protobuf:"bytes,3,rep,name=pending_countries,json=pendingCountries,proto3" json:"pending_countries,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where the offer is
	// disapproved.
	DisapprovedCountries []string `protobuf:"bytes,4,rep,name=disapproved_countries,json=disapprovedCountries,proto3" json:"disapproved_countries,omitempty"`
}

func (x *ProductStatus_DestinationStatus) Reset() {
	*x = ProductStatus_DestinationStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductStatus_DestinationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductStatus_DestinationStatus) ProtoMessage() {}

func (x *ProductStatus_DestinationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductStatus_DestinationStatus.ProtoReflect.Descriptor instead.
func (*ProductStatus_DestinationStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{18, 0}
}

func (x *ProductStatus_DestinationStatus) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *ProductStatus_DestinationStatus) GetApprovedCountries() []string {
	if x != nil {
		return x.ApprovedCountries
	}
	return nil
}

func (x *ProductStatus_DestinationStatus) GetPendingCountries() []string {
	if x != nil {
		return x.PendingCountries
	}
	return nil
}

func (x *ProductStatus_DestinationStatus) GetDisapprovedCountries() []string {
	if x != nil {
		return x.DisapprovedCountries
	}
	return nil
}

// The ItemLevelIssue of the product status.
type ProductStatus_ItemLevelIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The error code of the issue.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// How this issue affects serving of the offer.
	Severity ProductStatus_ItemLevelIssue_Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.shopping.merchant.products.v1beta.ProductStatus_ItemLevelIssue_Severity" json:"severity,omitempty"`
	// Whether the issue can be resolved by the merchant.
	Resolution string `protobuf:"bytes,3,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// The attribute's name, if the issue is caused by a single attribute.
	Attribute string `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// The reporting context the issue applies to.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,5,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
	// A short issue description in English.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// A detailed issue description in English.
	Detail string `protobuf:"bytes,7,opt,name=detail,proto3" json:"detail,omitempty"`
	// The URL of a web page to help with resolving this issue.
	Documentation string `protobuf:"bytes,8,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// List of country codes (ISO 3166-1 alpha-2) where issue applies to the
	// offer.
	ApplicableCountries []string `protobuf:"bytes,9,rep,name=applicable_countries,json=applicableCountries,proto3" json:"applicable_countries,omitempty"`
}

func (x *ProductStatus_ItemLevelIssue) Reset() {
	*x = ProductStatus_ItemLevelIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProductStatus_ItemLevelIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductStatus_ItemLevelIssue) ProtoMessage() {}

func (x *ProductStatus_ItemLevelIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductStatus_ItemLevelIssue.ProtoReflect.Descriptor instead.
func (*ProductStatus_ItemLevelIssue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP(), []int{18, 1}
}

func (x *ProductStatus_ItemLevelIssue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *ProductStatus_ItemLevelIssue) GetSeverity() ProductStatus_ItemLevelIssue_Severity {
	if x != nil {
		return x.Severity
	}
	return ProductStatus_ItemLevelIssue_SEVERITY_UNSPECIFIED
}

func (x *ProductStatus_ItemLevelIssue) GetResolution() string {
	if x != nil {
		return x.Resolution
	}
	return ""
}

func (x *ProductStatus_ItemLevelIssue) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *ProductStatus_ItemLevelIssue) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *ProductStatus_ItemLevelIssue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ProductStatus_ItemLevelIssue) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *ProductStatus_ItemLevelIssue) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *ProductStatus_ItemLevelIssue) GetApplicableCountries() []string {
	if x != nil {
		return x.ApplicableCountries
	}
	return nil
}

var File_google_shopping_merchant_products_v1beta_products_common_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_products_v1beta_products_common_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x32, 0x0a, 0x0a, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x45, 0x78, 0x69, 0x73, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x69,
	0x73, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01,
	0x52, 0x08, 0x69, 0x73, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x17, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52,
	0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x6f, 0x62, 0x69,
	0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52,
	0x0a, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x2a,
	0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07,
	0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x34,
	0x0a, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73,
	0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x4f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e,
	0x64, 0x69, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x61, 0x64, 0x75, 0x6c, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x48, 0x08, 0x52,
	0x05, 0x61, 0x64, 0x75, 0x6c, 0x74, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x61, 0x67, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09, 0x52, 0x08,
	0x61, 0x67, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0c, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x0a, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x88, 0x01, 0x01, 0x12, 0x47, 0x0a, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0b, 0x52, 0x05,
	0x62, 0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f,
	0x72, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
	0x88, 0x01, 0x01, 0x12, 0x21, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0d, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0e, 0x52, 0x06, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x0f, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x88, 0x01, 0x01,
	0x12, 0x17, 0x0a, 0x04, 0x67, 0x74, 0x69, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x10,
	0x52, 0x04, 0x67, 0x74, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0d, 0x69, 0x74, 0x65,
	0x6d, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x11, 0x52, 0x0b, 0x69, 0x74, 0x65, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x88,
	0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x12, 0x52, 0x08, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x70, 0x6e, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x13, 0x52, 0x03, 0x6d, 0x70, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x14, 0x52, 0x07, 0x70,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x05, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x57, 0x0a, 0x0b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x20, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x11, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x73, 0x74, 0x52, 0x10, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x5e,
	0x0a, 0x0e, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52,
	0x0d, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x64,
	0x0a, 0x10, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x88, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x52, 0x0f, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x23, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0a, 0x73, 0x61, 0x6c,
	0x65, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x09, 0x73, 0x61, 0x6c, 0x65,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x19, 0x73, 0x61, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52,
	0x16, 0x73, 0x61, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x63, 0x65, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12, 0x3a, 0x0a, 0x17, 0x73, 0x65, 0x6c, 0x6c, 0x5f,
	0x6f, 0x6e, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x26, 0x20, 0x01, 0x28, 0x03, 0x48, 0x15, 0x52, 0x14, 0x73, 0x65, 0x6c, 0x6c,
	0x4f, 0x6e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x88, 0x01, 0x01, 0x12, 0x61, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x77, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x61, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x78, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x5f, 0x0a, 0x0d, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x79, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x57, 0x69, 0x64, 0x74, 0x68, 0x12, 0x5e, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x7a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x52, 0x0d, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x4e, 0x0a, 0x08, 0x73, 0x68,
	0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x27, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x52, 0x08, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x78, 0x0a, 0x17, 0x66, 0x72,
	0x65, 0x65, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x87, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x72, 0x65, 0x65, 0x53, 0x68, 0x69, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x15, 0x66,
	0x72, 0x65, 0x65, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x12, 0x61, 0x0a, 0x0f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x52, 0x0e, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x64, 0x0a, 0x0f, 0x73, 0x68, 0x69, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73,
	0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x62, 0x0a,
	0x0e, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18,
	0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x64, 0x74,
	0x68, 0x12, 0x64, 0x0a, 0x0f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x2c, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x16, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e,
	0x67, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x2d, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x17, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x69,
	0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x68, 0x69,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x2e, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x18, 0x52, 0x0d, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x2f, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x19, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x30, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1a, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x18, 0x31, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1b, 0x52, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x32, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x69, 0x7a,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x05, 0x74, 0x61, 0x78, 0x65, 0x73, 0x18,
	0x33, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x54, 0x61, 0x78, 0x52, 0x05, 0x74, 0x61, 0x78, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x74,
	0x61, 0x78, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x34, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x1c, 0x52, 0x0b, 0x74, 0x61, 0x78, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x5f, 0x65, 0x66,
	0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x35,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x1d, 0x52, 0x15, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x45, 0x66,
	0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x42, 0x0a, 0x1b, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x5f, 0x65,
	0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18,
	0x36, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1e, 0x52, 0x18, 0x6d, 0x69, 0x6e, 0x45, 0x6e, 0x65, 0x72,
	0x67, 0x79, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6e, 0x65, 0x72,
	0x67, 0x79, 0x5f, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x18, 0x37, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1f, 0x52, 0x18, 0x6d, 0x61, 0x78,
	0x45, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x14, 0x75, 0x6e, 0x69, 0x74,
	0x5f, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x18, 0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x52, 0x12, 0x75, 0x6e, 0x69, 0x74, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x12, 0x7b, 0x0a, 0x19, 0x75, 0x6e, 0x69, 0x74,
	0x5f, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x18, 0x39, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x50, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x42, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x52, 0x16, 0x75,
	0x6e, 0x69, 0x74, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x73, 0x65, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61,
	0x63, 0x6b, 0x18, 0x3a, 0x20, 0x01, 0x28, 0x03, 0x48, 0x20, 0x52, 0x09, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x61, 0x63, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x64, 0x73, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x21,
	0x52, 0x0b, 0x61, 0x64, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x3c,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x64, 0x73, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x26, 0x0a, 0x0c, 0x61, 0x64, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18,
	0x3d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x22, 0x52, 0x0b, 0x61, 0x64, 0x73, 0x52, 0x65, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x12, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x6f, 0x66, 0x5f, 0x67, 0x6f, 0x6f, 0x64, 0x73, 0x5f, 0x73, 0x6f, 0x6c, 0x64, 0x18, 0x3e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65,
	0x52, 0x0f, 0x63, 0x6f, 0x73, 0x74, 0x4f, 0x66, 0x47, 0x6f, 0x6f, 0x64, 0x73, 0x53, 0x6f, 0x6c,
	0x64, 0x12, 0x60, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x3f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x68,
	0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x40, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x48, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x12, 0x29, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x61, 0x64,
	0x73, 0x5f, 0x69, 0x64, 0x18, 0x41, 0x20, 0x01, 0x28, 0x09, 0x48, 0x23, 0x52, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x41, 0x64, 0x73, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a,
	0x17, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x73, 0x69, 0x6d,
	0x69, 0x6c, 0x61, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x42, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x41, 0x64, 0x73, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61,
	0x72, 0x49, 0x64, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x61, 0x64, 0x73, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x43, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x24, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x41, 0x64, 0x73, 0x54, 0x69, 0x74,
	0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x44, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x25, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x61, 0x64, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x45, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x26, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x41, 0x64, 0x73, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x46, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x69,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x50, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x27, 0x52, 0x0c, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73,
	0x6c, 0x61, 0x18, 0x51, 0x20, 0x01, 0x28, 0x09, 0x48, 0x28, 0x52, 0x09, 0x70, 0x69, 0x63, 0x6b,
	0x75, 0x70, 0x53, 0x6c, 0x61, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x52, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x29, 0x52, 0x0c, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x53, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x2a, 0x52, 0x12, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x30, 0x18, 0x47, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x2b, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x30, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x31, 0x18, 0x48, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2c, 0x52, 0x0c,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x31, 0x88, 0x01, 0x01, 0x12,
	0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x32, 0x18, 0x49, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2d, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x32, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x33, 0x18, 0x4a, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x2e, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x34, 0x18, 0x4b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2f, 0x52,
	0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x34, 0x88, 0x01, 0x01,
	0x12, 0x33, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x4c, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x4d,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x0a, 0x1f, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x4e, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x1c, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x41, 0x64, 0x73,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x31, 0x0a, 0x12, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x30, 0x52,
	0x10, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x49,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x75, 0x73, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x31, 0x52, 0x05, 0x70, 0x61, 0x75, 0x73, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x32, 0x0a, 0x15, 0x6c, 0x69, 0x66, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13,
	0x6c, 0x69, 0x66, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x12, 0x96, 0x01, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x54, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x1f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x12,
	0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x82, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x32, 0x52, 0x10, 0x76, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x69, 0x6e, 0x6b, 0x88, 0x01, 0x01,
	0x12, 0x5f, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x7b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x71, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x84, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x48, 0x33,
	0x52, 0x0f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x54, 0x69, 0x74, 0x6c,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x83, 0x01, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x85, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x34,
	0x52, 0x15, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x16, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x18, 0x7c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x50, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x6e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x14, 0x0a, 0x12,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x69, 0x73,
	0x74, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x69, 0x73, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x61, 0x64, 0x75, 0x6c, 0x74, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x61, 0x67, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x0f, 0x0a,
	0x0d, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x08,
	0x0a, 0x06, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x63, 0x6f, 0x6c,
	0x6f, 0x72, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x42, 0x1a, 0x0a, 0x18, 0x5f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x67, 0x74, 0x69, 0x6e,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x42,
	0x06, 0x0a, 0x04, 0x5f, 0x6d, 0x70, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x73, 0x65, 0x6c, 0x6c, 0x5f, 0x6f, 0x6e, 0x5f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x15,
	0x0a, 0x13, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x0f,
	0x0a, 0x0d, 0x5f, 0x74, 0x61, 0x78, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42,
	0x1a, 0x0a, 0x18, 0x5f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x5f, 0x65, 0x66, 0x66, 0x69, 0x63,
	0x69, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x1e, 0x0a, 0x1c, 0x5f,
	0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x5f, 0x65, 0x66, 0x66, 0x69, 0x63,
	0x69, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x1e, 0x0a, 0x1c, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x5f, 0x65, 0x66, 0x66, 0x69, 0x63,
	0x69, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x5f,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x61, 0x63, 0x6b, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61, 0x64,
	0x73, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61,
	0x64, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x69, 0x64, 0x42, 0x14,
	0x0a, 0x12, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x6c, 0x61,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x30, 0x42, 0x11,
	0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x31, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x32, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x33, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x34, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x64, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x03, 0x54, 0x61, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x72, 0x61, 0x74, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x78, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x74, 0x61, 0x78, 0x53, 0x68, 0x69, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x3a, 0x0a,
	0x0e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0x3d, 0x0a, 0x11, 0x53, 0x68, 0x69,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0x42, 0x0a, 0x16, 0x55, 0x6e, 0x69, 0x74,
	0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0x3e, 0x0a, 0x12,
	0x55, 0x6e, 0x69, 0x74, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0xc2, 0x01, 0x0a,
	0x10, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x73,
	0x74, 0x12, 0x54, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52,
	0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x33, 0x0a, 0x06,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0xe4, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x12, 0x33, 0x0a, 0x06, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x42,
	0x0a, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x64, 0x69,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x6f, 0x77,
	0x6e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x72, 0x65,
	0x64, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x5c, 0x0a, 0x0d, 0x4c, 0x6f, 0x79, 0x61,
	0x6c, 0x74, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x22, 0xf5, 0x02, 0x0a, 0x0e, 0x4c, 0x6f, 0x79, 0x61, 0x6c,
	0x74, 0x79, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x69, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x09, 0x74, 0x69, 0x65, 0x72, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x48, 0x02, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x57, 0x0a, 0x17, 0x63, 0x61, 0x73, 0x68, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x66, 0x6f, 0x72, 0x5f,
	0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x48, 0x03, 0x52,
	0x14, 0x63, 0x61, 0x73, 0x68, 0x62, 0x61, 0x63, 0x6b, 0x46, 0x6f, 0x72, 0x46, 0x75, 0x74, 0x75,
	0x72, 0x65, 0x55, 0x73, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x6c, 0x6f, 0x79, 0x61,
	0x6c, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x04, 0x52, 0x0d, 0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x42,
	0x1a, 0x0a, 0x18, 0x5f, 0x63, 0x61, 0x73, 0x68, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x66, 0x6f, 0x72,
	0x5f, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x6c, 0x6f, 0x79, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x91,
	0x04, 0x0a, 0x08, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x31, 0x0a, 0x05, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70,
	0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x11,
	0x6d, 0x69, 0x6e, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a,
	0x11, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x48,
	0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2d,
	0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a,
	0x10, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12,
	0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x6d, 0x69, 0x6e,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x22, 0xa1, 0x01, 0x0a, 0x15, 0x46, 0x72, 0x65, 0x65, 0x53, 0x68, 0x69, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x1d, 0x0a, 0x07,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x07, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x0f, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x48, 0x01, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0x82, 0x01, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xcd, 0x02, 0x0a, 0x0d,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a,
	0x17, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x16, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x11, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x32, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x11, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x13, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x03, 0x52, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x16,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x64, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61,
	0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x64,
	0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x96,
	0x01, 0x0a, 0x1c, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x33, 0x0a, 0x13, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11,
	0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x46, 0x0a, 0x10, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22,
	0x43, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75,
	0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x75, 0x6e, 0x69, 0x74, 0x22, 0x90, 0x0a, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x7c, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x65, 0x73, 0x12, 0x72, 0x0a, 0x11, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12,
	0x50, 0x0a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x14, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x65, 0x1a, 0x8e, 0x02, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x68, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x52,
	0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x33, 0x0a,
	0x15, 0x64, 0x69, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x64, 0x69,
	0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x1a, 0xa2, 0x04, 0x0a, 0x0e, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x6b, 0x0a, 0x08, 0x73, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x12, 0x68, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x10, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31,
	0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x22, 0x54, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a,
	0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x49,
	0x4d, 0x50, 0x41, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4d,
	0x4f, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x49, 0x53, 0x41, 0x50, 0x50,
	0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x03, 0x22, 0xfd, 0x02, 0x0a, 0x1f, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x03, 0x52, 0x08, 0x69, 0x6e, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x02, 0x52, 0x0a, 0x66, 0x6c, 0x6f, 0x61,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x48, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x48, 0x03, 0x52, 0x08, 0x6d,
	0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x75, 0x6e,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52,
	0x08, 0x75, 0x6e, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x75, 0x6e,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x2a, 0x4e, 0x0a, 0x12, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x23, 0x0a,
	0x1f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45,
	0x52, 0x49, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x59, 0x45, 0x41, 0x52, 0x10, 0x02, 0x42, 0x95, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x13, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x70, 0x62, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescData = file_google_shopping_merchant_products_v1beta_products_common_proto_rawDesc
)

func file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescData)
	})
	return file_google_shopping_merchant_products_v1beta_products_common_proto_rawDescData
}

var file_google_shopping_merchant_products_v1beta_products_common_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_shopping_merchant_products_v1beta_products_common_proto_goTypes = []interface{}{
	(SubscriptionPeriod)(0),                           // 0: google.shopping.merchant.products.v1beta.SubscriptionPeriod
	(ProductStatus_ItemLevelIssue_Severity)(0),        // 1: google.shopping.merchant.products.v1beta.ProductStatus.ItemLevelIssue.Severity
	(*Attributes)(nil),                                // 2: google.shopping.merchant.products.v1beta.Attributes
	(*Tax)(nil),                                       // 3: google.shopping.merchant.products.v1beta.Tax
	(*ShippingWeight)(nil),                            // 4: google.shopping.merchant.products.v1beta.ShippingWeight
	(*ShippingDimension)(nil),                         // 5: google.shopping.merchant.products.v1beta.ShippingDimension
	(*UnitPricingBaseMeasure)(nil),                    // 6: google.shopping.merchant.products.v1beta.UnitPricingBaseMeasure
	(*UnitPricingMeasure)(nil),                        // 7: google.shopping.merchant.products.v1beta.UnitPricingMeasure
	(*SubscriptionCost)(nil),                          // 8: google.shopping.merchant.products.v1beta.SubscriptionCost
	(*Installment)(nil),                               // 9: google.shopping.merchant.products.v1beta.Installment
	(*LoyaltyPoints)(nil),                             // 10: google.shopping.merchant.products.v1beta.LoyaltyPoints
	(*LoyaltyProgram)(nil),                            // 11: google.shopping.merchant.products.v1beta.LoyaltyProgram
	(*Shipping)(nil),                                  // 12: google.shopping.merchant.products.v1beta.Shipping
	(*FreeShippingThreshold)(nil),                     // 13: google.shopping.merchant.products.v1beta.FreeShippingThreshold
	(*ProductDetail)(nil),                             // 14: google.shopping.merchant.products.v1beta.ProductDetail
	(*Certification)(nil),                             // 15: google.shopping.merchant.products.v1beta.Certification
	(*ProductStructuredTitle)(nil),                    // 16: google.shopping.merchant.products.v1beta.ProductStructuredTitle
	(*ProductStructuredDescription)(nil),              // 17: google.shopping.merchant.products.v1beta.ProductStructuredDescription
	(*ProductDimension)(nil),                          // 18: google.shopping.merchant.products.v1beta.ProductDimension
	(*ProductWeight)(nil),                             // 19: google.shopping.merchant.products.v1beta.ProductWeight
	(*ProductStatus)(nil),                             // 20: google.shopping.merchant.products.v1beta.ProductStatus
	(*CloudExportAdditionalProperties)(nil),           // 21: google.shopping.merchant.products.v1beta.CloudExportAdditionalProperties
	(*ProductStatus_DestinationStatus)(nil),           // 22: google.shopping.merchant.products.v1beta.ProductStatus.DestinationStatus
	(*ProductStatus_ItemLevelIssue)(nil),              // 23: google.shopping.merchant.products.v1beta.ProductStatus.ItemLevelIssue
	(*timestamppb.Timestamp)(nil),                     // 24: google.protobuf.Timestamp
	(*typepb.Price)(nil),                              // 25: google.shopping.type.Price
	(*interval.Interval)(nil),                         // 26: google.type.Interval
	(typepb.ReportingContext_ReportingContextEnum)(0), // 27: google.shopping.type.ReportingContext.ReportingContextEnum
}
var file_google_shopping_merchant_products_v1beta_products_common_proto_depIdxs = []int32{
	24, // 0: google.shopping.merchant.products.v1beta.Attributes.expiration_date:type_name -> google.protobuf.Timestamp
	24, // 1: google.shopping.merchant.products.v1beta.Attributes.disclosure_date:type_name -> google.protobuf.Timestamp
	24, // 2: google.shopping.merchant.products.v1beta.Attributes.availability_date:type_name -> google.protobuf.Timestamp
	25, // 3: google.shopping.merchant.products.v1beta.Attributes.price:type_name -> google.shopping.type.Price
	9,  // 4: google.shopping.merchant.products.v1beta.Attributes.installment:type_name -> google.shopping.merchant.products.v1beta.Installment
	8,  // 5: google.shopping.merchant.products.v1beta.Attributes.subscription_cost:type_name -> google.shopping.merchant.products.v1beta.SubscriptionCost
	10, // 6: google.shopping.merchant.products.v1beta.Attributes.loyalty_points:type_name -> google.shopping.merchant.products.v1beta.LoyaltyPoints
	11, // 7: google.shopping.merchant.products.v1beta.Attributes.loyalty_programs:type_name -> google.shopping.merchant.products.v1beta.LoyaltyProgram
	25, // 8: google.shopping.merchant.products.v1beta.Attributes.sale_price:type_name -> google.shopping.type.Price
	26, // 9: google.shopping.merchant.products.v1beta.Attributes.sale_price_effective_date:type_name -> google.type.Interval
	18, // 10: google.shopping.merchant.products.v1beta.Attributes.product_height:type_name -> google.shopping.merchant.products.v1beta.ProductDimension
	18, // 11: google.shopping.merchant.products.v1beta.Attributes.product_length:type_name -> google.shopping.merchant.products.v1beta.ProductDimension
	18, // 12: google.shopping.merchant.products.v1beta.Attributes.product_width:type_name -> google.shopping.merchant.products.v1beta.ProductDimension
	19, // 13: google.shopping.merchant.products.v1beta.Attributes.product_weight:type_name -> google.shopping.merchant.products.v1beta.ProductWeight
	12, // 14: google.shopping.merchant.products.v1beta.Attributes.shipping:type_name -> google.shopping.merchant.products.v1beta.Shipping
	13, // 15: google.shopping.merchant.products.v1beta.Attributes.free_shipping_threshold:type_name -> google.shopping.merchant.products.v1beta.FreeShippingThreshold
	4,  // 16: google.shopping.merchant.products.v1beta.Attributes.shipping_weight:type_name -> google.shopping.merchant.products.v1beta.ShippingWeight
	5,  // 17: google.shopping.merchant.products.v1beta.Attributes.shipping_length:type_name -> google.shopping.merchant.products.v1beta.ShippingDimension
	5,  // 18: google.shopping.merchant.products.v1beta.Attributes.shipping_width:type_name -> google.shopping.merchant.products.v1beta.ShippingDimension
	5,  // 19: google.shopping.merchant.products.v1beta.Attributes.shipping_height:type_name -> google.shopping.merchant.products.v1beta.ShippingDimension
	3,  // 20: google.shopping.merchant.products.v1beta.Attributes.taxes:type_name -> google.shopping.merchant.products.v1beta.Tax
	7,  // 21: google.shopping.merchant.products.v1beta.Attributes.unit_pricing_measure:type_name -> google.shopping.merchant.products.v1beta.UnitPricingMeasure
	6,  // 22: google.shopping.merchant.products.v1beta.Attributes.unit_pricing_base_measure:type_name -> google.shopping.merchant.products.v1beta.UnitPricingBaseMeasure
	25, // 23: google.shopping.merchant.products.v1beta.Attributes.cost_of_goods_sold:type_name -> google.shopping.type.Price
	14, // 24: google.shopping.merchant.products.v1beta.Attributes.product_details:type_name -> google.shopping.merchant.products.v1beta.ProductDetail
	21, // 25: google.shopping.merchant.products.v1beta.Attributes.cloud_export_additional_properties:type_name -> google.shopping.merchant.products.v1beta.CloudExportAdditionalProperties
	15, // 26: google.shopping.merchant.products.v1beta.Attributes.certifications:type_name -> google.shopping.merchant.products.v1beta.Certification
	16, // 27: google.shopping.merchant.products.v1beta.Attributes.structured_title:type_name -> google.shopping.merchant.products.v1beta.ProductStructuredTitle
	17, // 28: google.shopping.merchant.products.v1beta.Attributes.structured_description:type_name -> google.shopping.merchant.products.v1beta.ProductStructuredDescription
	25, // 29: google.shopping.merchant.products.v1beta.Attributes.auto_pricing_min_price:type_name -> google.shopping.type.Price
	0,  // 30: google.shopping.merchant.products.v1beta.SubscriptionCost.period:type_name -> google.shopping.merchant.products.v1beta.SubscriptionPeriod
	25, // 31: google.shopping.merchant.products.v1beta.SubscriptionCost.amount:type_name -> google.shopping.type.Price
	25, // 32: google.shopping.merchant.products.v1beta.Installment.amount:type_name -> google.shopping.type.Price
	25, // 33: google.shopping.merchant.products.v1beta.Installment.downpayment:type_name -> google.shopping.type.Price
	25, // 34: google.shopping.merchant.products.v1beta.LoyaltyProgram.price:type_name -> google.shopping.type.Price
	25, // 35: google.shopping.merchant.products.v1beta.LoyaltyProgram.cashback_for_future_use:type_name -> google.shopping.type.Price
	25, // 36: google.shopping.merchant.products.v1beta.Shipping.price:type_name -> google.shopping.type.Price
	25, // 37: google.shopping.merchant.products.v1beta.FreeShippingThreshold.price_threshold:type_name -> google.shopping.type.Price
	22, // 38: google.shopping.merchant.products.v1beta.ProductStatus.destination_statuses:type_name -> google.shopping.merchant.products.v1beta.ProductStatus.DestinationStatus
	23, // 39: google.shopping.merchant.products.v1beta.ProductStatus.item_level_issues:type_name -> google.shopping.merchant.products.v1beta.ProductStatus.ItemLevelIssue
	24, // 40: google.shopping.merchant.products.v1beta.ProductStatus.creation_date:type_name -> google.protobuf.Timestamp
	24, // 41: google.shopping.merchant.products.v1beta.ProductStatus.last_update_date:type_name -> google.protobuf.Timestamp
	24, // 42: google.shopping.merchant.products.v1beta.ProductStatus.google_expiration_date:type_name -> google.protobuf.Timestamp
	27, // 43: google.shopping.merchant.products.v1beta.ProductStatus.DestinationStatus.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	1,  // 44: google.shopping.merchant.products.v1beta.ProductStatus.ItemLevelIssue.severity:type_name -> google.shopping.merchant.products.v1beta.ProductStatus.ItemLevelIssue.Severity
	27, // 45: google.shopping.merchant.products.v1beta.ProductStatus.ItemLevelIssue.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	46, // [46:46] is the sub-list for method output_type
	46, // [46:46] is the sub-list for method input_type
	46, // [46:46] is the sub-list for extension type_name
	46, // [46:46] is the sub-list for extension extendee
	0,  // [0:46] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_products_v1beta_products_common_proto_init() }
func file_google_shopping_merchant_products_v1beta_products_common_proto_init() {
	if File_google_shopping_merchant_products_v1beta_products_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Tax); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShippingWeight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShippingDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnitPricingBaseMeasure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnitPricingMeasure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriptionCost); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Installment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoyaltyPoints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoyaltyProgram); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shipping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FreeShippingThreshold); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductStructuredTitle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductStructuredDescription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductWeight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudExportAdditionalProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductStatus_DestinationStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProductStatus_ItemLevelIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[13].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes[19].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_products_v1beta_products_common_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_merchant_products_v1beta_products_common_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_products_v1beta_products_common_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_products_v1beta_products_common_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_products_v1beta_products_common_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_products_v1beta_products_common_proto = out.File
	file_google_shopping_merchant_products_v1beta_products_common_proto_rawDesc = nil
	file_google_shopping_merchant_products_v1beta_products_common_proto_goTypes = nil
	file_google_shopping_merchant_products_v1beta_products_common_proto_depIdxs = nil
}
