/* SPDX-FileCopyrightText: 2013, 2016 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gtk/gtk.h>
#include "gtksourceinternal.h"
#include "gtksourcesearchcontext.h"
#include "gtksourcetypes.h"

G_BEGIN_DECLS

GTK_SOURCE_INTERNAL
void			 _gtk_source_buffer_update_syntax_highlight	(GtkSourceBuffer        *buffer,
									 const GtkTextIter      *start,
									 const GtkTextIter      *end,
									 gboolean                synchronous);

GTK_SOURCE_INTERNAL
void			 _gtk_source_buffer_update_search_highlight	(GtkSourceBuffer        *buffer,
									 const GtkTextIter      *start,
									 const GtkTextIter      *end,
									 gboolean                synchronous);

GTK_SOURCE_INTERNAL
GtkSourceMark		*_gtk_source_buffer_source_mark_next		(GtkSourceBuffer        *buffer,
									 GtkSourceMark          *mark,
									 const gchar            *category);

GTK_SOURCE_INTERNAL
GtkSourceMark		*_gtk_source_buffer_source_mark_prev		(GtkSourceBuffer        *buffer,
									 GtkSourceMark          *mark,
									 const gchar            *category);

GTK_SOURCE_INTERNAL
GtkTextTag		*_gtk_source_buffer_get_bracket_match_tag	(GtkSourceBuffer        *buffer);

GTK_SOURCE_INTERNAL
void			 _gtk_source_buffer_add_search_context		(GtkSourceBuffer        *buffer,
									 GtkSourceSearchContext *search_context);

GTK_SOURCE_INTERNAL
void			 _gtk_source_buffer_set_as_invalid_character	(GtkSourceBuffer        *buffer,
									 const GtkTextIter      *start,
									 const GtkTextIter      *end);

GTK_SOURCE_INTERNAL
gboolean		 _gtk_source_buffer_has_invalid_chars		(GtkSourceBuffer        *buffer);

GTK_SOURCE_INTERNAL
GtkSourceBracketMatchType
			 _gtk_source_buffer_find_bracket_match		(GtkSourceBuffer        *buffer,
									 const GtkTextIter      *pos,
									 GtkTextIter            *bracket,
									 GtkTextIter            *bracket_match);

GTK_SOURCE_INTERNAL
void			 _gtk_source_buffer_save_and_clear_selection	(GtkSourceBuffer        *buffer);

GTK_SOURCE_INTERNAL
void			 _gtk_source_buffer_restore_selection		(GtkSourceBuffer        *buffer);

GTK_SOURCE_INTERNAL
gboolean		 _gtk_source_buffer_is_undo_redo_enabled	(GtkSourceBuffer        *buffer);

G_END_DECLS
