import json
import pathlib
from typing import Any


def load_fixture(filename: str) -> Any:
    """Load a fixtures from files."""

    script_dir = pathlib.Path(__file__).parent.resolve()
    fixture_path = script_dir / "fixtures" / filename

    with open(fixture_path, "r", encoding="utf-8") as file:
        return json.load(file)
