# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.iotfirmwaredefense import IoTFirmwareDefenseMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-iotfirmwaredefense
# USAGE
    python firmwares_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = IoTFirmwareDefenseMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.firmwares.update(
        resource_group_name="rgiotfirmwaredefense",
        workspace_name="exampleWorkspaceName",
        firmware_id="00000000-0000-0000-0000-000000000000",
        properties={
            "properties": {
                "description": "User provided description of the firmware.",
                "fileName": "FileNameThatWasUploaded.bin",
                "fileSize": 30,
                "model": "ExampleModelOfDevice",
                "status": "Pending",
                "statusMessages": [
                    {
                        "errorCode": 5,
                        "message": "Firmware image contained some file systems that are not supported for extraction so results may be incomplete.",
                    }
                ],
                "vendor": "ExampleVendorName",
                "version": "1.0.0",
            }
        },
    )
    print(response)


# x-ms-original-file: 2025-08-02/Firmwares_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
