% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutinomialreg.R
\name{mlogit}
\alias{mlogit}
\alias{predict}
\title{Multinomial regression based on phreg regression}
\usage{
mlogit(formula, data, offset = NULL, weights = NULL, fix.X = FALSE, ...)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{fix.X}{to have same coefficients for all categories}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Fits multinomial regression model 
\deqn{ P_i = \frac{ \exp( X^\beta_i ) }{ \sum_{j=1}^K \exp( X^\beta_j ) }} 
for \deqn{i=1,..,K}
where \deqn{\beta_1 = 0}, such that \deqn{\sum_j P_j = 1} using phreg function. 
Thefore the ratio \deqn{\frac{P_i}{P_1} = \exp( X^\beta_i )}
}
\details{
Coefficients give log-Relative-Risk relative to baseline group (first level of factor, so that it can reset by relevel command).  
Standard errors computed based on sandwhich form \deqn{ DU^-1  \sum U_i^2 DU^-1}.  

Can also get influence functions (possibly robust) via iid() function, response should be a factor. 

Can fit cumulative odds model as a special case of interval.logitsurv.discrete
}
\examples{
library(mets)
data(bmt)
bmt$id <- sample(200,408,replace=TRUE)
dfactor(bmt) <- cause1f~cause
drelevel(bmt,ref=3) <- cause3f~cause
dlevels(bmt)

mreg <- mlogit(cause1f~+1+cluster(id),bmt)
summary(mreg)
head(iid(mreg))
dim(iid(mreg))

mreg <- mlogit(cause1f~tcell+platelet,bmt)
summary(mreg)
head(iid(mreg))
dim(iid(mreg))

mreg3 <- mlogit(cause3f~tcell+platelet,bmt)
summary(mreg3)

## inverse information standard errors 
lava::estimate(coef=mreg3$coef,vcov=mreg3$II)

## predictions based on seen response or not 
## all probabilities
head(predict(mreg,response=FALSE))
head(predict(mreg))
## using newdata 
newdata <- data.frame(tcell=c(1,1,1),platelet=c(0,1,1),cause1f=c("2","2","0"))
## only probability of seen response 
predict(mreg,newdata)
## without response
predict(mreg,newdata,response=FALSE)
## given indexx of P(Y=j)
predict(mreg,newdata,Y=c(1,2,3))
##  reponse not given 
newdata <- data.frame(tcell=c(1,1,1),platelet=c(0,1,1))
predict(mreg,newdata)
}
\author{
Thomas Scheike
}
