#![allow(clippy::exhaustive_structs)]
#![allow(dead_code)]

use http::StatusCode;
use ruma_common::{
    api::{OutgoingResponse as _, auth_scheme::NoAuthentication, request, response},
    metadata,
};

metadata! {
    method: GET,
    rate_limited: false,
    authentication: NoAuthentication,
    history: {
        unstable => "/_matrix/my/endpoint",
    }
}

/// Request type for the `default_status` endpoint.
#[request]
pub struct Request {}

/// Response type for the `default_status` endpoint.
#[response]
pub struct Response {}

#[test]
fn response_default_status() {
    let res = Response {};
    let http_res = res.try_into_http_response::<Vec<u8>>().unwrap();

    // Test that we correctly changed the status code.
    assert_eq!(http_res.status(), StatusCode::OK);
}
