#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_l3_interfaces
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


DOCUMENTATION = """
module: junos_l3_interfaces
short_description: L3 interfaces resource module
description: This module provides declarative management of a Layer 3 interface on
  Juniper JUNOS devices
version_added: 1.0.0
author: Daniel Mellado (@dmellado)
requirements:
- ncclient (>=v0.6.4)
notes:
- This module requires the netconf system service be enabled on the device being managed.
- Tested against JunOS v18.4R1
- This module works with connection C(netconf).
  See U(https://docs.ansible.com/ansible/latest/network/user_guide/platform_junos.html)
- The module examples uses callback plugin (stdout_callback = yaml) to generate task
  output in yaml format.
options:
  config:
    description: A dictionary of Layer 3 interface options
    type: list
    elements: dict
    suboptions:
      name:
        description:
        - Full name of interface, e.g. ge-0/0/1
        type: str
        required: true
      unit:
        description:
        - Logical interface number. Value of C(unit) should be of type integer
        default: 0
        type: int
      ipv4:
        description:
        - IPv4 addresses to be set for the Layer 3 logical interface mentioned in
          I(name) option. The address format is <ipv4 address>/<mask>. The mask is
          number in range 0-32 for example, 192.0.2.1/24, or C(dhcp) to query DHCP
          for an IP address
        type: list
        elements: dict
        suboptions:
          address:
            description:
            - IPv4 address to be set for the specific interface
            type: str
      ipv6:
        description:
        - IPv6 addresses to be set for the Layer 3 logical interface mentioned in
          I(name) option. The address format is <ipv6 address>/<mask>, the mask is
          number in range 0-128 for example, 2001:db8:2201:1::1/64 or C(auto-config)
          to use SLAAC
        type: list
        elements: dict
        suboptions:
          address:
            description:
            - IPv6 address to be set for the specific interface
            type: str
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show interfaces).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result
    type: str
  state:
    description:
    - The state of the configuration after module completion
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged
"""
EXAMPLES = """
# Using merged

# Before state
# ------------
#
# admin# show interfaces
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#     }
# }

- name: Merge provided configuration with device configuration
  junipernetworks.junos.junos_l3_interfaces:
    config:
      - name: ge-0/0/1
        ipv4:
          - address: 192.168.1.10/24
        ipv6:
          - address: 8d8d:8d01::1/64
      - name: ge-0/0/2
        ipv4:
          - address: dhcp
    state: merged

# Task Output
# -----------
#
# before:
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'
# commands:
# - <nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#     <nc:interface>
#       <nc:name>ge-0/0/1</nc:name>
#       <nc:unit>
#         <nc:name>0</nc:name>
#         <nc:family>
#           <nc:inet>
#             <nc:address>
#               <nc:name>192.168.1.10/24</nc:name>
#             </nc:address>
#           </nc:inet>
#         </nc:family>
#         <nc:family>
#           <nc:inet6>
#             <nc:address>
#               <nc:name>8d8d:8d01::1/64</nc:name>
#             </nc:address>
#           </nc:inet6>
#         </nc:family>
#       </nc:unit>
#     </nc:interface>
#     <nc:interface>
#       <nc:name>ge-0/0/2</nc:name>
#       <nc:unit>
#         <nc:name>0</nc:name>
#         <nc:family>
#           <nc:inet>
#             <nc:dhcp/>
#           </nc:inet>
#         </nc:family>
#       </nc:unit>
#     </nc:interface>
#   </nc:interfaces>
# after:
# - ipv4:
#   - address: 192.168.1.10/24
#   ipv6:
#   - address: 8d8d:8d01::1/64
#   name: ge-0/0/1
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'

# After state:
# ------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet {
#             address 192.168.1.10/24;
#         }
#         family inet6 {
#             address 8d8d:8d01::1/64;
#         }
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#     }
# }

# Using overridden

# Before state
# ------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet {
#             address 192.168.1.10/24;
#         }
#         family inet6 {
#             address 8d8d:8d01::1/64;
#         }
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#     }
# }

- name: Override provided configuration with device configuration
  junipernetworks.junos.junos_l3_interfaces:
    config:
      - name: ge-0/0/1
        ipv4:
          - address: 192.168.1.10/24
      - ipv4:
          - address: dhcp
        name: fxp0
        unit: '0'
    state: overridden

# Task Output
# -----------
#
# before:
# - ipv4:
#   - address: 192.168.1.10/24
#   ipv6:
#   - address: 8d8d:8d01::1/64
#   name: ge-0/0/1
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'
# commands:
# - <nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#   <nc:interface>
#     <nc:name>ge-0/0/1</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:address delete="delete"/>
#         </nc:inet>
#         <nc:inet6>
#           <nc:address delete="delete"/>
#         </nc:inet6>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>ge-0/0/2</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:dhcp delete="delete"/>
#         </nc:inet>
#         <nc:inet6>
#           <nc:address delete="delete"/>
#         </nc:inet6>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>fxp0</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:dhcp delete="delete"/>
#         </nc:inet>
#         <nc:inet6>
#           <nc:address delete="delete"/>
#         </nc:inet6>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>ge-0/0/1</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:address>
#             <nc:name>192.168.1.10/24</nc:name>
#           </nc:address>
#         </nc:inet>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>fxp0</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:dhcp/>
#         </nc:inet>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
# </nc:interfaces>
# after:
# - ipv4:
#   - address: 192.168.1.10/24
#   name: ge-0/0/1
#   unit: '0'
# - name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'

# After state:
# ------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet {
#             address 192.168.1.10/24;
#         }
#         family inet6;
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet;
#         family inet6;
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }

# Using replaced

# Before state
# ------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet {
#             address 192.168.1.10/24;
#         }
#         family inet6;
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet;
#         family inet6;
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }

- name: Replace provided configuration with device configuration
  junipernetworks.junos.junos_l3_interfaces:
    config:
      - name: ge-0/0/1
        ipv4:
          - address: 192.168.1.10/24
        ipv6:
          - address: 8d8d:8d01::1/64
      - name: ge-0/0/2
        ipv4:
          - address: dhcp
    state: replaced

# Task Output
# -----------
#
# before:
# - ipv4:
#   - address: 192.168.1.10/24
#   name: ge-0/0/1
#   unit: '0'
# - name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'
# commands:
# - <nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#   <nc:interface>
#     <nc:name>ge-0/0/1</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:address delete="delete"/>
#         </nc:inet>
#         <nc:inet6>
#           <nc:address delete="delete"/>
#         </nc:inet6>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>ge-0/0/2</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet/>
#         <nc:inet6>
#           <nc:address delete="delete"/>
#         </nc:inet6>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>ge-0/0/1</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:address>
#             <nc:name>192.168.1.10/24</nc:name>
#           </nc:address>
#         </nc:inet>
#       </nc:family>
#       <nc:family>
#         <nc:inet6>
#           <nc:address>
#             <nc:name>8d8d:8d01::1/64</nc:name>
#           </nc:address>
#         </nc:inet6>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
#   <nc:interface>
#     <nc:name>ge-0/0/2</nc:name>
#     <nc:unit>
#       <nc:name>0</nc:name>
#       <nc:family>
#         <nc:inet>
#           <nc:dhcp/>
#         </nc:inet>
#       </nc:family>
#     </nc:unit>
#   </nc:interface>
# </nc:interfaces>
# after:
# - ipv4:
#   - address: 192.168.1.10/24
#   ipv6:
#   - address: 8d8d:8d01::1/64
#   name: ge-0/0/1
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'

# After state:
# ------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet {
#             address 192.168.1.10/24;
#         }
#         family inet6 {
#             address 8d8d:8d01::1/64;
#         }
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }

# Using deleted

# Before state:
# -------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet {
#             address 192.168.1.10/24;
#         }
#         family inet6 {
#             address 8d8d:8d01::1/64;
#         }
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }

- name: Delete L3 logical interface
  junipernetworks.junos.junos_l3_interfaces:
    config:
      - name: ge-0/0/1
      - name: ge-0/0/2
    state: deleted

# Task Output
# -----------
#
# before:
# - ipv4:
#   - address: 192.168.1.10/24
#   ipv6:
#   - address: 8d8d:8d01::1/64
#   name: ge-0/0/1
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'
# commands:
# - <nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#     <nc:interface>
#       <nc:name>ge-0/0/1</nc:name>
#       <nc:unit>
#         <nc:name>0</nc:name>
#         <nc:family>
#           <nc:inet>
#             <nc:address delete="delete"/>
#           </nc:inet>
#           <nc:inet6>
#             <nc:address delete="delete"/>
#           </nc:inet6>
#         </nc:family>
#       </nc:unit>
#     </nc:interface>
#     <nc:interface>
#       <nc:name>ge-0/0/2</nc:name>
#       <nc:unit>
#         <nc:name>0</nc:name>
#         <nc:family>
#           <nc:inet>
#             <nc:dhcp delete="delete"/>
#           </nc:inet>
#           <nc:inet6>
#             <nc:address delete="delete"/>
#           </nc:inet6>
#         </nc:family>
#       </nc:unit>
#     </nc:interface>
#   </nc:interfaces>
# after:
# - name: ge-0/0/1
#   unit: '0'
# - name: ge-0/0/2
#   unit: '0'
# - ipv4:
#   - address: dhcp
#   name: fxp0
#   unit: '0'

# After state:
# ------------
#
# admin# show interfaces
# ge-0/0/1 {
#     unit 0 {
#         family inet;
#         family inet6;
#     }
# }
# ge-0/0/2 {
#     unit 0 {
#         family inet;
#         family inet6;
#     }
# }
# fxp0 {
#     enable;
#     unit 0 {
#         family inet {
#             dhcp;
#         }
#         family inet6;
#     }
# }

# Using gathered

# Before state:
# ------------
#
# user@junos01# show interfaces
# ge-0/0/1 {
#     description "Configured by Ansible";
#     disable;
#     speed 100m;
#     mtu 1024;
#     hold-time up 2000 down 2200;
#     link-mode full-duplex;
#     unit 0 {
#         family ethernet-switching {
#             interface-mode access;
#             vlan {
#                 members vlan100;
#             }
#         }
#     }
# }
# ge-0/0/2 {
#     description "Configured by Ansible";
#     native-vlan-id 400;
#     speed 10m;
#     mtu 2048;
#     hold-time up 3000 down 3200;
#     unit 0 {
#         family ethernet-switching {
#             interface-mode trunk;
#             vlan {
#                 members [ vlan200 vlan300 ];
#             }
#         }
#     }
# }
# ge-1/0/0 {
#     unit 0 {
#         family inet {
#             address 192.168.100.1/24;
#             address 10.200.16.20/24;
#         }
#         family inet6;
#     }
# }
# ge-2/0/0 {
#     unit 0 {
#         family inet {
#             address 192.168.100.2/24;
#             address 10.200.16.21/24;
#         }
#         family inet6;
#     }
# }
# ge-3/0/0 {
#     unit 0 {
#         family inet {
#             address 192.168.100.3/24;
#             address 10.200.16.22/24;
#         }
#         family inet6;
#     }
# }
# em1 {
#     description TEST;
# }
# fxp0 {
#     description ANSIBLE;
#     speed 1g;
#     link-mode automatic;
#     unit 0 {
#         family inet {
#             address 10.8.38.38/24;
#         }
#     }
# }

- name: Gather layer3 interfaces facts
  junipernetworks.junos.junos_l3_interfaces:
    state: gathered

# Task Output
# -----------
#
# gathered:
# - ipv4:
#   - address: 192.168.100.1/24
#   - address: 10.200.16.20/24
#   name: ge-1/0/0
#   unit: '0'
# - ipv4:
#   - address: 192.168.100.2/24
#   - address: 10.200.16.21/24
#   name: ge-2/0/0
#   unit: '0'
# - ipv4:
#   - address: 192.168.100.3/24
#   - address: 10.200.16.22/24
#   name: ge-3/0/0
#   unit: '0'
# - ipv4:
#   - address: 10.8.38.38/24
#   name: fxp0
#   unit: '0'

# Using parsed

# parsed.cfg
# ------------
#
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <interfaces>
#             <interface>
#                 <name>ge-1/0/0</name>
#                 <unit>
#                     <name>0</name>
#                     <family>
#                         <inet>
#                             <address>
#                                 <name>192.168.100.1/24</name>
#                             </address>
#                             <address>
#                                 <name>10.200.16.20/24</name>
#                             </address>
#                         </inet>
#                         <inet6></inet6>
#                     </family>
#                 </unit>
#             </interface>
#             <interface>
#                 <name>ge-2/0/0</name>
#                 <unit>
#                     <name>0</name>
#                     <family>
#                         <inet>
#                             <address>
#                                 <name>192.168.100.2/24</name>
#                             </address>
#                             <address>
#                                 <name>10.200.16.21/24</name>
#                             </address>
#                         </inet>
#                         <inet6></inet6>
#                     </family>
#                 </unit>
#             </interface>
#         </interfaces>
#     </configuration>
# </rpc-reply>

# - name: Convert interfaces config to argspec without connecting to the appliance
#   junipernetworks.junos.junos_l3_interfaces:
#     running_config: "{{ lookup('file', './parsed.cfg') }}"
#     state: parsed

# Task Output
# -----------
#
# parsed:
# - ipv4:
#   - address: 192.168.100.1/24
#   - address: 10.200.16.20/24
#   name: ge-1/0/0
#   unit: '0'
# - ipv4:
#   - address: 192.168.100.2/24
#   - address: 10.200.16.21/24
#   name: ge-2/0/0
#   unit: '0'

# Using rendered

- name: Render platform specific xml from task input using rendered state
  junipernetworks.junos.junos_l3_interfaces:
    config:
      - name: ge-1/0/0
        ipv4:
          - address: 192.168.100.1/24
          - address: 10.200.16.20/24
        unit: 0
      - name: ge-2/0/0
        ipv4:
          - address: 192.168.100.2/24
          - address: 10.200.16.21/24
        unit: 0
    state: rendered

# Task Output
# -----------
#
# "rendered": "<nc:interfaces xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
#     <nc:interface>
#         <nc:name>ge-1/0/0</nc:name>
#         <nc:unit>
#             <nc:name>0</nc:name>
#             <nc:family>
#                 <nc:inet>
#                     <nc:address>
#                         <nc:name>192.168.100.1/24</nc:name>
#                     </nc:address>
#                     <nc:address>
#                         <nc:name>10.200.16.20/24</nc:name>
#                     </nc:address>
#                 </nc:inet>
#             </nc:family>
#         </nc:unit>
#     </nc:interface>
#     <nc:interface>
#         <nc:name>ge-2/0/0</nc:name>
#         <nc:unit>
#             <nc:name>0</nc:name>
#             <nc:family>
#                 <nc:inet>
#                     <nc:address>
#                         <nc:name>192.168.100.2/24</nc:name>
#                     </nc:address>
#                     <nc:address>
#                         <nc:name>10.200.16.21/24</nc:name>
#                     </nc:address>
#                 </nc:inet>
#             </nc:family>
#         </nc:unit>
#     </nc:interface>
# </nc:interfaces>"
"""

RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: list
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
  type: list
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['<nc:interfaces
    xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
    <nc:interface>
        <nc:name>ge-1/0/0</nc:name>
        <nc:unit>
            <nc:name>0</nc:name>
            <nc:family>
                <nc:inet>
                    <nc:address>
                        <nc:name>192.168.100.1/24</nc:name>
                    </nc:address>
                    <nc:address>
                        <nc:name>10.200.16.20/24</nc:name>
                    </nc:address>
                </nc:inet>
            </nc:family>
        </nc:unit>
</nc:interfaces>', 'xml 2', 'xml 3']
rendered:
  description: The provided configuration in the
    task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
    - <nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
gathered:
  description: Facts about the network resource gathered
    from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed
    into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.l3_interfaces.l3_interfaces import (
    L3_interfacesArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.l3_interfaces.l3_interfaces import (
    L3_interfaces,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    module = AnsibleModule(
        argument_spec=L3_interfacesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = L3_interfaces(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
