/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;

final class XMLTDSHeader {
    private boolean isSchemaPresent;
    private String databaseName;
    private String owningSchema;
    private String xmlSchemaCollection;

    XMLTDSHeader() {
    }

    XMLTDSHeader(byte[] byArray, int n) throws SQLServerException {
        this.readXMLTDSHeader(byArray, n);
    }

    int readXMLTDSHeader(byte[] byArray, int n) throws SQLServerException {
        int n2 = 0;
        if (0 == byArray[n]) {
            this.isSchemaPresent = false;
            return 1;
        }
        this.isSchemaPresent = true;
        int n3 = byArray[n + ++n2] & 0xFF;
        ++n2;
        if (n3 > 0) {
            Util.checkSingleByteLength(n3 * 2);
            this.databaseName = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        n3 = byArray[n + n2] & 0xFF;
        ++n2;
        if (n3 > 0) {
            Util.checkSingleByteLength(n3 * 2);
            this.owningSchema = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        n3 = Util.readShort(byArray, n + n2);
        n2 += 2;
        if (n3 > 0) {
            Util.checkDoubleByteLength(n3 * 2);
            this.xmlSchemaCollection = Util.readUnicodeString(byArray, n + n2, n3 * 2);
            n2 += n3 * 2;
        }
        return n2;
    }

    int writeXMLTDSHeader(byte[] byArray, int n) throws SQLServerException {
        int n2;
        int n3 = 0;
        if (this.isSchemaPresent) {
            byArray[n] = 1;
            ++n3;
        } else {
            byArray[n] = 0;
            return 1;
        }
        if (null == this.databaseName) {
            byArray[n + n3] = 0;
            ++n3;
        } else {
            n2 = this.databaseName.length();
            Util.checkSingleByteLength(n2);
            byArray[n + n3] = (byte)n2;
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.databaseName);
        }
        if (null == this.owningSchema) {
            byArray[n + n3] = 0;
            ++n3;
        } else {
            n2 = this.owningSchema.length();
            Util.checkSingleByteLength(n2);
            byArray[n + n3] = (byte)n2;
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.owningSchema);
        }
        if (null == this.xmlSchemaCollection) {
            byArray[n + n3] = 0;
            byArray[n + ++n3] = 0;
            ++n3;
        } else {
            n2 = this.xmlSchemaCollection.length();
            Util.checkDoubleByteLength(n2);
            byArray[n + n3] = (byte)(n2 & 0xFF);
            byArray[n + ++n3] = (byte)(n2 >> 8 & 0xFF);
            ++n3;
            n3 += Util.writeUnicodeString(byArray, n + n3, this.xmlSchemaCollection);
        }
        return n3;
    }
}

