/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DDLGenerator;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.apache.log4j.Logger;

public class DDLGeneratorListCellRenderer
extends DefaultListCellRenderer {
    private static final Logger logger = Logger.getLogger(DDLGeneratorListCellRenderer.class);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            try {
                Class c = (Class)value;
                Class<DDLGenerator> ddlgClass = c.asSubclass(DDLGenerator.class);
                DDLGenerator g = ddlgClass.newInstance();
                value = g.getName();
            }
            catch (Exception e) {
                logger.warn((Object)"Couldn't determine DDL Generator name. Just using class name...", (Throwable)e);
                value = value.getClass().getName();
            }
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }
}

