/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinput;

import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceServiceLocator;
import com.sforce.soap.partner.SoapBindingStub;
import com.sforce.soap.partner.sobject.SObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforceinput.Messages;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputData;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputField;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputMeta;

public class SalesforceInput
extends BaseStep
implements StepInterface {
    private SalesforceInputMeta meta;
    private SalesforceInputData data;

    public SalesforceInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public SoapBindingStub getBinding(String Url, String username, String password, String module, String condition, String timeout) throws KettleException {
        SoapBindingStub binding = null;
        LoginResult loginResult = null;
        GetUserInfoResult userInfo = null;
        try {
            int timeOut;
            binding = (SoapBindingStub)new SforceServiceLocator().getSoap();
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("SalesforceInput.Log.LoginURL") + " : " + binding._getProperty("javax.xml.rpc.service.endpoint.address"));
            }
            if ((timeOut = Const.toInt((String)timeout, (int)0)) > 0) {
                binding.setTimeout(timeOut);
            }
            binding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)Url);
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("SalesforceInput.Log.LoginNow"));
                this.logDetailed("----------------------------------------->");
                this.logDetailed(Messages.getString("SalesforceInput.Log.LoginURL", Url));
                this.logDetailed(Messages.getString("SalesforceInput.Log.LoginUsername", username));
                this.logDetailed(Messages.getString("SalesforceInput.Log.LoginModule", module));
                if (!Const.isEmpty((String)condition)) {
                    this.logDetailed(Messages.getString("SalesforceInput.Log.LoginCondition", condition));
                }
                this.logDetailed("<-----------------------------------------");
            }
            loginResult = binding.login(username, password);
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("SalesforceInput.Log.SessionId") + " : " + loginResult.getSessionId());
                this.logDebug(Messages.getString("SalesforceInput.Log.NewServerURL") + " : " + loginResult.getServerUrl());
            }
            binding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)loginResult.getServerUrl());
            SessionHeader sh = new SessionHeader();
            sh.setSessionId(loginResult.getSessionId());
            binding.setHeader(new SforceServiceLocator().getServiceName().getNamespaceURI(), "SessionHeader", (Object)sh);
            userInfo = binding.getUserInfo();
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("SalesforceInput.Log.UserInfos") + " : " + userInfo.getUserFullName());
                this.logDebug("----------------------------------------->");
                this.logDebug(Messages.getString("SalesforceInput.Log.UserName") + " : " + userInfo.getUserFullName());
                this.logDebug(Messages.getString("SalesforceInput.Log.UserEmail") + " : " + userInfo.getUserEmail());
                this.logDebug(Messages.getString("SalesforceInput.Log.UserLanguage") + " : " + userInfo.getUserLanguage());
                this.logDebug(Messages.getString("SalesforceInput.Log.UserOrganization") + " : " + userInfo.getOrganizationName());
                this.logDebug("<-----------------------------------------");
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        return binding;
    }

    public void connectSalesforce() throws KettleException {
        String username = this.environmentSubstitute(this.meta.getUserName());
        String password = this.environmentSubstitute(this.meta.getPassword());
        String module = this.environmentSubstitute(this.meta.getModule());
        String condition = this.environmentSubstitute(this.meta.getCondition());
        String timeout = this.environmentSubstitute(this.meta.getTimeOut());
        this.data.binding = this.getBinding(this.data.URL, username, password, module, condition, timeout);
        if (this.data.binding == null) {
            throw new KettleException(Messages.getString("SalesforceInput.Exception.CanNotGetBiding"));
        }
        try {
            DescribeSObjectResult describeSObjectResult = this.data.binding.describeSObject(module);
            if (describeSObjectResult == null) {
                throw new KettleException(Messages.getString("SalesforceInput.ErrorGettingObject"));
            }
            if (!describeSObjectResult.isQueryable()) {
                throw new KettleException(Messages.getString("SalesforceInputDialog.ObjectNotQueryable", module));
            }
            String SQLString = this.BuiltSQl();
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("SalesforceInput.Log.SQLString") + " : " + SQLString);
            }
            if (this.meta.includeSQL()) {
                this.data.SQL = SQLString;
            }
            if (this.meta.includeTimestamp()) {
                this.data.Timestamp = this.data.binding.getServerTimestamp().toString();
            }
            if (this.log.isDebug()) {
                Messages.getString("SalesforceInput.Log.ServerTimestamp", "" + this.data.binding.getServerTimestamp());
            }
            this.data.qr = this.data.binding.query(SQLString);
            this.data.limitReached = true;
            this.data.recordcount = this.data.qr.getSize();
            if (this.data.recordcount > 0) {
                this.data.limitReached = false;
                this.data.nrRecords = this.data.qr.getRecords().length;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("SalesforceInput.Log.RecordCount") + " : " + this.data.recordcount);
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            if (Const.isEmpty((String)this.meta.getModule())) {
                throw new KettleException(Messages.getString("SalesforceInputDialog.ModuleMissing.DialogMessage"));
            }
            if (Const.isEmpty((String)this.meta.getUserName())) {
                throw new KettleException(Messages.getString("SalesforceInputDialog.UsernameMissing.DialogMessage"));
            }
            this.data.limit = Const.toLong((String)this.environmentSubstitute(this.meta.getRowLimit()), (long)0L);
            this.data.URL = this.environmentSubstitute(this.meta.getTargetURL());
            this.data.Module = this.environmentSubstitute(this.meta.getModule());
            this.data.nrfields = this.meta.getInputFields().length;
            if (this.data.nrfields == 0) {
                throw new KettleException(Messages.getString("SalesforceInputDialog.FieldsMissing.DialogMessage"));
            }
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
            this.connectSalesforce();
        }
        if (this.log.isDebug()) {
            this.logDebug(Messages.getString("SalesforceInput.Log.Connected"));
        }
        Object[] outputRowData = null;
        boolean sendToErrorRow = false;
        String errorMessage = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(Messages.getString("SalesforceInput.log.LineRow", "" + this.getLinesInput()));
            }
            ++this.data.rownr;
            ++this.data.recordIndex;
            return true;
        }
        catch (KettleException e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(Messages.getString("SalesforceInput.log.Exception", e.getMessage()));
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "SalesforceInput001");
            }
            return true;
        }
    }

    private Object[] getOneRow() throws KettleException {
        if (this.data.limitReached || this.data.rownr >= (long)this.data.recordcount) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            RowMetaInterface irow;
            if (this.data.limit > 0L && this.data.rownr >= this.data.limit - 1L) {
                this.data.limitReached = true;
                return null;
            }
            if (this.data.rownr >= (long)this.data.nrRecords) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("SalesforceInput.Log.NeedQueryMore", "" + this.data.rownr), new Object[0]);
                }
                if (!this.data.qr.isDone()) {
                    this.data.qr = this.data.binding.queryMore(this.data.qr.getQueryLocator());
                    int nr = this.data.qr.getRecords().length;
                    this.data.nrRecords += nr;
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), Messages.getString("SalesforceInput.Log.QueryMoreRetrieved", "" + nr), new Object[0]);
                    }
                    this.data.recordIndex = 0;
                } else {
                    return null;
                }
            }
            SObject con = this.data.qr.getRecords()[this.data.recordIndex];
            for (int i = 0; i < this.data.nrfields; ++i) {
                String value = null;
                if (con.get_any()[i] != null) {
                    value = con.get_any()[i].getValue();
                }
                switch (this.meta.getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(i);
                outputRowData[i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)value)) continue;
                outputRowData[i] = this.data.previousRow[i];
            }
            int rowIndex = this.data.nrfields;
            if (this.meta.includeTargetURL() && !Const.isEmpty((String)this.meta.getTargetURLField())) {
                outputRowData[rowIndex++] = this.data.URL;
            }
            if (this.meta.includeModule() && !Const.isEmpty((String)this.meta.getModuleField())) {
                outputRowData[rowIndex++] = this.data.Module;
            }
            if (this.meta.includeSQL() && !Const.isEmpty((String)this.meta.getSQLField())) {
                outputRowData[rowIndex++] = this.data.SQL;
            }
            if (this.meta.includeTimestamp() && !Const.isEmpty((String)this.meta.getTimestampField())) {
                outputRowData[rowIndex++] = this.data.Timestamp;
            }
            if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                outputRowData[rowIndex++] = new Long(this.data.rownr);
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("SalesforceInput.Exception.CanNotReadFromSalesforce"), (Throwable)e);
        }
        return outputRowData;
    }

    private String BuiltSQl() {
        String sql = "SELECT ";
        SalesforceInputField[] fields = this.meta.getInputFields();
        for (int i = 0; i < this.data.nrfields; ++i) {
            SalesforceInputField field = fields[i];
            sql = sql + this.environmentSubstitute(field.getField());
            if (i >= this.data.nrfields - 1) continue;
            sql = sql + ",";
        }
        sql = sql + " FROM " + this.environmentSubstitute(this.meta.getModule());
        if (!Const.isEmpty((String)this.environmentSubstitute(this.meta.getCondition()))) {
            sql = sql + " WHERE " + this.environmentSubstitute(this.meta.getCondition().replace("\n\r", "").replace("\n", ""));
        }
        return sql;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceInputMeta)smi;
        this.data = (SalesforceInputData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceInputMeta)smi;
        this.data = (SalesforceInputData)sdi;
        try {
            if (!this.data.qr.isDone()) {
                this.data.qr.setDone(true);
                this.data.qr = null;
            }
            if (this.data.binding != null) {
                this.data.binding = null;
            }
            if (this.data.outputRowMeta != null) {
                this.data.outputRowMeta = null;
            }
            if (this.data.convertRowMeta != null) {
                this.data.convertRowMeta = null;
            }
            if (this.data.previousRow != null) {
                this.data.previousRow = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

