/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sqlfileoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sqlfileoutput.Messages;
import org.pentaho.di.trans.steps.sqlfileoutput.SQLFileOutput;
import org.pentaho.di.trans.steps.sqlfileoutput.SQLFileOutputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFileOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String schemaName;
    private String tablename;
    private boolean truncateTable;
    private boolean AddToResult;
    private boolean createTable;
    private String fileName;
    private String extension;
    private int splitEvery;
    private boolean fileAppended;
    private boolean stepNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private String encoding;
    private String dateformat;
    private boolean StartNewLine;
    private boolean createparentfolder;
    private boolean DoNotOpenNewFileInit;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        SQLFileOutputMeta retval = (SQLFileOutputMeta)super.clone();
        return retval;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDateFormat() {
        return this.dateformat;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDateFormat(String dateFormat) {
        this.dateformat = dateFormat;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public boolean truncateTable() {
        return this.truncateTable;
    }

    public boolean AddToResult() {
        return this.AddToResult;
    }

    public boolean StartNewLine() {
        return this.StartNewLine;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.DoNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean DoNotOpenNewFileInit) {
        this.DoNotOpenNewFileInit = DoNotOpenNewFileInit;
    }

    public boolean createTable() {
        return this.createTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public void setAddToResult(boolean AddToResult) {
        this.AddToResult = AddToResult;
    }

    public void setStartNewLine(boolean StartNewLine) {
        this.StartNewLine = StartNewLine;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public String[] getFiles(String fileName) {
        int nr;
        int copies = 1;
        int splits = 1;
        int parts = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * parts * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                for (int split = 0; split < splits; ++split) {
                    retval[i] = this.buildFilename(fileName, copy, split);
                    ++i;
                }
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(String fileName, int stepnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = fileName;
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = retval + "_" + t;
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.splitEvery > 0) {
            retval = retval + "_" + splitnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = retval + "." + this.extension;
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.truncateTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"truncate"));
            this.createTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"create"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.dateformat = XMLHandler.getTagValue((Node)stepnode, (String)"dateformat");
            this.AddToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"AddToResult"));
            this.StartNewLine = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"StartNewLine"));
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"create_parent_folder"));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"append"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.splitEvery = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"splitevery"), (int)0);
            this.DoNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"DoNotOpenNewFileInit"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.tablename = "";
        this.createparentfolder = false;
        this.DoNotOpenNewFileInit = false;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    " + XMLHandler.addTagValue((String)"table", (String)this.tablename));
        retval.append("    " + XMLHandler.addTagValue((String)"truncate", (boolean)this.truncateTable));
        retval.append("    " + XMLHandler.addTagValue((String)"create", (boolean)this.createTable));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"dateformat", (String)this.dateformat));
        retval.append("    " + XMLHandler.addTagValue((String)"addtoresult", (boolean)this.AddToResult));
        retval.append("    " + XMLHandler.addTagValue((String)"startnewline", (boolean)this.StartNewLine));
        retval.append("    <file>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      " + XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      " + XMLHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append("      " + XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("      " + XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("      " + XMLHandler.addTagValue((String)"DoNotOpenNewFileInit", (boolean)this.DoNotOpenNewFileInit));
        retval.append("      </file>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.truncateTable = rep.getStepAttributeBoolean(id_step, "truncate");
            this.createTable = rep.getStepAttributeBoolean(id_step, "create");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.dateformat = rep.getStepAttributeString(id_step, "dateformat");
            this.AddToResult = rep.getStepAttributeBoolean(id_step, "addtoresult");
            this.StartNewLine = rep.getStepAttributeBoolean(id_step, "startnewline");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.fileAppended = rep.getStepAttributeBoolean(id_step, "file_append");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_partnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.DoNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "DoNotOpenNewFileInit");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "truncate", this.truncateTable);
            rep.saveStepAttribute(id_transformation, id_step, "create", this.createTable);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "dateformat", this.dateformat);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresult", this.AddToResult);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_append", this.fileAppended);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_partnr", this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "DoNotOpenNewFileInit", this.DoNotOpenNewFileInit);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        block18: {
            if (this.databaseMeta != null) {
                cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.ConnectionExists"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                Database db = new Database(this.databaseMeta);
                try {
                    block17: {
                        try {
                            db.connect();
                            cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.ConnectionOk"), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            if (!Const.isEmpty((String)this.tablename)) {
                                String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tablename);
                                if (db.checkTableExists(schemaTable)) {
                                    cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.TableAccessible", schemaTable), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                    RowMetaInterface r = db.getTableFields(schemaTable);
                                    if (r != null) {
                                        cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.TableOk", schemaTable), (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                        String error_message = "";
                                        boolean error_found = false;
                                        if (prev != null && prev.size() > 0) {
                                            int idx;
                                            int i;
                                            cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.FieldsReceived", "" + prev.size()), (CheckResultSourceInterface)stepMeta);
                                            remarks.add((CheckResultInterface)cr);
                                            for (i = 0; i < prev.size(); ++i) {
                                                ValueMetaInterface pv = prev.getValueMeta(i);
                                                idx = r.indexOfValue(pv.getName());
                                                if (idx >= 0) continue;
                                                error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = Messages.getString("SQLFileOutputMeta.CheckResult.FieldsNotFoundInOutput", error_message);
                                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                                remarks.add((CheckResultInterface)cr);
                                            } else {
                                                cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.AllFieldsFoundInOutput"), (CheckResultSourceInterface)stepMeta);
                                                remarks.add((CheckResultInterface)cr);
                                            }
                                            for (i = 0; i < r.size(); ++i) {
                                                ValueMetaInterface rv = r.getValueMeta(i);
                                                idx = prev.indexOfValue(rv.getName());
                                                if (idx >= 0) continue;
                                                error_message = error_message + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                                error_found = true;
                                            }
                                            if (error_found) {
                                                error_message = Messages.getString("SQLFileOutputMeta.CheckResult.FieldsNotFound", error_message);
                                                cr = new CheckResult(3, error_message, (CheckResultSourceInterface)stepMeta);
                                                remarks.add((CheckResultInterface)cr);
                                                break block17;
                                            } else {
                                                cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.AllFieldsFound"), (CheckResultSourceInterface)stepMeta);
                                                remarks.add((CheckResultInterface)cr);
                                            }
                                            break block17;
                                        }
                                        cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.NoFields"), (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                        break block17;
                                    }
                                    cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.TableNotAccessible"), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                    break block17;
                                }
                                cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.TableError", schemaTable), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                break block17;
                            }
                            cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.NoTableName"), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                        catch (KettleException e) {
                            cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.UndefinedError", e.getMessage()), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            Object var18_19 = null;
                            db.disconnect();
                            break block18;
                        }
                    }
                    Object var18_18 = null;
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    db.disconnect();
                    throw throwable;
                }
                db.disconnect();
            } else {
                cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.NoConnection"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("SQLFileOutputMeta.CheckResult.ExpectedInputOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        cr = new CheckResult(4, Messages.getString("SQLFileOutputMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SQLFileOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SQLFileOutputData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.truncateTable) {
            DatabaseImpact ii = new DatabaseImpact(4, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tablename, "", "", "", "", "Truncate of table");
            impact.add(ii);
        }
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                ValueMetaInterface v = prev.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(2, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tablename, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta == null) {
            retval.setError(Messages.getString("SQLFileOutputMeta.Error.NoConnection"));
            return retval;
        }
        if (prev != null && prev.size() > 0) {
            if (Const.isEmpty((String)this.tablename)) {
                retval.setError(Messages.getString("SQLFileOutputMeta.Exception.TableNotSpecified"));
                return retval;
            }
            Database db = new Database(this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                try {
                    db.connect();
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tablename);
                    String cr_table = db.getDDL(schemaTable, prev);
                    if (cr_table == null || cr_table.length() == 0) {
                        cr_table = null;
                    }
                    retval.setSQL(cr_table);
                }
                catch (KettleDatabaseException dbe) {
                    retval.setError(Messages.getString("SQLFileOutputMeta.Error.ErrorConnecting", dbe.getMessage()));
                    Object var9_10 = null;
                    db.disconnect();
                    return retval;
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                db.disconnect();
                throw throwable;
            }
            db.disconnect();
            return retval;
        }
        retval.setError(Messages.getString("SQLFileOutputMeta.Error.NoInput"));
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        Database db;
        block5: {
            String realTableName = space.environmentSubstitute(this.tablename);
            String realSchemaName = space.environmentSubstitute(this.schemaName);
            if (this.databaseMeta == null) throw new KettleException(Messages.getString("SQLFileOutputMeta.Exception.ConnectionNotDefined"));
            db = new Database(this.databaseMeta);
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(Messages.getString("SQLFileOutputMeta.Exception.TableNotSpecified"));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (!db.checkTableExists(schemaTable)) break block5;
            RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
            Object var8_8 = null;
            db.disconnect();
            return rowMetaInterface;
        }
        try {
            try {
                throw new KettleException(Messages.getString("SQLFileOutputMeta.Exception.TableNotFound"));
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("SQLFileOutputMeta.Exception.ErrorGettingFields"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            db.disconnect();
            throw throwable;
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName));
            if (fileObject.exists()) {
                this.fileName = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                return this.fileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

