/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.Collections;
import java.util.Map;
import org.olap4j.impl.ArrayMap;
import org.olap4j.impl.Olap4jUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableArrayMap<K, V>
extends ArrayMap<K, V> {
    public UnmodifiableArrayMap(Map<K, V> map) {
        super(map);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static <K, V> Map<K, V> of(K key, V value, Object ... keyValues) {
        if (keyValues.length == 0) {
            return Collections.singletonMap(key, value);
        }
        return new UnmodifiableArrayMap<K, V>(Olap4jUtil.mapOf(key, value, keyValues));
    }

    public static <K, V> Map<K, V> of(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return new UnmodifiableArrayMap<K, V>(map);
    }
}

