/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fmt;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class HmtxTable
implements Table {
    private final int[] _hMetrics;
    private final short[] _leftSideBearing;
    private final int _length;

    public HmtxTable(DataInput dataInput, int n, HheaTable hheaTable, MaxpTable maxpTable) throws IOException {
        int n2;
        this._hMetrics = new int[hheaTable.getNumberOfHMetrics()];
        for (n2 = 0; n2 < hheaTable.getNumberOfHMetrics(); ++n2) {
            this._hMetrics[n2] = dataInput.readUnsignedByte() << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        n2 = maxpTable.getNumGlyphs() - hheaTable.getNumberOfHMetrics();
        this._leftSideBearing = new short[n2];
        for (int i = 0; i < n2; ++i) {
            this._leftSideBearing[i] = dataInput.readShort();
        }
        this._length = n;
    }

    @Override
    public int getType() {
        return 1752003704;
    }

    public int getAdvanceWidth(int n) {
        if (this._hMetrics == null) {
            return 0;
        }
        if (n < this._hMetrics.length) {
            return this._hMetrics[n] >>> 16;
        }
        return this._hMetrics[this._hMetrics.length - 1] >>> 16;
    }

    public short getLeftSideBearing(int n) {
        if (this._hMetrics == null) {
            return 0;
        }
        if (n < this._hMetrics.length) {
            return (short)(this._hMetrics[n] & 0xFFFF);
        }
        return this._leftSideBearing[n - this._hMetrics.length];
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'hmtx' Table - Horizontal Metrics\n");
        stringBuilder.append("---------------------------------\n");
        stringBuilder.append("        Size:   ").append(this._length).append(" bytes\n");
        stringBuilder.append("        Length: ").append(this._hMetrics.length).append(" entries\n");
        for (n = 0; n < this._hMetrics.length; ++n) {
            stringBuilder.append("        ").append(Fmt.pad(6, n)).append(": ");
            stringBuilder.append("adv=").append(this.getAdvanceWidth(n));
            stringBuilder.append(", lsb=").append(this.getLeftSideBearing(n));
            stringBuilder.append("\n");
        }
        for (n = 0; n < this._leftSideBearing.length; ++n) {
            stringBuilder.append("        ").append(Fmt.pad(6, n + this._hMetrics.length)).append(": ");
            stringBuilder.append("lsb=").append(this._leftSideBearing[n]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

