/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.SAMLLoginResponseMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class SAMLAudienceProtocolMapper
extends AbstractSAMLProtocolMapper
implements SAMLLoginResponseMapper {
    protected static final Logger logger = Logger.getLogger(SAMLAudienceProtocolMapper.class);
    public static final String PROVIDER_ID = "saml-audience-mapper";
    public static final String AUDIENCE_CATEGORY = "Audience mapper";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String INCLUDED_CLIENT_AUDIENCE = "included.client.audience";
    private static final String INCLUDED_CLIENT_AUDIENCE_LABEL = "included.client.audience.label";
    private static final String INCLUDED_CLIENT_AUDIENCE_HELP_TEXT = "included.client.audience.tooltip";
    public static final String INCLUDED_CUSTOM_AUDIENCE = "included.custom.audience";
    private static final String INCLUDED_CUSTOM_AUDIENCE_LABEL = "included.custom.audience.label";
    private static final String INCLUDED_CUSTOM_AUDIENCE_HELP_TEXT = "included.custom.audience.tooltip";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Audience";
    }

    public String getDisplayCategory() {
        return AUDIENCE_CATEGORY;
    }

    public String getHelpText() {
        return "Add specified audience to the audience conditions in the assertion.";
    }

    protected static AudienceRestrictionType locateAudienceRestriction(ResponseType response) {
        try {
            return ((ResponseType.RTChoiceType)response.getAssertions().get(0)).getAssertion().getConditions().getConditions().stream().filter(AudienceRestrictionType.class::isInstance).map(AudienceRestrictionType.class::cast).findFirst().orElse(null);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            logger.warn((Object)"Invalid SAML ResponseType to add the audience restriction", (Throwable)e);
            return null;
        }
    }

    @Override
    public ResponseType transformLoginResponse(ResponseType response, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AudienceRestrictionType aud;
        String audience = (String)mappingModel.getConfig().get(INCLUDED_CLIENT_AUDIENCE);
        if (audience == null || audience.isEmpty()) {
            audience = (String)mappingModel.getConfig().get(INCLUDED_CUSTOM_AUDIENCE);
        }
        if (audience != null && !audience.isEmpty() && (aud = SAMLAudienceProtocolMapper.locateAudienceRestriction(response)) != null) {
            logger.debugf("adding audience: %s", (Object)audience);
            try {
                aud.addAudience(URI.create(audience));
            }
            catch (IllegalArgumentException e) {
                logger.warnf((Throwable)e, "Invalid URI syntax for audience: %s", (Object)audience);
            }
        }
        return response;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(INCLUDED_CLIENT_AUDIENCE);
        property.setLabel(INCLUDED_CLIENT_AUDIENCE_LABEL);
        property.setHelpText(INCLUDED_CLIENT_AUDIENCE_HELP_TEXT);
        property.setType("ClientList");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(INCLUDED_CUSTOM_AUDIENCE);
        property.setLabel(INCLUDED_CUSTOM_AUDIENCE_LABEL);
        property.setHelpText(INCLUDED_CUSTOM_AUDIENCE_HELP_TEXT);
        property.setType("String");
        configProperties.add(property);
    }
}

