/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare.core;

import java.util.Locale;
import java.util.Set;
import liquibase.GlobalConfiguration;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.util.BooleanUtil;
import org.apache.commons.lang3.BooleanUtils;

public class ColumnComparator
implements DatabaseObjectComparator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Column.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    @Override
    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        Column column = (Column)databaseObject;
        String hash = column.getName();
        if (column.getRelation() != null) {
            hash = hash + ":" + column.getRelation().getName();
        }
        if (BooleanUtil.isTrue(column.getComputed())) {
            hash = hash + ":computed";
        }
        if (BooleanUtil.isTrue(column.getDescending())) {
            hash = hash + ":descending";
        }
        return new String[]{hash.toLowerCase(Locale.US)};
    }

    @Override
    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof Column) || !(databaseObject2 instanceof Column)) {
            return false;
        }
        Column thisColumn = (Column)databaseObject1;
        Column otherColumn = (Column)databaseObject2;
        if (!DefaultDatabaseObjectComparator.nameMatches(thisColumn, otherColumn, accordingTo)) {
            return false;
        }
        if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(thisColumn.getRelation(), otherColumn.getRelation(), chain.getSchemaComparisons(), accordingTo)) {
            return false;
        }
        if (BooleanUtil.isTrue(thisColumn.getComputed()) != BooleanUtil.isTrue(otherColumn.getComputed())) {
            return false;
        }
        if (BooleanUtils.isTrue((Boolean)thisColumn.getIncluded()) != BooleanUtils.isTrue((Boolean)otherColumn.getIncluded())) {
            return false;
        }
        return BooleanUtil.isTrue(thisColumn.getDescending()) == BooleanUtil.isTrue(otherColumn.getDescending());
    }

    @Override
    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("name");
        exclude.add("type");
        exclude.add("autoIncrementInformation");
        if (!GlobalConfiguration.DIFF_COLUMN_ORDER.getCurrentValue().booleanValue()) {
            exclude.add("order");
        }
        ObjectDifferences differences = chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
        DataType type1 = ((Column)databaseObject1).getType();
        DataType type2 = ((Column)databaseObject2).getType();
        differences.compare("name", databaseObject1, databaseObject2, new ObjectDifferences.DatabaseObjectNameCompareFunction(Column.class, accordingTo));
        this.compareTypes(databaseObject1, databaseObject2, accordingTo, type1, type2, differences);
        this.autoIncrementCompare((Column)databaseObject1, (Column)databaseObject2, accordingTo, compareControl, differences);
        return differences;
    }

    private void compareTypes(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DataType type1, DataType type2, ObjectDifferences differences) {
        if (accordingTo instanceof MSSQLDatabase && type1.getTypeName().equalsIgnoreCase("int") && type2.getTypeName().equalsIgnoreCase("int")) {
            type1.setColumnSize(null);
            type2.setColumnSize(null);
            ((DataType)((Object)databaseObject1.getAttribute("type", DataType.class))).setColumnSize(null);
            ((DataType)((Object)databaseObject2.getAttribute("type", DataType.class))).setColumnSize(null);
        }
        differences.compare("type", databaseObject1, databaseObject2, new ObjectDifferences.DatabaseObjectNameCompareFunction(Column.class, accordingTo));
    }

    private void autoIncrementCompare(Column databaseObject1, Column databaseObject2, Database accordingTo, CompareControl compareControl, ObjectDifferences differences) {
        boolean autoIncrement2;
        boolean autoIncrement1 = databaseObject1.isAutoIncrement();
        if (autoIncrement1 != (autoIncrement2 = databaseObject2.isAutoIncrement()) && !compareControl.isSuppressedField(Column.class, "autoIncrementInformation")) {
            differences.addDifference("autoIncrement", autoIncrement1, autoIncrement2);
        }
        if (accordingTo instanceof PostgresDatabase && autoIncrement1 && autoIncrement2) {
            String type2Name;
            boolean typesEquivalent;
            String type1Name = databaseObject1.getType().getTypeName();
            boolean bl = typesEquivalent = this.isPostgresAutoIncrementEquivalentType(type1Name, type2Name = databaseObject2.getType().getTypeName()) || this.isPostgresAutoIncrementEquivalentType(type2Name, type1Name);
            if (typesEquivalent) {
                differences.removeDifference("type");
            }
        }
    }

    private boolean isPostgresAutoIncrementEquivalentType(String type1, String type2) {
        if (type1.equalsIgnoreCase(type2)) {
            return true;
        }
        if (type1.equalsIgnoreCase("bigserial")) {
            return type2.equalsIgnoreCase("bigserial") || type2.equalsIgnoreCase("int8");
        }
        if (type1.equalsIgnoreCase("serial")) {
            return type2.equalsIgnoreCase("serial") || type2.equalsIgnoreCase("int4");
        }
        if (type1.equalsIgnoreCase("smallserial")) {
            return type2.equalsIgnoreCase("smallserial") || type2.equalsIgnoreCase("int2");
        }
        return false;
    }
}

