/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.libreoffice.report.pentaho.model.DataStyle;
import org.libreoffice.report.pentaho.model.FontFaceDeclsSection;
import org.libreoffice.report.pentaho.model.FontFaceElement;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;

public class StyleUtilities {
    private static final Logger LOGGER = Logger.getLogger(StyleUtilities.class.getName());
    private static final String STYLE = "style";

    private StyleUtilities() {
    }

    public static void copyStyle(String string, String string2, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2, OfficeStylesCollection officeStylesCollection3) throws ReportProcessingException {
        StyleUtilities.copyStyle(string, string2, officeStylesCollection, officeStylesCollection2, officeStylesCollection3, new HashSet<String>());
    }

    private static void copyStyle(String string, String string2, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2, OfficeStylesCollection officeStylesCollection3, Set<String> set) throws ReportProcessingException {
        if (set.contains(string2)) {
            return;
        }
        set.add(string2);
        if (officeStylesCollection.containsStyle(string, string2) || officeStylesCollection2.getCommonStyles().containsStyle(string, string2)) {
            return;
        }
        OfficeStyle officeStyle = officeStylesCollection3.getCommonStyles().getStyle(string, string2);
        if (officeStyle != null) {
            OfficeStyles officeStyles = officeStylesCollection2.getCommonStyles();
            StyleUtilities.copyStyleInternal(officeStyle, officeStyles, officeStylesCollection, officeStylesCollection2, officeStylesCollection3, string, set);
            return;
        }
        OfficeStyle officeStyle2 = officeStylesCollection3.getAutomaticStyles().getStyle(string, string2);
        if (officeStyle2 != null) {
            OfficeStyles officeStyles = officeStylesCollection.getAutomaticStyles();
            StyleUtilities.copyStyleInternal(officeStyle2, officeStyles, officeStylesCollection, officeStylesCollection2, officeStylesCollection3, string, set);
            return;
        }
        OfficeStyle officeStyle3 = new OfficeStyle();
        officeStyle3.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        officeStyle3.setType(STYLE);
        officeStyle3.setStyleFamily(string);
        officeStyle3.setStyleName(string2);
        OfficeStyles officeStyles = officeStylesCollection.getAutomaticStyles();
        officeStyles.addStyle(officeStyle3);
    }

    private static OfficeStyle copyStyleInternal(OfficeStyle officeStyle, OfficeStyles officeStyles, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2, OfficeStylesCollection officeStylesCollection3, String string, Set<String> set) throws ReportProcessingException {
        try {
            OfficeStyle officeStyle2 = (OfficeStyle)officeStyle.clone();
            officeStyles.addStyle(officeStyle2);
            StyleUtilities.performFontFaceProcessing(officeStyle2, officeStylesCollection, officeStylesCollection3);
            StyleUtilities.performDataStyleProcessing(officeStyle2, officeStylesCollection, officeStylesCollection3);
            String string2 = officeStyle2.getStyleParent();
            OfficeStyle officeStyle3 = officeStylesCollection.getStyle(string, string2);
            if (officeStyle3 != null) {
                StyleUtilities.copyStyle(string, string2, officeStylesCollection, officeStylesCollection2, officeStylesCollection3, set);
            } else if (string2 != null) {
                LOGGER.warning("Inconsistent styles: " + string + ":" + string2 + " does not exist.");
            }
            return officeStyle2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Failed to derive a stylesheet", cloneNotSupportedException);
        }
    }

    private static void performFontFaceProcessing(OfficeStyle officeStyle, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2) throws ReportProcessingException {
        Element element = officeStyle.getTextProperties();
        if (element == null) {
            return;
        }
        try {
            FontFaceElement fontFaceElement;
            Object object;
            Object object2;
            FontFaceDeclsSection fontFaceDeclsSection = officeStylesCollection.getFontFaceDecls();
            FontFaceDeclsSection fontFaceDeclsSection2 = officeStylesCollection2.getFontFaceDecls();
            String string = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name");
            if (string != null && !fontFaceDeclsSection.containsFont(string) && (object2 = fontFaceDeclsSection2.getFontFace(string)) != null) {
                fontFaceDeclsSection.addFontFace((FontFaceElement)((Section)object2).clone());
            }
            if ((object2 = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name-asian")) != null && !fontFaceDeclsSection.containsFont((String)object2) && (object = fontFaceDeclsSection2.getFontFace((String)object2)) != null) {
                fontFaceDeclsSection.addFontFace((FontFaceElement)((Section)object).clone());
            }
            if ((object = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name-complex")) != null && !fontFaceDeclsSection.containsFont((String)object) && (fontFaceElement = fontFaceDeclsSection2.getFontFace((String)object)) != null) {
                fontFaceDeclsSection.addFontFace((FontFaceElement)fontFaceElement.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Failed to clone font-face element", cloneNotSupportedException);
        }
    }

    private static void performDataStyleProcessing(OfficeStyle officeStyle, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2) throws ReportProcessingException {
        Section section = StyleUtilities.performDataStyleProcessing(officeStyle, officeStylesCollection, officeStylesCollection2, "data-style-name");
        if (section != null) {
            try {
                Section section2 = (Section)section.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "map");
                if (section2 != null) {
                    StyleUtilities.performDataStyleProcessing(section2, officeStylesCollection, officeStylesCollection2, "apply-style-name");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Section performDataStyleProcessing(Section section, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2, String string) throws ReportProcessingException {
        DataStyle dataStyle;
        Object object = section.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", string);
        if (object != null) {
            String string2 = String.valueOf(object);
            if (!officeStylesCollection.getAutomaticStyles().containsDataStyle(string2) && !officeStylesCollection.getCommonStyles().containsDataStyle(string2)) {
                try {
                    OfficeStyles officeStyles = officeStylesCollection2.getAutomaticStyles();
                    DataStyle dataStyle2 = officeStyles.getDataStyle(string2);
                    if (dataStyle2 != null) {
                        dataStyle = (DataStyle)dataStyle2.clone();
                        officeStylesCollection.getAutomaticStyles().addDataStyle(dataStyle);
                    }
                    OfficeStyles officeStyles2 = officeStylesCollection2.getCommonStyles();
                    DataStyle dataStyle3 = officeStyles2.getDataStyle(string2);
                    if (dataStyle3 != null) {
                        dataStyle = (DataStyle)dataStyle3.clone();
                        officeStylesCollection.getCommonStyles().addDataStyle(dataStyle);
                    }
                    LOGGER.warning("Dangling data style: " + string2);
                    dataStyle = null;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new ReportProcessingException("Failed to copy style. This should not have happened.", cloneNotSupportedException);
                }
            } else {
                dataStyle = null;
            }
        } else {
            dataStyle = null;
        }
        return dataStyle;
    }

    public static OfficeStyle deriveStyle(String string, String string2, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2, OfficeStylesCollection officeStylesCollection3, AttributeNameGenerator attributeNameGenerator) throws ReportProcessingException {
        Element element;
        OfficeStyle officeStyle;
        if (string == null) {
            throw new NullPointerException("StyleFamily must not be null");
        }
        if (string2 != null) {
            officeStyle = officeStylesCollection.getAutomaticStyles().getStyle(string, string2);
            if (officeStyle != null) {
                OfficeStyle officeStyle2 = StyleUtilities.deriveAutomaticStyle(officeStyle, string, string2, attributeNameGenerator, officeStylesCollection2, officeStylesCollection3);
                officeStylesCollection.getAutomaticStyles().addStyle(officeStyle2);
                return officeStyle2;
            }
            element = officeStylesCollection.getCommonStyles().getStyle(string, string2);
            if (element != null) {
                OfficeStyle officeStyle3 = StyleUtilities.deriveCommonStyle((OfficeStyle)element, string, string2, attributeNameGenerator, officeStylesCollection2, officeStylesCollection3);
                officeStylesCollection.getAutomaticStyles().addStyle(officeStyle3);
                return officeStyle3;
            }
            OfficeStyle officeStyle4 = officeStylesCollection2.getCommonStyles().getStyle(string, string2);
            if (officeStyle4 != null) {
                OfficeStyle officeStyle5 = StyleUtilities.deriveCommonStyle(officeStyle4, string, string2, attributeNameGenerator, officeStylesCollection2, officeStylesCollection3);
                officeStylesCollection.getAutomaticStyles().addStyle(officeStyle5);
                return officeStyle5;
            }
            OfficeStyle officeStyle6 = officeStylesCollection3.getAutomaticStyles().getStyle(string, string2);
            if (officeStyle6 != null) {
                OfficeStyle officeStyle7 = StyleUtilities.deriveAutomaticStyle(officeStyle6, string, string2, attributeNameGenerator, officeStylesCollection2, officeStylesCollection3);
                officeStylesCollection.getAutomaticStyles().addStyle(officeStyle7);
                return officeStyle7;
            }
            OfficeStyle officeStyle8 = officeStylesCollection3.getCommonStyles().getStyle(string, string2);
            if (officeStyle8 != null) {
                OfficeStyle officeStyle9 = StyleUtilities.deriveCommonStyle(officeStyle8, string, string2, attributeNameGenerator, officeStylesCollection2, officeStylesCollection3);
                officeStylesCollection.getAutomaticStyles().addStyle(officeStyle9);
                return officeStyle9;
            }
        }
        officeStyle = new OfficeStyle();
        officeStyle.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        officeStyle.setType(STYLE);
        officeStyle.setStyleFamily(string);
        if (string2 != null) {
            officeStyle.setStyleName(string2);
        } else {
            officeStyle.setStyleName(attributeNameGenerator.generateName("derived_anonymous"));
        }
        element = officeStylesCollection.getAutomaticStyles();
        ((OfficeStyles)element).addStyle(officeStyle);
        return officeStyle;
    }

    private static OfficeStyle deriveCommonStyle(OfficeStyle officeStyle, String string, String string2, AttributeNameGenerator attributeNameGenerator, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2) throws ReportProcessingException {
        OfficeStyle officeStyle2 = new OfficeStyle();
        officeStyle2.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        officeStyle2.setType(STYLE);
        officeStyle2.setStyleFamily(string);
        officeStyle2.setStyleName(attributeNameGenerator.generateName("derived_" + string2));
        officeStyle2.setStyleParent(string2);
        OfficeStyles officeStyles = officeStylesCollection.getCommonStyles();
        if (!officeStyles.containsStyle(string, string2)) {
            StyleUtilities.copyStyleInternal(officeStyle, officeStyles, officeStylesCollection, officeStylesCollection, officeStylesCollection2, string, new HashSet<String>());
        }
        return officeStyle2;
    }

    private static OfficeStyle deriveAutomaticStyle(OfficeStyle officeStyle, String string, String string2, AttributeNameGenerator attributeNameGenerator, OfficeStylesCollection officeStylesCollection, OfficeStylesCollection officeStylesCollection2) throws ReportProcessingException {
        try {
            OfficeStyle officeStyle2 = (OfficeStyle)officeStyle.clone();
            officeStyle2.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            officeStyle2.setType(STYLE);
            officeStyle2.setStyleFamily(string);
            officeStyle2.setStyleName(attributeNameGenerator.generateName("derived_auto_" + string2));
            String string3 = officeStyle2.getStyleParent();
            if (string3 != null) {
                StyleUtilities.copyStyle(string, string3, officeStylesCollection, officeStylesCollection, officeStylesCollection2);
            }
            return officeStyle2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Deriving the style failed. Clone error: ", cloneNotSupportedException);
        }
    }

    public static String queryStyle(OfficeStylesCollection officeStylesCollection, String string, String string2, String string3, String string4, String string5) {
        return StyleUtilities.queryStyle(officeStylesCollection, string, string2, string3, string4, string5, new HashSet<String>());
    }

    public static OfficeStyle queryStyleByProperties(OfficeStylesCollection officeStylesCollection, String string, String string2, ArrayList<?> arrayList, ArrayList<?> arrayList2, ArrayList<?> arrayList3) {
        if (arrayList.size() != arrayList2.size()) {
            return null;
        }
        OfficeStyle[] officeStyleArray = officeStylesCollection.getAutomaticStyles().getAllStyles();
        for (int i = 0; i < officeStyleArray.length; ++i) {
            int n;
            Element element;
            OfficeStyle officeStyle = officeStyleArray[i];
            if (!officeStyle.getStyleFamily().equals(string) || (element = officeStyle.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", string2)) == null) continue;
            for (n = 0; n < arrayList.size(); ++n) {
                String string3 = (String)arrayList.get(n);
                String string4 = (String)arrayList2.get(n);
                Object object = element.getAttribute(string3, string4);
                Object obj = arrayList3.get(n);
                if (object != null && obj != null && !arrayList3.get(n).equals(object)) break;
            }
            if (n != arrayList2.size()) continue;
            return officeStyle;
        }
        return null;
    }

    private static String queryStyle(OfficeStylesCollection officeStylesCollection, String string, String string2, String string3, String string4, String string5, Set<String> set) {
        Object object;
        if (set.contains(string2)) {
            return null;
        }
        set.add(string2);
        OfficeStyle officeStyle = officeStylesCollection.getStyle(string, string2);
        if (officeStyle == null) {
            return null;
        }
        Element element = officeStyle.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:style:1.0", string3);
        if (element != null && (object = element.getAttribute(string4, string5)) != null) {
            return String.valueOf(object);
        }
        object = officeStyle.getStyleParent();
        if (object == null) {
            return null;
        }
        return StyleUtilities.queryStyle(officeStylesCollection, string, (String)object, string3, string4, string5, set);
    }
}

