/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneFrustumBoundMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSE;
    public static final int FOV;
    public static final int FARDISTANCE;

    public XrSceneFrustumBoundMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneFrustumBoundMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef pose() {
        return XrSceneFrustumBoundMSFT.npose(this.address());
    }

    public XrFovf fov() {
        return XrSceneFrustumBoundMSFT.nfov(this.address());
    }

    public float farDistance() {
        return XrSceneFrustumBoundMSFT.nfarDistance(this.address());
    }

    public XrSceneFrustumBoundMSFT pose(XrPosef value) {
        XrSceneFrustumBoundMSFT.npose(this.address(), value);
        return this;
    }

    public XrSceneFrustumBoundMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSceneFrustumBoundMSFT fov(XrFovf value) {
        XrSceneFrustumBoundMSFT.nfov(this.address(), value);
        return this;
    }

    public XrSceneFrustumBoundMSFT fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrSceneFrustumBoundMSFT farDistance(float value) {
        XrSceneFrustumBoundMSFT.nfarDistance(this.address(), value);
        return this;
    }

    public XrSceneFrustumBoundMSFT set(XrPosef pose, XrFovf fov, float farDistance) {
        this.pose(pose);
        this.fov(fov);
        this.farDistance(farDistance);
        return this;
    }

    public XrSceneFrustumBoundMSFT set(XrSceneFrustumBoundMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneFrustumBoundMSFT malloc() {
        return (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneFrustumBoundMSFT calloc() {
        return (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneFrustumBoundMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneFrustumBoundMSFT create(long address) {
        return (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneFrustumBoundMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneFrustumBoundMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneFrustumBoundMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneFrustumBoundMSFT malloc(MemoryStack stack) {
        return (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneFrustumBoundMSFT calloc(MemoryStack stack) {
        return (XrSceneFrustumBoundMSFT)XrSceneFrustumBoundMSFT.wrap(XrSceneFrustumBoundMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneFrustumBoundMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static float nfarDistance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FARDISTANCE);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV), (long)XrFovf.SIZEOF);
    }

    public static void nfarDistance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)FARDISTANCE, value);
    }

    static {
        Struct.Layout layout = XrSceneFrustumBoundMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneFrustumBoundMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrSceneFrustumBoundMSFT.__member((int)XrFovf.SIZEOF, (int)XrFovf.ALIGNOF), XrSceneFrustumBoundMSFT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSE = layout.offsetof(0);
        FOV = layout.offsetof(1);
        FARDISTANCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSceneFrustumBoundMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneFrustumBoundMSFT ELEMENT_FACTORY = XrSceneFrustumBoundMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneFrustumBoundMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef pose() {
            return XrSceneFrustumBoundMSFT.npose(this.address());
        }

        public XrFovf fov() {
            return XrSceneFrustumBoundMSFT.nfov(this.address());
        }

        public float farDistance() {
            return XrSceneFrustumBoundMSFT.nfarDistance(this.address());
        }

        public Buffer pose(XrPosef value) {
            XrSceneFrustumBoundMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrSceneFrustumBoundMSFT.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        public Buffer farDistance(float value) {
            XrSceneFrustumBoundMSFT.nfarDistance(this.address(), value);
            return this;
        }
    }
}

