/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.internal;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.openhab.core.voice.DTService;
import org.openhab.core.voice.DTServiceHandle;
import org.openhab.core.voice.DialogContext;
import org.openhab.core.voice.DialogRegistration;
import org.openhab.core.voice.KSService;
import org.openhab.core.voice.RecognitionStartEvent;
import org.openhab.core.voice.RecognitionStopEvent;
import org.openhab.core.voice.STTException;
import org.openhab.core.voice.STTService;
import org.openhab.core.voice.STTServiceHandle;
import org.openhab.core.voice.SpeechRecognitionErrorEvent;
import org.openhab.core.voice.SpeechRecognitionEvent;
import org.openhab.core.voice.TTSException;
import org.openhab.core.voice.TTSService;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.VoiceManager;
import org.openhab.core.voice.internal.DialogProcessor;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.InterpretationException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.openhab.voice"}, property={"service.pid=org.openhab.voice"})
@ConfigurableService(category="system", label="Voice", description_uri="system:voice")
@NonNullByDefault
public class VoiceManagerImpl
implements VoiceManager,
ConfigOptionProvider,
DialogProcessor.DialogEventListener {
    public static final String CONFIGURATION_PID = "org.openhab.voice";
    private static final String DEFAULT_KEYWORD = "Wakeup";
    protected static final String CONFIG_URI = "system:voice";
    private static final String CONFIG_KEYWORD = "keyword";
    private static final String CONFIG_LISTENING_ITEM = "listeningItem";
    private static final String CONFIG_LISTENING_MELODY = "listeningMelody";
    private static final String CONFIG_DEFAULT_HLI = "defaultHLI";
    private static final String CONFIG_DEFAULT_KS = "defaultKS";
    private static final String CONFIG_DEFAULT_STT = "defaultSTT";
    private static final String CONFIG_DEFAULT_TTS = "defaultTTS";
    private static final String CONFIG_DEFAULT_VOICE = "defaultVoice";
    private static final String CONFIG_PREFIX_DEFAULT_VOICE = "defaultVoice.";
    private final Logger logger = LoggerFactory.getLogger(VoiceManagerImpl.class);
    private final ScheduledExecutorService scheduledExecutorService = ThreadPoolManager.getScheduledPool((String)"common");
    private final Map<String, KSService> ksServices = new HashMap<String, KSService>();
    private final Map<String, STTService> sttServices = new HashMap<String, STTService>();
    private final Map<String, TTSService> ttsServices = new HashMap<String, TTSService>();
    private final Map<String, HumanLanguageInterpreter> humanLanguageInterpreters = new HashMap<String, HumanLanguageInterpreter>();
    private final WeakHashMap<String, DialogContext> activeDialogGroups = new WeakHashMap();
    private final LocaleProvider localeProvider;
    private final AudioManager audioManager;
    private final EventPublisher eventPublisher;
    private final TranslationProvider i18nProvider;
    private final Storage<DialogRegistration> dialogRegistrationStorage;
    private @Nullable Bundle bundle;
    private String keyword = "Wakeup";
    private @Nullable String listeningItem;
    private @Nullable String listeningMelody;
    private @Nullable String defaultTTS;
    private @Nullable String defaultSTT;
    private @Nullable String defaultKS;
    private @Nullable String defaultHLI;
    private @Nullable String defaultVoice;
    private final Map<String, String> defaultVoices = new HashMap<String, String>();
    private final Map<String, DialogProcessor> dialogProcessors = new HashMap<String, DialogProcessor>();
    private final Map<String, DialogProcessor> singleDialogProcessors = new ConcurrentHashMap<String, DialogProcessor>();
    private @Nullable DialogContext lastDialogContext;
    private @Nullable ScheduledFuture<?> dialogRegistrationFuture;

    @Activate
    public VoiceManagerImpl(@Reference LocaleProvider localeProvider, @Reference AudioManager audioManager, @Reference EventPublisher eventPublisher, @Reference TranslationProvider i18nProvider, @Reference StorageService storageService) {
        this.localeProvider = localeProvider;
        this.audioManager = audioManager;
        this.eventPublisher = eventPublisher;
        this.i18nProvider = i18nProvider;
        this.dialogRegistrationStorage = storageService.getStorage(DialogRegistration.class.getName(), this.getClass().getClassLoader());
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> config) {
        this.bundle = bundleContext.getBundle();
        this.modified(config);
    }

    @Deactivate
    protected void deactivate() {
        this.dialogProcessors.values().forEach(DialogProcessor::stop);
        this.dialogProcessors.clear();
        ScheduledFuture<?> dialogRegistrationFuture = this.dialogRegistrationFuture;
        if (dialogRegistrationFuture != null) {
            dialogRegistrationFuture.cancel(true);
            this.dialogRegistrationFuture = null;
        }
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        if (config != null) {
            this.keyword = config.containsKey(CONFIG_KEYWORD) ? config.get(CONFIG_KEYWORD).toString() : DEFAULT_KEYWORD;
            this.listeningItem = config.containsKey(CONFIG_LISTENING_ITEM) ? config.get(CONFIG_LISTENING_ITEM).toString() : null;
            this.listeningMelody = config.containsKey(CONFIG_LISTENING_MELODY) ? config.get(CONFIG_LISTENING_MELODY).toString() : null;
            this.defaultTTS = config.containsKey(CONFIG_DEFAULT_TTS) ? config.get(CONFIG_DEFAULT_TTS).toString() : null;
            this.defaultSTT = config.containsKey(CONFIG_DEFAULT_STT) ? config.get(CONFIG_DEFAULT_STT).toString() : null;
            this.defaultKS = config.containsKey(CONFIG_DEFAULT_KS) ? config.get(CONFIG_DEFAULT_KS).toString() : null;
            this.defaultHLI = config.containsKey(CONFIG_DEFAULT_HLI) ? config.get(CONFIG_DEFAULT_HLI).toString() : null;
            this.defaultVoice = config.containsKey(CONFIG_DEFAULT_VOICE) ? config.get(CONFIG_DEFAULT_VOICE).toString() : null;
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(CONFIG_PREFIX_DEFAULT_VOICE)) continue;
                String tts = key.substring(CONFIG_PREFIX_DEFAULT_VOICE.length());
                this.defaultVoices.put(tts, entry.getValue().toString());
            }
        }
    }

    @Override
    public void say(String text) {
        this.say(text, null, null, null);
    }

    @Override
    public void say(String text, @Nullable PercentType volume) {
        this.say(text, null, null, volume);
    }

    @Override
    public void say(String text, String voiceId) {
        this.say(text, voiceId, null, null);
    }

    @Override
    public void say(String text, @Nullable String voiceId, @Nullable PercentType volume) {
        this.say(text, voiceId, null, volume);
    }

    @Override
    public void say(String text, @Nullable String voiceId, @Nullable String sinkId) {
        this.say(text, voiceId, sinkId, null);
    }

    @Override
    public void say(String text, @Nullable String voiceId, @Nullable String sinkId, @Nullable PercentType volume) {
        Objects.requireNonNull(text, "Text cannot be said as it is null.");
        try {
            TTSService tts = null;
            Voice voice = null;
            String selectedVoiceId = voiceId;
            if (selectedVoiceId == null) {
                selectedVoiceId = this.defaultVoice;
            }
            if (selectedVoiceId == null) {
                tts = this.getTTS();
                if (tts != null) {
                    voice = this.getPreferredVoice(tts.getAvailableVoices());
                }
            } else {
                voice = this.getVoice(selectedVoiceId);
                if (voice != null) {
                    tts = this.getTTS(voice);
                }
            }
            if (tts == null) {
                throw new TTSException("No TTS service can be found for voice " + selectedVoiceId);
            }
            if (voice == null) {
                throw new TTSException("Unable to find a voice for language " + this.localeProvider.getLocale().getLanguage());
            }
            Set<AudioFormat> ttsSupportedFormats = tts.getSupportedFormats();
            AudioSink sink = this.audioManager.getSink(sinkId);
            if (sink == null) {
                throw new TTSException("Unable to find the audio sink " + sinkId);
            }
            AudioFormat ttsAudioFormat = VoiceManagerImpl.getBestMatch(ttsSupportedFormats, sink.getSupportedFormats());
            if (ttsAudioFormat == null) {
                throw new TTSException("No compatible audio format found for TTS '" + tts.getId() + "' and sink '" + sink.getId() + "'");
            }
            AudioStream audioStream = tts.synthesize(text, voice, ttsAudioFormat);
            if (!sink.getSupportedStreams().stream().anyMatch(clazz -> clazz.isInstance(audioStream))) {
                throw new TTSException("Failed playing audio stream '" + String.valueOf(audioStream) + "' as audio sink doesn't support it");
            }
            Runnable restoreVolume = this.audioManager.handleVolumeCommand(volume, sink);
            ((CompletableFuture)sink.processAndComplete(audioStream).exceptionally(exception -> {
                this.logger.warn("Error playing '{}': {}", new Object[]{audioStream, exception.getMessage(), exception});
                return null;
            })).thenRun(restoreVolume);
        }
        catch (TTSException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error saying '{}': {}", new Object[]{text, e.getMessage(), e});
            }
            this.logger.warn("Error saying '{}': {}", (Object)text, (Object)e.getMessage());
        }
    }

    @Override
    public String transcribe(@Nullable String audioSourceId, @Nullable String sttId, @Nullable Locale locale) {
        AudioStream audioStream;
        STTService sttService;
        AudioSource audioSource;
        AudioSource audioSource2 = audioSource = audioSourceId != null ? this.audioManager.getSource(audioSourceId) : this.audioManager.getSource();
        if (audioSource == null) {
            this.logger.warn("Audio source '{}' not available", (Object)(audioSourceId != null ? audioSourceId : "default"));
            return "";
        }
        STTService sTTService = sttService = sttId != null ? this.getSTT(sttId) : this.getSTT();
        if (sttService == null) {
            this.logger.warn("Speech-to-text service '{}' not available", (Object)(sttId != null ? sttId : "default"));
            return "";
        }
        AudioFormat sttFormat = VoiceManagerImpl.getBestMatch(audioSource.getSupportedFormats(), sttService.getSupportedFormats());
        if (sttFormat == null) {
            this.logger.warn("No compatible audio format found for stt '{}' and the provided audio stream", (Object)sttService.getId());
            return "";
        }
        try {
            audioStream = audioSource.getInputStream(sttFormat);
        }
        catch (AudioException e) {
            this.logger.warn("AudioException creating source audio stream: {}", (Object)e.getMessage());
            return "";
        }
        return this.transcribe(audioStream, sttService, locale);
    }

    @Override
    public String transcribe(AudioStream audioStream, @Nullable String sttId, @Nullable Locale locale) {
        STTService sttService;
        STTService sTTService = sttService = sttId != null ? this.getSTT(sttId) : this.getSTT();
        if (sttService == null) {
            this.logger.warn("Speech-to-text service '{}' not available", (Object)(sttId != null ? sttId : "default"));
            return "";
        }
        AudioFormat sttFormat = VoiceManagerImpl.getBestMatch(Set.of(audioStream.getFormat()), sttService.getSupportedFormats());
        if (sttFormat == null) {
            this.logger.warn("No compatible audio format found for stt '{}' and the provided audio stream", (Object)sttService.getId());
            return "";
        }
        return this.transcribe(audioStream, sttService, locale);
    }

    private String transcribe(AudioStream audioStream, STTService sttService, @Nullable Locale locale) {
        STTServiceHandle sttServiceHandle;
        Locale nullSafeLocale = locale != null ? locale : this.localeProvider.getLocale();
        CompletableFuture transcriptionResult = new CompletableFuture();
        try {
            sttServiceHandle = sttService.recognize(sttEvent -> {
                if (sttEvent instanceof SpeechRecognitionEvent) {
                    SpeechRecognitionEvent sre = (SpeechRecognitionEvent)sttEvent;
                    this.logger.debug("SpeechRecognitionEvent event received");
                    String transcript = sre.getTranscript();
                    this.logger.debug("Text recognized: {}", (Object)transcript);
                    transcriptionResult.complete(transcript);
                } else if (sttEvent instanceof RecognitionStartEvent) {
                    this.logger.debug("RecognitionStartEvent event received");
                } else if (sttEvent instanceof RecognitionStopEvent) {
                    this.logger.debug("RecognitionStopEvent event received");
                } else if (sttEvent instanceof SpeechRecognitionErrorEvent) {
                    SpeechRecognitionErrorEvent sre = (SpeechRecognitionErrorEvent)sttEvent;
                    this.logger.debug("SpeechRecognitionErrorEvent event received");
                    transcriptionResult.completeExceptionally(new IOException("SpeechRecognitionErrorEvent emitted: " + sre.getMessage()));
                }
            }, audioStream, nullSafeLocale, new HashSet<String>());
        }
        catch (STTException e) {
            this.logger.warn("STTException while running transcription");
            return "";
        }
        try {
            return (String)transcriptionResult.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("InterruptedException waiting for transcription: {}", (Object)e.getMessage());
            sttServiceHandle.abort();
        }
        catch (ExecutionException e) {
            this.logger.warn("ExecutionException running transcription: {}", (Object)e.getCause().getMessage());
        }
        catch (TimeoutException e) {
            this.logger.warn("TimeoutException waiting for transcription");
            sttServiceHandle.abort();
        }
        return "";
    }

    @Override
    public String interpret(String text) throws InterpretationException {
        return this.interpret(text, null);
    }

    @Override
    public String interpret(String text, @Nullable String hliIdList) throws InterpretationException {
        List<Object> interpreters = new ArrayList();
        if (hliIdList == null) {
            HumanLanguageInterpreter interpreter = this.getHLI();
            if (interpreter != null) {
                interpreters.add(interpreter);
            }
        } else {
            interpreters = this.getHLIsByIds(hliIdList);
        }
        if (!interpreters.isEmpty()) {
            Locale locale = this.localeProvider.getLocale();
            InterpretationException exception = null;
            for (HumanLanguageInterpreter humanLanguageInterpreter : interpreters) {
                try {
                    String answer = humanLanguageInterpreter.interpret(locale, text);
                    this.logger.debug("Interpretation result: {}", (Object)answer);
                    return answer;
                }
                catch (InterpretationException e) {
                    this.logger.debug("Interpretation exception: {}", (Object)e.getMessage());
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        if (hliIdList == null) {
            throw new InterpretationException("No human language interpreter available!");
        }
        throw new InterpretationException("No human language interpreter can be found for " + hliIdList);
    }

    private @Nullable Voice getVoice(@Nullable String id) {
        if (id == null) {
            return null;
        }
        if (id.contains(":")) {
            String[] segments = id.split(":");
            TTSService tts = this.getTTS(segments[0]);
            if (tts != null) {
                return this.getVoice(tts.getAvailableVoices(), segments[1]);
            }
        } else {
            TTSService tts = this.getTTS();
            if (tts != null) {
                return this.getVoice(tts.getAvailableVoices(), id);
            }
        }
        return null;
    }

    private @Nullable Voice getVoice(Set<Voice> voices, String id) {
        for (Voice voice : voices) {
            if (!voice.getUID().endsWith(":" + id)) continue;
            return voice;
        }
        return null;
    }

    public static @Nullable AudioFormat getPreferredFormat(Set<AudioFormat> audioFormats) {
        for (AudioFormat currentAudioFormat : audioFormats) {
            if (currentAudioFormat.getCodec() == null || currentAudioFormat.getContainer() == null || currentAudioFormat.isBigEndian() == null || currentAudioFormat.getBitDepth() == null || currentAudioFormat.getBitRate() == null || currentAudioFormat.getFrequency() == null || !"WAVE".equals(currentAudioFormat.getContainer())) continue;
            return currentAudioFormat;
        }
        for (AudioFormat currentAudioFormat : audioFormats) {
            AudioFormat format = currentAudioFormat;
            if (format.getCodec() == null || format.getContainer() == null || !"WAVE".equals(format.getContainer())) continue;
            if (format.isBigEndian() == null) {
                format = new AudioFormat(format.getContainer(), format.getCodec(), Boolean.TRUE, format.getBitDepth(), format.getBitRate(), format.getFrequency());
            }
            if (format.getBitDepth() == null || format.getBitRate() == null || format.getFrequency() == null) {
                int defaultBitDepth = 16;
                long defaultFrequency = 44100L;
                Integer bitRate = format.getBitRate();
                Long frequency = format.getFrequency();
                Integer bitDepth = format.getBitDepth();
                if (bitRate == null) {
                    if (bitDepth == null) {
                        bitDepth = defaultBitDepth;
                    }
                    if (frequency == null) {
                        frequency = defaultFrequency;
                    }
                    bitRate = bitDepth * frequency.intValue();
                } else if (bitDepth == null) {
                    if (frequency == null) {
                        frequency = defaultFrequency;
                    }
                    bitDepth = bitRate / frequency.intValue();
                } else if (frequency == null) {
                    frequency = bitRate.longValue() / bitDepth.longValue();
                }
                format = new AudioFormat(format.getContainer(), format.getCodec(), format.isBigEndian(), bitDepth, bitRate, frequency);
            }
            return format;
        }
        return null;
    }

    public static @Nullable AudioFormat getBestMatch(Set<AudioFormat> inputs, Set<AudioFormat> outputs) {
        AudioFormat preferredFormat = VoiceManagerImpl.getPreferredFormat(inputs);
        for (AudioFormat output : outputs) {
            if (output.isCompatible(preferredFormat)) {
                return preferredFormat;
            }
            for (AudioFormat input : inputs) {
                if (!output.isCompatible(input)) continue;
                return input;
            }
        }
        return null;
    }

    @Override
    public @Nullable Voice getPreferredVoice(Set<Voice> voices) {
        Locale locale = this.localeProvider.getLocale();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (Voice currentVoice : voices) {
            locales.add(currentVoice.getLocale());
        }
        String ranges = locale.toLanguageTag();
        List<Locale.LanguageRange> languageRanges = Locale.LanguageRange.parse(ranges + "-*");
        Locale preferredLocale = Locale.lookup(languageRanges, locales);
        if (preferredLocale == null && !voices.isEmpty()) {
            preferredLocale = (Locale)locales.iterator().next();
        }
        if (preferredLocale == null) {
            return null;
        }
        Voice preferredVoice = null;
        for (Voice currentVoice : voices) {
            if (!preferredLocale.equals(currentVoice.getLocale())) continue;
            preferredVoice = currentVoice;
        }
        return preferredVoice;
    }

    @Override
    public DialogContext.Builder getDialogContextBuilder() {
        return new DialogContext.Builder(this.keyword, this.localeProvider.getLocale()).withSink(this.audioManager.getSink()).withSource(this.audioManager.getSource()).withKS(this.getKS()).withSTT(this.getSTT()).withTTS(this.getTTS()).withHLI(this.getHLI()).withVoice(this.getDefaultVoice()).withMelody(this.listeningMelody).withListeningItem(this.listeningItem);
    }

    @Override
    public List<DialogContext> getDialogsContexts() {
        return this.dialogProcessors.values().stream().map(DialogProcessor::getContext).toList();
    }

    @Override
    public @Nullable DialogContext getLastDialogContext() {
        return this.lastDialogContext;
    }

    @Override
    public @Nullable DTServiceHandle startDialog(DialogContext context) throws IllegalStateException {
        KSService ksService;
        DTService dtService = context.dt();
        String ksKeyword = context.keyword();
        if (dtService == null) {
            throw new IllegalStateException("Invalid dialog context for persistent dialog: missing dialog trigger implementation");
        }
        if (dtService instanceof KSService && (ksKeyword == null || ksKeyword.isEmpty())) {
            throw new IllegalStateException("Invalid dialog context for persistent dialog: missing keyword spot configuration");
        }
        Bundle b = this.bundle;
        if (b == null) {
            throw new IllegalStateException("Bundle is not (yet?) set.");
        }
        if (dtService instanceof KSService && !this.checkLocales((ksService = (KSService)dtService).getSupportedLocales(), context.locale()) || !this.checkLocales(context.stt().getSupportedLocales(), context.locale()) || !context.hlis().stream().allMatch(interpreter -> this.checkLocales(interpreter.getSupportedLocales(), context.locale()))) {
            throw new IllegalStateException("Cannot start dialog as provided locale is not supported by all services.");
        }
        DialogProcessor processor = this.dialogProcessors.get(context.source().getId());
        if (processor == null) {
            this.logger.debug("Starting a new dialog for source {} ({})", (Object)context.source().getLabel(null), (Object)context.source().getId());
            processor = new DialogProcessor(context, this, this.eventPublisher, this.activeDialogGroups, this.i18nProvider, b);
            this.dialogProcessors.put(context.source().getId(), processor);
            return processor.start();
        }
        throw new IllegalStateException(String.format("Cannot start dialog as a dialog is already started for audio source '%s'.", context.source().getLabel(null)));
    }

    @Override
    public void stopDialog(@Nullable AudioSource source) throws IllegalStateException {
        DialogProcessor processor;
        AudioSource audioSource;
        AudioSource audioSource2 = audioSource = source == null ? this.audioManager.getSource() : source;
        if (audioSource != null) {
            processor = this.dialogProcessors.remove(audioSource.getId());
            this.singleDialogProcessors.values().removeIf(e -> !e.isProcessing());
            if (processor == null) {
                processor = this.singleDialogProcessors.get(audioSource.getId());
            }
            if (processor == null) {
                throw new IllegalStateException(String.format("Cannot stop dialog as no dialog is started for audio source '%s'.", audioSource.getLabel(null)));
            }
        } else {
            throw new IllegalStateException("Cannot stop dialog as audio source is missing.");
        }
        processor.stop();
        this.logger.debug("Dialog stopped for source {} ({})", (Object)audioSource.getLabel(null), (Object)audioSource.getId());
    }

    @Override
    public void stopDialog(DialogContext context) throws IllegalStateException {
        this.stopDialog(context.source());
    }

    @Override
    public void listenAndAnswer(DialogContext context) throws IllegalStateException {
        Bundle b = this.bundle;
        if (b == null) {
            throw new IllegalStateException("Cannot execute a simple dialog as services are missing.");
        }
        if (!this.checkLocales(context.stt().getSupportedLocales(), context.locale()) || !context.hlis().stream().allMatch(interpreter -> this.checkLocales(interpreter.getSupportedLocales(), context.locale()))) {
            throw new IllegalStateException("Cannot execute a simple dialog as provided locale is not supported by all services.");
        }
        boolean isSingleDialog = false;
        AudioSource audioSource = context.source();
        DialogProcessor activeProcessor = this.dialogProcessors.get(audioSource.getId());
        this.singleDialogProcessors.values().removeIf(e -> !e.isProcessing());
        if (activeProcessor == null) {
            isSingleDialog = true;
            activeProcessor = this.singleDialogProcessors.get(audioSource.getId());
        }
        DialogProcessor processor = new DialogProcessor(context, this, this.eventPublisher, this.activeDialogGroups, this.i18nProvider, b);
        if (activeProcessor == null) {
            this.logger.debug("Executing a simple dialog for source {} ({})", (Object)audioSource.getLabel(null), (Object)audioSource.getId());
            processor.startSimpleDialog();
            this.singleDialogProcessors.put(audioSource.getId(), processor);
        } else if (!isSingleDialog && activeProcessor.isCompatible(processor)) {
            this.logger.debug("Executing a simple dialog for active source {} ({})", (Object)audioSource.getLabel(null), (Object)audioSource.getId());
            activeProcessor.startSimpleDialog();
        } else {
            throw new IllegalStateException(String.format("Cannot execute a simple dialog as a dialog is already started for audio source '%s'.", audioSource.getLabel(null)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDialog(DialogRegistration registration) throws IllegalStateException {
        if (this.dialogRegistrationStorage.containsKey(registration.sourceId)) {
            throw new IllegalStateException(String.format("Cannot register dialog as a dialog is registered for audio source '%s'.", registration.sourceId));
        }
        Storage<DialogRegistration> storage = this.dialogRegistrationStorage;
        synchronized (storage) {
            this.dialogRegistrationStorage.put(registration.sourceId, (Object)registration);
        }
        this.scheduleDialogRegistrations();
    }

    @Override
    public void unregisterDialog(DialogRegistration registration) {
        this.unregisterDialog(registration.sourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDialog(String sourceId) {
        Storage<DialogRegistration> storage = this.dialogRegistrationStorage;
        synchronized (storage) {
            DialogProcessor dialog;
            DialogRegistration registrationRef = (DialogRegistration)this.dialogRegistrationStorage.remove(sourceId);
            if (registrationRef != null && (dialog = this.dialogProcessors.get(sourceId)) != null) {
                this.stopDialog(dialog.dialogContext);
            }
        }
    }

    @Override
    public List<DialogRegistration> getDialogRegistrations() {
        ArrayList<DialogRegistration> list = new ArrayList<DialogRegistration>();
        this.dialogRegistrationStorage.getValues().forEach(dr -> {
            if (dr != null) {
                dr.running = this.dialogProcessors.containsKey(dr.sourceId);
                list.add((DialogRegistration)dr);
            }
        });
        return list;
    }

    private boolean checkLocales(Set<Locale> supportedLocales, Locale locale) {
        if (supportedLocales.isEmpty()) {
            return true;
        }
        return supportedLocales.stream().anyMatch(sLocale -> {
            String country = sLocale.getCountry();
            return Objects.equals(sLocale.getLanguage(), locale.getLanguage()) && (country == null || country.isBlank() || country.equals(locale.getCountry()));
        });
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAudioSink(AudioSink audioSink) {
        this.scheduleDialogRegistrations();
    }

    protected void removeAudioSink(AudioSink audioSink) {
        this.stopDialogs(dialog -> dialog.dialogContext.sink().getId().equals(audioSink.getId()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAudioSource(AudioSource audioSource) {
        this.scheduleDialogRegistrations();
    }

    protected void removeAudioSource(AudioSource audioSource) {
        this.stopDialogs(dialog -> dialog.dialogContext.source().getId().equals(audioSource.getId()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addKSService(KSService ksService) {
        this.ksServices.put(ksService.getId(), ksService);
        this.scheduleDialogRegistrations();
    }

    protected void removeKSService(KSService ksService) {
        this.ksServices.remove(ksService.getId());
        this.stopDialogs(dialog -> {
            DTService dt = dialog.dialogContext.dt();
            return dt != null && dt.getId().equals(ksService.getId());
        });
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSTTService(STTService sttService) {
        this.sttServices.put(sttService.getId(), sttService);
        this.scheduleDialogRegistrations();
    }

    protected void removeSTTService(STTService sttService) {
        this.sttServices.remove(sttService.getId());
        this.stopDialogs(dialog -> dialog.dialogContext.stt().getId().equals(sttService.getId()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTTSService(TTSService ttsService) {
        this.ttsServices.put(ttsService.getId(), ttsService);
        this.scheduleDialogRegistrations();
    }

    protected void removeTTSService(TTSService ttsService) {
        this.ttsServices.remove(ttsService.getId());
        this.stopDialogs(dialog -> dialog.dialogContext.tts().getId().equals(ttsService.getId()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addHumanLanguageInterpreter(HumanLanguageInterpreter humanLanguageInterpreter) {
        this.humanLanguageInterpreters.put(humanLanguageInterpreter.getId(), humanLanguageInterpreter);
        this.scheduleDialogRegistrations();
    }

    protected void removeHumanLanguageInterpreter(HumanLanguageInterpreter humanLanguageInterpreter) {
        this.humanLanguageInterpreters.remove(humanLanguageInterpreter.getId());
        this.stopDialogs(dialog -> dialog.dialogContext.hlis().stream().anyMatch(hli -> hli.getId().equals(humanLanguageInterpreter.getId())));
    }

    @Override
    public @Nullable TTSService getTTS() {
        TTSService tts = null;
        if (this.defaultTTS != null) {
            tts = this.ttsServices.get(this.defaultTTS);
            if (tts == null) {
                this.logger.warn("Default TTS service '{}' not available!", (Object)this.defaultTTS);
            }
        } else if (!this.ttsServices.isEmpty()) {
            tts = this.ttsServices.values().iterator().next();
        } else {
            this.logger.debug("No TTS service available!");
        }
        return tts;
    }

    @Override
    public @Nullable TTSService getTTS(@Nullable String id) {
        return id == null ? null : this.ttsServices.get(id);
    }

    private @Nullable TTSService getTTS(Voice voice) {
        return this.getTTS(voice.getUID().split(":")[0]);
    }

    @Override
    public Collection<TTSService> getTTSs() {
        return new HashSet<TTSService>(this.ttsServices.values());
    }

    @Override
    public @Nullable STTService getSTT() {
        STTService stt = null;
        if (this.defaultSTT != null) {
            stt = this.sttServices.get(this.defaultSTT);
            if (stt == null) {
                this.logger.warn("Default STT service '{}' not available!", (Object)this.defaultSTT);
            }
        } else if (!this.sttServices.isEmpty()) {
            stt = this.sttServices.values().iterator().next();
        } else {
            this.logger.debug("No STT service available!");
        }
        return stt;
    }

    @Override
    public @Nullable STTService getSTT(@Nullable String id) {
        return id == null ? null : this.sttServices.get(id);
    }

    @Override
    public Collection<STTService> getSTTs() {
        return new HashSet<STTService>(this.sttServices.values());
    }

    @Override
    public @Nullable KSService getKS() {
        KSService ks = null;
        if (this.defaultKS != null) {
            ks = this.ksServices.get(this.defaultKS);
            if (ks == null) {
                this.logger.warn("Default KS service '{}' not available!", (Object)this.defaultKS);
            }
        } else if (!this.ksServices.isEmpty()) {
            ks = this.ksServices.values().iterator().next();
        } else {
            this.logger.debug("No KS service available!");
        }
        return ks;
    }

    @Override
    public @Nullable KSService getKS(@Nullable String id) {
        return id == null ? null : this.ksServices.get(id);
    }

    @Override
    public Collection<KSService> getKSs() {
        return new HashSet<KSService>(this.ksServices.values());
    }

    @Override
    public @Nullable HumanLanguageInterpreter getHLI() {
        HumanLanguageInterpreter hli = null;
        if (this.defaultHLI != null) {
            hli = this.humanLanguageInterpreters.get(this.defaultHLI);
            if (hli == null) {
                this.logger.warn("Default HumanLanguageInterpreter '{}' not available!", (Object)this.defaultHLI);
            }
        } else if (!this.humanLanguageInterpreters.isEmpty()) {
            hli = this.humanLanguageInterpreters.values().iterator().next();
        } else {
            this.logger.debug("No HumanLanguageInterpreter available!");
        }
        return hli;
    }

    @Override
    public @Nullable HumanLanguageInterpreter getHLI(@Nullable String id) {
        return id == null ? null : this.humanLanguageInterpreters.get(id);
    }

    @Override
    public List<HumanLanguageInterpreter> getHLIsByIds(@Nullable String ids) {
        return ids == null ? List.of() : this.getHLIsByIds(Arrays.asList(ids.split(",")));
    }

    @Override
    public List<HumanLanguageInterpreter> getHLIsByIds(List<String> ids) {
        ArrayList<HumanLanguageInterpreter> interpreters = new ArrayList<HumanLanguageInterpreter>();
        for (String id : ids) {
            HumanLanguageInterpreter hli = this.humanLanguageInterpreters.get(id);
            if (hli == null) {
                this.logger.warn("HumanLanguageInterpreter '{}' not available!", (Object)id);
                continue;
            }
            interpreters.add(hli);
        }
        return interpreters;
    }

    @Override
    public Collection<HumanLanguageInterpreter> getHLIs() {
        return new HashSet<HumanLanguageInterpreter>(this.humanLanguageInterpreters.values());
    }

    @Override
    public Set<Voice> getAllVoices() {
        return this.getAllVoicesSorted(this.localeProvider.getLocale());
    }

    private Set<Voice> getAllVoicesSorted(Locale locale) {
        return this.ttsServices.values().stream().map(TTSService::getAvailableVoices).flatMap(Collection::stream).sorted(this.createVoiceComparator(locale)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    private Comparator<Voice> createVoiceComparator(Locale locale) {
        Comparator byTTSLabel = (v1, v2) -> {
            TTSService tts1 = this.getTTS((Voice)v1);
            TTSService tts2 = this.getTTS((Voice)v2);
            return tts1 == null || tts2 == null ? 0 : tts1.getLabel(locale).compareToIgnoreCase(tts2.getLabel(locale));
        };
        Comparator byVoiceLocale = (v1, v2) -> v1.getLocale().getDisplayName(locale).compareToIgnoreCase(v2.getLocale().getDisplayName(locale));
        return byTTSLabel.thenComparing(byVoiceLocale).thenComparing(Voice::getLabel);
    }

    @Override
    public @Nullable Voice getDefaultVoice() {
        String localDefaultVoice = this.defaultVoice;
        return localDefaultVoice != null ? this.getVoice(localDefaultVoice) : null;
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        block19: {
            if (!CONFIG_URI.equals(uri.toString())) break block19;
            switch (param) {
                case "defaultHLI": {
                    return this.humanLanguageInterpreters.values().stream().sorted((hli1, hli2) -> hli1.getLabel(locale).compareToIgnoreCase(hli2.getLabel(locale))).map(hli -> new ParameterOption(hli.getId(), hli.getLabel(locale))).toList();
                }
                case "defaultKS": {
                    return this.ksServices.values().stream().sorted((ks1, ks2) -> ks1.getLabel(locale).compareToIgnoreCase(ks2.getLabel(locale))).map(ks -> new ParameterOption(ks.getId(), ks.getLabel(locale))).toList();
                }
                case "defaultSTT": {
                    return this.sttServices.values().stream().sorted((stt1, stt2) -> stt1.getLabel(locale).compareToIgnoreCase(stt2.getLabel(locale))).map(stt -> new ParameterOption(stt.getId(), stt.getLabel(locale))).toList();
                }
                case "defaultTTS": {
                    return this.ttsServices.values().stream().sorted((tts1, tts2) -> tts1.getLabel(locale).compareToIgnoreCase(tts2.getLabel(locale))).map(tts -> new ParameterOption(tts.getId(), tts.getLabel(locale))).toList();
                }
                case "defaultVoice": {
                    Locale nullSafeLocale = locale != null ? locale : this.localeProvider.getLocale();
                    return this.getAllVoicesSorted(nullSafeLocale).stream().filter(v -> this.getTTS((Voice)v) != null).map(v -> new ParameterOption(v.getUID(), String.format("%s - %s - %s", this.getTTS((Voice)v).getLabel(nullSafeLocale), v.getLocale().getDisplayName(nullSafeLocale), v.getLabel()))).toList();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDialogs(Predicate<DialogProcessor> filter) {
        Storage<DialogRegistration> storage = this.dialogRegistrationStorage;
        synchronized (storage) {
            List<DialogProcessor> dialogsToStop = this.dialogProcessors.values().stream().filter(filter).toList();
            if (dialogsToStop.isEmpty()) {
                return;
            }
            for (DialogProcessor dialog : dialogsToStop) {
                this.stopDialog(dialog.dialogContext.source());
            }
        }
    }

    private void scheduleDialogRegistrations() {
        ScheduledFuture<?> job = this.dialogRegistrationFuture;
        if (job != null) {
            job.cancel(false);
        }
        this.dialogRegistrationFuture = this.scheduledExecutorService.schedule(this::buildDialogRegistrations, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDialogRegistrations() {
        Storage<DialogRegistration> storage = this.dialogRegistrationStorage;
        synchronized (storage) {
            this.dialogRegistrationStorage.getValues().forEach(dr -> {
                if (dr != null && !this.dialogProcessors.containsKey(dr.sourceId)) {
                    try {
                        this.startDialog(this.getDialogContextBuilder().withSink(this.audioManager.getSink(dr.sinkId)).withSource(this.audioManager.getSource(dr.sourceId)).withKS(this.getKS(dr.ksId)).withKeyword(dr.keyword).withSTT(this.getSTT(dr.sttId)).withTTS(this.getTTS(dr.ttsId)).withVoice(this.getVoice(dr.voiceId)).withHLIs(this.getHLIsByIds(dr.hliIds)).withLocale(dr.locale).withDialogGroup(dr.dialogGroup).withLocationItem(dr.locationItem).withListeningItem(dr.listeningItem).withMelody(dr.listeningMelody).build());
                    }
                    catch (IllegalStateException e) {
                        this.logger.debug("Unable to start dialog registration: {}", (Object)e.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void onBeforeDialogInterpretation(DialogContext context) {
        this.lastDialogContext = context;
    }

    @Override
    public void onDialogStopped(DialogContext context) {
        DialogRegistration registration = (DialogRegistration)this.dialogRegistrationStorage.get(context.source().getId());
        if (registration != null) {
            this.scheduleDialogRegistrations();
        }
    }
}

