/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.i18n;

import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;

@NonNullByDefault
public abstract class AbstractI18nException
extends RuntimeException {
    private String msgKey;
    private @Nullable Object @Nullable [] msgParams;

    protected AbstractI18nException(String message, Object ... msgParams) {
        this(message, null, msgParams);
    }

    protected AbstractI18nException(String message, @Nullable Throwable cause, Object ... msgParams) {
        super(I18nUtil.isConstant(message) ? null : message, cause);
        if (I18nUtil.isConstant(message)) {
            this.msgKey = I18nUtil.stripConstant(message);
            this.msgParams = msgParams;
        } else {
            this.msgKey = "";
        }
    }

    protected AbstractI18nException(Throwable cause) {
        super(cause);
        this.msgKey = "";
    }

    public @Nullable String getMessage(@Nullable Bundle bundle, @Nullable TranslationProvider i18nProvider) {
        return this.getLocalizedMessage(bundle, i18nProvider, Locale.ENGLISH);
    }

    public @Nullable String getLocalizedMessage(@Nullable Bundle bundle, @Nullable TranslationProvider i18nProvider, @Nullable Locale locale) {
        if (this.msgKey.isBlank() || bundle == null || i18nProvider == null) {
            return super.getMessage();
        }
        return i18nProvider.getText(bundle, this.msgKey, null, locale != null ? locale : Locale.ENGLISH, this.msgParams);
    }

    public @Nullable String getRawMessage() {
        if (this.msgKey.isBlank()) {
            return super.getMessage();
        }
        String result = "@text/" + this.msgKey;
        Object @Nullable [] params = this.msgParams;
        if (params != null && params.length > 0) {
            result = result + Stream.of(params).map(param -> String.format("\"%s\"", param == null ? "" : param.toString())).collect(Collectors.joining(", ", " [ ", " ]"));
        }
        return result;
    }
}

