/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomWriter
extends AbstractXmlWriter {
    private final Document document;
    private Element current;

    public DomWriter(Document document) {
        this(document, new XmlFriendlyReplacer());
    }

    public DomWriter(Element rootElement) {
        this(rootElement, new XmlFriendlyReplacer());
    }

    public DomWriter(Document document, XmlFriendlyReplacer replacer) {
        super(replacer);
        this.document = document;
        this.current = document.getDocumentElement();
    }

    public DomWriter(Element rootElement, XmlFriendlyReplacer replacer) {
        super(replacer);
        this.document = rootElement.getOwnerDocument();
        this.current = rootElement;
    }

    public void startNode(String name) {
        Element child = this.document.createElement(this.escapeXmlName(name));
        if (this.current == null) {
            this.document.appendChild(child);
        } else {
            this.current.appendChild(child);
        }
        this.current = child;
    }

    public void startNode(String name, Class clazz) {
        this.startNode(name);
    }

    public void addAttribute(String name, String value) {
        this.current.setAttribute(this.escapeXmlName(name), value);
    }

    public void setValue(String text) {
        this.current.appendChild(this.document.createTextNode(text));
    }

    public void endNode() {
        Node parent = this.current.getParentNode();
        this.current = parent instanceof Element ? (Element)parent : null;
    }

    public void flush() {
    }

    public void close() {
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }
}

