/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.util.net.openssl.OpenSSLX509Certificate;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLCertificateVerifier
implements CertificateVerifier {
    private static final Log log = LogFactory.getLog(OpenSSLCertificateVerifier.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLCertificateVerifier.class);
    private final X509TrustManager x509TrustManager;

    public OpenSSLCertificateVerifier(X509TrustManager x509TrustManager) {
        this.x509TrustManager = x509TrustManager;
    }

    public boolean verify(long ssl, byte[][] chain, String auth) {
        X509Certificate[] peerCerts = OpenSSLCertificateVerifier.certificates(chain);
        try {
            this.x509TrustManager.checkClientTrusted(peerCerts, auth);
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("openssl.certificateVerificationFailed"), (Throwable)e);
            }
            return false;
        }
    }

    private static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSSLX509Certificate(chain[i]);
        }
        return peerCerts;
    }
}

