/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.Format;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.memory.MemoryView;
import org.graalvm.visualvm.lib.ui.swing.ExportUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.renderer.CheckBoxRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;

abstract class LivenessTableView
extends MemoryView {
    private MemoryTableModel tableModel;
    private ProfilerTable table;
    private int nTrackedItems;
    private ClientUtils.SourceCodeSelection[] classNames;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private long[] nTrackedAllocObjects;
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final boolean includeTotalAllocs;
    private boolean filterZeroItems = true;
    private HideableBarRenderer[] renderers;
    private NumberRenderer[] renderersEx;

    LivenessTableView(Set<ClientUtils.SourceCodeSelection> selection, boolean includeTotalAllocs) {
        this.selection = selection;
        this.includeTotalAllocs = includeTotalAllocs;
        this.initUI();
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    private void setData(final int _nTrackedItems, final String[] _classNames, final int[] _nTrackedLiveObjects, final long[] _trackedLiveObjectsSize, final long[] _nTrackedAllocObjects, final float[] _avgObjectAge, final int[] _maxSurvGen, final int[] _nTotalAllocObjects, final boolean diff) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LivenessTableView.this.tableModel != null) {
                    LivenessTableView.this.nTrackedItems = _nTrackedItems;
                    LivenessTableView.access$202(LivenessTableView.this, new ClientUtils.SourceCodeSelection[_classNames.length]);
                    for (int i = 0; i < LivenessTableView.this.classNames.length; ++i) {
                        ((LivenessTableView)LivenessTableView.this).classNames[i] = new ClientUtils.SourceCodeSelection(_classNames[i], "*", null);
                    }
                    LivenessTableView.access$302(LivenessTableView.this, _nTrackedLiveObjects);
                    LivenessTableView.access$402(LivenessTableView.this, _trackedLiveObjectsSize);
                    LivenessTableView.access$502(LivenessTableView.this, _nTrackedAllocObjects);
                    LivenessTableView.access$602(LivenessTableView.this, _avgObjectAge);
                    LivenessTableView.access$702(LivenessTableView.this, _maxSurvGen);
                    if (LivenessTableView.this.includeTotalAllocs) {
                        LivenessTableView.access$902(LivenessTableView.this, _nTotalAllocObjects);
                    }
                    long liveBytes = 0L;
                    long _liveBytes = 0L;
                    long liveObjects = 0L;
                    long _liveObjects = 0L;
                    long allocObjects = 0L;
                    long _allocObjects = 0L;
                    long totalAllocObjects = 0L;
                    long _totalAllocObjects = 0L;
                    for (int i = 0; i < LivenessTableView.this.nTrackedItems; ++i) {
                        if (diff) {
                            liveBytes = Math.max(liveBytes, LivenessTableView.this.trackedLiveObjectsSize[i]);
                            _liveBytes = Math.min(_liveBytes, LivenessTableView.this.trackedLiveObjectsSize[i]);
                            liveObjects = Math.max(liveObjects, (long)LivenessTableView.this.nTrackedLiveObjects[i]);
                            _liveObjects = Math.min(_liveObjects, (long)LivenessTableView.this.nTrackedLiveObjects[i]);
                            allocObjects = Math.max(allocObjects, LivenessTableView.this.nTrackedAllocObjects[i]);
                            _allocObjects = Math.min(_allocObjects, LivenessTableView.this.nTrackedAllocObjects[i]);
                            if (!LivenessTableView.this.includeTotalAllocs) continue;
                            totalAllocObjects = Math.max(totalAllocObjects, (long)LivenessTableView.this.nTotalAllocObjects[i]);
                            _totalAllocObjects = Math.min(_totalAllocObjects, (long)LivenessTableView.this.nTotalAllocObjects[i]);
                            continue;
                        }
                        liveBytes += LivenessTableView.this.trackedLiveObjectsSize[i];
                        liveObjects += (long)LivenessTableView.this.nTrackedLiveObjects[i];
                        allocObjects += LivenessTableView.this.nTrackedAllocObjects[i];
                        if (!LivenessTableView.this.includeTotalAllocs) continue;
                        totalAllocObjects += (long)LivenessTableView.this.nTotalAllocObjects[i];
                    }
                    if (diff) {
                        LivenessTableView.this.renderers[0].setMaxValue(Math.max(Math.abs(liveBytes), Math.abs(_liveBytes)));
                        LivenessTableView.this.renderers[1].setMaxValue(Math.max(Math.abs(liveObjects), Math.abs(_liveObjects)));
                        LivenessTableView.this.renderers[2].setMaxValue(Math.max(Math.abs(allocObjects), Math.abs(_allocObjects)));
                        if (LivenessTableView.this.includeTotalAllocs) {
                            LivenessTableView.this.renderers[3].setMaxValue(Math.max(Math.abs(totalAllocObjects), Math.abs(_totalAllocObjects)));
                        }
                    } else {
                        LivenessTableView.this.renderers[0].setMaxValue(liveBytes);
                        LivenessTableView.this.renderers[1].setMaxValue(liveObjects);
                        LivenessTableView.this.renderers[2].setMaxValue(allocObjects);
                        if (LivenessTableView.this.includeTotalAllocs) {
                            LivenessTableView.this.renderers[3].setMaxValue(totalAllocObjects);
                        }
                    }
                    LivenessTableView.this.renderers[0].setDiffMode(diff);
                    LivenessTableView.this.renderers[1].setDiffMode(diff);
                    LivenessTableView.this.renderers[2].setDiffMode(diff);
                    if (LivenessTableView.this.includeTotalAllocs) {
                        LivenessTableView.this.renderers[3].setDiffMode(diff);
                    }
                    LivenessTableView.this.renderersEx[0].setDiffMode(diff);
                    LivenessTableView.this.renderersEx[1].setDiffMode(diff);
                    LivenessTableView.this.tableModel.fireTableDataChanged();
                }
            }
        });
    }

    @Override
    public void setData(MemoryResultsSnapshot snapshot, GenericFilter filter, int aggregation) {
        LivenessMemoryResultsSnapshot _snapshot = (LivenessMemoryResultsSnapshot)snapshot;
        boolean diff = _snapshot instanceof LivenessMemoryResultsDiff;
        String[] _classNames = _snapshot.getClassNames();
        int[] _nTrackedLiveObjects = _snapshot.getNTrackedLiveObjects();
        long[] _trackedLiveObjectsSize = _snapshot.getTrackedLiveObjectsSize();
        long[] _nTrackedAllocObjects = _snapshot.getNTrackedAllocObjects();
        float[] _avgObjectAge = _snapshot.getAvgObjectAge();
        int[] _maxSurvGen = _snapshot.getMaxSurvGen();
        int[] _nTotalAllocObjects = _snapshot.getnTotalAllocObjects();
        int _nTrackedItems = Math.min(_snapshot.getNProfiledClasses(), _classNames.length);
        _nTrackedItems = Math.min(_nTrackedItems, _nTotalAllocObjects.length);
        if (filter == null) {
            this.filterZeroItems = !diff;
            this.setData(_nTrackedItems, _classNames, _nTrackedLiveObjects, _trackedLiveObjectsSize, _nTrackedAllocObjects, _avgObjectAge, _maxSurvGen, _nTotalAllocObjects, diff);
        } else {
            this.filterZeroItems = false;
            ArrayList<String> fClassNames = new ArrayList<String>();
            ArrayList<Integer> fTrackedLiveObjects = new ArrayList<Integer>();
            ArrayList<Long> fTrackedLiveObjectsSize = new ArrayList<Long>();
            ArrayList<Long> fTrackedAllocObjects = new ArrayList<Long>();
            ArrayList<Float> fAvgObjectAge = new ArrayList<Float>();
            ArrayList<Integer> fMaxSurvGen = new ArrayList<Integer>();
            for (int i = 0; i < _nTrackedItems; ++i) {
                if (!filter.passes(_classNames[i].replace('.', '/'))) continue;
                fClassNames.add(_classNames[i]);
                fTrackedLiveObjects.add(_nTrackedLiveObjects[i]);
                fTrackedLiveObjectsSize.add(_trackedLiveObjectsSize[i]);
                fTrackedAllocObjects.add(_nTrackedAllocObjects[i]);
                fAvgObjectAge.add(Float.valueOf(_avgObjectAge[i]));
                fMaxSurvGen.add(_maxSurvGen[i]);
            }
            int trackedItems = fClassNames.size();
            String[] aClassNames = fClassNames.toArray(new String[0]);
            int[] aTrackedLiveObjects = new int[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aTrackedLiveObjects[i] = (Integer)fTrackedLiveObjects.get(i);
            }
            long[] aTrackedLiveObjectsSize = new long[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aTrackedLiveObjectsSize[i] = (Long)fTrackedLiveObjectsSize.get(i);
            }
            long[] aTrackedAllocObjects = new long[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aTrackedAllocObjects[i] = (Long)fTrackedAllocObjects.get(i);
            }
            float[] aAvgObjectAge = new float[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aAvgObjectAge[i] = ((Float)fAvgObjectAge.get(i)).floatValue();
            }
            int[] aMaxSurvGen = new int[trackedItems];
            for (int i = 0; i < trackedItems; ++i) {
                aMaxSurvGen[i] = (Integer)fMaxSurvGen.get(i);
            }
            this.setData(trackedItems, aClassNames, aTrackedLiveObjects, aTrackedLiveObjectsSize, aTrackedAllocObjects, aAvgObjectAge, aMaxSurvGen, _nTotalAllocObjects, diff);
        }
    }

    @Override
    public void resetData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LivenessTableView.this.nTrackedItems = 0;
                LivenessTableView.access$202(LivenessTableView.this, null);
                LivenessTableView.access$302(LivenessTableView.this, null);
                LivenessTableView.access$402(LivenessTableView.this, null);
                LivenessTableView.access$502(LivenessTableView.this, null);
                LivenessTableView.access$602(LivenessTableView.this, null);
                LivenessTableView.access$702(LivenessTableView.this, null);
                LivenessTableView.access$902(LivenessTableView.this, null);
                LivenessTableView.this.renderers[0].setMaxValue(0L);
                LivenessTableView.this.renderers[1].setMaxValue(0L);
                LivenessTableView.this.renderers[2].setMaxValue(0L);
                if (LivenessTableView.this.includeTotalAllocs) {
                    LivenessTableView.this.renderers[3].setMaxValue(0L);
                }
                LivenessTableView.this.renderers[0].setDiffMode(false);
                LivenessTableView.this.renderers[1].setDiffMode(false);
                LivenessTableView.this.renderers[2].setDiffMode(false);
                if (LivenessTableView.this.includeTotalAllocs) {
                    LivenessTableView.this.renderers[3].setDiffMode(false);
                }
                LivenessTableView.this.renderersEx[0].setDiffMode(false);
                LivenessTableView.this.renderersEx[1].setDiffMode(false);
                LivenessTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_ALLOCATED_LIVE);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_ALLOCATED_LIVE);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        final int offset = this.selection == null ? -1 : 0;
        this.tableModel = new MemoryTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return LivenessTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                LivenessTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                LivenessTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LivenessTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray2[2] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray2[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray2[4] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray2[5] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[6] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray3[3] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray3[4] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray3[5] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray3[6] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[7] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        this.table.setMainColumn(1 + offset);
        this.table.setFitWidthColumn(1 + offset);
        this.table.setSortColumn(2 + offset);
        this.table.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.table.setColumnVisibility(5 + offset, false);
        if (this.includeTotalAllocs) {
            this.table.setColumnVisibility(7 + offset, false);
        }
        this.table.addRowFilter(new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                return !LivenessTableView.this.filterZeroItems || ((Number)entry.getValue(4 + offset)).intValue() > 0;
            }
        });
        this.renderers = new HideableBarRenderer[4];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[2] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[3] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        this.renderers[2].setMaxValue(12345678L);
        this.renderers[3].setMaxValue(12345678L);
        this.renderersEx = new NumberRenderer[2];
        this.renderersEx[0] = new NumberRenderer(){

            @Override
            protected String getValueString(Object value, int row, Format format) {
                if (value == null) {
                    return "-";
                }
                float _value = ((Float)value).floatValue();
                String s = StringUtils.floatPerCentToString((float)_value);
                if (this.renderingDiff && _value >= 0.0f) {
                    s = '+' + s;
                }
                return s;
            }
        };
        this.renderersEx[1] = new NumberRenderer();
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer());
        }
        this.table.setColumnRenderer(1 + offset, new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(2 + offset, this.renderers[0]);
        this.table.setColumnRenderer(3 + offset, this.renderers[1]);
        this.table.setColumnRenderer(4 + offset, this.renderers[2]);
        this.table.setColumnRenderer(5 + offset, this.renderersEx[0]);
        this.table.setColumnRenderer(6 + offset, this.renderersEx[1]);
        if (this.includeTotalAllocs) {
            this.table.setColumnRenderer(7 + offset, this.renderers[3]);
        }
        if (this.selection != null) {
            int w = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, w + 15);
        }
        this.table.setDefaultColumnWidth(2 + offset, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(3 + offset, this.renderers[1].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(4 + offset, this.renderers[2].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(5 + offset, this.renderers[2].getNoBarWidth() - 25);
        this.table.setDefaultColumnWidth(6 + offset, this.renderers[2].getNoBarWidth() - 25);
        if (this.includeTotalAllocs) {
            this.table.setDefaultColumnWidth(7 + offset, this.renderers[3].getMaxNoBarWidth());
        }
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        if (this.nTrackedItems == 0 || row == -1) {
            return null;
        }
        if (row >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.classNames[this.table.convertRowIndexToModel(row)];
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$202(LivenessTableView x0, ClientUtils.SourceCodeSelection[] x1) {
        x0.classNames = x1;
        return x1;
    }

    static /* synthetic */ int[] access$302(LivenessTableView x0, int[] x1) {
        x0.nTrackedLiveObjects = x1;
        return x1;
    }

    static /* synthetic */ long[] access$402(LivenessTableView x0, long[] x1) {
        x0.trackedLiveObjectsSize = x1;
        return x1;
    }

    static /* synthetic */ long[] access$502(LivenessTableView x0, long[] x1) {
        x0.nTrackedAllocObjects = x1;
        return x1;
    }

    static /* synthetic */ float[] access$602(LivenessTableView x0, float[] x1) {
        x0.avgObjectAge = x1;
        return x1;
    }

    static /* synthetic */ int[] access$702(LivenessTableView x0, int[] x1) {
        x0.maxSurvGen = x1;
        return x1;
    }

    static /* synthetic */ int[] access$902(LivenessTableView x0, int[] x1) {
        x0.nTotalAllocObjects = x1;
        return x1;
    }

    private class MemoryTableModel
    extends AbstractTableModel {
        private final int columns;

        private MemoryTableModel() {
            this.columns = 6 + (LivenessTableView.this.selection == null ? 0 : 1) + (LivenessTableView.this.includeTotalAllocs ? 1 : 0);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (LivenessTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return MemoryView.COLUMN_LIVE_BYTES;
            }
            if (columnIndex == 3) {
                return MemoryView.COLUMN_LIVE_OBJECTS;
            }
            if (columnIndex == 4) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (columnIndex == 5) {
                return MemoryView.COLUMN_AVG_AGE;
            }
            if (columnIndex == 6) {
                return MemoryView.COLUMN_GENERATIONS;
            }
            if (columnIndex == 7) {
                return MemoryView.COLUMN_TOTAL_ALLOCATED_OBJECTS;
            }
            if (columnIndex == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (LivenessTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return Long.class;
            }
            if (columnIndex == 3) {
                return Integer.class;
            }
            if (columnIndex == 4) {
                return Long.class;
            }
            if (columnIndex == 5) {
                return Float.class;
            }
            if (columnIndex == 6) {
                return Integer.class;
            }
            if (columnIndex == 7) {
                return Integer.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return LivenessTableView.this.nTrackedItems;
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (LivenessTableView.this.nTrackedItems == 0) {
                return null;
            }
            if (LivenessTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return LivenessTableView.this.classNames[rowIndex].getClassName();
            }
            if (columnIndex == 2) {
                return LivenessTableView.this.trackedLiveObjectsSize[rowIndex];
            }
            if (columnIndex == 3) {
                return LivenessTableView.this.nTrackedLiveObjects[rowIndex];
            }
            if (columnIndex == 4) {
                return LivenessTableView.this.nTrackedAllocObjects[rowIndex];
            }
            if (columnIndex == 5) {
                return Float.valueOf(LivenessTableView.this.avgObjectAge[rowIndex]);
            }
            if (columnIndex == 6) {
                return LivenessTableView.this.maxSurvGen[rowIndex];
            }
            if (columnIndex == 7) {
                return LivenessTableView.this.nTotalAllocObjects[rowIndex];
            }
            if (columnIndex == 0) {
                if (LivenessTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return LivenessTableView.this.selection.contains(LivenessTableView.this.classNames[rowIndex]);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (LivenessTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                if (Boolean.FALSE.equals(aValue)) {
                    LivenessTableView.this.selection.remove(LivenessTableView.this.classNames[rowIndex]);
                } else {
                    LivenessTableView.this.selection.add(LivenessTableView.this.classNames[rowIndex]);
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (LivenessTableView.this.selection == null) {
                ++columnIndex;
            }
            return columnIndex == 0;
        }
    }
}

