/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdException;

public abstract class ByteBufferBackend
extends RrdBackend {
    private volatile boolean dirty = false;
    private ByteBuffer byteBuffer;

    protected ByteBufferBackend(String path) {
        super(path);
    }

    protected void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        byteBuffer.order(BYTEORDER);
    }

    @Override
    protected synchronized void write(long offset, byte[] b) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.put(b, (int)offset, b.length);
        this.dirty = true;
    }

    @Override
    protected void writeShort(long offset, short value) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.putShort((int)offset, value);
        this.dirty = true;
    }

    @Override
    protected void writeInt(long offset, int value) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.putInt((int)offset, value);
        this.dirty = true;
    }

    @Override
    protected void writeLong(long offset, long value) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.putLong((int)offset, value);
        this.dirty = true;
    }

    @Override
    protected void writeDouble(long offset, double value) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.putDouble((int)offset, value);
        this.dirty = true;
    }

    @Override
    protected void writeDouble(long offset, double value, int count) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        double[] values = new double[count];
        Arrays.fill(values, value);
        this.byteBuffer.position((int)offset);
        this.byteBuffer.asDoubleBuffer().put(values, 0, count);
        this.dirty = true;
    }

    @Override
    protected void writeDouble(long offset, double[] values) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.position((int)offset);
        this.byteBuffer.asDoubleBuffer().put(values, 0, values.length);
        this.dirty = true;
    }

    @Override
    protected void writeString(long offset, String value, int length) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.position((int)offset);
        CharBuffer cbuff = this.byteBuffer.asCharBuffer();
        cbuff.limit(length);
        cbuff.put(value);
        while (cbuff.position() < cbuff.limit()) {
            cbuff.put(' ');
        }
        this.dirty = true;
    }

    @Override
    protected synchronized void read(long offset, byte[] b) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.position((int)offset);
        this.byteBuffer.get(b);
    }

    @Override
    protected short readShort(long offset) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        return this.byteBuffer.getShort((int)offset);
    }

    @Override
    protected int readInt(long offset) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        return this.byteBuffer.getInt((int)offset);
    }

    @Override
    protected long readLong(long offset) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        return this.byteBuffer.getLong((int)offset);
    }

    @Override
    public double readDouble(long offset) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        return this.byteBuffer.getDouble((int)offset);
    }

    @Override
    public double[] readDouble(long offset, int count) throws IOException {
        this.checkOffsetAndByteBuffer(offset);
        double[] values = new double[count];
        this.byteBuffer.position((int)offset);
        this.byteBuffer.asDoubleBuffer().get(values, 0, count);
        return values;
    }

    @Override
    protected CharBuffer getCharBuffer(long offset, int size) throws RrdException {
        this.checkOffsetAndByteBuffer(offset);
        this.byteBuffer.position((int)offset);
        CharBuffer cbuffer = this.byteBuffer.asCharBuffer();
        cbuffer.limit(size);
        return cbuffer;
    }

    @Override
    protected void close() throws IOException {
        this.byteBuffer = null;
    }

    private void checkOffsetAndByteBuffer(long offset) throws RrdException {
        if (offset < 0L || offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal offset: " + offset);
        }
        if (this.byteBuffer == null) {
            throw new RrdException("Empty rrd");
        }
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    @Override
    protected void rrdClose() throws IOException {
        super.rrdClose();
        this.dirty = false;
    }
}

