/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class TypePopulator {
    public static final TypePopulator DEFAULT = new DefaultTypePopulator();
    protected static final Class[] ARG0 = new Class[0];
    protected static final Class[] ARG1 = new Class[]{IRubyObject.class};
    protected static final Class[] ARG2 = new Class[]{IRubyObject.class, IRubyObject.class};
    protected static final Class[] ARG3 = new Class[]{IRubyObject.class, IRubyObject.class, IRubyObject.class};
    protected static final Class[] ARG4 = new Class[]{IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class};
    protected static final Class[] ARG0_ARY = new Class[]{IRubyObject[].class};
    protected static final Class[] ARG1_ARY = new Class[]{IRubyObject.class, IRubyObject[].class};
    protected static final Class[] CONTEXT_ARG0 = new Class[]{ThreadContext.class};
    protected static final Class[] CONTEXT_ARG1 = new Class[]{ThreadContext.class, IRubyObject.class};
    protected static final Class[] CONTEXT_ARG2 = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class};
    protected static final Class[] CONTEXT_ARG3 = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class};
    protected static final Class[] CONTEXT_ARG4 = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class};
    protected static final Class[] CONTEXT_ARG0_ARY = new Class[]{ThreadContext.class, IRubyObject[].class};
    protected static final Class[] CONTEXT_ARG1_ARY = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class};
    protected static final Class[] ARG0_BLOCK = new Class[]{Block.class};
    protected static final Class[] ARG1_BLOCK = new Class[]{IRubyObject.class, Block.class};
    protected static final Class[] ARG2_BLOCK = new Class[]{IRubyObject.class, IRubyObject.class, Block.class};
    protected static final Class[] ARG3_BLOCK = new Class[]{IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
    protected static final Class[] ARG4_BLOCK = new Class[]{IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
    protected static final Class[] ARG0_ARY_BLOCK = new Class[]{IRubyObject[].class, Block.class};
    protected static final Class[] ARG1_ARY_BLOCK = new Class[]{IRubyObject.class, IRubyObject[].class, Block.class};
    protected static final Class[] CONTEXT_ARG0_BLOCK = new Class[]{ThreadContext.class, Block.class};
    protected static final Class[] CONTEXT_ARG1_BLOCK = new Class[]{ThreadContext.class, IRubyObject.class, Block.class};
    protected static final Class[] CONTEXT_ARG2_BLOCK = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class};
    protected static final Class[] CONTEXT_ARG3_BLOCK = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
    protected static final Class[] CONTEXT_ARG4_BLOCK = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
    protected static final Class[] CONTEXT_ARG0_ARY_BLOCK = new Class[]{ThreadContext.class, IRubyObject[].class, Block.class};
    protected static final Class[] CONTEXT_ARG1_ARY_BLOCK = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};

    public static void populateMethod(JavaMethod javaMethod, int arity2, String simpleName, boolean isStatic, boolean notImplemented, boolean core) {
        javaMethod.setIsBuiltin(core);
        javaMethod.setSignature(Signature.fromArityValue(arity2));
        javaMethod.setJavaName(simpleName);
        javaMethod.setSingleton(isStatic);
        javaMethod.setNotImplemented(notImplemented);
    }

    public static void populateMethod(JavaMethod javaMethod, int arity2, String simpleName, boolean isStatic, boolean notImplemented, boolean core, Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeArguments) {
        javaMethod.setIsBuiltin(core);
        javaMethod.setSignature(Signature.fromArityValue(arity2));
        javaMethod.setJavaName(simpleName);
        javaMethod.setSingleton(isStatic);
        javaMethod.setNotImplemented(notImplemented);
        javaMethod.setNativeCall(nativeTarget, nativeName, nativeReturn, nativeArguments, isStatic, false);
    }

    @Deprecated(since="10.0.0.0")
    public static DynamicMethod populateModuleMethod(RubyModule cls, DynamicMethod javaMethod) {
        return TypePopulator.populateModuleMethod(cls, cls.singletonClass(cls.getCurrentContext()), javaMethod);
    }

    public static DynamicMethod populateModuleMethod(RubyModule cls, RubyClass singletonClass, DynamicMethod javaMethod) {
        DynamicMethod moduleMethod = javaMethod.dup();
        moduleMethod.setImplementationClass(singletonClass);
        moduleMethod.setVisibility(Visibility.PUBLIC);
        return moduleMethod;
    }

    public abstract void populate(RubyModule var1, Class var2);

    public void populate(ThreadContext context, RubyModule cls, Class clazz) {
        this.populate(cls, clazz);
    }

    public static class DefaultTypePopulator
    extends TypePopulator {
        @Override
        public void populate(RubyModule clsmod, Class clazz) {
            ReflectiveTypePopulator populator = new ReflectiveTypePopulator(clazz);
            populator.populate(clsmod.getRuntime().getCurrentContext(), clsmod, clazz);
        }
    }

    public static final class ReflectiveTypePopulator
    extends TypePopulator {
        private final Class clazz;
        private final RubyModule.MethodClumper clumper;
        final List<String> classAndSubs = new ArrayList<String>();

        public ReflectiveTypePopulator(Class clazz) {
            this.clazz = clazz;
            this.clumper = new RubyModule.MethodClumper();
            this.clumper.clump(clazz);
            this.classAndSubs.add(clazz.getCanonicalName());
            Optional.ofNullable(clazz.getAnnotation(JRubyClass.class)).ifPresent(classAnno -> AnnotationHelper.addSubclassNames(this.classAndSubs, classAnno));
        }

        @Override
        @Deprecated(since="10.0.0.0")
        public void populate(RubyModule target2, Class clazz) {
            this.populate(target2.getCurrentContext(), target2, clazz);
        }

        @Override
        public void populate(ThreadContext context, RubyModule target2, Class clazz) {
            List<JavaMethodDescriptor> methods2;
            String name2;
            assert (clazz == this.clazz) : "populator for " + String.valueOf(this.clazz) + " used for " + String.valueOf(clazz);
            AnnotationHelper.populateMethodIndex(this.clumper.readGroups, MethodIndex::addMethodReadFieldsPacked);
            AnnotationHelper.populateMethodIndex(this.clumper.writeGroups, MethodIndex::addMethodWriteFieldsPacked);
            MethodFactory methodFactory = MethodFactory.createFactory(context.runtime.getJRubyClassLoader());
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : this.clumper.getStaticAnnotatedMethods().entrySet()) {
                name2 = entry.getKey();
                methods2 = entry.getValue();
                target2.defineAnnotatedMethod(context, name2, methods2, methodFactory);
                this.addBoundMethodsUnlessOmitted(context.runtime, name2, methods2);
            }
            for (Map.Entry<String, List<JavaMethodDescriptor>> entry : this.clumper.getAnnotatedMethods().entrySet()) {
                name2 = entry.getKey();
                methods2 = entry.getValue();
                target2.defineAnnotatedMethod(context, name2, methods2, methodFactory);
                this.addBoundMethodsUnlessOmitted(context.runtime, name2, methods2);
            }
        }

        private void addBoundMethodsUnlessOmitted(Ruby runtime2, String name2, List<JavaMethodDescriptor> methods2) {
            int size2 = methods2.size();
            List<String> classAndSubs = this.classAndSubs;
            for (int i2 = 0; i2 < size2; ++i2) {
                JavaMethodDescriptor desc = methods2.get(i2);
                if (desc.anno.omit()) continue;
                String javaName = desc.name;
                for (int j = 0; j < classAndSubs.size(); ++j) {
                    runtime2.addBoundMethod(classAndSubs.get(j), javaName, name2);
                }
            }
        }
    }
}

