/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeSelectorProvider;

public class DefaultThemeSelectorProvider
implements ThemeSelectorProvider {
    public static final String LOGIN_THEME_KEY = "login_theme";
    private final KeycloakSession session;

    public DefaultThemeSelectorProvider(KeycloakSession session) {
        this.session = session;
    }

    public String getThemeName(Theme.Type type) {
        String name = null;
        switch (type) {
            case WELCOME: {
                name = Config.scope((String[])new String[]{"theme"}).get("welcomeTheme");
                break;
            }
            case LOGIN: {
                ClientModel client = this.session.getContext().getClient();
                if (client != null) {
                    name = client.getAttribute(LOGIN_THEME_KEY);
                }
                if (name != null && !name.isEmpty()) break;
                name = this.session.getContext().getRealm().getLoginTheme();
                break;
            }
            case ACCOUNT: {
                name = this.session.getContext().getRealm().getAccountTheme();
                break;
            }
            case EMAIL: {
                name = this.session.getContext().getRealm().getEmailTheme();
                break;
            }
            case ADMIN: {
                name = this.session.getContext().getRealm().getAdminTheme();
            }
        }
        if (name == null || name.isEmpty()) {
            name = this.getDefaultThemeName(type);
        }
        return name;
    }

    public void close() {
    }
}

