/* SPDX-FileCopyrightText: 2007 - Johannes Schmid <jhs@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_MARK             (gtk_source_mark_get_type ())
#define GTK_SOURCE_MARK(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_MARK, GtkSourceMark))
#define GTK_SOURCE_MARK_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_MARK, GtkSourceMarkClass))
#define GTK_SOURCE_IS_MARK(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_MARK))
#define GTK_SOURCE_IS_MARK_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_MARK))
#define GTK_SOURCE_MARK_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_MARK, GtkSourceMarkClass))

typedef struct _GtkSourceMark         GtkSourceMark;
typedef struct _GtkSourceMarkClass    GtkSourceMarkClass;
typedef struct _GtkSourceMarkPrivate  GtkSourceMarkPrivate;

struct _GtkSourceMark
{
	GtkTextMark parent_instance;

	GtkSourceMarkPrivate *priv;
};

struct _GtkSourceMarkClass
{
	GtkTextMarkClass parent_class;

	/* Padding for future expansion */
	gpointer padding[1];
};

G_MODULE_EXPORT
GType		 gtk_source_mark_get_type (void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceMark   *gtk_source_mark_new		(const gchar	*name,
						 const gchar	*category);

G_MODULE_EXPORT
const gchar	*gtk_source_mark_get_category	(GtkSourceMark	*mark);

G_MODULE_EXPORT
GtkSourceMark	*gtk_source_mark_next		(GtkSourceMark	*mark,
						 const gchar	*category);

G_MODULE_EXPORT
GtkSourceMark	*gtk_source_mark_prev		(GtkSourceMark	*mark,
						 const gchar	*category);

G_END_DECLS
