/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.stream.WrappedInputStream;
import org.pentaho.reporting.libraries.repository.stream.WrappedOutputStream;

public class StreamContentItem
implements ContentItem {
    private WrappedInputStream inputStream;
    private WrappedOutputStream outputStream;
    private ContentLocation parent;
    private String name;

    public StreamContentItem(String name, ContentLocation parent, WrappedInputStream inputStream, WrappedOutputStream outputStream) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.parent = parent;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public boolean isReadable() {
        if (this.inputStream == null) {
            return false;
        }
        return !this.inputStream.isClosed();
    }

    @Override
    public boolean isWriteable() {
        if (this.outputStream == null) {
            return false;
        }
        return !this.outputStream.isClosed();
    }

    @Override
    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    @Override
    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() throws ContentIOException, IOException {
        return this.inputStream;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContentId() {
        return this.parent.getName() + '/' + this.name;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.parent.getRepository();
    }

    @Override
    public boolean delete() {
        return false;
    }
}

