/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.PskSecretResultHandler;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerNames;

public class BridgePskStore
implements AdvancedPskStore {
    protected final PskStore pskStore;

    public BridgePskStore(PskStore pskStore) {
        if (pskStore == null) {
            throw new NullPointerException("PSK store must not be null!");
        }
        this.pskStore = pskStore;
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed) {
        SecretKey secret = serverNames != null ? this.pskStore.getKey(serverNames, identity) : this.pskStore.getKey(identity);
        return new PskSecretResult(cid, identity, secret);
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return virtualHost != null ? this.pskStore.getIdentity(peerAddress, virtualHost) : this.pskStore.getIdentity(peerAddress);
    }

    @Override
    public void setResultHandler(PskSecretResultHandler resultHandler) {
    }
}

