/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.features.osgi;

import java.util.Hashtable;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.karaf.deployer.features.FeatureDeploymentListener;
import org.apache.karaf.deployer.features.FeatureURLHandler;
import org.apache.karaf.features.DeploymentEvent;
import org.apache.karaf.features.DeploymentListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.service.url.URLStreamHandlerService;

@Services(requires={@RequireService(value=FeaturesService.class)})
public class Activator
extends BaseActivator {
    private FeatureDeploymentListener listener;
    private DeploymentListener deploymentListener;

    @Override
    protected void doStart() throws Exception {
        FeaturesService service = this.getTrackedService(FeaturesService.class);
        if (service == null) {
            return;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("url.handler.protocol", "feature");
        FeatureURLHandler handler = new FeatureURLHandler();
        this.register(URLStreamHandlerService.class, handler, props);
        this.deploymentListener = new DeploymentFinishedListener(service);
        service.registerListener(this.deploymentListener);
    }

    @Override
    protected void doStop() {
        FeaturesService service;
        super.doStop();
        if (this.deploymentListener != null && (service = this.getTrackedService(FeaturesService.class)) != null) {
            service.unregisterListener(this.deploymentListener);
        }
        if (this.listener != null) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    private class DeploymentFinishedListener
    implements DeploymentListener {
        private final FeaturesService service;

        public DeploymentFinishedListener(FeaturesService service) {
            this.service = service;
        }

        public void deploymentEvent(DeploymentEvent e) {
            if (e == DeploymentEvent.DEPLOYMENT_FINISHED && Activator.this.listener == null) {
                Activator.this.logger.info("Deployment finished. Registering FeatureDeploymentListener");
                Activator.this.listener = new FeatureDeploymentListener();
                Activator.this.listener.setFeaturesService(this.service);
                Activator.this.listener.setBundleContext(Activator.this.bundleContext);
                try {
                    Activator.this.listener.init();
                    Activator.this.register(new Class[]{ArtifactUrlTransformer.class, ArtifactListener.class}, Activator.this.listener);
                }
                catch (Exception ex) {
                    Activator.this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }
}

