/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 0u) => u64vec3(1333333333333333259ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 1u) => u64vec3(2666666666666666518ul, 170ul, 188ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 2u) => u64vec3(5333333333333333036ul, 340ul, 376ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 5u) => u64vec3(5773178519247561056ul, 2720ul, 3008ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 25u) => u64vec3(3776561488156688384ul, 2852126720ul, 3154116608ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) << 31u) => u64vec3(1892262283803885568ul, 182536110080ul, 201863462912ul)
 * (u64vec3(167ul, 66ul, 187ul) << 0u) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) << 1u) => u64vec3(334ul, 132ul, 374ul)
 * (u64vec3(167ul, 66ul, 187ul) << 2u) => u64vec3(668ul, 264ul, 748ul)
 * (u64vec3(167ul, 66ul, 187ul) << 5u) => u64vec3(5344ul, 2112ul, 5984ul)
 * (u64vec3(167ul, 66ul, 187ul) << 25u) => u64vec3(5603590144ul, 2214592512ul, 6274678784ul)
 * (u64vec3(167ul, 66ul, 187ul) << 31u) => u64vec3(358629769216ul, 141733920768ul, 401579442176ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 0u), u64vec3(1333333333333333259ul, 85ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 1u), u64vec3(2666666666666666518ul, 170ul, 188ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 2u), u64vec3(5333333333333333036ul, 340ul, 376ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 5u), u64vec3(5773178519247561056ul, 2720ul, 3008ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 25u), u64vec3(3776561488156688384ul, 2852126720ul, 3154116608ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) << 31u), u64vec3(1892262283803885568ul, 182536110080ul, 201863462912ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 0u), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 1u), u64vec3(334ul, 132ul, 374ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 2u), u64vec3(668ul, 264ul, 748ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 5u), u64vec3(5344ul, 2112ul, 5984ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 25u), u64vec3(5603590144ul, 2214592512ul, 6274678784ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) << 31u), u64vec3(358629769216ul, 141733920768ul, 401579442176ul))) ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
