/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class PowerLines
extends Test {
    private static final String MINOR_LINE = "minor_line";
    private static final String BUILDING = "building";
    private static final String POWER = "power";
    protected static final int POWER_SUPPORT = 2501;
    protected static final int POWER_CONNECTION = 2502;
    protected static final int POWER_SEGMENT_LENGTH = 2503;
    protected static final int POWER_LOCAL_REF_CONTINUITY = 2504;
    protected static final int POWER_WAY_REF_CONTINUITY = 2505;
    protected static final int POWER_LINE_TYPE = 2506;
    protected static final String PREFIX = "validator." + PowerLines.class.getSimpleName();
    static final Collection<String> POWER_LINE_TAGS = Arrays.asList("line", "minor_line");
    static final Collection<String> POWER_TOWER_TAGS = Arrays.asList("catenary_mast", "pole", "portal", "tower");
    static final Collection<String> POWER_STATION_TAGS = Arrays.asList("generator", "plant", "substation");
    static final Collection<String> BUILDING_STATION_TAGS = Collections.singletonList("transformer_tower");
    static final Collection<String> POWER_INFRASTRUCTURE_TAGS = Arrays.asList("compensator", "connection", "converter", "generator", "insulator", "switch", "switchgear", "terminal", "transformer");
    private double hillyCompensation;
    private double hillyThreshold;
    private final Set<Node> badConnections = new HashSet<Node>();
    private final Set<Node> missingTags = new HashSet<Node>();
    private final Set<Way> wrongLineType = new HashSet<Way>();
    private final Set<WaySegment> missingNodes = new HashSet<WaySegment>();
    private final Set<OsmPrimitive> refDiscontinuities = new HashSet<OsmPrimitive>();
    private final List<Set<Node>> segmentRefDiscontinuities = new ArrayList<Set<Node>>();
    private final List<OsmPrimitive> powerStations = new ArrayList<OsmPrimitive>();
    private final Collection<Way> foundPowerLines = new HashSet<Way>();
    private final Map<Point2D, List<WaySegment>> cellSegmentsWater = new HashMap<Point2D, List<WaySegment>>(32);

    public PowerLines() {
        super(I18n.tr("Power lines", new Object[0]), I18n.tr("Checks if power line missing a support node and for nodes in power lines that do not have a power=tower/pole tag", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        boolean nodeInLineOrCable = false;
        boolean connectedToUnrelated = false;
        for (Way parent : n.getParentWays()) {
            if (parent.hasTag(POWER, "line", MINOR_LINE, "cable")) {
                nodeInLineOrCable = true;
                continue;
            }
            if (PowerLines.isRelatedToPower(parent)) continue;
            connectedToUnrelated = true;
        }
        if (nodeInLineOrCable && connectedToUnrelated) {
            this.badConnections.add(n);
        }
    }

    @Override
    public void visit(Way w) {
        if (!this.isPrimitiveUsable(w)) {
            return;
        }
        if (PowerLines.isPowerLine(w) && !w.hasKey("line") && !w.hasTag("location", "underground") && w.isUsable()) {
            this.foundPowerLines.add(w);
        } else if (w.isClosed() && PowerLines.isPowerStation(w)) {
            this.powerStations.add(w);
        } else if (PowerLines.concernsWaterArea(w)) {
            this.addWaterWaySegments(w);
        }
    }

    private void addWaterWaySegments(Way w) {
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            WaySegment es1 = new WaySegment(w, i);
            Node first = (Node)es1.getFirstNode();
            Node second = (Node)es1.getSecondNode();
            if (!first.isLatLonKnown() || !second.isLatLonKnown()) continue;
            CrossingWays.getSegments(this.cellSegmentsWater, first, second).forEach(list -> list.add(es1));
        }
    }

    @Override
    public void visit(Relation r) {
        if (r.isMultipolygon() && PowerLines.isPowerStation(r)) {
            this.powerStations.add(r);
        } else if (PowerLines.concernsWaterArea(r)) {
            r.getMemberPrimitives(Way.class).forEach(this::addWaterWaySegments);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.hillyCompensation = Config.getPref().getDouble(PREFIX + ".hilly_compensation", 0.2);
        this.hillyThreshold = Config.getPref().getDouble(PREFIX + ".hilly_threshold", 4.0);
    }

    @Override
    public void endTest() {
        for (Way w : this.foundPowerLines) {
            this.powerlineChecks(w);
        }
        for (Node n : this.missingTags) {
            if (this.isInPowerStation(n)) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 2501).message(I18n.tr("missing tag", new Object[0]), I18n.tr("node without power=*", new Object[0]), new Object[0]).primitives(n).build());
        }
        for (Node n : this.badConnections) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 2502).message(I18n.tr("Node connects a power line or cable with an object which is not related to the power infrastructure", new Object[0])).primitives(n).build());
        }
        for (WaySegment s : this.missingNodes) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 2503).message(I18n.tr("Possibly missing line support node within power line", new Object[0])).primitives((OsmPrimitive)s.getFirstNode(), (OsmPrimitive)s.getSecondNode()).highlightWaySegments(new HashSet<WaySegment>(Collections.singleton(s))).build());
        }
        for (OsmPrimitive p : this.refDiscontinuities) {
            if (!(p instanceof Way)) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 2505).message(I18n.tr("Mixed reference numbering", new Object[0])).primitives(p).build());
        }
        String discontinuityMsg = I18n.tr("Reference numbering don''t match majority of way''s nodes", new Object[0]);
        for (OsmPrimitive osmPrimitive : this.refDiscontinuities) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 2504).message(discontinuityMsg).primitives(osmPrimitive).build());
        }
        for (Set set : this.segmentRefDiscontinuities) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 2504).message(discontinuityMsg).primitives(set).build());
        }
        for (Way way : this.wrongLineType) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 2506).message(I18n.tr("Possibly wrong power line type used", new Object[0])).primitives(way).build());
        }
        super.endTest();
    }

    private void powerlineChecks(Way w) {
        double baseThreshold;
        int segmentCount = w.getNodesCount() - 1;
        double mean = w.getLength() / (double)segmentCount;
        double stdDev = Utils.getStandardDeviation(w.getSegmentLengths(), mean);
        boolean isContinuesAsMinorLine = PowerLines.isContinuesAsMinorLine(w);
        boolean isCrossingWater = false;
        int poleCount = 0;
        int towerCount = 0;
        Node prevNode = w.firstNode();
        double d = baseThreshold = w.hasTag(POWER, "line") ? 1.6 : 1.8;
        if (mean / stdDev < this.hillyThreshold) {
            baseThreshold += this.hillyCompensation;
        }
        for (Node n : w.getNodes()) {
            if (PowerLines.isConnectedToStationLine(n, w) || n.hasTag(POWER, "connection")) {
                prevNode = n;
                continue;
            }
            if (!(PowerLines.isPowerTower(n) || PowerLines.isPowerInfrastructure(n) || !IN_DOWNLOADED_AREA.test(n) || w.isFirstLastNode(n) && PowerLines.isPowerStation(n))) {
                this.missingTags.add(n);
            }
            double segmentLen = n.greatCircleDistance(prevNode);
            HashSet<Way> crossingWaterWays = new HashSet<Way>(8);
            HashSet<ILatLon> crossingPositions = new HashSet<ILatLon>(8);
            PowerLines.findCrossings(this.cellSegmentsWater, w, crossingWaterWays, crossingPositions);
            if (!crossingWaterWays.isEmpty()) {
                double compensation = PowerLines.calculateIntersectingLen(prevNode, crossingPositions);
                segmentLen -= compensation;
            }
            if (segmentCount > 4 && segmentLen > mean * baseThreshold && !PowerLines.isPowerInfrastructure(n) && IN_DOWNLOADED_AREA.test(n)) {
                this.missingNodes.add(WaySegment.forNodePair(w, prevNode, n));
            }
            if (!crossingWaterWays.isEmpty()) {
                isCrossingWater = true;
            }
            if (n.hasTag(POWER, "pole")) {
                ++poleCount;
            } else if (n.hasTag(POWER, "tower", "portal")) {
                ++towerCount;
            }
            prevNode = n;
        }
        if (PowerLines.detectDiscontinuity(w, this.refDiscontinuities, this.segmentRefDiscontinuities)) {
            this.refDiscontinuities.add(w);
        }
        if ((poleCount > towerCount && w.hasTag(POWER, "line") || poleCount < towerCount && w.hasTag(POWER, MINOR_LINE) && !isCrossingWater && !isContinuesAsMinorLine) && IN_DOWNLOADED_AREA.test(w)) {
            this.wrongLineType.add(w);
        }
    }

    private static double calculateIntersectingLen(Node ref, Set<ILatLon> crossingNodes) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (ILatLon coor : crossingNodes) {
            if (ref == null || coor == null) continue;
            double dist = ref.greatCircleDistance(coor);
            if (dist < min) {
                min = dist;
            }
            if (!(dist > max)) continue;
            max = dist;
        }
        return max - min;
    }

    private static void findCrossings(Map<Point2D, List<WaySegment>> ways, Way parent, Set<Way> crossingWays, Set<ILatLon> crossingPositions) {
        int nodesSize = parent.getNodesCount();
        for (int i = 0; i < nodesSize - 1; ++i) {
            WaySegment es1 = new WaySegment(parent, i);
            if (!((Node)es1.getFirstNode()).isLatLonKnown() || !((Node)es1.getSecondNode()).isLatLonKnown()) {
                Logging.warn("PowerLines crossing ways test section skipped " + String.valueOf(es1));
                continue;
            }
            for (List<WaySegment> segments : CrossingWays.getSegments(ways, es1.getFirstNode(), es1.getSecondNode())) {
                for (WaySegment segment : segments) {
                    ILatLon ll;
                    if (!es1.intersects(segment) || (ll = Geometry.getSegmentSegmentIntersection(es1.getFirstNode(), es1.getSecondNode(), segment.getFirstNode(), segment.getSecondNode())) == null) continue;
                    crossingWays.add((Way)es1.getWay());
                    crossingPositions.add(ll);
                }
            }
        }
    }

    static boolean detectDiscontinuity(Way way, Set<OsmPrimitive> nRefDiscontinuities, List<Set<Node>> sRefDiscontinuities) {
        RefChecker checker = new RefChecker(way);
        List<SegmentInfo> segments = checker.getSegments();
        SegmentInfo referenceSegment = checker.getLongestSegment();
        if (referenceSegment == null) {
            return !segments.isEmpty();
        }
        for (SegmentInfo segment : segments) {
            if (PowerLines.isSegmentAlign(referenceSegment, segment)) continue;
            if (referenceSegment.length == 0) {
                return true;
            }
            if (segment.length == 0) {
                nRefDiscontinuities.add(way.getNode(segment.startIndex));
                continue;
            }
            HashSet<Node> nodeGroup = new HashSet<Node>();
            for (int i = segment.startIndex; i <= segment.startIndex + segment.length; ++i) {
                nodeGroup.add(way.getNode(i));
            }
            sRefDiscontinuities.add(nodeGroup);
        }
        return false;
    }

    private static boolean isSegmentAlign(SegmentInfo reference, SegmentInfo candidate) {
        if (reference.direction == NumberingDirection.NONE || reference.direction == candidate.direction || candidate.direction == NumberingDirection.NONE) {
            return Math.abs(candidate.startIndex - reference.startIndex) == Math.abs(candidate.startRef - reference.startRef);
        }
        return false;
    }

    private static boolean isRelatedToPower(Way way) {
        if (way.hasTag(POWER) || way.hasTag(BUILDING)) {
            return true;
        }
        for (OsmPrimitive ref : way.getReferrers()) {
            if (!(ref instanceof Relation) || !ref.isMultipolygon() || !ref.hasTag(POWER) && !ref.hasTag(BUILDING)) continue;
            for (RelationMember rm : ((Relation)ref).getMembers()) {
                if (way != rm.getMember()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConnectedToStationLine(Node n, Way w) {
        for (OsmPrimitive p : n.getReferrers()) {
            if (!(p instanceof Way) || p.equals(w) || !PowerLines.isPowerLine((Way)p) || !p.hasKey("line")) continue;
            return true;
        }
        return false;
    }

    private static boolean isContinuesAsMinorLine(Way way) {
        return way.firstNode().referrers(Way.class).filter(referrer -> !way.equals(referrer)).anyMatch(PowerLines::isMinorLine) || way.lastNode().referrers(Way.class).filter(referrer -> !way.equals(referrer)).anyMatch(PowerLines::isMinorLine);
    }

    private static boolean isMinorLine(OsmPrimitive p) {
        return p.hasTag(POWER, MINOR_LINE);
    }

    private static boolean concernsWaterArea(OsmPrimitive p) {
        return p.hasTag("water", "river", "lake") || p.hasKey("waterway") || p.hasTag("natural", "coastline");
    }

    protected final boolean isInPowerStation(Node n) {
        for (OsmPrimitive station : this.powerStations) {
            Multipolygon polygon;
            ArrayList<List<Node>> nodesLists = new ArrayList<List<Node>>();
            if (station instanceof Way) {
                nodesLists.add(((Way)station).getNodes());
            } else if (station instanceof Relation && (polygon = MultipolygonCache.getInstance().get((Relation)station)) != null) {
                for (Multipolygon.JoinedWay outer : Multipolygon.joinWays(polygon.getOuterWays())) {
                    nodesLists.add(outer.getNodes());
                }
            }
            for (List list : nodesLists) {
                if (!Geometry.nodeInsidePolygon(n, list)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isPowerLine(Way w) {
        return PowerLines.isPowerIn(w, POWER_LINE_TAGS);
    }

    protected static boolean isPowerStation(OsmPrimitive p) {
        return PowerLines.isPowerIn(p, POWER_STATION_TAGS) || PowerLines.isBuildingIn(p, BUILDING_STATION_TAGS);
    }

    protected static boolean isPowerTower(Node n) {
        return PowerLines.isPowerIn(n, POWER_TOWER_TAGS);
    }

    protected static boolean isPowerInfrastructure(Node n) {
        return PowerLines.isPowerIn(n, POWER_INFRASTRUCTURE_TAGS);
    }

    private static boolean isPowerIn(OsmPrimitive p, Collection<String> values) {
        return p.hasTag(POWER, values);
    }

    private static boolean isBuildingIn(OsmPrimitive p, Collection<String> values) {
        return p.hasTag(BUILDING, values);
    }

    @Override
    public void clear() {
        super.clear();
        this.badConnections.clear();
        this.cellSegmentsWater.clear();
        this.foundPowerLines.clear();
        this.missingNodes.clear();
        this.missingTags.clear();
        this.powerStations.clear();
        this.refDiscontinuities.clear();
        this.segmentRefDiscontinuities.clear();
        this.wrongLineType.clear();
    }

    static class RefChecker {
        private final List<SegmentInfo> segments = new ArrayList<SegmentInfo>();
        private NumberingDirection direction = NumberingDirection.NONE;
        private Integer startIndex;
        private Integer previousRef;

        RefChecker(Way way) {
            this.run(way);
        }

        private void run(Way way) {
            int wayLength = way.getNodesCount();
            for (int i = 1; i < wayLength - 1; ++i) {
                Node n = way.getNode(i);
                if (!PowerLines.isPowerTower(n)) continue;
                this.maintain(RefChecker.parseRef(n.get("ref")), i);
            }
            this.maintain(null, wayLength - 1);
        }

        private void maintain(Integer ref, int index) {
            if (this.previousRef == null && ref != null) {
                this.startIndex = index;
            } else if (this.previousRef != null && ref == null) {
                this.segments.add(new SegmentInfo(this.startIndex, index - 1 - this.startIndex, this.previousRef, this.direction));
                this.direction = NumberingDirection.NONE;
            } else if (this.previousRef != null) {
                if (Math.abs(ref - this.previousRef) != 1) {
                    this.segments.add(new SegmentInfo(this.startIndex, index - 1 - this.startIndex, this.previousRef, this.direction));
                    this.startIndex = index;
                    this.previousRef = ref;
                }
                this.direction = RefChecker.detectDirection(ref, this.previousRef);
            }
            this.previousRef = ref;
        }

        private static Integer parseRef(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                Logging.trace("The " + String.valueOf(RefChecker.class) + " couldn't parse ref=" + value + ", consider rewriting the parser");
                return null;
            }
        }

        private static NumberingDirection detectDirection(int ref, int previousRef) {
            if (ref > previousRef) {
                return NumberingDirection.SAME;
            }
            if (ref < previousRef) {
                return NumberingDirection.OPPOSITE;
            }
            return NumberingDirection.NONE;
        }

        SegmentInfo getLongestSegment() {
            EnumSet<NumberingDirection> directions = EnumSet.noneOf(NumberingDirection.class);
            int longestLength = -1;
            int counter = 0;
            SegmentInfo longest = null;
            for (SegmentInfo segment : this.segments) {
                if (segment.length > longestLength) {
                    longestLength = segment.length;
                    longest = segment;
                    counter = 0;
                    directions.clear();
                    directions.add(segment.direction);
                    continue;
                }
                if (segment.length != longestLength) continue;
                ++counter;
                directions.add(segment.direction);
            }
            if (counter > 0 && directions.size() > 1) {
                return null;
            }
            return longest;
        }

        List<SegmentInfo> getSegments() {
            return this.segments;
        }
    }

    private static class SegmentInfo {
        private final int startIndex;
        private final int startRef;
        private final int length;
        private final NumberingDirection direction;

        SegmentInfo(int startIndex, int length, int ref, NumberingDirection direction) {
            this.startIndex = startIndex;
            this.length = length;
            this.direction = direction;
            this.startRef = direction == NumberingDirection.SAME ? ref - length : ref + length;
            if (length == 0 && direction != NumberingDirection.NONE) {
                throw new IllegalArgumentException("When the segment length is zero, the direction should be NONE");
            }
        }

        public String toString() {
            return String.format("SegmentInfo{startIndex=%d, startRef=%d, length=%d, direction=%s}", new Object[]{this.startIndex, this.startRef, this.length, this.direction});
        }
    }

    private static enum NumberingDirection {
        NONE,
        SAME,
        OPPOSITE;

    }
}

