/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.spi.NavigablePath;

@Incubating
public class TreatedNavigablePath
extends NavigablePath {
    public TreatedNavigablePath(NavigablePath parent, String entityTypeName) {
        this(parent, entityTypeName, null);
    }

    public TreatedNavigablePath(NavigablePath parent, String entityTypeName, @Nullable String alias) {
        super(parent, "#" + entityTypeName, alias, "treat(" + String.valueOf(parent) + " as " + entityTypeName + ")", 1);
        assert (!(parent instanceof TreatedNavigablePath));
    }

    @Override
    public NavigablePath treatAs(String entityName) {
        return new TreatedNavigablePath(NullnessUtil.castNonNull(this.getRealParent()), entityName);
    }

    @Override
    public NavigablePath treatAs(String entityName, String alias) {
        return new TreatedNavigablePath(NullnessUtil.castNonNull(this.getRealParent()), entityName, alias);
    }
}

