/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Limousin for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_74 : {
					width : 90.408798,
					height : 101.04042,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = -28.34195;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3064.4974;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-23" : "m 52.55,0.09 c -1.02,-0.12 -1.33,0.59 -1.16,1.5 0.07,1.08 -0.59,2.55 -1.76,2.68 -0.85,-0.22 -1.08,-1.55 -1.84,-1.63 -0.64,0.58 -1.06,1.8 -2.01,1.88 -0.82,-0.39 -1.15,-1.36 -0.77,-2.19 -0.47,-0.51 -0.8,0.88 -1.49,0.79 -0.66,-0.02 -1.1,1 -1.72,0.76 -0.4,-0.51 -0.08,-2.05 -1.09,-1.83 -0.91,0.47 -0.83,1.92 -1.9,2.14 -0.5,0.58 -0.97,1.22 -1.72,1.49 -0.3,0.48 -0.45,1.07 -1.03,1.36 -1.03,0.71 0.81,0.76 1.1,1.14 -0.43,0.65 0.32,1.86 -0.63,2.13 -0.69,0.37 -0.53,1.29 0.09,1.62 0.18,0.47 -0.57,0.55 -0.88,0.51 -0.57,0.33 -0.19,0.94 0.2,1.19 0.17,0.56 -0.53,0.56 -0.87,0.63 -0.88,0.73 -1.2,2.25 -0.13,2.99 0.14,0.86 1.17,1.03 1.93,0.96 0.4,-8e-4 1.25,-0.06 0.97,0.55 0.27,0.4 0.1,0.78 0.03,1.19 0.27,0.23 0.65,0.34 0.84,0.71 0.6,0.15 1.08,0.7 1.15,1.31 -0.66,0.36 -0.61,1.15 -0.1,1.61 0.48,0.38 1.07,0.54 1.35,1.16 0.45,0.24 0.56,0.65 0.24,1.06 -0.37,0.97 0.96,1.88 0.1,2.78 -0.48,0.71 -0.1,1.81 0.86,1.72 0.85,0.09 1.13,1.55 0.42,2.03 -0.74,0.69 -2.28,0.84 -2.48,1.98 0.26,0.44 0.98,0.2 1.23,0.74 0.52,0.57 1.81,0.62 1.79,-0.35 0.8,-0.19 2.11,-0.42 2.59,0.45 -0.65,0.68 0.39,1.43 0.21,2.19 -0.59,0.25 -1.35,-0.03 -1.87,0.3 0.06,0.49 0.43,0.95 0.35,1.52 0.24,1 1.45,0.86 2.14,1.27 0.7,0.64 1.7,-0.08 2.54,0.05 0.78,-0.07 1.5,-0.58 2.06,-1.04 -0.13,-0.57 0.81,-1.02 0.92,-0.29 0.45,0.66 -0.34,1.86 0.66,2.14 0.7,0.04 1.02,1.21 1.71,0.97 0.07,-0.3 0.32,-0.89 0.57,-0.33 0.36,0.8 1.39,0.88 1.87,1.63 0.51,0.57 0.46,1.43 0.98,1.98 0.09,0.7 -1.24,0.44 -0.86,1.17 0.48,0.5 -0.43,1.16 0.17,1.63 0.59,0.28 0.11,0.6 0.08,1 0.2,0.94 1.21,0.19 1.57,-0.2 0.36,0.09 0.82,0.25 1.06,-0.2 0.38,-0.81 1.25,-0.45 1.92,-0.52 0.72,-0.5 0.26,-1.84 1.31,-2.11 0.56,-0.1 1.11,-0.22 1.52,-0.64 0.5,0.16 0.71,0.9 1.27,1.03 0.49,0.26 0.32,1.12 1.01,1.05 0.48,0.41 1.03,0.01 1.51,-0.05 0.28,0.27 1.08,1.07 1.23,0.28 -0.11,-0.71 0.79,-0.1 0.97,0.15 0.2,0.39 0.83,0.44 1.02,0.7 0.11,0.57 0.9,0.6 1.19,1.1 0.54,0.53 1.38,0.42 1.96,0.76 0.11,0.47 -0.03,1.66 0.77,1.39 0.44,-0.36 0.97,-0.41 1.5,-0.42 0.89,-0.36 1.17,-1.39 1.16,-2.25 0.96,-0.54 2.23,-0.17 3.24,0.06 0.89,0.71 1.87,-0.39 2.43,-1.04 0.05,-0.52 1.18,-1.03 0.5,-1.46 -0.55,-0.39 -1.02,-0.94 -1.71,-1.04 -0.77,-0.59 -0.38,-1.76 -1.14,-2.4 -0.42,-0.65 -1.15,-1.22 -1.39,-1.95 0.24,-0.65 0.84,-0.82 1.45,-0.7 0.96,-0.13 1.19,-1.21 1.22,-2 0.6,-0.32 1.32,-0.29 1.89,0.01 0.72,-0.22 0.32,-1.39 1.19,-1.51 0.52,-0.46 1.55,-0.89 1.45,-1.68 -0.35,-0.72 0.1,-1.69 0.76,-2.08 0.15,-0.51 0.42,-0.96 1.03,-1.02 0.45,-0.11 1.35,-0.33 0.91,-0.96 -1.12,-1.11 0.23,-2.7 -0.5,-3.91 -0.82,-0.54 -1.47,-1.36 -1.68,-2.37 -0.58,-1.66 -0.26,-3.41 0.18,-5.06 0.11,-0.7 0.03,-1.79 -0.87,-1.85 -1.57,-1.13 -0.46,-3.74 -2.12,-4.79 -0.79,-0.26 -0.69,-1.4 -0.9,-2.07 -0.47,-0.7 -1.85,-1.3 -2.26,-0.31 -0.77,-0.48 -0.25,-1.7 -1,-2.28 -0.47,-0.93 -1.06,-0.68 -1.35,0.16 -0.32,0.56 -0.64,0.09 -0.8,-0.27 -0.74,-0.23 -1.57,-0.35 -2.07,-1.03 -0.87,-0.71 0.21,-1.72 0.78,-2.19 0.4,-0.37 -0.13,-0.61 -0.46,-0.43 -0.86,-0.09 -1.82,-0.53 -1.8,-1.52 -0.14,-0.55 0.06,-1.56 -0.81,-1.53 -2.16,-0.25 -4.41,-0.27 -6.54,0.18 -0.56,0.49 -1.48,0.84 -2.07,0.2 -1.4,-0.55 -3,-0.59 -4.31,-1.36 -0.85,-0.17 -1.83,0.53 -2.61,0.15 -0.48,-0.82 -1.47,0.03 -2.13,0.13 -0.9,-0.08 -1.98,0.75 -2.75,-0.04 -0.33,-0.56 -0.79,-1.43 -1.57,-1.35 z",
					    "department-87" : "m 32.52,3.72 c -0.51,0.05 -1.17,0.12 -1.14,0.78 -0.25,1 -1.42,1.2 -2.23,0.78 -0.91,-0.55 -1.46,0.97 -2.37,0.47 -0.41,-0.24 -0.15,-1.36 -0.88,-1.06 -0.15,0.36 -0.49,0.69 -0.87,0.31 -0.42,-0.56 -1.48,-0.46 -1.39,0.36 -0.29,0.51 -0.98,0.78 -0.95,1.46 -0.55,0.47 -1.05,-0.38 -1.56,-0.48 -1.22,-0.29 -2.83,0.17 -3.07,1.56 0.1,1.34 -1.16,2.36 -1.14,3.65 -1.12,-0.21 -2.44,-0.58 -3.48,-0.02 -0.57,-0.29 -1.43,-0.46 -1.55,0.41 -0.29,0.71 -1.43,0.57 -1.53,1.41 -0.45,0.32 -0.59,0.81 -0.41,1.28 -0.57,0.79 -2.14,-0.04 -2.35,1.21 -0.11,1.15 1.52,1.66 1.49,2.82 0.45,0.61 -0.22,1.55 0.51,2.07 0.3,0.78 -1.04,0.68 -1.22,1.21 0.1,0.73 1.16,1.32 0.57,2.1 -0.2,0.88 -0.43,1.82 -0.37,2.7 0.55,0.71 1.53,1.06 1.85,1.96 0.6,0.29 0.77,-1.11 1.42,-0.47 0.52,0.57 1.56,1 1.37,1.91 0.17,0.33 0.61,0.45 0.5,0.91 0.25,0.56 0.69,1.22 0.15,1.8 -0.4,0.33 -0.69,0.93 -0.79,1.33 -1.08,0.03 -1.62,1.45 -2.79,1.15 -0.74,0.1 -1.45,-0.83 -2.13,-0.41 -0.07,0.49 0.25,0.98 0.12,1.53 -0.13,0.54 0.63,1.02 0.41,1.49 -0.44,0.28 -0.27,0.69 -0.21,1.04 -0.23,1.22 -1.06,2.19 -1.62,3.25 -0.26,0.54 0.17,1.51 -0.39,1.85 -0.92,-0.16 -1.85,-1.49 -2.8,-0.78 -0.33,0.63 -0.36,1.44 0.03,2.02 -0.07,0.89 -1.28,0.52 -1.72,1.1 -0.39,0.39 -0.56,0.91 -1.06,1.2 -0.36,0.39 -0.09,1.12 -0.8,1.16 -0.53,0.7 0.73,1.29 1.05,1.78 1.12,0.48 2.72,-0.73 3.83,0.16 0.41,0.49 0.74,1.16 1.39,1.34 0.08,1.16 -0.5,2.25 -0.79,3.32 0.28,0.85 0.98,1.77 2,1.46 0.49,0.16 0.41,1.27 1.18,1.08 1.27,-0.42 1.02,-2.31 2.06,-2.9 0.55,0.27 0.58,1.69 1.39,1.27 0.5,-0.37 1.3,-0.2 1.85,-0.57 0.8,-0.12 1.6,0.64 2.37,0.08 1.2,-0.25 2.21,0.92 2.02,2.08 -0.09,0.92 0.66,1.51 1.35,1.88 0.41,0.32 0.61,1.42 1.32,0.87 0.49,-0.58 1.3,-0.68 1.86,-0.14 0.33,0.35 1.23,0.52 1.23,1.08 -0.69,0.87 -1.92,1.66 -1.92,2.87 0.34,0.84 1.26,0.35 1.87,0.21 0.56,0.26 0.58,0.97 0.93,1.33 0.84,-0.26 2.33,-0.57 2.49,0.7 0.19,0.63 0.87,0.23 0.77,-0.27 0.67,-0.31 0.04,-1.73 0.98,-1.81 0.57,0.07 0.21,-0.87 0.71,-0.67 0.95,0.21 1.74,1.1 2.68,1.15 0.76,-1.2 1.96,-2.1 2.52,-3.45 0.35,-0.6 1.02,-0.45 1.52,-0.23 0.86,-0.13 0.35,-1.3 0.75,-1.74 0.56,-0.03 0.98,-0.4 1.21,-0.85 0.63,0.05 0.58,1.16 1.29,0.85 0.37,-0.17 0.08,-0.99 0.68,-0.63 0.79,0.46 1.82,0.91 2.6,0.18 0.48,-0.4 0.34,-1.43 1.2,-1.3 1.25,0.1 2.05,-1.03 2.56,-1.98 0.73,-0.73 1.34,-1.82 2.34,-2.13 0.74,0.12 1.5,-0.28 1.87,-0.87 0.93,-0.17 1.13,-1.16 1.48,-1.85 0.37,-0.07 0.64,0.49 1.11,0.2 0.61,0.2 0.97,1.44 1.71,0.76 0.42,-0.5 1.1,0.52 1.33,-0.26 -0.03,-0.66 0.6,-0.53 1.03,-0.64 0.45,-0.2 0.16,-0.77 -0.12,-0.88 -0.02,-0.51 -0.84,-0.68 -0.83,-1.1 0.48,-0.35 0.14,-0.82 -0.21,-1.07 0.24,-0.6 0.41,-1.25 0.01,-1.83 -0.05,-0.55 1.2,0 0.86,-0.75 -0.45,-0.79 -0.3,-1.85 -1.26,-2.36 -0.47,-0.29 -0.98,-0.56 -1.37,-0.86 -0.42,0.28 -0.85,0.21 -1.19,-0.2 -0.57,-0.6 -1.85,-0.61 -1.72,-1.7 0.18,-0.43 0.1,-1.78 -0.62,-1.22 -0.17,0.44 -0.43,0.74 -0.89,0.87 -0.71,0.92 -2.04,0.24 -2.93,0.87 -0.49,0.28 -0.9,0.12 -1.15,-0.31 -0.68,-0.45 -1.84,-0.44 -2.21,-1.23 0.21,-0.61 -0.04,-1.24 -0.49,-1.61 0.25,-0.59 1.11,-0.28 1.36,-0.78 0.47,0.27 0.94,-0.21 0.51,-0.63 -0.6,-0.41 0.17,-1.39 -0.62,-1.58 -0.8,-0.29 -1.69,0.06 -2.03,0.8 -0.73,0.21 -1.51,-0.02 -1.97,-0.63 -0.45,-0.19 -1.31,-0.18 -0.96,-0.92 0.42,-1.4 2.91,-1.11 2.81,-2.78 -0.02,-0.79 -0.76,-1.12 -1.46,-1.02 -0.74,-0.49 -0.23,-1.62 0.01,-2.28 0.07,-0.84 -0.67,-1.62 -0.2,-2.45 -0.01,-0.95 -1.08,-1.21 -1.63,-1.75 -0.29,-0.44 -0.89,-1.12 -0.22,-1.54 0.59,-0.47 -0.22,-1.14 -0.7,-1.29 -0.29,-0.51 -0.96,-0.67 -1.32,-1.01 0.65,-0.4 0.49,-1.69 -0.42,-1.53 -0.93,0.06 -2.05,-0.18 -2.28,-1.2 -0.52,-0.39 -1.08,-1.35 -0.53,-1.94 0.31,-0.58 0.65,-1.21 1.39,-1.2 0.66,-0.47 -0.77,-0.84 -0.18,-1.34 0.43,-0.32 0.7,-0.79 0.48,-1.28 -0.02,-0.64 0.42,-1.1 0.86,-1.45 0.24,-0.83 0.18,-2.06 -0.9,-2.22 -0.7,-0.32 -0.2,-1.35 -0.83,-1.79 -0.85,-0.67 -1.34,-1.98 -2.45,-2.23 l -0.03,0.01 z",
					    "department-19" : "m 64.84,45.9 c -0.51,0.32 -1.1,0.5 -1.72,0.55 -0.96,0.33 -0.29,1.87 -1.24,2.15 -0.68,-0.01 -1.77,-0.32 -1.87,0.68 -0.23,0.65 -0.74,0.14 -1.1,0.03 -0.88,0.25 -0.4,1.39 -0.66,1.97 -0.43,0.21 -1.19,0.1 -1.23,0.81 -0.31,0.66 -1.14,-0.47 -1.51,0.23 -0.6,0.3 -1.15,-0.22 -1.45,-0.67 -0.71,-0.39 -1.64,-0.06 -1.7,0.81 -0.36,0.47 -1.07,0.58 -1.31,1.14 -0.89,0.51 -2.12,0.17 -2.77,1.15 -0.69,0.59 -1.21,1.3 -1.49,2.13 -0.6,0.75 -1.54,1.31 -2.49,1.15 -0.62,0.5 -0.63,1.65 -1.63,1.73 -0.88,0.35 -1.81,-0.96 -2.56,-0.05 -0.32,0.26 -1.14,0.45 -0.9,-0.26 -0.05,-1.07 -0.56,0.18 -1.03,0.31 -0.87,-0.02 -0.47,1.14 -0.94,1.59 -0.15,0.5 -0.5,0.76 -0.79,0.21 -1.02,-0.59 -1.49,1.08 -1.8,1.74 -0.15,0.44 -0.87,0.25 -1.02,0.77 -0.41,0.47 -0.73,1.82 -1.55,1.05 -0.85,-0.29 -1.77,-1.54 -2.52,-0.44 -0.6,0.32 -0.62,1.02 -0.79,1.57 -0.7,0.54 0.49,1.05 0.92,1.2 0.46,0.2 0.34,1.04 0.06,1.3 -0.59,-0.13 -1.41,0.46 -0.88,1.03 0.26,0.19 0.71,0.04 0.59,0.54 0.35,0.55 1.05,-0.35 1.49,0.18 1.04,0.35 0.57,1.82 -0.21,2.15 -1.36,0.29 -1.09,2.6 -2.65,2.52 -0.73,0.35 0.02,1.42 -0.51,1.97 -0.79,0.9 0.38,2.4 1.45,2.14 0.75,0.16 0.35,1.33 -0.12,1.65 -0.54,0.53 -1.66,0.51 -1.62,1.52 -0.11,1.03 1.27,0.44 1.85,0.51 0.78,0.24 1.36,1.47 0.45,1.94 -0.28,0.26 -1.4,0.81 -0.7,1.13 0.9,0.53 1.81,1.23 2.94,0.96 0.43,0.03 1.11,-0.24 1.16,0.34 0.65,0.2 1.44,-0.16 2.07,0.32 0.52,0.14 0.94,0.69 0.41,1.15 -0.39,0.4 -1.23,0.58 -0.67,1.25 -0.2,0.73 0.67,1.28 0.54,2.01 0.52,1.14 1.16,2.43 2.24,3.1 1.06,-0.12 1.58,-1.33 2.61,-1.58 0.41,-0.19 1.48,-0.65 1.37,0.21 0.09,0.79 0.91,0.26 1.2,-0.08 0.92,-0.06 1.88,0.35 2.81,0.44 0.58,0.16 1.09,0.49 1.27,1.07 0.42,0.72 1.33,0.7 1.67,1.5 0.56,0.65 0.64,1.83 1.7,1.92 1.25,0.27 0.91,1.93 2,2.33 0.41,0.06 0.5,-0.89 0.85,-0.2 0.63,0.69 1.63,0.1 1.76,-0.7 0.24,-0.18 0.74,0.17 0.89,-0.25 0.79,-0.29 1.59,-0.68 1.96,-1.52 0.47,-0.7 1.56,-1.04 2.02,-0.14 0.29,0.4 -0.03,1.52 0.72,0.83 0.84,-0.73 1.8,-1.24 2.92,-1.32 0.68,-0.27 1.37,-0.25 2.02,0.03 0.71,-0.16 1.39,-0.64 2.15,-0.32 1.01,0.18 1.69,-1.07 0.94,-1.8 -0.77,-0.8 -1.02,-1.94 -1.49,-2.92 0.23,-0.92 1.27,-1.41 1.94,-1.99 0.53,-0.33 1.62,0.35 1.68,-0.62 0.33,-0.87 0.4,-1.77 0.18,-2.66 0.32,-0.21 0.95,-0.17 1.14,-0.69 0.25,-0.47 0.23,-1.18 0.95,-1.16 0.41,-0.55 -0.68,-0.72 -0.92,-1.14 -0.45,-0.71 -0.82,-1.62 -0.66,-2.48 0.43,-0.88 1.35,-1.47 2.03,-2.1 0.04,-0.58 0.17,-1.13 0.71,-1.45 0.4,-0.5 0.6,-1.34 1.41,-1.24 1.13,-0.5 1.02,-2.35 2.45,-2.49 0.7,0.03 0.93,-0.61 0.79,-1.19 0.21,-0.73 0.69,-1.39 0.5,-2.22 0.09,-0.82 -0.56,-1.51 -0.59,-2.27 0.71,-0.37 1.68,-0.11 2.15,0.57 0.61,0.44 1.4,0.51 1.97,1.06 0.53,0.24 1.12,0.23 1.58,0.58 0.74,0.06 1.8,0.03 2.27,-0.63 -0.05,-0.97 -1.52,-1.27 -1.72,-2.06 0.39,-2.04 1.14,-4 1.07,-6.1 -0.13,-0.81 0.52,-2 -0.19,-2.63 -0.96,-0.5 -1.36,-1.7 -1.91,-2.58 -0.37,-0.58 0.22,-0.86 0.5,-1.22 0.3,-0.63 -0.23,-1.97 0.72,-2.12 0.57,0.18 1.39,0.09 1.31,-0.7 0.02,-0.54 -0.57,-1.01 -0.13,-1.57 0.49,-0.46 0.29,-1.05 0.05,-1.57 -0.05,-0.88 -0.6,-1.9 -1.44,-2.22 -0.65,0.12 -0.47,1.01 -1.12,1.19 -0.57,0.31 -1.04,1.38 -1.79,0.81 -0.89,-0.23 -1.8,-0.36 -2.66,-0.56 -0.88,-0.09 -0.75,0.88 -0.93,1.42 -0.32,0.74 -1.03,1.46 -1.92,1.28 -0.43,0.09 -1.19,0.77 -1.48,0.19 0,-0.67 -0.14,-1.55 -1.02,-1.48 -0.86,-0.14 -1.47,-0.92 -2.38,-0.75 0.04,-0.46 0.11,-1.14 -0.5,-1.19 -0.31,-0.26 -0.85,-1.29 -1.22,-0.58 0.13,0.79 -0.8,0.28 -1.04,0 -0.51,-0.39 -1.05,0.31 -1.57,-0.11 -0.33,-0.23 -0.94,0.45 -0.86,-0.24 0.11,-0.97 -1.08,-1.18 -1.46,-1.83 -0,0 -0.04,-0.02 -0.03,0 z"
					}
				}
			}
		}
	);
})(jQuery);