/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) / 3l) => i64vec4(55l, 44l, 64l, 25l)
 * (i64vec4(165l, 133l, 193l, 76l) / -1192l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) / 1048576l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) / 4251475l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) / 29852643761l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) / -4398046511104l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) / -3948976685146l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) / -135763469567146206l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / 3l) => i64vec4(26l, -5l, -17l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / -1192l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / 1048576l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / 4251475l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / 29852643761l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / -4398046511104l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / -3948976685146l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) / -135763469567146206l) => i64vec4(0l, 0l, 0l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / 3l), i64vec4(55l, 44l, 64l, 25l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / -1192l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / 1048576l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / 4251475l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / 29852643761l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / -4398046511104l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / -3948976685146l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) / -135763469567146206l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / 3l), i64vec4(26l, -5l, -17l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / -1192l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / 1048576l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / 4251475l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array11;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / 29852643761l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array12;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / -4398046511104l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array13;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / -3948976685146l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array14;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) / -135763469567146206l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
