/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u * uvec4(66u, 72u, 87u, 75u)) => uvec4(0u, 0u, 0u, 0u)
 * (0u * uvec4(24u, 40u, 23u, 74u)) => uvec4(0u, 0u, 0u, 0u)
 * (6u * uvec4(66u, 72u, 87u, 75u)) => uvec4(396u, 432u, 522u, 450u)
 * (6u * uvec4(24u, 40u, 23u, 74u)) => uvec4(144u, 240u, 138u, 444u)
 * (12u * uvec4(66u, 72u, 87u, 75u)) => uvec4(792u, 864u, 1044u, 900u)
 * (12u * uvec4(24u, 40u, 23u, 74u)) => uvec4(288u, 480u, 276u, 888u)
 * (32u * uvec4(66u, 72u, 87u, 75u)) => uvec4(2112u, 2304u, 2784u, 2400u)
 * (32u * uvec4(24u, 40u, 23u, 74u)) => uvec4(768u, 1280u, 736u, 2368u)
 * (74u * uvec4(66u, 72u, 87u, 75u)) => uvec4(4884u, 5328u, 6438u, 5550u)
 * (74u * uvec4(24u, 40u, 23u, 74u)) => uvec4(1776u, 2960u, 1702u, 5476u)
 */
#version 130

void main()
{
  float[all(equal((0u * uvec4(66u, 72u, 87u, 75u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((0u * uvec4(24u, 40u, 23u, 74u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array1;
  float[all(equal((6u * uvec4(66u, 72u, 87u, 75u)), uvec4(396u, 432u, 522u, 450u))) ? 1 : -1] array2;
  float[all(equal((6u * uvec4(24u, 40u, 23u, 74u)), uvec4(144u, 240u, 138u, 444u))) ? 1 : -1] array3;
  float[all(equal((12u * uvec4(66u, 72u, 87u, 75u)), uvec4(792u, 864u, 1044u, 900u))) ? 1 : -1] array4;
  float[all(equal((12u * uvec4(24u, 40u, 23u, 74u)), uvec4(288u, 480u, 276u, 888u))) ? 1 : -1] array5;
  float[all(equal((32u * uvec4(66u, 72u, 87u, 75u)), uvec4(2112u, 2304u, 2784u, 2400u))) ? 1 : -1] array6;
  float[all(equal((32u * uvec4(24u, 40u, 23u, 74u)), uvec4(768u, 1280u, 736u, 2368u))) ? 1 : -1] array7;
  float[all(equal((74u * uvec4(66u, 72u, 87u, 75u)), uvec4(4884u, 5328u, 6438u, 5550u))) ? 1 : -1] array8;
  float[all(equal((74u * uvec4(24u, 40u, 23u, 74u)), uvec4(1776u, 2960u, 1702u, 5476u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
