/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.builders;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.CommandKeyArgumentPreProcessor;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheConfig;
import redis.clients.jedis.csc.CacheFactory;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.executors.DefaultCommandExecutor;
import redis.clients.jedis.json.JsonObjectMapper;
import redis.clients.jedis.providers.ConnectionProvider;

public abstract class AbstractClientBuilder<T extends AbstractClientBuilder<T, C>, C> {
    protected GenericObjectPoolConfig<Connection> poolConfig = new ConnectionPoolConfig();
    protected Cache cache = null;
    protected CacheConfig cacheConfig = null;
    protected CommandExecutor commandExecutor = null;
    protected CommandObjects commandObjects = null;
    protected ConnectionProvider connectionProvider = null;
    protected CommandKeyArgumentPreProcessor keyPreProcessor = null;
    protected JsonObjectMapper jsonObjectMapper = null;
    protected int searchDialect = 2;
    protected JedisClientConfig clientConfig = null;

    public T clientConfig(JedisClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this.self();
    }

    protected abstract T self();

    protected abstract ConnectionProvider createDefaultConnectionProvider();

    protected CommandExecutor createDefaultCommandExecutor() {
        return new DefaultCommandExecutor(this.connectionProvider);
    }

    protected JedisClientConfig createDefaultClientConfig() {
        return DefaultJedisClientConfig.builder().build();
    }

    protected CommandObjects createDefaultCommandObjects() {
        return new CommandObjects();
    }

    protected abstract C createClient();

    protected abstract void validateSpecificConfiguration();

    public C build() {
        this.validateSpecificConfiguration();
        if (this.cacheConfig != null) {
            this.cache = CacheFactory.getCache(this.cacheConfig);
        }
        if (this.clientConfig == null) {
            this.clientConfig = this.createDefaultClientConfig();
        }
        if (this.connectionProvider == null) {
            this.connectionProvider = this.createDefaultConnectionProvider();
        }
        if (this.commandExecutor == null) {
            this.commandExecutor = this.createDefaultCommandExecutor();
        }
        if (this.commandObjects == null) {
            this.commandObjects = this.createDefaultCommandObjects();
        }
        this.applyCommandObjectsConfiguration(this.commandObjects);
        return this.createClient();
    }

    public T poolConfig(GenericObjectPoolConfig<Connection> poolConfig) {
        this.poolConfig = poolConfig;
        return this.self();
    }

    public T cache(Cache cache) {
        this.cache = cache;
        return this.self();
    }

    public T cacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        return this.self();
    }

    public T connectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this.self();
    }

    public T commandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this.self();
    }

    public T keyPreProcessor(CommandKeyArgumentPreProcessor keyPreProcessor) {
        this.keyPreProcessor = keyPreProcessor;
        return this.self();
    }

    public T jsonObjectMapper(JsonObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
        return this.self();
    }

    public T searchDialect(int searchDialect) {
        if (searchDialect == 0) {
            throw new IllegalArgumentException("DIALECT=0 cannot be set.");
        }
        this.searchDialect = searchDialect;
        return this.self();
    }

    public void applyCommandObjectsConfiguration(CommandObjects commandObjects) {
        if (this.keyPreProcessor != null) {
            commandObjects.setKeyArgumentPreProcessor(this.keyPreProcessor);
        }
        if (this.jsonObjectMapper != null) {
            commandObjects.setJsonObjectMapper(this.jsonObjectMapper);
        }
        if (this.searchDialect != 2) {
            commandObjects.setDefaultSearchDialect(this.searchDialect);
        }
    }

    protected void validateCommonConfiguration() {
        if ((this.cache != null || this.cacheConfig != null) && this.clientConfig != null && this.clientConfig.getRedisProtocol() != RedisProtocol.RESP3) {
            throw new IllegalArgumentException("Client-side caching is only supported with RESP3.");
        }
    }
}

