/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class M2cProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("#M2C,").expression("[^,]+,").expression("[^,]+,").number("d+,").number("(d+),").number("(d+),").expression("([LH]),").number("d+,").number("(d+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(-?d+),").number("(d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+.?d*),").any().compile();

    public M2cProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodePosition(Channel channel, SocketAddress remoteAddress, String line) {
        Parser parser = new Parser(PATTERN, line);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", parser.nextInt());
        if (parser.next().equals("H")) {
            position.set("archive", true);
        }
        position.set("event", parser.nextInt());
        position.setValid(true);
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setAltitude(parser.nextInt().intValue());
        position.setCourse(parser.nextInt().intValue());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.set("sat", parser.nextInt());
        position.set("odometer", parser.nextLong());
        position.set("input", parser.nextInt());
        position.set("output", parser.nextInt());
        position.set("power", (double)parser.nextInt().intValue() * 0.001);
        position.set("battery", (double)parser.nextInt().intValue() * 0.001);
        position.set("adc1", parser.nextInt());
        position.set("adc2", parser.nextInt());
        position.set("temp1", parser.nextDouble());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        sentence = sentence.substring(1);
        LinkedList<Position> positions = new LinkedList<Position>();
        for (String line : sentence.split("\r\n")) {
            Position position;
            if (line.isEmpty() || (position = this.decodePosition(channel, remoteAddress, line)) == null) continue;
            positions.add(position);
        }
        return positions;
    }
}

