#!/usr/bin/env bash

# run-clang-tidy.sh - Clang-tidy runner
# Usage: ./run-clang-tidy.sh [-j N] [--dry-run] [--no-fix]

# NOTE: This was mostly generated by Claude Sonnet 4

set -euo pipefail

# Change to project root directory
cd "$(dirname "$0")/.."

# Parse options
DRY_RUN=false
FIX=true

for arg in "$@"; do
    case $arg in
        --dry-run) DRY_RUN=true ;;
        --no-fix)  FIX=false ;;
    esac
done

# Configuration
BUILD_DIR="./build"
INCLUDES=(
    "-I./include"
    "-I./src"
    "-I./third_party/shared_mutex"
    "-I$BUILD_DIR"
    "-I./rocm_smi/include"
    "-I./esmi_ib_library/include"
    "-I./tests/amd_smi_test"
)

ARGS=("--header-filter=.*")
[[ "$FIX" == true ]] && ARGS+=("--fix")

# Fail if build dir doesn't exist
if ! test -d "$BUILD_DIR"; then
    echo "Error: Build directory '$BUILD_DIR' does not exist. Please run the build first."
    exit 1
fi

# Find all source files
mapfile -t FILES < <(
    find . \( -name build -o -name .git -o -path "./src/ras-decode-instinct-staging" -o -path "./esmi_ib_library" -o -path "./rocm_smi/include/rocm_smi/kfd_ioctl.h" \) -prune -o \
           \( -name "*.cc" -o -name "*.cpp" -o -name "*.c" \) -print
)

# Dry run - show what would be processed
if [[ "$DRY_RUN" == true ]]; then
    printf '%s\n' "${FILES[@]}"
    echo "Would process ${#FILES[@]} files"
    exit 0
fi

# Run clang-tidy
printf '%s\0' "${FILES[@]}" | \
    xargs -0 -I{} \
    clang-tidy "${ARGS[@]}" {} -- "${INCLUDES[@]}" -std=c++17

echo "Processed ${#FILES[@]} files"
