/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


/////////////////////// libXpertMassCore includes


/////////////////////// libXpertMassGUI includes
#include "MsXpS/libXpertMassGui/JavaScriptQObjectExposureRecord.hpp"

namespace MsXpS
{
namespace libXpertMassGui
{

JavaScriptQObjectExposureRecord::JavaScriptQObjectExposureRecord(
  QObject *object_p,
  QObject *object_parent_p,
  const QString &object_name,
  const QString &object_alias,
  const QString &object_description)
  : mp_object(object_p),
    mp_objectParent(object_parent_p),
    m_objectName(object_name),
    m_objectAlias(object_alias),
    m_objectDescription(object_description)
{
}

JavaScriptQObjectExposureRecord::~JavaScriptQObjectExposureRecord()
{
}

QObject *
JavaScriptQObjectExposureRecord::getObject()
{
  return mp_object;
}

QObject *
JavaScriptQObjectExposureRecord::getObjectParent()
{
  return mp_objectParent;
}

QString
JavaScriptQObjectExposureRecord::getObjectName()
{
  return m_objectName;
}

QString
JavaScriptQObjectExposureRecord::getObjectAlias()
{
  return m_objectAlias;
}

QString
JavaScriptQObjectExposureRecord::getObjectDescription()
{
  return m_objectDescription;
}


} // namespace libXpertMassGui
} // namespace MsXpS
