# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementApiManagementServiceOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_restore(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_restore(
                resource_group_name=resource_group.name,
                service_name="str",
                parameters={
                    "backupName": "str",
                    "containerName": "str",
                    "storageAccount": "str",
                    "accessKey": "str",
                    "accessType": "AccessKey",
                    "clientId": "str",
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_backup(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_backup(
                resource_group_name=resource_group.name,
                service_name="str",
                parameters={
                    "backupName": "str",
                    "containerName": "str",
                    "storageAccount": "str",
                    "accessKey": "str",
                    "accessType": "AccessKey",
                    "clientId": "str",
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_create_or_update(
                resource_group_name=resource_group.name,
                service_name="str",
                parameters={
                    "location": "str",
                    "publisherEmail": "str",
                    "publisherName": "str",
                    "sku": {"capacity": 0, "name": "str"},
                    "additionalLocations": [
                        {
                            "location": "str",
                            "sku": {"capacity": 0, "name": "str"},
                            "disableGateway": False,
                            "gatewayRegionalUrl": "str",
                            "natGatewayState": "str",
                            "outboundPublicIPAddresses": ["str"],
                            "platformVersion": "str",
                            "privateIPAddresses": ["str"],
                            "publicIPAddresses": ["str"],
                            "publicIpAddressId": "str",
                            "virtualNetworkConfiguration": {
                                "subnetResourceId": "str",
                                "subnetname": "str",
                                "vnetid": "str",
                            },
                            "zones": ["str"],
                        }
                    ],
                    "apiVersionConstraint": {"minApiVersion": "str"},
                    "certificates": [
                        {
                            "storeName": "str",
                            "certificate": {"expiry": "2020-02-20 00:00:00", "subject": "str", "thumbprint": "str"},
                            "certificatePassword": "str",
                            "encodedCertificate": "str",
                        }
                    ],
                    "configurationApi": {"legacyApi": "Enabled"},
                    "createdAtUtc": "2020-02-20 00:00:00",
                    "customProperties": {"str": "str"},
                    "developerPortalStatus": "Enabled",
                    "developerPortalUrl": "str",
                    "disableGateway": False,
                    "enableClientCertificate": False,
                    "etag": "str",
                    "gatewayRegionalUrl": "str",
                    "gatewayUrl": "str",
                    "hostnameConfigurations": [
                        {
                            "hostName": "str",
                            "type": "str",
                            "certificate": {"expiry": "2020-02-20 00:00:00", "subject": "str", "thumbprint": "str"},
                            "certificatePassword": "str",
                            "certificateSource": "str",
                            "certificateStatus": "str",
                            "defaultSslBinding": False,
                            "encodedCertificate": "str",
                            "identityClientId": "str",
                            "keyVaultId": "str",
                            "negotiateClientCertificate": False,
                        }
                    ],
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "legacyPortalStatus": "Enabled",
                    "managementApiUrl": "str",
                    "name": "str",
                    "natGatewayState": "str",
                    "notificationSenderEmail": "str",
                    "outboundPublicIPAddresses": ["str"],
                    "platformVersion": "str",
                    "portalUrl": "str",
                    "privateEndpointConnections": [
                        {
                            "groupIds": ["str"],
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "privateIPAddresses": ["str"],
                    "provisioningState": "str",
                    "publicIPAddresses": ["str"],
                    "publicIpAddressId": "str",
                    "publicNetworkAccess": "str",
                    "restore": False,
                    "scmUrl": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "targetProvisioningState": "str",
                    "type": "str",
                    "virtualNetworkConfiguration": {"subnetResourceId": "str", "subnetname": "str", "vnetid": "str"},
                    "virtualNetworkType": "str",
                    "zones": ["str"],
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_update(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_update(
                resource_group_name=resource_group.name,
                service_name="str",
                parameters={
                    "additionalLocations": [
                        {
                            "location": "str",
                            "sku": {"capacity": 0, "name": "str"},
                            "disableGateway": False,
                            "gatewayRegionalUrl": "str",
                            "natGatewayState": "str",
                            "outboundPublicIPAddresses": ["str"],
                            "platformVersion": "str",
                            "privateIPAddresses": ["str"],
                            "publicIPAddresses": ["str"],
                            "publicIpAddressId": "str",
                            "virtualNetworkConfiguration": {
                                "subnetResourceId": "str",
                                "subnetname": "str",
                                "vnetid": "str",
                            },
                            "zones": ["str"],
                        }
                    ],
                    "apiVersionConstraint": {"minApiVersion": "str"},
                    "certificates": [
                        {
                            "storeName": "str",
                            "certificate": {"expiry": "2020-02-20 00:00:00", "subject": "str", "thumbprint": "str"},
                            "certificatePassword": "str",
                            "encodedCertificate": "str",
                        }
                    ],
                    "configurationApi": {"legacyApi": "Enabled"},
                    "createdAtUtc": "2020-02-20 00:00:00",
                    "customProperties": {"str": "str"},
                    "developerPortalStatus": "Enabled",
                    "developerPortalUrl": "str",
                    "disableGateway": False,
                    "enableClientCertificate": False,
                    "etag": "str",
                    "gatewayRegionalUrl": "str",
                    "gatewayUrl": "str",
                    "hostnameConfigurations": [
                        {
                            "hostName": "str",
                            "type": "str",
                            "certificate": {"expiry": "2020-02-20 00:00:00", "subject": "str", "thumbprint": "str"},
                            "certificatePassword": "str",
                            "certificateSource": "str",
                            "certificateStatus": "str",
                            "defaultSslBinding": False,
                            "encodedCertificate": "str",
                            "identityClientId": "str",
                            "keyVaultId": "str",
                            "negotiateClientCertificate": False,
                        }
                    ],
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "legacyPortalStatus": "Enabled",
                    "managementApiUrl": "str",
                    "name": "str",
                    "natGatewayState": "str",
                    "notificationSenderEmail": "str",
                    "outboundPublicIPAddresses": ["str"],
                    "platformVersion": "str",
                    "portalUrl": "str",
                    "privateEndpointConnections": [
                        {
                            "groupIds": ["str"],
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "type": "str",
                        }
                    ],
                    "privateIPAddresses": ["str"],
                    "provisioningState": "str",
                    "publicIPAddresses": ["str"],
                    "publicIpAddressId": "str",
                    "publicNetworkAccess": "str",
                    "publisherEmail": "str",
                    "publisherName": "str",
                    "restore": False,
                    "scmUrl": "str",
                    "sku": {"capacity": 0, "name": "str"},
                    "tags": {"str": "str"},
                    "targetProvisioningState": "str",
                    "type": "str",
                    "virtualNetworkConfiguration": {"subnetResourceId": "str", "subnetname": "str", "vnetid": "str"},
                    "virtualNetworkType": "str",
                    "zones": ["str"],
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_get(self, resource_group):
        response = await self.client.api_management_service.get(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_delete(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_delete(
                resource_group_name=resource_group.name,
                service_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_migrate_to_stv2(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_migrate_to_stv2(
                resource_group_name=resource_group.name,
                service_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_list_by_resource_group(self, resource_group):
        response = self.client.api_management_service.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_list(self, resource_group):
        response = self.client.api_management_service.list(
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_get_sso_token(self, resource_group):
        response = await self.client.api_management_service.get_sso_token(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_check_name_availability(self, resource_group):
        response = await self.client.api_management_service.check_name_availability(
            parameters={"name": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_get_domain_ownership_identifier(self, resource_group):
        response = await self.client.api_management_service.get_domain_ownership_identifier(
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_api_management_service_begin_apply_network_configuration_updates(self, resource_group):
        response = await (
            await self.client.api_management_service.begin_apply_network_configuration_updates(
                resource_group_name=resource_group.name,
                service_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
