% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour-manip.R
\name{col2hcl}
\alias{col2hcl}
\title{Modify standard R colour in hcl colour space.}
\usage{
col2hcl(colour, h = NULL, c = NULL, l = NULL, alpha = NULL)
}
\arguments{
\item{colour}{character vector of colours to be modified}

\item{h}{Hue, \verb{[0, 360]}}

\item{c}{Chroma, \verb{[0, 100]}}

\item{l}{Luminance, \verb{[0, 100]}}

\item{alpha}{Alpha, \verb{[0, 1]}.}
}
\description{
Transforms rgb to hcl, sets non-missing arguments and then backtransforms
to rgb.
}
\examples{
reds <- rep("red", 6)
show_col(col2hcl(reds, h = seq(0, 180, length = 6)))
show_col(col2hcl(reds, c = seq(0, 80, length = 6)))
show_col(col2hcl(reds, l = seq(0, 100, length = 6)))
show_col(col2hcl(reds, alpha = seq(0, 1, length = 6)))
}
\seealso{
Other colour manipulation: 
\code{\link{alpha}()},
\code{\link{col_mix}()},
\code{\link{colour_manip}},
\code{\link{muted}()}
}
\concept{colour manipulation}
