# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Usb.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.usb


# structure
class UsbDevice(Structure):
    idlType = "usb.UsbDevice:3.0.0"
    elements = ["portNumber", "bus", "device", "vendorId", "productId", "manufacturer", "product"]

    def __init__(self, portNumber=0, bus=0, device=0, vendorId=0, productId=0, manufacturer="", product=""):
        typecheck.is_int(portNumber, AssertionError)
        typecheck.is_int(bus, AssertionError)
        typecheck.is_int(device, AssertionError)
        typecheck.is_int(vendorId, AssertionError)
        typecheck.is_int(productId, AssertionError)
        if not typecheck._is_int(manufacturer):
            typecheck.is_string(manufacturer, AssertionError)
        if not typecheck._is_int(product):
            typecheck.is_string(product, AssertionError)

        self.portNumber = portNumber
        self.bus = bus
        self.device = device
        self.vendorId = vendorId
        self.productId = productId
        self.manufacturer = manufacturer
        self.product = product

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            portNumber = json['portNumber'] if 'portNumber' in json or not useDefaults else 0,
            bus = json['bus'] if 'bus' in json or not useDefaults else 0,
            device = json['device'] if 'device' in json or not useDefaults else 0,
            vendorId = json['vendorId'] if 'vendorId' in json or not useDefaults else 0,
            productId = json['productId'] if 'productId' in json or not useDefaults else 0,
            manufacturer = json['manufacturer'] if 'manufacturer' in json or not useDefaults else "",
            product = json['product'] if 'product' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['portNumber'] = self.portNumber
        json['bus'] = self.bus
        json['device'] = self.device
        json['vendorId'] = self.vendorId
        json['productId'] = self.productId
        json['manufacturer'] = str(self.manufacturer)
        json['product'] = str(self.product)
        return json

# interface
class Usb(Interface):
    idlType = "usb.Usb:1.0.4"

    # structure
    class Settings(Structure):
        idlType = "usb.Usb_1_0_4.Settings:1.0.0"
        elements = ["hostPortsEnabled"]

        def __init__(self, hostPortsEnabled=False):
            typecheck.is_bool(hostPortsEnabled, AssertionError)

            self.hostPortsEnabled = hostPortsEnabled

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                hostPortsEnabled = json['hostPortsEnabled'] if 'hostPortsEnabled' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['hostPortsEnabled'] = self.hostPortsEnabled
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "usb.Usb_1_0_4.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.usb.Usb.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.usb.Usb.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.usb.Usb.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.usb.Usb.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.usb.Usb.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.usb.Usb.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.usb.Usb.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.usb.Usb.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.usb.Usb.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.usb.Usb.Settings(),
                newSettings = raritan.rpc.usb.Usb.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.usb.Usb.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.usb.Usb.SettingsChangedEvent, self).listElements()
            return elements

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.usb.Usb.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.usb.Usb.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.usb.Usb.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.usb.Usb.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getHostPortCount(Interface.Method):
        name = 'getHostPortCount'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getDevices(Interface.Method):
        name = 'getDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            usbDevices = [raritan.rpc.usb.UsbDevice.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['usbDevices']]
            for x0 in usbDevices:
                typecheck.is_struct(x0, raritan.rpc.usb.UsbDevice, DecodeException)
            return usbDevices
    def __init__(self, target, agent):
        super(Usb, self).__init__(target, agent)
        self.getSettings = Usb._getSettings(self)
        self.setSettings = Usb._setSettings(self)
        self.getHostPortCount = Usb._getHostPortCount(self)
        self.getDevices = Usb._getDevices(self)
