/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.AbstractContainerTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.google.TestMultimapGenerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.junit.contrib.truth.Truth;

@GwtCompatible
public abstract class AbstractMultimapTester<K, V>
extends AbstractContainerTester<Multimap<K, V>, Map.Entry<K, V>> {
    private Multimap<K, V> multimap;

    protected Multimap<K, V> multimap() {
        return this.multimap;
    }

    protected Map.Entry<K, V>[] createArrayWithNullKey() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullKeyLocation = this.getNullLocation();
        Map.Entry oldEntry = array[nullKeyLocation];
        array[nullKeyLocation] = Helpers.mapEntry(null, oldEntry.getValue());
        return array;
    }

    protected Map.Entry<K, V>[] createArrayWithNullValue() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullValueLocation = this.getNullLocation();
        Map.Entry oldEntry = array[nullValueLocation];
        array[nullValueLocation] = Helpers.mapEntry(oldEntry.getKey(), null);
        return array;
    }

    protected Map.Entry<K, V>[] createArrayWithNullKeyAndValue() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullValueLocation = this.getNullLocation();
        array[nullValueLocation] = Helpers.mapEntry(null, null);
        return array;
    }

    protected V getValueForNullKey() {
        return this.getEntryNullReplaces().getValue();
    }

    protected K getKeyForNullValue() {
        return this.getEntryNullReplaces().getKey();
    }

    private Map.Entry<K, V> getEntryNullReplaces() {
        Iterator entries = this.getSampleElements().iterator();
        for (int i = 0; i < this.getNullLocation(); ++i) {
            entries.next();
        }
        return (Map.Entry)entries.next();
    }

    protected void initMultimapWithNullKey() {
        this.resetContainer((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullKey()));
    }

    protected void initMultimapWithNullValue() {
        this.resetContainer((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullValue()));
    }

    protected void initMultimapWithNullKeyAndValue() {
        this.resetContainer((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullKeyAndValue()));
    }

    protected SampleElements<K> sampleKeys() {
        return ((TestMultimapGenerator)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getInnerGenerator()).sampleKeys();
    }

    protected SampleElements<V> sampleValues() {
        return ((TestMultimapGenerator)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getInnerGenerator()).sampleValues();
    }

    @Override
    protected Collection<Map.Entry<K, V>> actualContents() {
        return this.multimap.entries();
    }

    @Override
    protected Multimap<K, V> resetContainer(Multimap<K, V> newContents) {
        this.multimap = super.resetContainer(newContents);
        return this.multimap;
    }

    @Override
    protected Multimap<K, V> resetContainer(Map.Entry<K, V> ... newContents) {
        this.multimap = (Multimap)super.resetContainer(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(newContents));
        return this.multimap;
    }

    protected void resetCollection() {
        this.resetContainer();
    }

    protected void assertGet(K key, Object ... values) {
        Truth.ASSERT.that(this.multimap().get(key)).hasContentsAnyOrder(values);
        if (values.length > 0) {
            Truth.ASSERT.that((Collection)this.multimap().asMap().get(key)).hasContentsAnyOrder(values);
            AbstractMultimapTester.assertFalse((boolean)this.multimap().isEmpty());
        } else {
            Truth.ASSERT.that((Collection)this.multimap().asMap().get(key)).isNull();
        }
        Truth.ASSERT.that(Integer.valueOf(this.multimap().get(key).size())).is((Object)values.length);
        AbstractMultimapTester.assertEquals((values.length > 0 ? 1 : 0) != 0, (boolean)this.multimap().containsKey(key));
        AbstractMultimapTester.assertEquals((values.length > 0 ? 1 : 0) != 0, (boolean)this.multimap().keySet().contains(key));
        AbstractMultimapTester.assertEquals((values.length > 0 ? 1 : 0) != 0, (boolean)this.multimap().keys().contains(key));
    }
}

