#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Swapper
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250226.3

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-swapper'
GAME_NAME='The Swapper'

ARCHIVE_BASE_0_NAME='the-swapper-linux-1.24_1409159048.sh'
ARCHIVE_BASE_0_MD5='4f9627d245388edc320f61fae7cbd29f'
ARCHIVE_BASE_0_SIZE='980000'
ARCHIVE_BASE_0_VERSION='1.24-humble140404'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/the-swapper'

CONTENT_PATH_DEFAULT='data/noarch'
CONTENT_LIBS_FILES='
libfmodex.so'
CONTENT_LIBS_LIBS64_RELATIVE_PATH='lib64'
CONTENT_LIBS_LIBS64_FILES="$CONTENT_LIBS_FILES"
CONTENT_LIBS_LIBS32_RELATIVE_PATH='lib'
CONTENT_LIBS_LIBS32_FILES="$CONTENT_LIBS_FILES"
CONTENT_GAME_MAIN_FILES='
data
mono
TheSwapper.exe
TheSwapper.exe.config
BugReporter.exe
mainSettings.ini
config.xml
AdvanceMath.dll
Antlr3.Runtime.dll
C5.dll
FarseerPhysics331.dll
HackFlipcodeDecomposer.dll
ImageManipulation.dll
Jint.dll
Lidgren.Network.dll
MiniTK.dll
MiniTK.dll.config
MonoGame.Framework.dll
Newtonsoft.Json.dll
OptimusSwitcher.dll
Poly2Tri.dll
SDL2#.dll
SDL2#.dll.config
SteamManagedWrapper.dll
Steamworks.NET.dll
TargaImage.dll
TrueEngine.dll
TrueEngine.dll.config'
CONTENT_DOC_MAIN_FILES='
Licences
README*'

APP_MAIN_EXE='TheSwapper.exe'
## The icon must be explicitly set for mono games.
APP_MAIN_ICON='TheSwapper.exe'

PACKAGES_LIST='
PKG_MAIN
PKG_LIBS64
PKG_LIBS32'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_LIBS'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
Mono.Posix.dll
Mono.Security.dll
OpenTK.dll
OpenTK.Compatibility.dll
OpenTK.GLControl.dll
System.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Numerics.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Xml.dll
System.Xml.Linq.dll'

PKG_LIBS_ID="${GAME_ID}-libs"
PKG_LIBS64_ID="$PKG_LIBS_ID"
PKG_LIBS32_ID="$PKG_LIBS_ID"
PKG_LIBS_DESCRIPTION='Shipped libraries'
PKG_LIBS64_DESCRIPTION="$PKG_LIBS_DESCRIPTION"
PKG_LIBS32_DESCRIPTION="$PKG_LIBS_DESCRIPTION"
PKG_LIBS64_ARCH='64'
PKG_LIBS32_ARCH='32'
PKG_LIBS_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libm.so.6
libpthread.so.0
libstdc++.so.6'
PKG_LIBS32_DEPENDENCIES_LIBRARIES="$PKG_LIBS_DEPENDENCIES_LIBRARIES"
PKG_LIBS64_DEPENDENCIES_LIBRARIES="$PKG_LIBS_DEPENDENCIES_LIBRARIES"

# Delete unwanted Dropbox metadata files

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
find"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Delete unwanted Dropbox metadata files
	find . \
		-name '*:com.dropbox.attributes:$DATA' \
		-delete
)

# Include game data

content_inclusion_icons

## Use the shipped build of OpenTK on Arch Linux and Gentoo,
## as they do not provide it from their repositories.
case "$(option_value 'package')" in
	('arch'|'gentoo'|'egentoo')
		CONTENT_LIBS0_MAIN_FILES='
		OpenTK.dll
		OpenTK.Compatibility.dll
		OpenTK.GLControl.dll'
	;;
esac

content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
