/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.dff;

import com.kreative.dff.DFFResource;
import com.kreative.dff.DFFResourceAlreadyExistsException;
import com.kreative.dff.DFFResourceProvider;
import com.kreative.dff.DFFResourceTooBigException;
import com.kreative.dff.NotADFFFileException;
import com.kreative.ksfl.KSFLUtilities;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class DFFResourceArray
extends DFFResourceProvider {
    private byte[] arr;
    private int version;
    private boolean le;
    private int d2objectCount;
    private int d2headerSpace;
    private int d2nameSpace;
    private int d2dataSpace;
    private String textEncoding;
    private static final int INSERTED_TYPE_RECORD = 1;
    private static final int INSERTED_OBJECT_RECORD = 2;
    private static final int INSERTED_NAME = 3;
    private static final int INSERTED_DATA = 4;
    private static final int REMOVED_TYPE_RECORD = 1;
    private static final int REMOVED_OBJECT_RECORD = 2;
    private static final int REMOVED_NAME = 3;
    private static final int REMOVED_DATA = 4;

    private String ns(byte[] a, int b, int c) {
        try {
            return new String(a, b, c, this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(a, b, c);
        }
    }

    private byte[] gb(String a) {
        try {
            return a.getBytes(this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return a.getBytes();
        }
    }

    private int d1locate(long type, int id) {
        int i = 4;
        while (i + 16 <= this.arr.length) {
            if (KSFLUtilities.getLong(this.arr, i, this.le) == type && KSFLUtilities.getShort(this.arr, i + 8, this.le) == (short)id) {
                return i;
            }
            i += 16 + KSFLUtilities.getInt(this.arr, i + 12, this.le);
        }
        return 0;
    }

    private int[] d2locate(long type, int id) {
        int i = 0;
        int hi = this.d2headerSpace;
        int ni = this.d2nameSpace;
        int di = this.d2dataSpace;
        while (i < this.d2objectCount && hi < this.d2nameSpace && ni < this.d2dataSpace && di < this.arr.length) {
            if (KSFLUtilities.getLong(this.arr, hi, this.le) == type && (KSFLUtilities.getShort(this.arr, hi + 8, this.le) & 0xFFFF) == (id & 0xFFFF) && (KSFLUtilities.getShort(this.arr, hi + 14, this.le) << 16 & 0xFFFF0000) == (id & 0xFFFF0000)) {
                return new int[]{hi, ni, di, 20, (this.arr[ni] & 0xFF) + 1, KSFLUtilities.getInt(this.arr, hi + 16, this.le)};
            }
            di += KSFLUtilities.getInt(this.arr, hi + 16, this.le);
            ni += 1 + (this.arr[ni] & 0xFF);
            hi += 20;
            ++i;
        }
        return null;
    }

    private int[] d2locate(long type, String name) {
        int i = 0;
        int hi = this.d2headerSpace;
        int ni = this.d2nameSpace;
        int di = this.d2dataSpace;
        while (i < this.d2objectCount && hi < this.d2nameSpace && ni < this.d2dataSpace && di < this.arr.length) {
            if (KSFLUtilities.getLong(this.arr, hi, this.le) == type && this.ns(this.arr, ni + 1, this.arr[ni] & 0xFF).equals(name)) {
                return new int[]{hi, ni, di, 20, (this.arr[ni] & 0xFF) + 1, KSFLUtilities.getInt(this.arr, hi + 16, this.le)};
            }
            di += KSFLUtilities.getInt(this.arr, hi + 16, this.le);
            ni += 1 + (this.arr[ni] & 0xFF);
            hi += 20;
            ++i;
        }
        return null;
    }

    private void d3adjustTypeMap(int offset, int length, int whatInserted, long typeInserted, int idInserted) {
        int typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
        int ti = 0;
        while (ti < typeCnt) {
            long thisType = KSFLUtilities.getLong(this.arr, 8 + 16 * ti, this.le);
            int objTblOfst = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 12, this.le);
            if (objTblOfst > offset || objTblOfst == offset && length > 0 && (whatInserted != 2 || typeInserted != thisType)) {
                if ((long)objTblOfst + (long)length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException("Map too big. Map now corrupted. You're screwed.");
                }
                KSFLUtilities.putInt(this.arr, 8 + 16 * ti + 12, this.le, objTblOfst + length);
            }
            ++ti;
        }
    }

    private void d3adjustObjectMaps(int offset, int length, int whatInserted, long typeInserted, int idInserted) {
        int typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
        int ti = 0;
        while (ti < typeCnt) {
            long thisType = KSFLUtilities.getLong(this.arr, 8 + 16 * ti, this.le);
            int objCnt = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 8, this.le);
            int objTblOfst = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 12, this.le);
            int oi = 0;
            while (oi < objCnt) {
                long dataOfst;
                int thisID = KSFLUtilities.getInt(this.arr, objTblOfst + 24 * oi, this.le);
                int nameOfst = KSFLUtilities.getInt(this.arr, objTblOfst + 24 * oi + 8, this.le);
                if (nameOfst > 0 && (nameOfst > offset || nameOfst == offset && length > 0 && (whatInserted != 3 || typeInserted != thisType || idInserted != thisID))) {
                    if ((long)nameOfst + (long)length > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException("Map too big. Map now corrupted. You're screwed.");
                    }
                    KSFLUtilities.putInt(this.arr, objTblOfst + 24 * oi + 8, this.le, nameOfst + length);
                }
                if ((dataOfst = KSFLUtilities.getUInt48(this.arr, objTblOfst + 24 * oi + 12, this.le)) > 0L && (dataOfst > (long)offset || dataOfst == (long)offset && length > 0 && (whatInserted != 4 || typeInserted != thisType || idInserted != thisID))) {
                    if (dataOfst + (long)length > 0xFFFFFFFFFFFFL) {
                        throw new DFFResourceTooBigException("Map too big. Map now corrupted. You're screwed.");
                    }
                    KSFLUtilities.putUInt48(this.arr, objTblOfst + 24 * oi + 12, this.le, dataOfst + (long)length);
                }
                ++oi;
            }
            ++ti;
        }
    }

    private void d3adjustMetrics(int[] a, int offset, int length, int whatInserted) {
        if (a[1] > offset || a[1] == offset && length > 0 && whatInserted != 1) {
            a[1] = a[1] + length;
        }
        if (a[3] > offset || a[3] == offset && length > 0 && whatInserted != 2) {
            a[3] = a[3] + length;
        }
        if (a[4] > offset || a[4] == offset && length > 0 && whatInserted != 2) {
            a[4] = a[4] + length;
        }
        if (a[5] > offset || a[5] == offset && length > 0 && whatInserted != 3) {
            a[5] = a[5] + length;
        }
        if (a[6] > offset || a[6] == offset && length > 0 && whatInserted != 3) {
            a[6] = a[6] + length;
        }
        if (a[7] > offset || a[7] == offset && length > 0 && whatInserted != 4) {
            a[7] = a[7] + length;
        }
        if (a[8] > offset || a[8] == offset && length > 0 && whatInserted != 4) {
            a[8] = a[8] + length;
        }
    }

    private void d3adjustLocation(int[] a, int offset, int length, int whatInserted) {
        if (a[0] > offset || a[0] == offset && length > 0 && whatInserted != 1) {
            a[0] = a[0] + length;
        }
        if (a[3] > offset || a[3] == offset && length > 0 && whatInserted != 2) {
            a[3] = a[3] + length;
        }
        if (a[5] > offset || a[5] == offset && length > 0 && whatInserted != 2) {
            a[5] = a[5] + length;
        }
        if (a[7] > offset || a[7] == offset && length > 0 && whatInserted != 3) {
            a[7] = a[7] + length;
        }
        if (a[9] > offset || a[9] == offset && length > 0 && whatInserted != 4) {
            a[9] = a[9] + length;
        }
    }

    private int[] d3metrics() {
        int objTblMin = Integer.MAX_VALUE;
        int objTblMax = 0;
        int nameMin = Integer.MAX_VALUE;
        int nameMax = 0;
        int dataMin = Integer.MAX_VALUE;
        int dataMax = 0;
        int typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
        int ti = 0;
        while (ti < typeCnt) {
            int objCnt = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 8, this.le);
            int objTblOfst = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 12, this.le);
            if (objTblOfst > 0) {
                if (objTblOfst < objTblMin) {
                    objTblMin = objTblOfst;
                }
                if (objTblOfst + 24 * objCnt > objTblMax) {
                    objTblMax = objTblOfst + 24 * objCnt;
                }
            }
            int oi = 0;
            while (oi < objCnt) {
                long dataOfst;
                int nameOfst = KSFLUtilities.getInt(this.arr, objTblOfst + 24 * oi + 8, this.le);
                if (nameOfst > 0) {
                    int nameLen = (this.arr[nameOfst] & 0xFF) + 1;
                    if (nameOfst < nameMin) {
                        nameMin = nameOfst;
                    }
                    if (nameOfst + nameLen > nameMax) {
                        nameMax = nameOfst + nameLen;
                    }
                }
                if ((dataOfst = KSFLUtilities.getUInt48(this.arr, objTblOfst + 24 * oi + 12, this.le)) > 0L) {
                    int dLen;
                    long dataLen = KSFLUtilities.getUInt48(this.arr, objTblOfst + 24 * oi + 18, this.le);
                    int dOfst = dataOfst > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)dataOfst;
                    int n = dLen = dataLen > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)dataLen;
                    if (dataOfst < (long)dataMin) {
                        dataMin = dOfst;
                    }
                    if (dataOfst + dataLen > (long)dataMax) {
                        dataMax = dOfst + dLen;
                    }
                }
                ++oi;
            }
            ++ti;
        }
        if (objTblMin > objTblMax) {
            objTblMin = objTblMax = 8 + typeCnt * 16;
        }
        if (nameMin > nameMax) {
            nameMin = nameMax = objTblMax;
        }
        if (dataMin > dataMax) {
            dataMin = dataMax = nameMax;
        }
        return new int[]{typeCnt, 8, typeCnt * 16, objTblMin, objTblMax, nameMin, nameMax, dataMin, dataMax};
    }

    private int[] d3getType(long type) {
        int typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
        int ti = 0;
        while (ti < typeCnt) {
            long t = KSFLUtilities.getLong(this.arr, 8 + 16 * ti, this.le);
            int objCnt = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 8, this.le);
            int objTblOfst = KSFLUtilities.getInt(this.arr, 8 + 16 * ti + 12, this.le);
            if (t == type) {
                return new int[]{8 + 16 * ti, 16, objCnt, objTblOfst, 24 * objCnt};
            }
            ++ti;
        }
        return null;
    }

    private int[] d3locate(long type, int id) {
        int[] ty = this.d3getType(type);
        if (ty != null) {
            int oi = 0;
            while (oi < ty[2]) {
                int i = KSFLUtilities.getInt(this.arr, ty[3] + 24 * oi, this.le);
                if (i == id) {
                    int nameOfst = KSFLUtilities.getInt(this.arr, ty[3] + 24 * oi + 8, this.le);
                    long dataOfst = KSFLUtilities.getUInt48(this.arr, ty[3] + 24 * oi + 12, this.le);
                    long dataLen = KSFLUtilities.getUInt48(this.arr, ty[3] + 24 * oi + 18, this.le);
                    if (dataOfst > Integer.MAX_VALUE || dataLen > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    int nameLen = nameOfst > 0 ? (this.arr[nameOfst] & 0xFF) + 1 : 0;
                    return new int[]{ty[0], ty[1], ty[2], ty[3], ty[4], ty[3] + 24 * oi, 24, nameOfst, nameLen, (int)dataOfst, (int)dataLen};
                }
                ++oi;
            }
        }
        return null;
    }

    private int[] d3locate(long type, String name) {
        int[] ty = this.d3getType(type);
        if (ty != null) {
            int oi = 0;
            while (oi < ty[2]) {
                String n;
                int nameOfst = KSFLUtilities.getInt(this.arr, ty[3] + 24 * oi + 8, this.le);
                int nameLen = nameOfst > 0 ? (this.arr[nameOfst] & 0xFF) + 1 : 0;
                String string = n = nameOfst > 0 ? this.ns(this.arr, nameOfst + 1, nameLen - 1) : "";
                if (n.equals(name)) {
                    long dataOfst = KSFLUtilities.getUInt48(this.arr, ty[3] + 24 * oi + 12, this.le);
                    long dataLen = KSFLUtilities.getUInt48(this.arr, ty[3] + 24 * oi + 18, this.le);
                    if (dataOfst > Integer.MAX_VALUE || dataLen > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    return new int[]{ty[0], ty[1], ty[2], ty[3], ty[4], ty[3] + 24 * oi, 24, nameOfst, nameLen, (int)dataOfst, (int)dataLen};
                }
                ++oi;
            }
        }
        return null;
    }

    private void d3cut(int[] metrics, int[] loc, int offset, int length, int what, long type, int id) {
        this.arr = KSFLUtilities.cut(this.arr, offset, length);
        this.d3adjustTypeMap(offset, -length, what, type, id);
        this.d3adjustObjectMaps(offset, -length, what, type, id);
        if (loc != null) {
            this.d3adjustLocation(loc, offset, -length, what);
        }
        if (metrics != null) {
            this.d3adjustMetrics(metrics, offset, -length, what);
        }
    }

    private void d3paste(int[] metrics, int[] loc, int offset, byte[] stuff, int what, long type, int id) {
        this.arr = KSFLUtilities.paste(this.arr, offset, stuff);
        this.d3adjustTypeMap(offset, stuff.length, what, type, id);
        this.d3adjustObjectMaps(offset, stuff.length, what, type, id);
        if (loc != null) {
            this.d3adjustLocation(loc, offset, stuff.length, what);
        }
        if (metrics != null) {
            this.d3adjustMetrics(metrics, offset, stuff.length, what);
        }
    }

    private void d3paste(int[] metrics, int[] loc, int offset, int length, int what, long type, int id) {
        this.arr = KSFLUtilities.paste(this.arr, offset, length);
        this.d3adjustTypeMap(offset, length, what, type, id);
        this.d3adjustObjectMaps(offset, length, what, type, id);
        if (loc != null) {
            this.d3adjustLocation(loc, offset, length, what);
        }
        if (metrics != null) {
            this.d3adjustMetrics(metrics, offset, length, what);
        }
    }

    public DFFResourceArray(int version) throws NotADFFFileException {
        this.textEncoding = "UTF-8";
        this.version = version;
        this.le = false;
        switch (version) {
            case 1: {
                this.arr = new byte[]{37, 68, 70, 70};
                break;
            }
            case 2: {
                byte[] byArray = new byte[8];
                byArray[0] = 37;
                byArray[1] = 68;
                byArray[2] = 70;
                byArray[3] = 50;
                this.arr = byArray;
                this.d2objectCount = 0;
                this.d2dataSpace = 8;
                this.d2nameSpace = 8;
                this.d2headerSpace = 8;
                break;
            }
            case 3: {
                byte[] byArray = new byte[8];
                byArray[0] = 37;
                byArray[1] = 68;
                byArray[2] = 70;
                byArray[3] = 51;
                this.arr = byArray;
                break;
            }
            default: {
                throw new NotADFFFileException("Invalid version number: " + version);
            }
        }
    }

    public DFFResourceArray(int version, boolean le) throws NotADFFFileException {
        block11: {
            block10: {
                this.textEncoding = "UTF-8";
                this.version = version;
                this.le = le;
                if (!le) break block10;
                switch (version) {
                    case 1: {
                        this.arr = new byte[]{70, 70, 68, 37};
                        break block11;
                    }
                    case 2: {
                        byte[] byArray = new byte[8];
                        byArray[0] = 50;
                        byArray[1] = 70;
                        byArray[2] = 68;
                        byArray[3] = 37;
                        this.arr = byArray;
                        this.d2objectCount = 0;
                        this.d2dataSpace = 8;
                        this.d2nameSpace = 8;
                        this.d2headerSpace = 8;
                        break block11;
                    }
                    case 3: {
                        byte[] byArray = new byte[8];
                        byArray[0] = 51;
                        byArray[1] = 70;
                        byArray[2] = 68;
                        byArray[3] = 37;
                        this.arr = byArray;
                        break block11;
                    }
                    default: {
                        throw new NotADFFFileException("Invalid version number: " + version);
                    }
                }
            }
            switch (version) {
                case 1: {
                    this.arr = new byte[]{37, 68, 70, 70};
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[8];
                    byArray[0] = 37;
                    byArray[1] = 68;
                    byArray[2] = 70;
                    byArray[3] = 50;
                    this.arr = byArray;
                    this.d2objectCount = 0;
                    this.d2dataSpace = 8;
                    this.d2nameSpace = 8;
                    this.d2headerSpace = 8;
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[8];
                    byArray[0] = 37;
                    byArray[1] = 68;
                    byArray[2] = 70;
                    byArray[3] = 51;
                    this.arr = byArray;
                    break;
                }
                default: {
                    throw new NotADFFFileException("Invalid version number: " + version);
                }
            }
        }
    }

    public DFFResourceArray(byte[] data) throws NotADFFFileException {
        this.textEncoding = "UTF-8";
        if (data.length < 4) {
            throw new NotADFFFileException("Byte array is too small");
        }
        int v = KSFLUtilities.getInt(data, 0, false);
        switch (v) {
            case 625231430: {
                this.arr = data;
                this.version = 1;
                this.le = false;
                break;
            }
            case 1179010085: {
                this.arr = data;
                this.version = 1;
                this.le = true;
                break;
            }
            case 625231410: {
                if (data.length < 8) {
                    throw new NotADFFFileException("Byte array is too small");
                }
                this.arr = data;
                this.version = 2;
                this.le = false;
                this.d2objectCount = KSFLUtilities.getInt(data, 4, this.le);
                this.d2headerSpace = 8;
                this.d2dataSpace = this.d2nameSpace = this.d2headerSpace + 20 * this.d2objectCount;
                int nh1 = this.d2objectCount;
                while (nh1 > 0) {
                    this.d2dataSpace += (data[this.d2dataSpace] & 0xFF) + 1;
                    --nh1;
                }
                break;
            }
            case 843465765: {
                if (data.length < 8) {
                    throw new NotADFFFileException("Byte array is too small");
                }
                this.arr = data;
                this.version = 2;
                this.le = true;
                this.d2objectCount = KSFLUtilities.getInt(data, 4, this.le);
                this.d2headerSpace = 8;
                this.d2dataSpace = this.d2nameSpace = this.d2headerSpace + 20 * this.d2objectCount;
                int nh2 = this.d2objectCount;
                while (nh2 > 0) {
                    this.d2dataSpace += (data[this.d2dataSpace] & 0xFF) + 1;
                    --nh2;
                }
                break;
            }
            case 625231411: {
                if (data.length < 8) {
                    throw new NotADFFFileException("Byte array is too small");
                }
                this.arr = data;
                this.version = 3;
                this.le = false;
                break;
            }
            case 860242981: {
                if (data.length < 8) {
                    throw new NotADFFFileException("Byte array is too small");
                }
                this.arr = data;
                this.version = 3;
                this.le = true;
                break;
            }
            default: {
                throw new NotADFFFileException("Invalid magic number: " + Integer.toHexString(v));
            }
        }
    }

    public synchronized String getTextEncoding() {
        return this.textEncoding;
    }

    public synchronized void setTextEncoding(String encoding) {
        this.textEncoding = encoding;
    }

    public byte[] getBytes() {
        return this.arr;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public synchronized boolean add(DFFResource r) throws DFFResourceAlreadyExistsException {
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        switch (this.version) {
            case 1: {
                if ((long)this.arr.length + 16L + (long)r.data.length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                if (this.d1locate(r.type, r.id) > 0) {
                    throw new DFFResourceAlreadyExistsException();
                }
                byte[] stuff = KSFLUtilities.paste(r.data, 0, 16);
                KSFLUtilities.putLong(stuff, 0, this.le, r.type);
                KSFLUtilities.putShort(stuff, 8, this.le, (short)r.id);
                KSFLUtilities.putInt(stuff, 12, this.le, r.data.length);
                this.arr = KSFLUtilities.paste(this.arr, this.arr.length, stuff);
                return true;
            }
            case 2: {
                if ((long)this.arr.length + 21L + (long)this.gb(r.name).length + (long)r.data.length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                if (this.d2locate(r.type, r.id) != null) {
                    throw new DFFResourceAlreadyExistsException();
                }
                byte[] h = new byte[20];
                KSFLUtilities.putLong(h, 0, this.le, r.type);
                KSFLUtilities.putShort(h, 8, this.le, (short)(r.id & 0xFFFF));
                KSFLUtilities.putShort(h, 10, this.le, r.datatype);
                KSFLUtilities.putShort(h, 12, this.le, r.getAttributes());
                KSFLUtilities.putShort(h, 14, this.le, (short)(r.id >> 16 & 0xFFFF));
                KSFLUtilities.putInt(h, 16, this.le, r.data.length);
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.cut(n, 255, n.length - 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                this.arr = KSFLUtilities.paste(this.arr, this.arr.length, r.data);
                this.arr = KSFLUtilities.paste(this.arr, this.d2dataSpace, n);
                this.arr = KSFLUtilities.paste(this.arr, this.d2nameSpace, h);
                this.d2dataSpace += h.length + n.length;
                this.d2nameSpace += h.length;
                KSFLUtilities.putInt(this.arr, 4, this.le, ++this.d2objectCount);
                return true;
            }
            case 3: {
                if ((long)this.arr.length + 24L + (r.name.length() > 0 ? (long)this.gb(r.name).length + 1L : 0L) + (this.d3getType(r.type) == null ? 16L : 0L) + (long)r.data.length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                if (this.d3locate(r.type, r.id) != null) {
                    throw new DFFResourceAlreadyExistsException();
                }
                int[] t = this.d3getType(r.type);
                int[] m = this.d3metrics();
                if (t == null) {
                    if (m[0] == Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException("Too many types.");
                    }
                    byte[] th = new byte[16];
                    KSFLUtilities.putLong(th, 0, this.le, r.type);
                    KSFLUtilities.putInt(th, 8, this.le, 0);
                    KSFLUtilities.putInt(th, 12, this.le, m[4]);
                    KSFLUtilities.putInt(this.arr, 4, this.le, m[0] + 1);
                    this.d3paste(m, null, m[1] + m[2], th, 1, r.type, r.id);
                    t = this.d3getType(r.type);
                } else if (t[2] == Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException("Too many objects of this type.");
                }
                byte[] h = new byte[24];
                KSFLUtilities.putInt(h, 0, this.le, r.id);
                KSFLUtilities.putShort(h, 4, this.le, r.datatype);
                KSFLUtilities.putShort(h, 6, this.le, r.getAttributes());
                KSFLUtilities.putInt(h, 8, this.le, r.name.length() > 0 ? m[6] : 0);
                KSFLUtilities.putUInt48(h, 12, this.le, r.data.length > 0 ? m[8] : 0);
                KSFLUtilities.putUInt48(h, 18, this.le, r.data.length);
                KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2] + 1);
                this.d3paste(m, null, t[3] + t[4], h, 2, r.type, r.id);
                if (r.name.length() > 0) {
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.cut(n, 255, n.length - 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    this.d3paste(m, null, m[6], n, 3, r.type, r.id);
                }
                if (r.data.length > 0) {
                    this.d3paste(m, null, m[8], r.data, 4, r.type, r.id);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean contains(long type, int id) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                return d1i > 0;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                return d2i != null;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                return d3i != null;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean contains(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                return d2i != null;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                return d3i != null;
            }
        }
        return false;
    }

    @Override
    public synchronized DFFResource get(long type, int id) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                long d1t = KSFLUtilities.getLong(this.arr, d1i, this.le);
                short d1id = KSFLUtilities.getShort(this.arr, d1i + 8, this.le);
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                byte[] d1a = KSFLUtilities.copy(this.arr, d1i + 16, d1l);
                return new DFFResource(d1t, d1id, d1a);
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d2i[0], this.le);
                int i = KSFLUtilities.getShort(this.arr, d2i[0] + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2i[0] + 14, this.le) << 16 & 0xFFFF0000;
                short dt = KSFLUtilities.getShort(this.arr, d2i[0] + 10, this.le);
                short f = KSFLUtilities.getShort(this.arr, d2i[0] + 12, this.le);
                String n = this.ns(this.arr, d2i[1] + 1, d2i[4] - 1);
                byte[] d = KSFLUtilities.copy(this.arr, d2i[2], d2i[5]);
                return new DFFResource(t, i, dt, f, n, d);
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d3i[0], this.le);
                int i = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                short dt = KSFLUtilities.getShort(this.arr, d3i[5] + 4, this.le);
                short f = KSFLUtilities.getShort(this.arr, d3i[5] + 6, this.le);
                String n = d3i[7] > 0 ? this.ns(this.arr, d3i[7] + 1, d3i[8] - 1) : "";
                byte[] d = d3i[9] > 0 ? KSFLUtilities.copy(this.arr, d3i[9], d3i[10]) : new byte[]{};
                return new DFFResource(t, i, dt, f, n, d);
            }
        }
        return null;
    }

    @Override
    public synchronized DFFResource get(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d2i[0], this.le);
                int id = KSFLUtilities.getShort(this.arr, d2i[0] + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2i[0] + 14, this.le) << 16 & 0xFFFF0000;
                short dt = KSFLUtilities.getShort(this.arr, d2i[0] + 10, this.le);
                short f = KSFLUtilities.getShort(this.arr, d2i[0] + 12, this.le);
                String n = this.ns(this.arr, d2i[1] + 1, d2i[4] - 1);
                byte[] d = KSFLUtilities.copy(this.arr, d2i[2], d2i[5]);
                return new DFFResource(t, id, dt, f, n, d);
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d3i[0], this.le);
                int i = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                short dt = KSFLUtilities.getShort(this.arr, d3i[5] + 4, this.le);
                short f = KSFLUtilities.getShort(this.arr, d3i[5] + 6, this.le);
                String n = d3i[7] > 0 ? this.ns(this.arr, d3i[7] + 1, d3i[8] - 1) : "";
                byte[] d = d3i[9] > 0 ? KSFLUtilities.copy(this.arr, d3i[9], d3i[10]) : new byte[]{};
                return new DFFResource(t, i, dt, f, n, d);
            }
        }
        return null;
    }

    @Override
    public synchronized DFFResource getAttributes(long type, int id) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                long d1t = KSFLUtilities.getLong(this.arr, d1i, this.le);
                short d1id = KSFLUtilities.getShort(this.arr, d1i + 8, this.le);
                return new DFFResource(d1t, d1id, new byte[0]);
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d2i[0], this.le);
                int i = KSFLUtilities.getShort(this.arr, d2i[0] + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2i[0] + 14, this.le) << 16 & 0xFFFF0000;
                short dt = KSFLUtilities.getShort(this.arr, d2i[0] + 10, this.le);
                short f = KSFLUtilities.getShort(this.arr, d2i[0] + 12, this.le);
                String n = this.ns(this.arr, d2i[1] + 1, d2i[4] - 1);
                byte[] d = new byte[]{};
                return new DFFResource(t, i, dt, f, n, d);
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d3i[0], this.le);
                int i = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                short dt = KSFLUtilities.getShort(this.arr, d3i[5] + 4, this.le);
                short f = KSFLUtilities.getShort(this.arr, d3i[5] + 6, this.le);
                String n = d3i[7] > 0 ? this.ns(this.arr, d3i[7] + 1, d3i[8] - 1) : "";
                byte[] d = new byte[]{};
                return new DFFResource(t, i, dt, f, n, d);
            }
        }
        return null;
    }

    @Override
    public synchronized DFFResource getAttributes(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d2i[0], this.le);
                int i = KSFLUtilities.getShort(this.arr, d2i[0] + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2i[0] + 14, this.le) << 16 & 0xFFFF0000;
                short dt = KSFLUtilities.getShort(this.arr, d2i[0] + 10, this.le);
                short f = KSFLUtilities.getShort(this.arr, d2i[0] + 12, this.le);
                String n = this.ns(this.arr, d2i[1] + 1, d2i[4] - 1);
                byte[] d = new byte[]{};
                return new DFFResource(t, i, dt, f, n, d);
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                long t = KSFLUtilities.getLong(this.arr, d3i[0], this.le);
                int i = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                short dt = KSFLUtilities.getShort(this.arr, d3i[5] + 4, this.le);
                short f = KSFLUtilities.getShort(this.arr, d3i[5] + 6, this.le);
                String n = d3i[7] > 0 ? this.ns(this.arr, d3i[7] + 1, d3i[8] - 1) : "";
                byte[] d = new byte[]{};
                return new DFFResource(t, i, dt, f, n, d);
            }
        }
        return null;
    }

    @Override
    public synchronized long getLength(long type, int id) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                return d1l;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                return d2i[5];
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                return d3i[10];
            }
        }
        return 0L;
    }

    @Override
    public synchronized long getLength(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                return d2i[5];
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                return d3i[10];
            }
        }
        return 0L;
    }

    @Override
    public synchronized byte[] getData(long type, int id) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                byte[] d1a = KSFLUtilities.copy(this.arr, d1i + 16, d1l);
                return d1a;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                byte[] d = KSFLUtilities.copy(this.arr, d2i[2], d2i[5]);
                return d;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                byte[] d = d3i[9] > 0 ? KSFLUtilities.copy(this.arr, d3i[9], d3i[10]) : new byte[]{};
                return d;
            }
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                byte[] d = KSFLUtilities.copy(this.arr, d2i[2], d2i[5]);
                return d;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                byte[] d = d3i[9] > 0 ? KSFLUtilities.copy(this.arr, d3i[9], d3i[10]) : new byte[]{};
                return d;
            }
        }
        return null;
    }

    @Override
    public synchronized int read(long type, int id, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                int begin = (int)((long)(d1i + 16) + doffset);
                int end = d1i + 16 + d1l;
                int d = off;
                int s = begin;
                while (d < off + len && s < end) {
                    data[d] = this.arr[s];
                    ++d;
                    ++s;
                }
                return Math.max(0, Math.min(len, end - begin));
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                int begin = (int)((long)d2i[2] + doffset);
                int end = d2i[2] + d2i[5];
                int d = off;
                int s = begin;
                while (d < off + len && s < end) {
                    data[d] = this.arr[s];
                    ++d;
                    ++s;
                }
                return Math.max(0, Math.min(len, end - begin));
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                int begin = (int)((long)d3i[9] + doffset);
                int end = d3i[9] + d3i[10];
                int d = off;
                int s = begin;
                while (d < off + len && s < end) {
                    data[d] = this.arr[s];
                    ++d;
                    ++s;
                }
                return Math.max(0, Math.min(len, end - begin));
            }
        }
        return 0;
    }

    @Override
    public synchronized int read(long type, String name, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                int begin = (int)((long)d2i[2] + doffset);
                int end = d2i[2] + d2i[5];
                int d = off;
                int s = begin;
                while (d < off + len && s < end) {
                    data[d] = this.arr[s];
                    ++d;
                    ++s;
                }
                return Math.max(0, Math.min(len, end - begin));
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int begin = (int)((long)d3i[9] + doffset);
                int end = d3i[9] + d3i[10];
                int d = off;
                int s = begin;
                while (d < off + len && s < end) {
                    data[d] = this.arr[s];
                    ++d;
                    ++s;
                }
                return Math.max(0, Math.min(len, end - begin));
            }
        }
        return 0;
    }

    @Override
    public synchronized boolean remove(long type, int id) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                this.arr = KSFLUtilities.cut(this.arr, d1i, 16 + d1l);
                return true;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                this.arr = KSFLUtilities.cut(this.arr, d2i[2], d2i[5]);
                this.arr = KSFLUtilities.cut(this.arr, d2i[1], d2i[4]);
                this.arr = KSFLUtilities.cut(this.arr, d2i[0], d2i[3]);
                this.d2dataSpace -= d2i[3] + d2i[4];
                this.d2nameSpace -= d2i[3];
                KSFLUtilities.putInt(this.arr, 4, this.le, --this.d2objectCount);
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                if (d3i[9] > 0) {
                    this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                }
                if (d3i[7] > 0) {
                    this.d3cut(null, d3i, d3i[7], d3i[8], 3, type, id);
                }
                if (d3i[2] < 2) {
                    KSFLUtilities.putInt(this.arr, 4, this.le, KSFLUtilities.getInt(this.arr, 4, this.le) - 1);
                    this.d3cut(null, d3i, d3i[0], d3i[1], 1, type, id);
                } else {
                    KSFLUtilities.putInt(this.arr, d3i[0] + 8, this.le, d3i[2] - 1);
                }
                if (d3i[5] > 0) {
                    this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean remove(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                this.arr = KSFLUtilities.cut(this.arr, d2i[2], d2i[5]);
                this.arr = KSFLUtilities.cut(this.arr, d2i[1], d2i[4]);
                this.arr = KSFLUtilities.cut(this.arr, d2i[0], d2i[3]);
                this.d2dataSpace -= d2i[3] + d2i[4];
                this.d2nameSpace -= d2i[3];
                KSFLUtilities.putInt(this.arr, 4, this.le, --this.d2objectCount);
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int id = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                if (d3i[9] > 0) {
                    this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                }
                if (d3i[7] > 0) {
                    this.d3cut(null, d3i, d3i[7], d3i[8], 3, type, id);
                }
                if (d3i[2] < 2) {
                    KSFLUtilities.putInt(this.arr, 4, this.le, KSFLUtilities.getInt(this.arr, 4, this.le) - 1);
                    this.d3cut(null, d3i, d3i[0], d3i[1], 1, type, id);
                } else {
                    KSFLUtilities.putInt(this.arr, d3i[0] + 8, this.le, d3i[2] - 1);
                }
                if (d3i[5] > 0) {
                    this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean set(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean set(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        int id = this.getIDFromName(type, name);
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean setAttributes(long type, int id, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (r.name == null) {
            r.name = "";
        }
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1e = this.d1locate(r.type, r.id);
                if (d1e > 0 && d1e != d1i) {
                    throw new DFFResourceAlreadyExistsException();
                }
                KSFLUtilities.putLong(this.arr, d1i, this.le, r.type);
                KSFLUtilities.putShort(this.arr, d1i + 8, this.le, (short)r.id);
                return true;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                int[] d2e = this.d2locate(r.type, r.id);
                if (d2e != null && (d2e[0] != d2i[0] || d2e[1] != d2i[1] || d2e[2] != d2i[2])) {
                    throw new DFFResourceAlreadyExistsException();
                }
                if ((long)this.arr.length - (long)d2i[4] + 1L + (long)this.gb(r.name).length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putLong(this.arr, d2i[0], this.le, r.type);
                KSFLUtilities.putShort(this.arr, d2i[0] + 8, this.le, (short)(r.id & 0xFFFF));
                KSFLUtilities.putShort(this.arr, d2i[0] + 10, this.le, r.datatype);
                KSFLUtilities.putShort(this.arr, d2i[0] + 12, this.le, r.getAttributes());
                KSFLUtilities.putShort(this.arr, d2i[0] + 14, this.le, (short)(r.id >> 16 & 0xFFFF));
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.cut(n, 255, n.length - 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                this.arr = KSFLUtilities.cut(this.arr, d2i[1], d2i[4]);
                this.arr = KSFLUtilities.paste(this.arr, d2i[1], n);
                this.d2dataSpace = this.d2dataSpace - d2i[4] + n.length;
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                int[] d3e = this.d3locate(r.type, r.id);
                if (d3e != null && (d3e[0] != d3i[0] || d3e[1] != d3i[1] || d3e[2] != d3i[2] || d3e[3] != d3i[3] || d3e[4] != d3i[4] || d3e[5] != d3i[5] || d3e[6] != d3i[6] || d3e[7] != d3i[7] || d3e[8] != d3i[8] || d3e[9] != d3i[9] || d3e[10] != d3i[10])) {
                    throw new DFFResourceAlreadyExistsException();
                }
                if ((long)this.arr.length - (long)d3i[8] + 1L + (long)this.gb(r.name).length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                if (type != r.type) {
                    int[] m = this.d3metrics();
                    int[] t = this.d3getType(r.type);
                    if (t == null) {
                        if (m[0] == Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException("Too many types.");
                        }
                        byte[] th = new byte[16];
                        KSFLUtilities.putLong(th, 0, this.le, r.type);
                        KSFLUtilities.putInt(th, 8, this.le, 0);
                        KSFLUtilities.putInt(th, 12, this.le, m[4]);
                        m[0] = m[0] + 1;
                        KSFLUtilities.putInt(this.arr, 4, this.le, m[0]);
                        this.d3paste(m, d3i, m[1] + m[2], th, 1, r.type, r.id);
                        t = this.d3getType(r.type);
                    } else if (t[2] == Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException("Too many objects of this type.");
                    }
                    byte[] h = new byte[24];
                    KSFLUtilities.putInt(h, 0, this.le, r.id);
                    KSFLUtilities.putShort(h, 4, this.le, r.datatype);
                    KSFLUtilities.putShort(h, 6, this.le, r.getAttributes());
                    KSFLUtilities.putInt(h, 8, this.le, d3i[7]);
                    KSFLUtilities.putUInt48(h, 12, this.le, d3i[9]);
                    KSFLUtilities.putUInt48(h, 18, this.le, d3i[10]);
                    KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2] + 1);
                    this.d3paste(m, d3i, t[3] + t[4], h, 2, r.type, r.id);
                    if (d3i[2] < 2) {
                        m[0] = m[0] - 1;
                        KSFLUtilities.putInt(this.arr, 4, this.le, m[0]);
                        this.d3cut(m, d3i, d3i[0], d3i[1], 1, type, id);
                    } else {
                        KSFLUtilities.putInt(this.arr, d3i[0] + 8, this.le, d3i[2] - 1);
                    }
                    if (d3i[5] > 0) {
                        this.d3cut(m, d3i, d3i[5], d3i[6], 2, type, id);
                    }
                } else {
                    int[] t = this.d3getType(r.type);
                    KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2] - 1);
                    this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                    byte[] h = new byte[24];
                    KSFLUtilities.putInt(h, 0, this.le, r.id);
                    KSFLUtilities.putShort(h, 4, this.le, r.datatype);
                    KSFLUtilities.putShort(h, 6, this.le, r.getAttributes());
                    KSFLUtilities.putInt(h, 8, this.le, d3i[7]);
                    KSFLUtilities.putUInt48(h, 12, this.le, d3i[9]);
                    KSFLUtilities.putUInt48(h, 18, this.le, d3i[10]);
                    KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2]);
                    this.d3paste(null, d3i, d3i[5], h, 2, r.type, r.id);
                }
                if (r.name.length() > 0) {
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.cut(n, 255, n.length - 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    if (d3i[7] > 0) {
                        this.d3paste(null, d3i, d3i[7], n, 3, r.type, r.id);
                        this.d3cut(null, d3i, d3i[7] + n.length, d3i[8], 3, r.type, r.id);
                    } else {
                        d3i[7] = this.d3metrics()[6];
                        KSFLUtilities.putInt(this.arr, d3i[5] + 8, this.le, d3i[7]);
                        this.d3paste(null, d3i, d3i[7], n, 3, r.type, r.id);
                    }
                    d3i[8] = n.length;
                } else if (d3i[7] > 0) {
                    this.d3cut(null, d3i, d3i[7], d3i[8], 3, r.type, r.id);
                    d3i[7] = 0;
                    KSFLUtilities.putInt(this.arr, d3i[5] + 8, this.le, 0);
                    d3i[8] = 0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setAttributes(long type, String name, DFFResource r) throws DFFResourceAlreadyExistsException {
        if (r.name == null) {
            r.name = "";
        }
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                int[] d2e = this.d2locate(r.type, r.id);
                if (d2e != null && (d2e[0] != d2i[0] || d2e[1] != d2i[1] || d2e[2] != d2i[2])) {
                    throw new DFFResourceAlreadyExistsException();
                }
                if ((long)this.arr.length - (long)d2i[4] + 1L + (long)this.gb(r.name).length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putLong(this.arr, d2i[0], this.le, r.type);
                KSFLUtilities.putShort(this.arr, d2i[0] + 8, this.le, (short)(r.id & 0xFFFF));
                KSFLUtilities.putShort(this.arr, d2i[0] + 10, this.le, r.datatype);
                KSFLUtilities.putShort(this.arr, d2i[0] + 12, this.le, r.getAttributes());
                KSFLUtilities.putShort(this.arr, d2i[0] + 14, this.le, (short)(r.id >> 16 & 0xFFFF));
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.cut(n, 255, n.length - 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                this.arr = KSFLUtilities.cut(this.arr, d2i[1], d2i[4]);
                this.arr = KSFLUtilities.paste(this.arr, d2i[1], n);
                this.d2dataSpace = this.d2dataSpace - d2i[4] + n.length;
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int[] d3e = this.d3locate(r.type, r.id);
                if (d3e != null && (d3e[0] != d3i[0] || d3e[1] != d3i[1] || d3e[2] != d3i[2] || d3e[3] != d3i[3] || d3e[4] != d3i[4] || d3e[5] != d3i[5] || d3e[6] != d3i[6] || d3e[7] != d3i[7] || d3e[8] != d3i[8] || d3e[9] != d3i[9] || d3e[10] != d3i[10])) {
                    throw new DFFResourceAlreadyExistsException();
                }
                if ((long)this.arr.length - (long)d3i[8] + 1L + (long)this.gb(r.name).length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                int id = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                if (type != r.type) {
                    int[] m = this.d3metrics();
                    int[] t = this.d3getType(r.type);
                    if (t == null) {
                        if (m[0] == Integer.MAX_VALUE) {
                            throw new DFFResourceTooBigException("Too many types.");
                        }
                        byte[] th = new byte[16];
                        KSFLUtilities.putLong(th, 0, this.le, r.type);
                        KSFLUtilities.putInt(th, 8, this.le, 0);
                        KSFLUtilities.putInt(th, 12, this.le, m[4]);
                        m[0] = m[0] + 1;
                        KSFLUtilities.putInt(this.arr, 4, this.le, m[0]);
                        this.d3paste(m, d3i, m[1] + m[2], th, 1, r.type, r.id);
                        t = this.d3getType(r.type);
                    } else if (t[2] == Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException("Too many objects of this type.");
                    }
                    byte[] h = new byte[24];
                    KSFLUtilities.putInt(h, 0, this.le, r.id);
                    KSFLUtilities.putShort(h, 4, this.le, r.datatype);
                    KSFLUtilities.putShort(h, 6, this.le, r.getAttributes());
                    KSFLUtilities.putInt(h, 8, this.le, d3i[7]);
                    KSFLUtilities.putUInt48(h, 12, this.le, d3i[9]);
                    KSFLUtilities.putUInt48(h, 18, this.le, d3i[10]);
                    KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2] + 1);
                    this.d3paste(m, d3i, t[3] + t[4], h, 2, r.type, r.id);
                    if (d3i[2] < 2) {
                        m[0] = m[0] - 1;
                        KSFLUtilities.putInt(this.arr, 4, this.le, m[0]);
                        this.d3cut(m, d3i, d3i[0], d3i[1], 1, type, id);
                    } else {
                        KSFLUtilities.putInt(this.arr, d3i[0] + 8, this.le, d3i[2] - 1);
                    }
                    if (d3i[5] > 0) {
                        this.d3cut(m, d3i, d3i[5], d3i[6], 2, type, id);
                    }
                } else {
                    int[] t = this.d3getType(r.type);
                    KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2] - 1);
                    this.d3cut(null, d3i, d3i[5], d3i[6], 2, type, id);
                    byte[] h = new byte[24];
                    KSFLUtilities.putInt(h, 0, this.le, r.id);
                    KSFLUtilities.putShort(h, 4, this.le, r.datatype);
                    KSFLUtilities.putShort(h, 6, this.le, r.getAttributes());
                    KSFLUtilities.putInt(h, 8, this.le, d3i[7]);
                    KSFLUtilities.putUInt48(h, 12, this.le, d3i[9]);
                    KSFLUtilities.putUInt48(h, 18, this.le, d3i[10]);
                    KSFLUtilities.putInt(this.arr, t[0] + 8, this.le, t[2]);
                    this.d3paste(null, d3i, d3i[5], h, 2, r.type, r.id);
                }
                if (r.name.length() > 0) {
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.cut(n, 255, n.length - 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    if (d3i[7] > 0) {
                        this.d3paste(null, d3i, d3i[7], n, 3, r.type, r.id);
                        this.d3cut(null, d3i, d3i[7] + n.length, d3i[8], 3, r.type, r.id);
                    } else {
                        d3i[7] = this.d3metrics()[6];
                        KSFLUtilities.putInt(this.arr, d3i[5] + 8, this.le, d3i[7]);
                        this.d3paste(null, d3i, d3i[7], n, 3, r.type, r.id);
                    }
                    d3i[8] = n.length;
                } else if (d3i[7] > 0) {
                    this.d3cut(null, d3i, d3i[7], d3i[8], 3, r.type, r.id);
                    d3i[7] = 0;
                    KSFLUtilities.putInt(this.arr, d3i[5] + 8, this.le, 0);
                    d3i[8] = 0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setLength(long type, int id, long len) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                if ((long)this.arr.length - (long)d1l + len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putInt(this.arr, d1i + 12, this.le, (int)len);
                this.arr = len < (long)d1l ? KSFLUtilities.cut(this.arr, (int)((long)(d1i + 16) + len), (int)((long)d1l - len)) : KSFLUtilities.paste(this.arr, d1i + 16 + d1l, (int)(len - (long)d1l));
                return true;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                if ((long)this.arr.length - (long)d2i[5] + len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putInt(this.arr, d2i[0] + 16, this.le, (int)len);
                this.arr = len < (long)d2i[5] ? KSFLUtilities.cut(this.arr, (int)((long)d2i[2] + len), (int)((long)d2i[5] - len)) : KSFLUtilities.paste(this.arr, d2i[2] + d2i[5], (int)(len - (long)d2i[5]));
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                if ((long)this.arr.length - (long)d3i[10] + len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, len);
                if (len < (long)d3i[10]) {
                    this.d3cut(null, d3i, (int)((long)d3i[9] + len), (int)((long)d3i[10] - len), 4, type, id);
                } else {
                    this.d3paste(null, d3i, d3i[9] + d3i[10], (int)(len - (long)d3i[10]), 4, type, id);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setLength(long type, String name, long len) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                if ((long)this.arr.length - (long)d2i[5] + len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putInt(this.arr, d2i[0] + 16, this.le, (int)len);
                this.arr = len < (long)d2i[5] ? KSFLUtilities.cut(this.arr, (int)((long)d2i[2] + len), (int)((long)d2i[5] - len)) : KSFLUtilities.paste(this.arr, d2i[2] + d2i[5], (int)(len - (long)d2i[5]));
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int id = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                if ((long)this.arr.length - (long)d3i[10] + len > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, len);
                if (len < (long)d3i[10]) {
                    this.d3cut(null, d3i, (int)((long)d3i[9] + len), (int)((long)d3i[10] - len), 4, type, id);
                } else {
                    this.d3paste(null, d3i, d3i[9] + d3i[10], (int)(len - (long)d3i[10]), 4, type, id);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setData(long type, int id, byte[] data) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                if ((long)this.arr.length - (long)d1l + (long)data.length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putInt(this.arr, d1i + 12, this.le, data.length);
                this.arr = KSFLUtilities.cut(this.arr, d1i + 16, d1l);
                this.arr = KSFLUtilities.paste(this.arr, d1i + 16, data);
                return true;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                if ((long)this.arr.length - (long)d2i[5] + (long)data.length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putInt(this.arr, d2i[0] + 16, this.le, data.length);
                this.arr = KSFLUtilities.cut(this.arr, d2i[2], d2i[5]);
                this.arr = KSFLUtilities.paste(this.arr, d2i[2], data);
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                if (d3i[9] > 0) {
                    this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                }
                if (data.length > 0) {
                    if (d3i[9] <= 0) {
                        d3i[9] = this.d3metrics()[8];
                        KSFLUtilities.putUInt48(this.arr, d3i[5] + 12, this.le, d3i[9]);
                    }
                    KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, data.length);
                    this.d3paste(null, d3i, d3i[9], data, 4, type, id);
                } else if (d3i[9] > 0) {
                    KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, 0L);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean setData(long type, String name, byte[] data) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                if ((long)this.arr.length - (long)d2i[5] + (long)data.length > Integer.MAX_VALUE) {
                    throw new DFFResourceTooBigException();
                }
                KSFLUtilities.putInt(this.arr, d2i[0] + 16, this.le, data.length);
                this.arr = KSFLUtilities.cut(this.arr, d2i[2], d2i[5]);
                this.arr = KSFLUtilities.paste(this.arr, d2i[2], data);
                return true;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int id = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                if (d3i[9] > 0) {
                    this.d3cut(null, d3i, d3i[9], d3i[10], 4, type, id);
                }
                if (data.length > 0) {
                    if (d3i[9] <= 0) {
                        d3i[9] = this.d3metrics()[8];
                        KSFLUtilities.putUInt48(this.arr, d3i[5] + 12, this.le, d3i[9]);
                    }
                    KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, data.length);
                    this.d3paste(null, d3i, d3i[9], data, 4, type, id);
                } else if (d3i[9] > 0) {
                    KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, 0L);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized int write(long type, int id, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                int d1i = this.d1locate(type, id);
                if (d1i <= 0) break;
                int d1l = KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                if (doffset + (long)len > (long)d1l) {
                    if ((long)this.arr.length - (long)d1l + doffset + (long)len > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    this.arr = doffset > (long)d1l ? KSFLUtilities.paste(this.arr, d1i + 16 + d1l, (int)(doffset - (long)d1l)) : KSFLUtilities.cut(this.arr, (int)((long)(d1i + 16) + doffset), (int)((long)d1l - doffset));
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)(d1i + 16) + doffset), KSFLUtilities.copy(data, off, len));
                    KSFLUtilities.putInt(this.arr, d1i + 12, this.le, (int)(doffset + (long)len));
                } else {
                    this.arr = KSFLUtilities.cut(this.arr, (int)((long)(d1i + 16) + doffset), len);
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)(d1i + 16) + doffset), KSFLUtilities.copy(data, off, len));
                }
                return len;
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                if (doffset + (long)len > (long)d2i[5]) {
                    if ((long)this.arr.length - (long)d2i[5] + doffset + (long)len > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    this.arr = doffset > (long)d2i[5] ? KSFLUtilities.paste(this.arr, d2i[2] + d2i[5], (int)(doffset - (long)d2i[5])) : KSFLUtilities.cut(this.arr, (int)((long)d2i[2] + doffset), (int)((long)d2i[5] - doffset));
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)d2i[2] + doffset), KSFLUtilities.copy(data, off, len));
                    KSFLUtilities.putInt(this.arr, d2i[0] + 16, this.le, (int)(doffset + (long)len));
                } else {
                    this.arr = KSFLUtilities.cut(this.arr, (int)((long)d2i[2] + doffset), len);
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)d2i[2] + doffset), KSFLUtilities.copy(data, off, len));
                }
                return len;
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                if (doffset + (long)len > (long)d3i[10]) {
                    if ((long)this.arr.length - (long)d3i[10] + doffset + (long)len > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, doffset + (long)len);
                    if (doffset > (long)d3i[10]) {
                        this.d3paste(null, d3i, d3i[9] + d3i[10], (int)(doffset - (long)d3i[10]), 4, type, id);
                    } else {
                        this.d3cut(null, d3i, (int)((long)d3i[9] + doffset), (int)((long)d3i[10] - doffset), 4, type, id);
                    }
                    this.d3paste(null, d3i, (int)((long)d3i[9] + doffset), KSFLUtilities.copy(data, off, len), 4, type, id);
                } else {
                    this.arr = KSFLUtilities.cut(this.arr, (int)((long)d3i[9] + doffset), len);
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)d3i[9] + doffset), KSFLUtilities.copy(data, off, len));
                }
                return len;
            }
        }
        return 0;
    }

    @Override
    public synchronized int write(long type, String name, long doffset, byte[] data, int off, int len) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                if (doffset + (long)len > (long)d2i[5]) {
                    if ((long)this.arr.length - (long)d2i[5] + doffset + (long)len > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    this.arr = doffset > (long)d2i[5] ? KSFLUtilities.paste(this.arr, d2i[2] + d2i[5], (int)(doffset - (long)d2i[5])) : KSFLUtilities.cut(this.arr, (int)((long)d2i[2] + doffset), (int)((long)d2i[5] - doffset));
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)d2i[2] + doffset), KSFLUtilities.copy(data, off, len));
                    KSFLUtilities.putInt(this.arr, d2i[0] + 16, this.le, (int)(doffset + (long)len));
                } else {
                    this.arr = KSFLUtilities.cut(this.arr, (int)((long)d2i[2] + doffset), len);
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)d2i[2] + doffset), KSFLUtilities.copy(data, off, len));
                }
                return len;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int id = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                if (doffset + (long)len > (long)d3i[10]) {
                    if ((long)this.arr.length - (long)d3i[10] + doffset + (long)len > Integer.MAX_VALUE) {
                        throw new DFFResourceTooBigException();
                    }
                    KSFLUtilities.putUInt48(this.arr, d3i[5] + 18, this.le, doffset + (long)len);
                    if (doffset > (long)d3i[10]) {
                        this.d3paste(null, d3i, d3i[9] + d3i[10], (int)(doffset - (long)d3i[10]), 4, type, id);
                    } else {
                        this.d3cut(null, d3i, (int)((long)d3i[9] + doffset), (int)((long)d3i[10] - doffset), 4, type, id);
                    }
                    this.d3paste(null, d3i, (int)((long)d3i[9] + doffset), KSFLUtilities.copy(data, off, len), 4, type, id);
                } else {
                    this.arr = KSFLUtilities.cut(this.arr, (int)((long)d3i[9] + doffset), len);
                    this.arr = KSFLUtilities.paste(this.arr, (int)((long)d3i[9] + doffset), KSFLUtilities.copy(data, off, len));
                }
                return len;
            }
        }
        return 0;
    }

    @Override
    public synchronized int getTypeCount() {
        switch (this.version) {
            case 1: {
                ArrayList<Long> d1s = new ArrayList<Long>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    long ty = KSFLUtilities.getLong(this.arr, d1i, this.le);
                    if (!d1s.contains(ty)) {
                        d1s.add(ty);
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                return d1s.size();
            }
            case 2: {
                ArrayList<Long> d2s = new ArrayList<Long>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    long ty = KSFLUtilities.getLong(this.arr, d2h, this.le);
                    if (!d2s.contains(ty)) {
                        d2s.add(ty);
                    }
                    d2h += 20;
                    ++d2i;
                }
                return d2s.size();
            }
            case 3: {
                int d3typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
                return d3typeCnt;
            }
        }
        return 0;
    }

    @Override
    public synchronized long getType(int index) {
        switch (this.version) {
            case 1: {
                ArrayList<Long> d1s = new ArrayList<Long>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    long ty = KSFLUtilities.getLong(this.arr, d1i, this.le);
                    if (!d1s.contains(ty)) {
                        if (d1s.size() == index) {
                            return ty;
                        }
                        d1s.add(ty);
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                break;
            }
            case 2: {
                ArrayList<Long> d2s = new ArrayList<Long>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    long ty = KSFLUtilities.getLong(this.arr, d2h, this.le);
                    if (!d2s.contains(ty)) {
                        if (d2s.size() == index) {
                            return ty;
                        }
                        d2s.add(ty);
                    }
                    d2h += 20;
                    ++d2i;
                }
                break;
            }
            case 3: {
                int d3typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
                if (index < 0 || index >= d3typeCnt) break;
                long t = KSFLUtilities.getLong(this.arr, 8 + 16 * index, this.le);
                return t;
            }
        }
        return 0L;
    }

    @Override
    public synchronized long[] getTypes() {
        switch (this.version) {
            case 1: {
                ArrayList<Long> d1s = new ArrayList<Long>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    long ty = KSFLUtilities.getLong(this.arr, d1i, this.le);
                    if (!d1s.contains(ty)) {
                        d1s.add(ty);
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                long[] d1a = new long[d1s.size()];
                Iterator d1si = d1s.iterator();
                int d1ai = 0;
                while (d1si.hasNext()) {
                    d1a[d1ai++] = (Long)d1si.next();
                }
                return d1a;
            }
            case 2: {
                ArrayList<Long> d2s = new ArrayList<Long>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    long ty = KSFLUtilities.getLong(this.arr, d2h, this.le);
                    if (!d2s.contains(ty)) {
                        d2s.add(ty);
                    }
                    d2h += 20;
                    ++d2i;
                }
                long[] d2a = new long[d2s.size()];
                Iterator d2si = d2s.iterator();
                int d2ai = 0;
                while (d2si.hasNext()) {
                    d2a[d2ai++] = (Long)d2si.next();
                }
                return d2a;
            }
            case 3: {
                int d3typeCnt = KSFLUtilities.getInt(this.arr, 4, this.le);
                long[] d3a = new long[d3typeCnt];
                int d3i = 0;
                while (d3i < d3typeCnt) {
                    d3a[d3i] = KSFLUtilities.getLong(this.arr, 8 + 16 * d3i, this.le);
                    ++d3i;
                }
                return d3a;
            }
        }
        return null;
    }

    @Override
    public synchronized int getResourceCount(long type) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    short id;
                    if (KSFLUtilities.getLong(this.arr, d1i, this.le) == type && !d1s.contains(id = KSFLUtilities.getShort(this.arr, d1i + 8, this.le))) {
                        d1s.add(Integer.valueOf(id));
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                return d1s.size();
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    if (KSFLUtilities.getLong(this.arr, d2h, this.le) == type) {
                        int id = KSFLUtilities.getShort(this.arr, d2h + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2h + 14, this.le) << 16 & 0xFFFF0000;
                        d2s.add(id);
                    }
                    d2h += 20;
                    ++d2i;
                }
                return d2s.size();
            }
            case 3: {
                int[] d3t = this.d3getType(type);
                if (d3t == null) break;
                return d3t[2];
            }
        }
        return 0;
    }

    @Override
    public synchronized int getID(long type, int index) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    short id;
                    if (KSFLUtilities.getLong(this.arr, d1i, this.le) == type && !d1s.contains(id = KSFLUtilities.getShort(this.arr, d1i + 8, this.le))) {
                        if (d1s.size() == index) {
                            return id;
                        }
                        d1s.add(Integer.valueOf(id));
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                break;
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    if (KSFLUtilities.getLong(this.arr, d2h, this.le) == type) {
                        int id = KSFLUtilities.getShort(this.arr, d2h + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2h + 14, this.le) << 16 & 0xFFFF0000;
                        if (d2s.size() == index) {
                            return id;
                        }
                        d2s.add(id);
                    }
                    d2h += 20;
                    ++d2i;
                }
                break;
            }
            case 3: {
                int[] d3t = this.d3getType(type);
                if (d3t == null || index < 0 || index >= d3t[2]) break;
                int id = KSFLUtilities.getInt(this.arr, d3t[3] + 24 * index, this.le);
                return id;
            }
        }
        return 0;
    }

    @Override
    public synchronized int[] getIDs(long type) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    short id;
                    if (KSFLUtilities.getLong(this.arr, d1i, this.le) == type && !d1s.contains(id = KSFLUtilities.getShort(this.arr, d1i + 8, this.le))) {
                        d1s.add(Integer.valueOf(id));
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                int[] d1a = new int[d1s.size()];
                Iterator d1si = d1s.iterator();
                int d1ai = 0;
                while (d1si.hasNext()) {
                    d1a[d1ai++] = (Integer)d1si.next();
                }
                return d1a;
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    if (KSFLUtilities.getLong(this.arr, d2h, this.le) == type) {
                        int id = KSFLUtilities.getShort(this.arr, d2h + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2h + 14, this.le) << 16 & 0xFFFF0000;
                        d2s.add(id);
                    }
                    d2h += 20;
                    ++d2i;
                }
                int[] d2a = new int[d2s.size()];
                Iterator d2si = d2s.iterator();
                int d2ai = 0;
                while (d2si.hasNext()) {
                    d2a[d2ai++] = (Integer)d2si.next();
                }
                return d2a;
            }
            case 3: {
                int[] d3t = this.d3getType(type);
                if (d3t != null) {
                    int[] d3a = new int[d3t[2]];
                    int d3i = 0;
                    while (d3i < d3t[2]) {
                        d3a[d3i] = KSFLUtilities.getInt(this.arr, d3t[3] + 24 * d3i, this.le);
                        ++d3i;
                    }
                    return d3a;
                }
                return new int[0];
            }
        }
        return null;
    }

    @Override
    public synchronized String getName(long type, int index) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                ArrayList<String> d2s = new ArrayList<String>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                int d2n = this.d2nameSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace && d2n < this.d2dataSpace) {
                    if (KSFLUtilities.getLong(this.arr, d2h, this.le) == type) {
                        String n = this.ns(this.arr, d2n + 1, this.arr[d2n] & 0xFF);
                        if (d2s.size() == index) {
                            return n;
                        }
                        d2s.add(n);
                    }
                    d2n += 1 + (this.arr[d2n] & 0xFF);
                    d2h += 20;
                    ++d2i;
                }
                break;
            }
            case 3: {
                int[] d3t = this.d3getType(type);
                if (d3t == null || index < 0 || index >= d3t[2]) break;
                int nameOfst = KSFLUtilities.getInt(this.arr, d3t[3] + 24 * index + 8, this.le);
                int nameLen = nameOfst > 0 ? (this.arr[nameOfst] & 0xFF) + 1 : 0;
                String n = nameOfst > 0 ? this.ns(this.arr, nameOfst + 1, nameLen - 1) : "";
                return n;
            }
        }
        return null;
    }

    @Override
    public synchronized String[] getNames(long type) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                ArrayList<String> d2s = new ArrayList<String>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                int d2n = this.d2nameSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace && d2n < this.d2dataSpace) {
                    if (KSFLUtilities.getLong(this.arr, d2h, this.le) == type) {
                        String n = this.ns(this.arr, d2n + 1, this.arr[d2n] & 0xFF);
                        d2s.add(n);
                    }
                    d2n += 1 + (this.arr[d2n] & 0xFF);
                    d2h += 20;
                    ++d2i;
                }
                return d2s.toArray(new String[0]);
            }
            case 3: {
                int[] d3t = this.d3getType(type);
                if (d3t != null) {
                    String[] d3a = new String[d3t[2]];
                    int d3i = 0;
                    while (d3i < d3t[2]) {
                        String n;
                        int nameOfst = KSFLUtilities.getInt(this.arr, d3t[3] + 24 * d3i + 8, this.le);
                        int nameLen = nameOfst > 0 ? (this.arr[nameOfst] & 0xFF) + 1 : 0;
                        d3a[d3i] = n = nameOfst > 0 ? this.ns(this.arr, nameOfst + 1, nameLen - 1) : "";
                        ++d3i;
                    }
                    return d3a;
                }
                return new String[0];
            }
        }
        return null;
    }

    @Override
    public synchronized int getNextAvailableID(long type, int start) {
        switch (this.version) {
            case 1: {
                ArrayList<Integer> d1s = new ArrayList<Integer>();
                int d1i = 4;
                while (d1i + 16 <= this.arr.length) {
                    short id;
                    if (KSFLUtilities.getLong(this.arr, d1i, this.le) == type && !d1s.contains(id = KSFLUtilities.getShort(this.arr, d1i + 8, this.le))) {
                        d1s.add(Integer.valueOf(id));
                    }
                    d1i += 16 + KSFLUtilities.getInt(this.arr, d1i + 12, this.le);
                }
                int d1n = start;
                while (d1s.contains(d1n)) {
                    ++d1n;
                }
                return d1n;
            }
            case 2: {
                ArrayList<Integer> d2s = new ArrayList<Integer>();
                int d2i = 0;
                int d2h = this.d2headerSpace;
                while (d2i < this.d2objectCount && d2h < this.d2nameSpace) {
                    int id;
                    if (KSFLUtilities.getLong(this.arr, d2h, this.le) == type && !d2s.contains(id = KSFLUtilities.getShort(this.arr, d2h + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2h + 14, this.le) << 16 & 0xFFFF0000)) {
                        d2s.add(id);
                    }
                    d2h += 20;
                    ++d2i;
                }
                int d2n = start;
                while (d2s.contains(d2n)) {
                    ++d2n;
                }
                return d2n;
            }
            case 3: {
                ArrayList<Integer> d3s = new ArrayList<Integer>();
                int[] d3t = this.d3getType(type);
                if (d3t != null) {
                    int d3i = 0;
                    while (d3i < d3t[2]) {
                        d3s.add(KSFLUtilities.getInt(this.arr, d3t[3] + 24 * d3i, this.le));
                        ++d3i;
                    }
                }
                int d3n = start;
                while (d3s.contains(d3n)) {
                    ++d3n;
                }
                return d3n;
            }
        }
        return start;
    }

    @Override
    public synchronized String getNameFromID(long type, int id) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, id);
                if (d2i == null) break;
                return this.ns(this.arr, d2i[1] + 1, d2i[4] - 1);
            }
            case 3: {
                int[] d3i = this.d3locate(type, id);
                if (d3i == null) break;
                return d3i[7] > 0 ? this.ns(this.arr, d3i[7] + 1, d3i[8] - 1) : "";
            }
        }
        return "";
    }

    @Override
    public synchronized int getIDFromName(long type, String name) {
        switch (this.version) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                int[] d2i = this.d2locate(type, name);
                if (d2i == null) break;
                int i = KSFLUtilities.getShort(this.arr, d2i[0] + 8, this.le) & 0xFFFF | KSFLUtilities.getShort(this.arr, d2i[0] + 14, this.le) << 16 & 0xFFFF0000;
                return i;
            }
            case 3: {
                int[] d3i = this.d3locate(type, name);
                if (d3i == null) break;
                int i = KSFLUtilities.getInt(this.arr, d3i[5], this.le);
                return i;
            }
        }
        return 0;
    }
}

